/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.entity.resolve.types;

import com.entitystream.identiza.entity.resolve.processing.GradientGenerator;
import com.entitystream.identiza.entity.resolve.types.Standardized;
import com.entitystream.identiza.entity.resolve.types.StandardizedSerialized;
import com.entitystream.identiza.entity.resolve.utils.EditDistance;
import com.entitystream.identiza.language.utils.zh.ZHConverter;
import com.entitystream.identiza.wordlist.WordList;
import java.util.ArrayList;

public class StandardChinesePersonName
extends StandardizedSerialized {
    public ArrayList<String> firstnamechars = new ArrayList();
    public ArrayList<String> surnamechars = new ArrayList();
    public ArrayList<String> firstnamecharspy = new ArrayList();
    public ArrayList<String> surnamecharspy = new ArrayList();
    public int tokensize;
    private WordList cv;
    private WordList anon;
    private int gradient;

    public StandardChinesePersonName() {
    }

    public StandardChinesePersonName(String[] words, WordList anon, WordList cv, int gradient, String name) {
        super(words, anon, cv, gradient, name);
        int i;
        this.anon = anon;
        this.cv = cv;
        this.tokensize = words.length;
        this.gradient = gradient;
        ZHConverter converter = ZHConverter.getInstance(1);
        String val = "";
        for (String token : words) {
            val = val + converter.convert(token) + " ";
        }
        val = anon.removeAnon(val);
        String[] basenames = this.extractNames(val.trim());
        for (i = 0; i < basenames[1].length(); ++i) {
            this.surnamechars.add("" + basenames[1].charAt(i));
        }
        for (i = 0; i < basenames[0].length(); ++i) {
            this.firstnamechars.add("" + basenames[0].charAt(i));
        }
        this.surnamecharspy = new ArrayList();
        for (i = 0; i < basenames[1].length(); ++i) {
            this.surnamecharspy.add(Integer.toHexString(basenames[1].charAt(i)));
        }
        for (i = 0; i < basenames[0].length(); ++i) {
            this.firstnamecharspy.add(Integer.toHexString(basenames[0].charAt(i)));
        }
    }

    private String[] extractNames(String fullValue) {
        String firstname = new String();
        String surname = new String();
        if (Character.UnicodeBlock.of(fullValue.charAt(0)) == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS) {
            if (this.cv != null) {
                surname = this.cv.startsWith(fullValue);
                if (surname.length() == 0) {
                    surname = "" + fullValue.charAt(0);
                }
            } else if (fullValue.length() > 0) {
                surname = "" + fullValue.charAt(0);
            }
            firstname = fullValue.substring(surname.length());
        } else {
            surname = fullValue.substring(0, fullValue.indexOf(" "));
            firstname = fullValue.substring(fullValue.indexOf(" ") + 1);
        }
        return new String[]{firstname, surname};
    }

    @Override
    public double compare(Standardized otherstd, WordList anon, WordList cv, boolean isSearch, boolean asContent) {
        StandardChinesePersonName stdcpn = (StandardChinesePersonName)otherstd;
        double[] gradients = GradientGenerator.generate(Math.min(this.tokensize, stdcpn.tokensize), Math.max(this.tokensize, stdcpn.tokensize), 2.0, 0.0, 1.0, this.gradient);
        double divisor = GradientGenerator.sum(gradients);
        double sneditzh = EditDistance.getLevenshteinDistanceOfStringArrayList(this.surnamecharspy, stdcpn.surnamecharspy, anon, cv, gradients);
        double fneditzh = EditDistance.getLevenshteinDistanceOfStringArrayList(this.firstnamecharspy, stdcpn.firstnamecharspy, anon, cv, gradients);
        double snedit = EditDistance.getLevenshteinDistanceOfStringArrayList(this.surnamechars, stdcpn.surnamechars, anon, cv, gradients);
        double fnedit = EditDistance.getLevenshteinDistanceOfStringArrayList(this.firstnamechars, stdcpn.firstnamechars, anon, cv, gradients);
        double edit = fnedit + snedit;
        double editzh = fneditzh + sneditzh;
        double factor = 100.0;
        if (edit > editzh) {
            edit = editzh;
            factor = 80.0;
        }
        int words = 0;
        double ret = 0.0;
        if (isSearch) {
            if (edit > 0.0) {
                edit -= (double)Math.abs(this.tokensize - stdcpn.tokensize);
            }
            if (edit < 0.0) {
                edit = 0.0;
            }
            ret = factor * (divisor - edit) / divisor;
        } else {
            words = Math.max(this.tokensize, stdcpn.tokensize);
            ret = 100.0 * (divisor - edit) / divisor;
        }
        return ret;
    }
}

