/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.entity.resolve.types;

import com.entitystream.identiza.entity.resolve.types.MatchCode;
import com.entitystream.identiza.entity.resolve.types.Standardized;
import com.entitystream.identiza.entity.resolve.types.StandardizedSerialized;
import com.entitystream.identiza.wordlist.RuleSet;
import com.entitystream.identiza.wordlist.WordList;

public class StandardCode
extends StandardizedSerialized {
    public String key;

    public StandardCode() {
    }

    public StandardCode(String[] words, WordList anon, WordList cv, int gradient, String name) {
        super(words, anon, cv, gradient, name);
        StringBuilder db = new StringBuilder();
        for (String left : this.originalWords) {
            if (left == null) continue;
            db.append(left.toUpperCase().replaceFirst("^0+(?!$)", ""));
        }
        this.key = db.toString();
    }

    @Override
    public double compare(Standardized otherstd, WordList anon, WordList cv, boolean isSearch, boolean asContent) {
        try {
            StandardCode othercode = null;
            othercode = otherstd instanceof StandardCode ? (StandardCode)otherstd : new StandardCode(otherstd.getComparitorWords(), anon, cv, 0, "");
            if (this.key != null && othercode != null && othercode.key != null) {
                int score = 0;
                for (int i = 0; i < Math.min(this.key.length(), othercode.key.length()) && this.key.charAt(i) == othercode.key.charAt(i); ++i) {
                    ++score;
                }
                return new Double(100 * score / Math.max(this.key.length(), othercode.key.length())).intValue();
            }
            return 0.0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public static void main(String[] args) {
        StandardCode one = new StandardCode(new String[]{"V", "147904", "8"}, null, null, 0, "");
        StandardCode two = new StandardCode(new String[]{"8147904"}, null, null, 0, "");
        System.out.println(one.compare(two, null, null, false, false));
        MatchCode mcde = new MatchCode("");
        mcde.setRuleSet(RuleSet.emptyRuleSet());
        System.out.println(mcde.getKeys(new String[]{"V", "147904", "8"}, true, false));
    }
}

