/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.entity.resolve.types;

import com.entitystream.identiza.entity.resolve.processing.GradientGenerator;
import com.entitystream.identiza.entity.resolve.types.Standardized;
import com.entitystream.identiza.entity.resolve.types.StandardizedSerialized;
import com.entitystream.identiza.entity.resolve.utils.EditDistance;
import com.entitystream.identiza.wordlist.WordList;
import java.util.ArrayList;

public class StandardCompanyName
extends StandardizedSerialized {
    private static final long serialVersionUID = -6958439718017970962L;
    private int gradient;
    private static final String badlist = "|MR|MRS|MISS|MS|DR|";

    public StandardCompanyName() {
    }

    public StandardCompanyName(String[] words, WordList anon, WordList cv, int gradient, String name) {
        super(words, anon, cv, gradient, name);
        this.gradient = gradient;
    }

    @Override
    public double compare(Standardized otherstd, WordList anon, WordList cv, boolean isSearch, boolean asContent) {
        boolean notsameflag = false;
        ArrayList comparitorTokens = ((StandardCompanyName)otherstd).baseTokens;
        double[] gradients = GradientGenerator.generate(Math.min(comparitorTokens.size(), this.baseTokens.size()), Math.max(comparitorTokens.size(), this.baseTokens.size()), 2.0, 1.0, 1.0, this.gradient, asContent);
        double ret = 0.0;
        if (gradients != null) {
            double divisor = 0.0;
            divisor = GradientGenerator.sum(gradients);
            double edit = 0.0;
            edit = EditDistance.getSimpleEditDistanceOfArrayList(this.baseTokens, comparitorTokens, anon, cv, gradients);
            for (int leftpos = 0; leftpos < this.baseTokens.size(); ++leftpos) {
                String left = (String)this.baseTokens.get(leftpos);
                int simcount = 0;
                int diffcomparisonsdone = 0;
                for (int rightpos = 0; rightpos < comparitorTokens.size(); ++rightpos) {
                    boolean rightb;
                    String right = (String)comparitorTokens.get(rightpos);
                    int shift = Math.abs(this.baseTokens.size() - (leftpos + 1) - (comparitorTokens.size() - (rightpos + 1)));
                    if (shift >= 3) continue;
                    boolean leftb = WordList.containsAnyNumbers(left) || left.length() == 1 && "ABCDEFGHIJKLMNOPQRSTUVWXYZ".contains(left.toUpperCase());
                    boolean bl = rightb = WordList.containsAnyNumbers(right) || right.length() == 1 && "ABCDEFGHIJKLMNOPQRSTUVWXYZ".contains(right.toUpperCase());
                    if (!leftb || !rightb) continue;
                    if (WordList.getNumber(left).equalsIgnoreCase(WordList.getNumber(right))) {
                        ++simcount;
                    }
                    ++diffcomparisonsdone;
                }
                if (simcount != 0 || diffcomparisonsdone <= 0) continue;
                notsameflag = true;
                break;
            }
            if (!notsameflag) {
                String key2;
                int pos;
                String val1 = null;
                for (pos = 0; val1 == null && pos < this.baseTokens.size(); ++pos) {
                    String word = (String)this.baseTokens.get(pos);
                    if (anon == null) {
                        if (badlist.contains("|" + word + "|")) continue;
                        val1 = word;
                        continue;
                    }
                    if (anon.inlist(word) || badlist.contains("|" + word + "|")) continue;
                    val1 = word;
                }
                String val2 = null;
                for (pos = 0; val2 == null && pos < comparitorTokens.size(); ++pos) {
                    String word = (String)comparitorTokens.get(pos);
                    if (anon == null) {
                        if (badlist.contains("|" + word + "|")) continue;
                        val2 = word;
                        continue;
                    }
                    if (anon.inlist(word) || badlist.contains("|" + word + "|")) continue;
                    val2 = word;
                }
                String key1 = val1;
                if (key1 != null) {
                    key1 = key1.substring(0, Math.min(1, key1.length()));
                }
                if ((key2 = val2) != null) {
                    key2 = key2.substring(0, Math.min(1, key2.length()));
                }
                if (key1 != null & key2 != null && !key1.startsWith(key2) && !key2.startsWith(key1) && !isSearch) {
                    notsameflag = true;
                }
                if (!notsameflag) {
                    if (this.baseTokens.contains("MR") && comparitorTokens.contains("MRS") || this.baseTokens.contains("MR") && comparitorTokens.contains("MISS") || this.baseTokens.contains("MR") && comparitorTokens.contains("MS") || this.baseTokens.contains("MRS") && comparitorTokens.contains("MR") || this.baseTokens.contains("MISS") && comparitorTokens.contains("MR") || this.baseTokens.contains("MS") && comparitorTokens.contains("MR")) {
                        notsameflag = true;
                    } else if (val1 != null && val2 != null && (val1.equals("MR") || val1.equals("MRS") || val1.equals("MS") || val1.equals("MISS") || val1.equals("DR")) && (val2.equals("MR") || val2.equals("MRS") || val2.equals("MS") || val2.equals("MISS") || val2.equals("DR")) && this.baseTokens.size() > 1 && comparitorTokens.size() > 1 && ((String)this.baseTokens.get(1)).length() > 0 && ((String)comparitorTokens.get(1)).length() > 0 && ((String)this.baseTokens.get(1)).charAt(0) != ((String)comparitorTokens.get(1)).charAt(0)) {
                        edit += 1.0;
                    }
                }
            }
            if (isSearch) {
                if (edit < 0.0) {
                    edit = 0.0;
                }
                if (notsameflag) {
                    edit = divisor;
                }
                ret = 100.0 * (divisor - edit) / divisor;
            } else {
                if (notsameflag) {
                    edit = divisor;
                }
                ret = 100.0 * (divisor - edit) / divisor;
            }
        }
        return ret;
    }
}

