/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.entity.resolve.types;

import com.entitystream.identiza.entity.resolve.types.Standardized;
import com.entitystream.identiza.entity.resolve.types.StandardizedSerialized;
import com.entitystream.identiza.wordlist.WordList;
import java.text.DateFormat;
import java.util.Calendar;

public class StandardDate
extends StandardizedSerialized {
    StringBuilder date = new StringBuilder();

    public StandardDate() {
    }

    public StandardDate(String[] words, WordList anon, WordList cv, int gradient, String name) {
        super(words, anon, cv, gradient, name);
        if (words.length > 0) {
            boolean f = true;
            for (String w : words) {
                if (!f) {
                    this.date.append("/");
                }
                f = false;
                this.date.append(w);
            }
        }
    }

    @Override
    public double compare(Standardized otherstd, WordList anon, WordList cv, boolean isSearch, boolean asContent) {
        StandardDate otherDate = (StandardDate)otherstd;
        if (this.date != null && otherDate.date != null) {
            DateFormat df = DateFormat.getDateInstance();
            Calendar date1 = null;
            Calendar date2 = null;
            try {
                date1 = Calendar.getInstance();
                date1.setTime(df.parse(this.date.toString()));
                date2 = Calendar.getInstance();
                date2.setTime(df.parse(otherDate.date.toString()));
            }
            catch (Exception e) {
                if (this.date.toString().equalsIgnoreCase(otherDate.date.toString())) {
                    return 100.0;
                }
                return 0.0;
            }
            if (date1.equals(date2)) {
                return 100.0;
            }
            int year1 = date1.get(1);
            int year2 = date2.get(1);
            int yearScore = 0;
            yearScore = year1 == year2 ? 100 : (year1 % 100 == year2 % 100 ? 100 : 100 - Math.abs(year1 - year2));
            if (date1.get(2) == date2.get(2)) {
                if (date1.get(5) == date2.get(5)) {
                    return yearScore;
                }
                int daydiff = Math.abs(date1.get(5) - date2.get(5));
                if (daydiff < 10 && year1 % 100 == year2 % 100) {
                    return (double)(yearScore * (31 - daydiff)) / 31.0;
                }
                if (date1.get(5) % 10 == date2.get(5) % 10 && year1 % 100 == year2 % 100) {
                    return (double)yearScore * 0.5;
                }
            } else {
                if (date1.get(5) == date2.get(2) + 1 && date2.get(5) == date1.get(2) + 1) {
                    return yearScore;
                }
                int monthDiff = Math.abs(date1.get(2) - date2.get(2));
                if (date1.get(5) == date2.get(5) && year1 % 100 == year2 % 100) {
                    if (monthDiff < 2) {
                        return Math.round((double)yearScore * ((double)(12 - monthDiff) / 12.0));
                    }
                    if (date1.get(2) % 10 == date2.get(2) % 10) {
                        return (double)yearScore * 0.5;
                    }
                }
            }
            return 0.0;
        }
        return 0.0;
    }

    public static void main(String[] args) {
        System.out.println(new StandardDate(new String[]{"5/1/1909"}, null, null, 0, "").compare(new StandardDate(new String[]{"1/5/09"}, null, null, 0, ""), null, null, false, false));
    }
}

