/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.entity.resolve.types;

import com.entitystream.identiza.entity.resolve.types.Standardized;
import com.entitystream.identiza.entity.resolve.types.StandardizedSerialized;
import com.entitystream.identiza.entity.resolve.utils.EditDistance;
import com.entitystream.identiza.wordlist.WordList;

public class StandardEditDistanceString
extends StandardizedSerialized {
    public StandardEditDistanceString() {
    }

    public StandardEditDistanceString(String[] words, WordList anon, WordList cv, int gradient, String name) {
        super(words, anon, cv, gradient, name);
    }

    @Override
    public double compare(Standardized otherstd, WordList anon, WordList cv, boolean isSearch, boolean asContent) {
        StandardEditDistanceString other = (StandardEditDistanceString)otherstd;
        StringBuilder db = new StringBuilder();
        for (Object left : this.baseTokens) {
            if (left == null) continue;
            db.append((String)left);
        }
        StringBuilder sdb = new StringBuilder();
        for (String left : ((StandardEditDistanceString)otherstd).baseTokens) {
            if (left == null) continue;
            sdb.append(left);
        }
        double edit = EditDistance.getLevenshteinDistanceOfString(db.toString(), sdb.toString());
        double _return = 0.0;
        double divisor = Math.max(db.toString().length(), sdb.toString().length());
        if (this.originalWords.length == 0 || other.originalWords.length == 0) {
            _return = -1.0;
        } else {
            if (edit < 0.0) {
                edit = 0.0;
            }
            _return = divisor > 0.0 ? 100.0 * (divisor - edit) / divisor : -1.0;
        }
        return _return;
    }

    public static void main(String[] args) {
        StandardEditDistanceString one = new StandardEditDistanceString(new String[]{"66753"}, null, null, 0, "");
        StandardEditDistanceString two = new StandardEditDistanceString(new String[]{"0066753"}, null, null, 0, "");
        System.out.println(one.compare(two, null, null, false, false));
    }
}

