/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.entity.resolve.types;

import com.entitystream.identiza.entity.resolve.types.Standardized;
import com.entitystream.identiza.entity.resolve.types.StandardizedSerialized;
import com.entitystream.identiza.wordlist.WordList;

public class StandardEndAddress
extends StandardizedSerialized {
    private int gradient;

    public StandardEndAddress() {
    }

    public StandardEndAddress(String[] words, WordList anon, WordList cv, int gradient, String name) {
        super(words, anon, cv, gradient, name);
        this.gradient = gradient;
    }

    @Override
    public double compare(Standardized otherstd, WordList anon, WordList cv, boolean isSearch, boolean asContent) {
        String[] comparitorTokens = ((StandardEndAddress)otherstd).originalWords;
        boolean ret = false;
        boolean num = false;
        double best = 0.0;
        double fscore = 0.0;
        if (comparitorTokens[comparitorTokens.length - 1].equalsIgnoreCase(this.originalWords[this.originalWords.length - 1])) {
            fscore = 0.7;
        } else if (cv != null) {
            fscore = 0.7 * (1.0 - cv.isStemmed(comparitorTokens[comparitorTokens.length - 1], this.originalWords[this.originalWords.length - 1]));
        }
        double score = 0.0;
        if (fscore > 0.0) {
            double grad = 0.3 / (double)this.originalWords.length;
            for (String token1 : this.originalWords) {
                double thisScore = 0.0;
                best = 0.0;
                for (String token2 : comparitorTokens) {
                    if (cv != null) {
                        thisScore = grad * cv.isStemmed(token1, token2);
                    } else if (token1.equalsIgnoreCase(token2)) {
                        thisScore = grad * 1.0;
                    }
                    if (!(thisScore > best)) continue;
                    best = thisScore;
                }
                score += best;
            }
        }
        return (score + fscore) * 100.0;
    }

    private int intMatch(String key1, String key2) {
        try {
            int score = 0;
            for (int i = 0; i < Math.min(key1.length(), key2.length()) && key1.charAt(i) == key2.charAt(i); ++i) {
                ++score;
            }
            return new Double(100 * score / Math.min(key1.length(), key2.length())).intValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static void main(String[] args) {
    }
}

