/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.entity.resolve.types;

import com.entitystream.identiza.entity.resolve.types.Standardized;
import com.entitystream.identiza.entity.resolve.types.StandardizedSerialized;
import com.entitystream.identiza.entity.resolve.utils.EditDistance;
import com.entitystream.identiza.entity.resolve.utils.NYSIIS;
import com.entitystream.identiza.wordlist.WordList;

public class StandardMisskeyCode
extends StandardizedSerialized {
    public String key;
    public int gradient;

    public StandardMisskeyCode() {
    }

    public StandardMisskeyCode(String[] words, WordList anon, WordList cv, int gradient, String name) {
        super(words, anon, cv, gradient, name);
        if (words.length > 0) {
            StringBuilder key1 = new StringBuilder();
            for (String base : words) {
                key1.append(base);
            }
            this.replaceChars(key1);
            this.key = key1.toString();
        }
    }

    @Override
    public double compare(Standardized otherstd, WordList anon, WordList cv, boolean isSearch, boolean asContent) {
        StandardMisskeyCode other = (StandardMisskeyCode)otherstd;
        double score = EditDistance.getLevenshteinDistanceOfString(this.key, other.key);
        double nTokens = 0.0;
        nTokens = !isSearch ? (double)Math.max(this.key.length(), other.key.length()) : (double)Math.min(this.key.length(), other.key.length());
        return 100.0 * ((nTokens - score) / nTokens);
    }

    private void replaceChars(StringBuilder key1) {
        NYSIIS.replaceAll(key1, " ", "");
        NYSIIS.replaceAll(key1, "K", "X");
        NYSIIS.replaceAll(key1, "M", "N");
        NYSIIS.replaceAll(key1, "8", "B");
        NYSIIS.replaceAll(key1, "6", "G");
        NYSIIS.replaceAll(key1, "1", "I");
        NYSIIS.replaceAll(key1, "L", "I");
        NYSIIS.replaceAll(key1, "0", "O");
        NYSIIS.replaceAll(key1, "5", "S");
        NYSIIS.replaceAll(key1, "V", "U");
        NYSIIS.replaceAll(key1, "Y", "U");
        NYSIIS.replaceAll(key1, "2", "Z");
    }
}

