/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.entity.resolve.types;

import com.entitystream.identiza.entity.resolve.processing.GradientGenerator;
import com.entitystream.identiza.entity.resolve.types.Standardized;
import com.entitystream.identiza.entity.resolve.types.StandardizedSerialized;
import com.entitystream.identiza.entity.resolve.utils.EditDistance;
import com.entitystream.identiza.wordlist.WordList;
import java.util.ArrayList;

public class StandardPersonName
extends StandardizedSerialized {
    private int gradient;

    public StandardPersonName() {
    }

    public StandardPersonName(String[] words, WordList anon, WordList cv, int gradient, String name) {
        super(words, anon, cv, gradient, name);
        this.gradient = gradient;
    }

    @Override
    public double compare(Standardized otherstd, WordList anon, WordList cv, boolean isSearch, boolean asContent) {
        ArrayList comparitorTokens = ((StandardPersonName)otherstd).baseTokens;
        double[] gradients = GradientGenerator.generate(Math.min(comparitorTokens.size(), this.baseTokens.size()), Math.max(comparitorTokens.size(), this.baseTokens.size()), 2.0, 0.5, 1.0, this.gradient);
        double ret = 0.0;
        if (gradients != null) {
            boolean notsameflag = false;
            double divisor = GradientGenerator.sum(gradients);
            double edit = 0.0;
            edit = asContent ? EditDistance.getHaynesEditDistanceOfArrayList(this.baseTokens, comparitorTokens, anon, cv, gradients, true) : EditDistance.getSimpleEditDistanceOfArrayList(this.baseTokens, comparitorTokens, anon, cv, gradients);
            String val1 = (String)this.baseTokens.get(0);
            String val2 = (String)comparitorTokens.get(0);
            if (this.baseTokens.contains("MR") && comparitorTokens.contains("MRS") || this.baseTokens.contains("MR") && comparitorTokens.contains("MISS") || this.baseTokens.contains("MR") && comparitorTokens.contains("MS") || this.baseTokens.contains("MRS") && comparitorTokens.contains("MR") || this.baseTokens.contains("MISS") && comparitorTokens.contains("MR") || this.baseTokens.contains("MS") && comparitorTokens.contains("MR")) {
                notsameflag = true;
            } else if ((val1.equals("MR") || val1.equals("MRS") || val1.equals("MS") || val1.equals("MISS") || val1.equals("DR")) && (val2.equals("MR") || val2.equals("MRS") || val2.equals("MS") || val2.equals("MISS") || val2.equals("DR")) && this.baseTokens.size() > 1 && comparitorTokens.size() > 1) {
                if (((String)this.baseTokens.get(1)).length() > 1 && ((String)comparitorTokens.get(1)).length() > 1) {
                    if (!((String)this.baseTokens.get(1)).substring(0, 2).equalsIgnoreCase(((String)comparitorTokens.get(1)).substring(0, 2))) {
                        edit += 2.0;
                    }
                } else if (((String)this.baseTokens.get(1)).length() > 0 && ((String)comparitorTokens.get(1)).length() > 0 && ((String)this.baseTokens.get(1)).charAt(0) != ((String)comparitorTokens.get(1)).charAt(0)) {
                    edit += 2.0;
                }
            }
            if (isSearch) {
                if (edit > 0.0) {
                    edit -= (double)Math.abs(this.baseTokens.size() - comparitorTokens.size());
                }
                if (edit < 0.0) {
                    edit = 0.0;
                }
                if (notsameflag) {
                    edit = divisor;
                }
                ret = 100.0 * (divisor - edit) / divisor;
            } else {
                if (notsameflag) {
                    edit = divisor;
                }
                ret = 100.0 * (divisor - edit) / divisor;
            }
        }
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkInitials(ArrayList<String> baseTokens, ArrayList<String> compTokens, WordList cv, WordList anon) {
        void var7_10;
        StringBuilder baseInitials = new StringBuilder();
        for (String string : baseTokens) {
            if (string.length() <= 0 || (anon == null || anon.inlist(string)) && anon != null) continue;
            ArrayList parents = new ArrayList();
            baseInitials.append(string.charAt(0));
        }
        StringBuilder compInitials = new StringBuilder();
        for (String w : compTokens) {
            if (w.length() <= 0 || (anon == null || anon.inlist(w)) && anon != null) continue;
            ArrayList parents = new ArrayList();
            compInitials.append(w.charAt(0));
        }
        boolean bl = false;
        String shortest = "";
        String longest = "";
        if (baseInitials.length() > compInitials.length()) {
            shortest = compInitials.toString();
            longest = baseInitials.toString();
        } else {
            shortest = baseInitials.toString();
            longest = compInitials.toString();
        }
        block2: for (int i = 0; i < shortest.length(); ++i) {
            for (int j = 0; j < longest.length(); ++j) {
                if (shortest.charAt(i) != longest.charAt(j)) continue;
                ++var7_10;
                continue block2;
            }
        }
        return var7_10 == shortest.length();
    }
}

