/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.entity.resolve.types;

import com.entitystream.identiza.entity.resolve.processing.GradientGenerator;
import com.entitystream.identiza.entity.resolve.types.Standardized;
import com.entitystream.identiza.entity.resolve.types.StandardizedSerialized;
import com.entitystream.identiza.entity.resolve.utils.EditDistance;
import com.entitystream.identiza.entity.resolve.utils.NYSIIS;
import com.entitystream.identiza.wordlist.WordList;
import java.util.ArrayList;

public class StandardPhonetic
extends StandardizedSerialized {
    public ArrayList<String> baseTokens = new ArrayList();
    private int gradient;

    public StandardPhonetic() {
    }

    public StandardPhonetic(String originalText, String[] words, WordList anon, WordList cv, int gradient, String name) {
        super(words, anon, cv, gradient, name);
        this.gradient = gradient;
        ArrayList<String> baseTokensNew = new ArrayList<String>();
        for (String word : this.baseTokens) {
            baseTokensNew.add(NYSIIS.encode(word));
        }
        this.baseTokens = baseTokensNew;
    }

    @Override
    public double compare(Standardized otherstd, WordList anon, WordList cv, boolean isSearch, boolean asContent) {
        ArrayList<String> comparitorTokens = ((StandardPhonetic)otherstd).baseTokens;
        double[] gradients = GradientGenerator.generate(Math.min(comparitorTokens.size(), this.baseTokens.size()), Math.max(comparitorTokens.size(), this.baseTokens.size()), 2.0, 0.5, 0.1, this.gradient);
        double ret = 0.0;
        if (gradients != null) {
            double edit = EditDistance.getLevenshteinDistanceOfStringArrayList(this.baseTokens, comparitorTokens, anon, cv, gradients);
            double divisor = GradientGenerator.sum(gradients);
            if (isSearch) {
                if (edit > 0.0) {
                    edit -= (double)Math.abs(this.baseTokens.size() - comparitorTokens.size());
                }
                if (edit < 0.0) {
                    edit = 0.0;
                }
                ret = 100.0 * (divisor - edit) / divisor;
            } else {
                ret = 100.0 * (divisor - edit) / divisor;
            }
        }
        return ret;
    }
}

