/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.entity.resolve.types;

import com.entitystream.identiza.entity.resolve.types.Standardized;
import com.entitystream.identiza.wordlist.WordList;
import com.entitystream.identiza.wordlist.WordObject;
import com.entitystream.monster.db.Document;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

public class StandardizedSerialized
implements Standardized {
    protected ArrayList<String> baseTokens = new ArrayList();
    protected String[] originalWords;

    public StandardizedSerialized() {
    }

    public StandardizedSerialized(String[] words, WordList anon, WordList cv, int gradient, String ruleFunction) {
        String trall;
        WordObject wo;
        if (words == null) {
            words = new String[]{};
        }
        this.originalWords = words;
        StringBuilder sb = new StringBuilder();
        for (String word : words) {
            sb.append(word.toUpperCase() + " ");
        }
        String all = sb.toString().trim();
        boolean tf = false;
        if (!anon.inlist(all) && (wo = cv.getWord(all)) != null && (trall = wo.getParent()) != null) {
            all = trall;
            tf = true;
        }
        if (!tf) {
            sb = new StringBuilder();
            String[] stringArray = words;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String word = stringArray[i];
                if (anon.inlist(word)) continue;
                WordObject wo2 = cv.getWord(word);
                String trword = null;
                if (wo2 != null) {
                    trword = wo2.getParent();
                }
                if (trword != null) {
                    tf = true;
                    word = trword;
                } else {
                    word = WordList.Singularize(word);
                }
                if (anon.inlist(word)) continue;
                sb.append(word.toUpperCase() + " ");
            }
            all = sb.toString().trim();
        }
        this.baseTokens = new ArrayList();
        for (String s : all.split(" ")) {
            if (s == null || s.trim().length() <= 0) continue;
            this.baseTokens.add(s.toUpperCase());
        }
    }

    @Override
    public double compare(Standardized otherstd, WordList anon, WordList cv, boolean isSearch, boolean asContent) {
        return 0.0;
    }

    @Override
    public String[] getComparitorWords() {
        if (this.originalWords != null) {
            return this.originalWords;
        }
        return this.baseTokens.toArray(new String[this.baseTokens.size()]);
    }

    @Override
    public String[] getCalculatedWords() {
        if (this.baseTokens != null) {
            return this.baseTokens.toArray(new String[this.baseTokens.size()]);
        }
        return null;
    }

    @Override
    public Document toDocument() {
        Document ret = new Document("Class", this.getClass().getName());
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field f : this.getClass().getDeclaredFields()) {
            fields.add(f);
        }
        for (Field f : this.getClass().getSuperclass().getDeclaredFields()) {
            fields.add(f);
        }
        for (Field f : fields) {
            f.setAccessible(true);
            try {
                if (Modifier.isStatic(f.getModifiers())) continue;
                if (f.getType().isArray()) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (String o : (String[])f.get(this)) {
                        list.add(o);
                    }
                    ret.append(f.getName(), list);
                    continue;
                }
                ret.append(f.getName(), f.get(this));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public static Standardized fromDocument(Document from) {
        try {
            String className = (String)from.get("Class");
            Class<?> clazz = Class.forName(className);
            Standardized std = (Standardized)clazz.newInstance();
            for (String fname : from.keyString()) {
                if (fname.equalsIgnoreCase("Class")) continue;
                try {
                    Field f = null;
                    try {
                        f = clazz.getDeclaredField(fname);
                    }
                    catch (NoSuchFieldException e) {
                        try {
                            f = clazz.getSuperclass().getDeclaredField(fname);
                        }
                        catch (NoSuchFieldException noSuchFieldException) {
                            // empty catch block
                        }
                    }
                    if (f == null) continue;
                    f.setAccessible(true);
                    if (from.get(fname) instanceof List && f.getType().isArray()) {
                        f.set(std, ((List)from.get(fname)).toArray(new String[((List)from.get(fname)).size()]));
                        continue;
                    }
                    if (from == null) continue;
                    if (f.getGenericType().getTypeName().equalsIgnoreCase("int")) {
                        if (from.getInteger(fname) != null) {
                            f.setInt(std, from.getInteger(fname));
                            continue;
                        }
                        f.setInt(std, (int)from.getLong(fname));
                        continue;
                    }
                    if (f.getGenericType().getTypeName().equalsIgnoreCase("double") && from.getDouble(fname) != null) {
                        f.setDouble(std, from.getDouble(fname));
                        continue;
                    }
                    if (f.getGenericType().getTypeName().equalsIgnoreCase("boolean")) {
                        f.setBoolean(std, from.getBoolean(fname, false));
                        continue;
                    }
                    if (f.getGenericType().getTypeName().equalsIgnoreCase("long")) {
                        f.setLong(std, from.getLong(fname));
                        continue;
                    }
                    f.set(std, from.get(fname));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return std;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String computeFn() {
        return null;
    }
}

