/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.entity.resolve.utils;

import com.entitystream.identiza.entity.resolve.processing.GradientGenerator;
import com.entitystream.identiza.wordlist.WordList;
import java.io.Serializable;
import java.util.ArrayList;

public class EditDistance
implements Serializable {
    public static double getLevenshteinDistanceOfString(String s, String t) {
        int i;
        if (s == null || t == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        double[] p = new double[n + 1];
        double[] d = new double[n + 1];
        for (i = 0; i <= n; ++i) {
            p[i] = i;
        }
        for (int j = 1; j <= m; ++j) {
            char t_j = t.charAt(j - 1);
            d[0] = j;
            for (i = 1; i <= n; ++i) {
                double cost = s.charAt(i - 1) == t_j ? 0.0 : 1.0;
                d[i] = Math.min(Math.min(d[i - 1] + 1.0, p[i] + 1.0), p[i - 1] + cost);
            }
            double[] _d = p;
            p = d;
            d = _d;
        }
        return p[n];
    }

    public static double getWeightedLevenshteinDistanceOfString(String s, String t, int gradientType) {
        int i;
        if (s == null || t == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        int n = s.length();
        int m = t.length();
        double[] gradients = GradientGenerator.generate(Math.min(n, m), Math.max(n, m), 1.0, 1.0, 0.0, gradientType);
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        double[] p = new double[n + 1];
        double[] d = new double[n + 1];
        for (i = 0; i <= n; ++i) {
            p[i] = i;
        }
        for (int j = 1; j <= m; ++j) {
            char t_j = t.charAt(j - 1);
            d[0] = j;
            for (i = 1; i <= n; ++i) {
                double cost = EditDistance.convertCostByGradient(s.charAt(i - 1) == t_j ? 0.0 : 1.0, i - 1, j - 1, gradients);
                d[i] = Math.min(Math.min(d[i - 1] + 1.0, p[i] + 1.0), p[i - 1] + cost);
            }
            double[] _d = p;
            p = d;
            d = _d;
        }
        return p[n];
    }

    private static double getCost(String one, String two, WordList anon, WordList cv) {
        if (one.equals(two)) {
            return 0.0;
        }
        if (anon != null) {
            if (!anon.isUsefulForComparison(one, 1) || !anon.isUsefulForComparison(two, 1)) {
                return 0.1;
            }
        } else {
            if (!WordList.sisUsefulForComparison(one, 1) && !WordList.sisUsefulForComparison(two, 1)) {
                return 1.0;
            }
            if (WordList.sisUsefulForComparison(one, 1) != WordList.sisUsefulForComparison(two, 1)) {
                return 1.0;
            }
        }
        if (cv != null) {
            return cv.isStemmed(one, two);
        }
        if (one.startsWith(two) || two.startsWith(one)) {
            return 0.8;
        }
        return EditDistance.getLevenshteinDistanceOfString(one, two) / (double)Math.min(one.length(), two.length());
    }

    public static double getHaynesEditDistanceOfArrayList(ArrayList<String> s, ArrayList<String> t, WordList anon, WordList cv, double[] gradients) {
        return EditDistance.getHaynesEditDistanceOfArrayList(s, t, anon, cv, gradients, true);
    }

    public static double getSimpleEditDistanceOfArrayList(ArrayList<String> s, ArrayList<String> t, WordList anon, WordList cv, double[] gradients) {
        ArrayList<String> largest;
        ArrayList<String> smallest;
        if (s.size() >= t.size()) {
            smallest = t;
            largest = s;
        } else {
            smallest = s;
            largest = t;
        }
        double cost = 0.0;
        int lpos = -1;
        for (String lString : largest) {
            int spos = -1;
            ++lpos;
            double costWord = Double.MAX_VALUE;
            double gradientWord = 0.0;
            for (String sString : smallest) {
                ++spos;
                double costTemp = EditDistance.getCost(lString, sString, anon, cv);
                if (costTemp <= costWord) {
                    costWord = costTemp;
                    gradientWord = Math.max(gradients[spos], gradients[lpos]);
                }
                if (costWord != 0.0) continue;
                break;
            }
            cost += (costWord *= gradientWord);
        }
        return cost;
    }

    public static double getHaynesEditDistanceOfArrayList(ArrayList<String> s, ArrayList<String> t, WordList anon, WordList cv, double[] gradients, boolean asContent) {
        ArrayList<String> largest;
        ArrayList<String> smallest;
        if (s.size() >= t.size()) {
            if (!asContent) {
                smallest = t;
                largest = s;
            } else {
                smallest = s;
                largest = t;
            }
        } else if (!asContent) {
            smallest = s;
            largest = t;
        } else {
            smallest = t;
            largest = s;
        }
        double cost = 0.0;
        int lpos = -1;
        ArrayList<Integer> lastGoodMatch = new ArrayList<Integer>();
        for (String lString : largest) {
            int spos = -1;
            ++lpos;
            double costWord = 1000000.0;
            ArrayList<Integer> bestMatchPos = new ArrayList<Integer>();
            String rs = "";
            for (String sString : smallest) {
                ++spos;
                double temp = 0.0;
                temp = EditDistance.getCost(lString, sString, anon, cv) * gradients[lpos];
                if (!(temp < gradients[lpos])) continue;
                boolean clearAfter = false;
                if (lastGoodMatch.size() == 0) {
                    lastGoodMatch.add(-1);
                    clearAfter = true;
                }
                double posWeight = 1000000.0;
                for (Integer lastGoodMatchToUse : lastGoodMatch) {
                    if (lastGoodMatchToUse == -1) {
                        lastGoodMatchToUse = spos - 1;
                    }
                    double posWTemp = (1.0 * (double)Math.abs(spos - lastGoodMatchToUse) - 1.0) / (1.0 * (double)Math.max(s.size(), t.size()));
                    posWeight = Math.min(posWeight, posWTemp);
                }
                temp += posWeight;
                if (clearAfter) {
                    lastGoodMatch.remove(0);
                }
                if (!(temp <= costWord)) continue;
                bestMatchPos.add(spos);
                costWord = temp;
            }
            lastGoodMatch = bestMatchPos;
            cost += costWord;
        }
        return cost;
    }

    public static double getLevenshteinDistanceOfStringArrayList(ArrayList<String> s, ArrayList<String> t, WordList anon, WordList cv, double[] gradients) {
        if (s.size() > t.size()) {
            return EditDistance.getLevenshteinDistanceOfStringArrayList(s, t, anon, cv, gradients, false);
        }
        return EditDistance.getLevenshteinDistanceOfStringArrayList(t, s, anon, cv, gradients, false);
    }

    public static double getLevenshteinDistanceOfStringArrayList(ArrayList<String> s, ArrayList<String> t, WordList anon, WordList cv, double[] gradients, boolean asContent) {
        int i;
        if (s == null || t == null) {
            throw new IllegalArgumentException("ArrayLists must not be null");
        }
        int n = s.size();
        int m = t.size();
        double[] p = new double[n + 1];
        double[] d = new double[n + 1];
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        double cost = 0.0;
        for (i = 0; i <= n; ++i) {
            p[i] = i;
        }
        for (int j = 1; j <= n; ++j) {
            d[0] = j;
            if (t.size() <= j - 1) continue;
            String t_j = t.get(j - 1);
            for (i = 1; i <= n; ++i) {
                cost = !s.get(i - 1).equalsIgnoreCase(t_j) ? 1 : 0;
                d[i] = Math.min(Math.min(d[i - 1] + 1.0, p[i] + 1.0), p[i - 1] + cost);
            }
            double[] _d = p;
            p = d;
            d = _d;
        }
        return cost;
    }

    private static double convertCostByGradient(double cost, int pos1, int pos2, double[] gradient) {
        return cost * Math.max(gradient[Math.min(pos1, gradient.length - 1)], gradient[Math.min(pos2, gradient.length - 1)]);
    }

    public static int getDemerauLevenshteinDistanceOfMatch(int[] match) {
        int i;
        if (match == null) {
            throw new IllegalArgumentException("Match array must not be null");
        }
        int n = match.length;
        if (n == 0) {
            return 0;
        }
        int[] p = new int[n + 1];
        int[] d = new int[n + 1];
        for (i = 0; i <= n; ++i) {
            p[i] = i;
        }
        for (int j = 1; j <= n; ++j) {
            d[0] = j;
            for (i = 1; i <= n; ++i) {
                int cost = match[i - 1] > 0 ? 0 : 1;
                d[i] = Math.min(Math.min(d[i - 1] + 1, p[i] + 1), p[i - 1] + cost);
            }
            int[] _d = p;
            p = d;
            d = _d;
        }
        return p[n];
    }

    public static int niceParseInt(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception e) {
            String newString = "";
            for (int i = 0; i < string.length(); ++i) {
                if (!"0123456789".contains("" + string.charAt(i))) continue;
                newString = newString + string.charAt(i);
            }
            try {
                return Integer.parseInt(newString);
            }
            catch (Exception ee) {
                return -1;
            }
        }
    }

    public static int findToken(String[] words, String[] tokens) {
        int wordpos = -1;
        for (String word : words) {
            ++wordpos;
            for (String token : tokens) {
                if (!token.equalsIgnoreCase(word)) continue;
                return wordpos;
            }
        }
        return -1;
    }

    public static void main(String[] args) {
        ArrayList<String> s = new ArrayList<String>();
        ArrayList<String> t = new ArrayList<String>();
        s.add("SUE");
        s.add("LUE");
        t.add("SU");
        t.add("LU");
        double[] gradients = GradientGenerator.generate(2, 2, 2.0, 0.0, 1.0, GradientGenerator.LINEAR);
        double e = EditDistance.getSimpleEditDistanceOfArrayList(s, t, null, null, gradients);
        System.out.println(e);
    }
}

