/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.entity.resolve.utils;

import com.entitystream.identiza.wordlist.WordList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class MinHash<T> {
    private static final int NGRAMS = 0;
    private int[] hash;
    private int numHash;
    private static int NHASH = 500;
    Random r = new Random();
    private int bmax;
    private int hashCodeSizeDiff;
    private int hashCount = 200;
    int[] randoms = new int[this.hashCount];

    public MinHash(int numHash) {
        this.numHash = numHash;
        this.hash = new int[numHash];
        Random r = new Random(11L);
        for (int i = 0; i < numHash; ++i) {
            int x;
            int a = r.nextInt();
            int b = r.nextInt();
            int c = r.nextInt();
            this.hash[i] = x = MinHash.hash(a * b * c, a, b, c);
        }
    }

    public double similarity(Set<T> set1, Set<T> set2) {
        int numSets = 2;
        Map<T, boolean[]> bitMap = this.buildBitMap(set1, set2);
        int[][] minHashValues = MinHash.initializeHashBuckets(numSets, this.numHash);
        this.computeMinHashForSet(set1, 0, minHashValues, bitMap);
        this.computeMinHashForSet(set2, 1, minHashValues, bitMap);
        return MinHash.computeSimilarityFromSignatures(minHashValues, this.numHash);
    }

    private static int[][] initializeHashBuckets(int numSets, int numHashFunctions) {
        int[][] minHashValues = new int[numSets][numHashFunctions];
        for (int i = 0; i < numSets; ++i) {
            for (int j = 0; j < numHashFunctions; ++j) {
                minHashValues[i][j] = Integer.MAX_VALUE;
            }
        }
        return minHashValues;
    }

    private static double computeSimilarityFromSignatures(int[][] minHashValues, int numHashFunctions) {
        int identicalMinHashes = 0;
        for (int i = 0; i < numHashFunctions; ++i) {
            if (minHashValues[0][i] != minHashValues[1][i]) continue;
            ++identicalMinHashes;
        }
        return 1.0 * (double)identicalMinHashes / (double)numHashFunctions;
    }

    private static int hash(int x, int a, int b, int c) {
        int hashValue = a * (x >> 4) + b * x + c & 0x1FFFF;
        return Math.abs(hashValue);
    }

    private void computeMinHashForSet(Set<T> set, int setIndex, int[][] minHashValues, Map<T, boolean[]> bitArray) {
        int index = 0;
        for (T element : bitArray.keySet()) {
            for (int i = 0; i < this.numHash; ++i) {
                int hindex;
                if (!set.contains(element) || (hindex = this.hash[index]) >= minHashValues[setIndex][index]) continue;
                minHashValues[setIndex][index] = hindex;
            }
            ++index;
        }
    }

    public Map<T, boolean[]> buildBitMap(Set<T> set1, Set<T> set2) {
        HashMap<T, boolean[]> bitArray = new HashMap<T, boolean[]>();
        for (T t : set1) {
            bitArray.put(t, new boolean[]{true, false});
        }
        for (T t : set2) {
            if (bitArray.containsKey(t)) {
                bitArray.put(t, new boolean[]{true, true});
                continue;
            }
            if (bitArray.containsKey(t)) continue;
            bitArray.put(t, new boolean[]{false, true});
        }
        return bitArray;
    }

    public void initRandom() {
        int machineWordSize = 32;
        int hashCodeSize = machineWordSize / 2;
        int hashCodeSizeDiff = machineWordSize - hashCodeSize;
        this.bmax = 1 << hashCodeSizeDiff;
        for (int i = 0; i < this.hashCount; ++i) {
            this.randoms[i] = this.r.nextInt();
        }
    }

    public int getMinHash(Set<String> set, int hcr) {
        int hashCode = Integer.MAX_VALUE;
        for (String s : set) {
            int hstart = s.hashCode();
            int hc = hstart * (hcr * 2 + 1) + this.randoms[hcr] >> this.hashCodeSizeDiff;
            if (hc >= hashCode) continue;
            hashCode = hc;
        }
        return hashCode;
    }

    public int[] getSignature(Set<String> set) {
        int[] sign = new int[200];
        for (int i = 0; i < 200; ++i) {
            sign[i] = this.getMinHash(set, i);
        }
        return sign;
    }

    private static double computeSimilarityFromSignatures(int[] minHashValues1, int[] minHashValues2) {
        int identicalMinHashes = 0;
        for (int i = 0; i < 200; ++i) {
            if (minHashValues1[i] != minHashValues2[i]) continue;
            ++identicalMinHashes;
        }
        return 1.0 * (double)identicalMinHashes / 200.0;
    }

    public static Set<String> shingle(String[] list) {
        HashSet<String> returnn = new HashSet<String>();
        for (int i = 0; i < list.length - 0; ++i) {
            StringBuilder sb = new StringBuilder();
            for (int j = i; j < i + 0; ++j) {
                sb.append(list[j]);
            }
            returnn.add(sb.toString());
        }
        return returnn;
    }

    public static void main(String[] args) {
        String one = "Thank you for registering with my easyJet. Welcome, we look forward to seeing you on board soon and getting you set for takeoff. Keep an eye on your inbox too as we'll be dropping a quick hello over the next few days with some of our latest, greatest fares. Or visit us online now at easyjet.com Now that you have registered you will be able to manage all your easyJet.com online bookings. Here's what your membership profile currently looks like";
        Set<String> set1 = MinHash.shingle(WordList.split(one));
        String two = "Thank you for registering with my telstra. Welcome, we look forward to seeing you online soon and getting you set with my tv. Keep an eye on your inbox too as we'll be dropping a quick hello over the next few days with some of our latest, greatest fares. Or visit us online now at easyjet.com Now that you have registered you will be able to manage all your telstra services. Here's what your membership profile currently looks like";
        Set<String> set2 = MinHash.shingle(WordList.split(two));
        MinHash<String> minHash = new MinHash<String>(set1.size() + set2.size());
        System.out.println(minHash.similarity(set1, set2));
        minHash.initRandom();
        int[] ones = minHash.getSignature(set1);
        int[] twos = minHash.getSignature(set2);
        System.out.println(MinHash.computeSimilarityFromSignatures(ones, twos));
    }
}

