/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.entity.resolve.utils;

import java.io.Serializable;
import java.util.logging.Logger;

public final class NYSIIS
implements Serializable {
    private static Logger logger = Logger.getLogger("com.identiza");

    public static String encode(String originalWord) {
        StringBuilder word = null;
        if (originalWord == null || originalWord.length() <= 0) {
            return "";
        }
        word = new StringBuilder(originalWord.toUpperCase());
        if (word.length() > 3) {
            while (word.toString().endsWith("S") || word.toString().endsWith("Z")) {
                word.deleteCharAt(word.length() - 1);
            }
        }
        NYSIIS.replaceFront(word, "MAC", "MC");
        NYSIIS.replaceFront(word, "PF", "F");
        NYSIIS.replaceEnd(word, "IX", "IC");
        NYSIIS.replaceEnd(word, "EX", "EC");
        NYSIIS.replaceEnd(word, "YE", "Y");
        NYSIIS.replaceEnd(word, "EE", "Y");
        NYSIIS.replaceEnd(word, "IE", "Y");
        NYSIIS.replaceEnd(word, "DT", "D");
        NYSIIS.replaceEnd(word, "RD", "D");
        NYSIIS.replaceEnd(word, "NT", "N");
        NYSIIS.replaceEnd(word, "ND", "N");
        NYSIIS.replaceAll(word, "EV", "EF", 1);
        NYSIIS.replaceAll(word, "CI", "SI");
        NYSIIS.replaceAll(word, "CY", "SI");
        char first = word.length() > 0 ? (char)word.charAt(0) : (char)' ';
        NYSIIS.replaceAll(word, "E", "A");
        NYSIIS.replaceAll(word, "I", "A");
        NYSIIS.replaceAll(word, "O", "A");
        NYSIIS.replaceAll(word, "U", "A");
        NYSIIS.replaceAll(word, "AW", "A");
        NYSIIS.replaceAll(word, "GHT", "GT");
        NYSIIS.replaceAll(word, "DG", "G");
        NYSIIS.replaceAll(word, "PH", "F");
        NYSIIS.replaceAll(word, "ACKS", "AX");
        NYSIIS.replaceAll(word, "AH", "A", 1);
        NYSIIS.replaceAll(word, "HA", "A", 1);
        NYSIIS.replaceAll(word, "KN", "N");
        NYSIIS.replaceAll(word, "K", "C");
        NYSIIS.replaceAll(word, "M", "N", 1);
        NYSIIS.replaceAll(word, "Q", "G", 1);
        NYSIIS.replaceAll(word, "SH", "S");
        NYSIIS.replaceAll(word, "SCH", "S");
        NYSIIS.replaceAll(word, "YW", "Y");
        NYSIIS.replaceAll(word, "Y", "A", 1, word.length() - 2);
        NYSIIS.replaceAll(word, "WR", "R");
        NYSIIS.replaceAll(word, "Z", "S", 1);
        NYSIIS.replaceEnd(word, "AY", "Y");
        while (word.toString().endsWith("A")) {
            word.deleteCharAt(word.length() - 1);
        }
        word = NYSIIS.reduceDuplicates(word);
        if ('A' == first || 'E' == first || 'I' == first || 'O' == first || 'U' == first) {
            if (word.length() > 0) {
                word.deleteCharAt(0);
            }
            word.insert(0, first);
        }
        return word.toString();
    }

    private static StringBuilder reduceDuplicates(StringBuilder word) {
        StringBuilder newWord = new StringBuilder();
        if (0 == word.length()) {
            return word;
        }
        char lastChar = word.charAt(0);
        newWord.append(lastChar);
        for (int i = 1; i < word.length(); ++i) {
            if (lastChar != word.charAt(i)) {
                newWord.append(word.charAt(i));
            }
            lastChar = word.charAt(i);
        }
        NYSIIS.log("reduceDuplicates: " + word);
        return newWord;
    }

    public static void replaceAll(StringBuilder word, String find, String repl) {
        NYSIIS.replaceAll(word, find, repl, 0, -1);
    }

    public static void replaceAll(StringBuilder word, String find, String repl, int startPos) {
        NYSIIS.replaceAll(word, find, repl, startPos, -1);
    }

    public static void replaceAll(StringBuilder word, String find, String repl, int startPos, int endPos) {
        int pos = word.toString().indexOf(find, startPos);
        if (-1 == endPos) {
            endPos = word.length() - 1;
        }
        while (-1 != pos) {
            if (-1 != endPos && pos > endPos) {
                NYSIIS.log("stopping pos > endPos: " + pos + ":" + endPos);
                break;
            }
            word.delete(pos, pos + find.length());
            if (pos <= word.length()) {
                word.insert(pos, repl);
            }
            pos = word.toString().indexOf(find);
            NYSIIS.log("replaceAll[" + find + "," + repl + "]: " + word);
        }
    }

    private static void replaceFront(StringBuilder word, String find, String repl) {
        if (word.toString().startsWith(find)) {
            word.delete(0, find.length());
            word.insert(0, repl);
            NYSIIS.log("replaceFront[" + find + "]: " + word);
        }
    }

    private static void replaceEnd(StringBuilder word, String find, String repl) {
        if (word.toString().endsWith(find)) {
            word.delete(word.length() - find.length(), word.length());
            word.append(repl);
            NYSIIS.log("replaceEnd[" + find + "]: " + word);
        }
    }

    private static void log(String msg) {
    }

    public static boolean isEncodeEqual(String s1, String s2) {
        return NYSIIS.encode(s1).equals(NYSIIS.encode(s2));
    }

    public static String extendedEncode(String trim) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < trim.length(); ++i) {
            if ("aeiouy".indexOf(trim.charAt(i)) != -1 && i != 0 && i != trim.length() - 1) continue;
            sb.append(trim.charAt(i));
        }
        return NYSIIS.encode(sb.toString());
    }

    public static String soundex(String s) {
        char[] x = s.toUpperCase().toCharArray();
        char firstLetter = x[0];
        block8: for (int i = 0; i < x.length; ++i) {
            switch (x[i]) {
                case 'B': 
                case 'F': 
                case 'P': 
                case 'V': {
                    x[i] = 49;
                    continue block8;
                }
                case 'C': 
                case 'G': 
                case 'J': 
                case 'K': 
                case 'Q': 
                case 'S': 
                case 'X': 
                case 'Z': {
                    x[i] = 50;
                    continue block8;
                }
                case 'D': 
                case 'T': {
                    x[i] = 51;
                    continue block8;
                }
                case 'L': {
                    x[i] = 52;
                    continue block8;
                }
                case 'M': 
                case 'N': {
                    x[i] = 53;
                    continue block8;
                }
                case 'R': {
                    x[i] = 54;
                    continue block8;
                }
                default: {
                    x[i] = 48;
                }
            }
        }
        String output = "" + firstLetter;
        for (int i = 1; i < x.length; ++i) {
            if (x[i] == x[i - 1] || x[i] == '0') continue;
            output = output + x[i];
        }
        output = output + "0000";
        return output.substring(0, 4);
    }
}

