/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.entity.resolve.utils;

import java.util.ArrayList;
import java.util.List;

public class Syllables {
    public static ArrayList<Integer> getWordSyllablesFromLine(String line) {
        String[] words;
        ArrayList<Integer> wordSyllables = new ArrayList<Integer>();
        Integer totalSyllables = 0;
        if (line == null || line.length() == 0) {
            return wordSyllables;
        }
        for (String word : words = line.split(" ")) {
            wordSyllables.add(Syllables.getSyllableCountFromWord(word));
        }
        return wordSyllables;
    }

    public static Integer getSyllableCountFromLine(List<String> line) {
        Integer totalSyllables = 0;
        for (String word : line) {
            totalSyllables = totalSyllables + Syllables.getSyllableCountFromWord(word);
        }
        return totalSyllables;
    }

    public static Integer getSyllableCountFromLine(String line) {
        String[] words;
        Integer totalSyllables = 0;
        if (line == null || line.length() == 0) {
            return 0;
        }
        for (String word : words = line.split(" ")) {
            totalSyllables = totalSyllables + Syllables.getSyllableCountFromWord(word);
        }
        return totalSyllables;
    }

    public static Integer getSyllableCountFromWord(String word) {
        return Syllables.getSyllablesFromWord(word).size();
    }

    public static List<String> getSyllablesFromWord(String word) {
        word = word.toLowerCase();
        ArrayList<String> syllables = new ArrayList<String>();
        int marker = 0;
        while (true) {
            List<String> clusters = Syllables.getClustersFromWord(word.substring(marker));
            String currentSyllable = "";
            if (clusters.size() == 1 && syllables.size() == 0) {
                syllables.add(clusters.get(0));
                break;
            }
            if (clusters.size() == 2 && clusters.get(1).equals("e") && syllables.size() == 0) {
                syllables.add(clusters.get(0) + clusters.get(1));
                break;
            }
            if (clusters.size() == 1) {
                String lastSyllable = (String)syllables.remove(syllables.size() - 1);
                lastSyllable = lastSyllable + clusters.get(0);
                syllables.add(lastSyllable);
                break;
            }
            if (clusters.size() == 2 && clusters.get(1).equals("e")) {
                String lastSyllable = (String)syllables.remove(syllables.size() - 1);
                if (clusters.get(0) != null) {
                    lastSyllable = lastSyllable + clusters.get(0);
                }
                lastSyllable = lastSyllable + clusters.get(1);
                syllables.add(lastSyllable);
                break;
            }
            if (clusters.get(0) != null) {
                currentSyllable = currentSyllable + clusters.get(0);
            }
            if (Syllables.isMultisyllableVowelCluster(clusters.get(1))) {
                currentSyllable = currentSyllable + clusters.get(1).substring(0, 1);
            } else {
                currentSyllable = currentSyllable + clusters.get(1);
                if (clusters.size() > 2 && clusters.get(2) != null && clusters.get(2).length() > 1) {
                    currentSyllable = currentSyllable + clusters.get(2).substring(0, 1);
                }
            }
            syllables.add(currentSyllable);
            marker += currentSyllable.length();
        }
        return syllables;
    }

    static boolean isMultisyllableVowelCluster(String cluster) {
        if (cluster.length() > 2) {
            return true;
        }
        return cluster.equals("eo") || cluster.equals("ia") || cluster.equals("io") || cluster.equals("ua") || cluster.equals("uo");
    }

    static List<String> getClustersFromWord(String word) {
        ArrayList<String> clusters = new ArrayList<String>();
        StringBuffer currentCluster = new StringBuffer();
        boolean buildingConsonantCluster = true;
        for (int i = 0; i < word.length(); ++i) {
            char c = word.charAt(i);
            if (i == 0 && Syllables.isVowel(c)) {
                clusters.add(null);
                currentCluster.append(c);
                continue;
            }
            if (buildingConsonantCluster && Syllables.isVowel(c)) {
                clusters.add(currentCluster.toString());
                currentCluster.delete(0, currentCluster.length());
                currentCluster.append(c);
                buildingConsonantCluster = false;
                continue;
            }
            if (!buildingConsonantCluster && Syllables.isConsonant(c)) {
                clusters.add(currentCluster.toString());
                currentCluster.delete(0, currentCluster.length());
                currentCluster.append(c);
                buildingConsonantCluster = true;
                continue;
            }
            if (buildingConsonantCluster && Syllables.isConsonant(c)) {
                currentCluster.append(c);
                continue;
            }
            if (!buildingConsonantCluster && Syllables.isVowel(c)) {
                currentCluster.append(c);
                continue;
            }
            throw new RuntimeException("I missed a case in the clustering code");
        }
        clusters.add(currentCluster.toString());
        return clusters;
    }

    static boolean isConsonant(char c) {
        return !Syllables.isVowel(c);
    }

    static boolean isVowel(char c) {
        return c == 'a' || c == 'e' || c == 'i' || c == 'o' || c == 'u' || c == 'y' || c == 'A' || c == 'E' || c == 'I' || c == 'O' || c == 'U' || c == 'Y';
    }
}

