/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.metadata;

import com.entitystream.identiza.metadata.Project;
import com.entitystream.monster.db.Document;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public class ProjectImpl
implements Serializable,
Project {
    private String projectName;
    private String schemaName;
    private String groupName;
    private String owner;
    private HashMap<String, Properties> customMenus = new HashMap();
    private String dbServer;
    private String userExit;
    private boolean onload;
    private static Logger logger = Logger.getLogger("com.identiza");

    public ProjectImpl() {
    }

    public ProjectImpl(String project, String owner, String schemaName, String group, HashMap<String, Properties> customMenus, String url, String userExit, int dbType, boolean onLoad2) {
        this.schemaName = schemaName;
        this.setProjectName(project);
        this.owner = owner;
        this.groupName = group;
        this.userExit = userExit;
        this.onload = onLoad2;
        this.setCustomMenus(customMenus);
        this.setDBServer(url);
    }

    public ProjectImpl(Document document) {
        this.schemaName = document.getString("SchemaName");
        this.projectName = document.getString("ProjectName");
        this.owner = document.getString("owner");
        this.groupName = document.getString("groupName");
        this.userExit = document.getString("userExit");
        if (document.get("customMenus") != null) {
            this.setCustomMenus(document.getAsDocument("customMenus"));
        }
        this.dbServer = document.getString("dbServer");
    }

    @Override
    public Document toDocument() {
        Document document = new Document();
        document.append("SchemaName", this.schemaName);
        document.append("ProjectName", this.projectName);
        document.append("groupName", this.groupName);
        document.append("owner", this.owner);
        document.append("userExit", this.userExit);
        document.append("dbServer", this.dbServer);
        document.append("customMenus", this.customMenus);
        return document;
    }

    private void setCustomMenus(Document document) {
        this.customMenus = new HashMap();
        for (String cmname : document.keyString()) {
            Properties props = new Properties();
            props.putAll((Map<?, ?>)document.getAsMap(cmname));
            this.customMenus.put(cmname, props);
        }
    }

    private void setDBServer(String url) {
        this.dbServer = url;
    }

    @Override
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @Override
    public String getProjectName() {
        return this.projectName;
    }

    @Override
    public void setCustomMenus(HashMap<String, Properties> customMenus) {
        this.customMenus = customMenus;
    }

    @Override
    public HashMap<String, Properties> getCustomMenus() {
        return this.customMenus;
    }

    @Override
    public String getDBServer() {
        return this.dbServer;
    }

    @Override
    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Override
    public void setDbServer(String dbServer) {
        this.dbServer = dbServer;
    }

    @Override
    public String getUserExit() {
        return this.userExit;
    }

    @Override
    public void setUserExit(String userExit) {
        this.userExit = userExit;
    }

    @Override
    public int getDbType() {
        return 1;
    }

    @Override
    public void setDbType(int type) {
    }

    @Override
    public boolean onLoad() {
        return this.onload;
    }

    @Override
    public void setOnLoad(boolean ol) {
        this.onload = ol;
    }
}

