/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.userexits;

import com.entitystream.identiza.userexits.JobObject;
import com.entitystream.identiza.userexits.MergeObject;
import com.entitystream.identiza.userexits.MessageObject;
import com.entitystream.identiza.userexits.PostTaskObject;
import com.entitystream.identiza.userexits.PreTaskObject;
import com.entitystream.identiza.userexits.TimerObject;
import com.entitystream.identiza.userexits.UpdateObject;
import com.entitystream.identiza.userexits.UserExitInterface;
import com.entitystream.monster.db.Document;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Logger;

public class UserExitController
implements Serializable {
    private static final long serialVersionUID = 1486171557334566058L;
    private static Logger logger = Logger.getLogger("com.identiza");
    private String schemaKey;
    private UserExitInterface userExitObject;

    public UserExitController(String schemaName, String projectName, String groupName, String uEDetails) {
        String[] temp;
        String uEName = null;
        Properties props = new Properties();
        for (String temp2 : temp = uEDetails.split(",")) {
            String[] parts = temp2.split("=");
            if (parts.length != 2) continue;
            if (parts[0].equalsIgnoreCase("classname")) {
                uEName = parts[1].trim();
                continue;
            }
            props.put(parts[0].trim(), parts[1].trim());
        }
        this.schemaKey = schemaName + ":" + projectName + ":" + groupName;
        try {
            if (uEName != null) {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(uEName);
                Constructor<?> cons = clazz.getConstructor(new Class[0]);
                UserExitInterface userExit = (UserExitInterface)cons.newInstance(new Object[0]);
                userExit.initialize(schemaName, projectName, groupName, props);
                this.putUserExitObject(userExit);
            } else {
                this.schemaKey = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private UserExitInterface getUserExitObject() {
        return this.userExitObject;
    }

    private void putUserExitObject(UserExitInterface ue) {
        this.userExitObject = ue;
    }

    public void callPostMerge(MergeObject mergeObject) {
        if (this.schemaKey != null) {
            logger.info("Post Merge Fired");
            UserExitInterface ue = this.getUserExitObject();
            ue.postMerge(mergeObject);
            this.putUserExitObject(ue);
        }
    }

    public void callPostUpdate(UpdateObject updateObject) {
        if (this.schemaKey != null) {
            logger.info("Post Update Fired");
            UserExitInterface ue = this.getUserExitObject();
            ue.postUpdate(updateObject);
            this.putUserExitObject(ue);
        }
    }

    public void callPreMerge(MergeObject mergeObject) {
        if (this.schemaKey != null) {
            logger.info("Pre Merge Fired");
            UserExitInterface ue = this.getUserExitObject();
            ue.preMerge(mergeObject);
            this.putUserExitObject(ue);
        }
    }

    public Document callPreUpdate(UpdateObject updateObject) {
        if (this.schemaKey != null) {
            logger.info("Pre Update Fired");
            UserExitInterface ue = this.getUserExitObject();
            Document ret = ue.preUpdate(updateObject);
            this.putUserExitObject(ue);
            return ret;
        }
        return null;
    }

    public void callPreJob(JobObject jobObject) {
        if (this.schemaKey != null) {
            logger.info("Pre Job Fired");
            UserExitInterface ue = this.getUserExitObject();
            ue.preJob(jobObject);
            this.putUserExitObject(ue);
        }
    }

    public void callPostJob(JobObject jobObject) {
        if (this.schemaKey != null) {
            logger.info("Post Job Fired");
            UserExitInterface ue = this.getUserExitObject();
            ue.postJob(jobObject);
            this.putUserExitObject(ue);
        }
    }

    public void callOnTimer(TimerObject timerObject) {
        if (this.schemaKey != null) {
            UserExitInterface ue = this.getUserExitObject();
            ue.onTimer(timerObject);
            this.putUserExitObject(ue);
        }
    }

    public HashMap<String, String> callProcessMessage(MessageObject msgObject) {
        if (this.schemaKey != null) {
            logger.info("Process Message Fired");
            UserExitInterface ue = this.getUserExitObject();
            HashMap<String, String> ret = ue.processMessage(msgObject);
            this.putUserExitObject(ue);
            return ret;
        }
        return null;
    }

    public String callPreTask(PreTaskObject taskObject) {
        if (this.schemaKey != null) {
            logger.info("Pre Task Fired");
            UserExitInterface ue = this.getUserExitObject();
            String ret = ue.preTask(taskObject);
            this.putUserExitObject(ue);
            return ret;
        }
        return null;
    }

    public void callOnResolveTask(PostTaskObject postTaskObject) {
        if (this.schemaKey != null) {
            logger.info("resolve task Fired");
            UserExitInterface ue = this.getUserExitObject();
            ue.onResolveTask(postTaskObject);
            this.putUserExitObject(ue);
        }
    }

    public HashMap<String, Properties> getCustomMenuItems() {
        if (this.schemaKey != null) {
            logger.info("get custom menus called");
            UserExitInterface ue = this.getUserExitObject();
            return ue.getCustomMenuItems();
        }
        return null;
    }

    public void callCustomMenu(String menuName, Properties props) {
        if (this.schemaKey != null) {
            logger.info("get custom menus called");
            UserExitInterface ue = this.getUserExitObject();
            try {
                String method = ue.getCustomMenuItems().get(menuName).getProperty("methodName");
                Method meth = ue.getClass().getMethod(method, Properties.class);
                meth.invoke((Object)ue, props);
            }
            catch (Exception e) {
                logger.severe(e.toString());
            }
        }
    }
}

