/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.wordlist;

import com.entitystream.identiza.wordlist.RuleSet;
import com.entitystream.identiza.wordlist.RuleSetMap;
import com.entitystream.monster.db.Document;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;

public class RuleFactory {
    private static final long serialVersionUID = -6554438074408458768L;
    private static RuleSetMap rulesets = new RuleSetMap();
    private static boolean offline = false;

    public static void setOffline() {
        offline = true;
    }

    public static void setOnline() {
        offline = false;
    }

    public static RuleSet getInstance(String purposeColumnName) {
        if (rulesets.containsKey(purposeColumnName)) {
            return (RuleSet)rulesets.get(purposeColumnName);
        }
        RuleSet rules = RuleSet.emptyRuleSet();
        rulesets.put(purposeColumnName, rules);
        return rules;
    }

    public static void invalidate() {
        rulesets = new RuleSetMap();
    }

    public static void build(String purposeColumnName, List<Document> list) {
        if (rulesets == null) {
            RuleFactory.invalidate();
        }
        if (!rulesets.containsKey(purposeColumnName)) {
            rulesets.put(purposeColumnName, RuleSet.createRuleSet(list.iterator()));
        } else {
            RuleSet.updateRuleSet((RuleSet)rulesets.get(purposeColumnName), list.iterator());
        }
    }

    public static RuleSetMap getRuleSetMap() {
        return rulesets;
    }

    public static void setRuleSetMap(RuleSetMap rsm) {
        System.out.println("Initialised " + rsm.size() + " rule sets: " + rsm.keySet().toString());
        rulesets = rsm;
    }

    public static Object executeApiCall(String string) {
        block7: {
            DefaultHttpClient hc = new DefaultHttpClient();
            String url = "http://online.mdm4free.com/api/1.0/" + string + "?access_token=09a529e8-3cbd-48b9-9de7-87d8f08a3398";
            HttpGet get = new HttpGet(url);
            HttpResponse resp = hc.execute((HttpUriRequest)get);
            if (resp.getStatusLine().getStatusCode() != 200) break block7;
            HttpEntity entity = resp.getEntity();
            String body = EntityUtils.toString((HttpEntity)entity);
            try {
                JsonParser parser = new JsonParser();
                JsonElement element = parser.parse(body);
                Gson gson = new Gson();
                ArrayList<Document> ret = null;
                if (element.isJsonArray()) {
                    ret = new ArrayList<Document>();
                    for (JsonElement el : element.getAsJsonArray()) {
                        ret.add(Document.parse(gson.toJson((JsonElement)el.getAsJsonObject())));
                    }
                    return ret;
                }
                return Document.parse(gson.toJson((JsonElement)element.getAsJsonObject()));
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        return null;
    }

    public static void main(String[] args) {
        String[] purposes = new String[]{"MatchCompanyName", "MatchPersonName", "MatchCountry"};
        RuleFactory.invalidate();
        for (String purpose : purposes) {
            ArrayList elemlist = (ArrayList)RuleFactory.executeApiCall("rule/" + purpose);
            if (elemlist == null) continue;
            RuleFactory.build(purpose, elemlist);
        }
        RuleSetMap rsm = RuleFactory.getRuleSetMap();
        try {
            FileOutputStream fos = new FileOutputStream("/Users/roberthaynes/EntityStream/userdata/rules/ruleset.map");
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(rsm);
            oos.flush();
            oos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

