/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.wordlist;

import com.entitystream.identiza.wordlist.AnonymousWordList;
import com.entitystream.identiza.wordlist.ControlledVocabularyWordList;
import com.entitystream.identiza.wordlist.WordList;
import com.entitystream.identiza.wordlist.WordObject;
import com.entitystream.monster.db.Document;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RuleSet
implements Serializable {
    private static final long serialVersionUID = -7626868195796103299L;
    ControlledVocabularyWordList keyCV;
    AnonymousWordList keyAnon;
    ControlledVocabularyWordList ruleCV;
    AnonymousWordList ruleAnon;
    ControlledVocabularyWordList keyLookup;
    ControlledVocabularyWordList ruleLookup;

    private RuleSet() {
        try {
            this.keyCV = new ControlledVocabularyWordList();
            this.keyCV.setChildisParent(false);
            this.ruleCV = new ControlledVocabularyWordList();
            this.ruleCV.setChildisParent(false);
            this.keyAnon = new AnonymousWordList();
            this.keyAnon.setChildisParent(false);
            this.ruleAnon = new AnonymousWordList();
            this.ruleAnon.setChildisParent(false);
            this.keyLookup = new ControlledVocabularyWordList();
            this.keyLookup.setChildisParent(true);
            this.ruleLookup = new ControlledVocabularyWordList();
            this.ruleLookup.setChildisParent(true);
        }
        catch (Exception e) {
            Logger.getLogger("RuleSet").log(Level.SEVERE, "Failed to create ruleset with an error");
            e.printStackTrace();
        }
    }

    public List<Document> toDocuments(String purpose, boolean custom) {
        ArrayList<Document> ret = new ArrayList<Document>();
        ret.addAll(this.toDocuments(this.keyCV, "EK", purpose, custom));
        ret.addAll(this.toDocuments(this.ruleCV, "ER", purpose, custom));
        ret.addAll(this.toDocuments(this.keyCV, "NK", purpose, custom));
        ret.addAll(this.toDocuments(this.ruleCV, "NR", purpose, custom));
        ret.addAll(this.toDocuments(this.keyAnon, "IK", purpose, custom));
        ret.addAll(this.toDocuments(this.ruleAnon, "IR", purpose, custom));
        ret.addAll(this.toDocuments(this.keyLookup, "TK", purpose, custom));
        ret.addAll(this.toDocuments(this.ruleLookup, "TR", purpose, custom));
        return ret;
    }

    private List<Document> toDocuments(WordList wl, String ty, String purpose, boolean custom) {
        ArrayList<Document> ret = new ArrayList<Document>();
        for (WordObject wo : wl.getList().values()) {
            if (!ty.endsWith(wo.getRuleType()) || wo.isCustom() != custom) continue;
            ret.add(wo.toDocument(purpose));
        }
        return ret;
    }

    private WordList getForPrefix(String prefix) {
        if (prefix.startsWith("IK")) {
            return this.keyAnon;
        }
        if (prefix.startsWith("IR")) {
            return this.ruleAnon;
        }
        if (prefix.startsWith("ER")) {
            return this.ruleCV;
        }
        if (prefix.startsWith("EK")) {
            return this.keyCV;
        }
        if (prefix.startsWith("NR")) {
            return this.ruleCV;
        }
        if (prefix.startsWith("NK")) {
            return this.keyCV;
        }
        if (prefix.startsWith("TK")) {
            return this.keyLookup;
        }
        if (prefix.startsWith("TR")) {
            return this.ruleLookup;
        }
        return null;
    }

    public static RuleSet createRuleSet(Iterator<Document> docs) {
        RuleSet rules = new RuleSet();
        return RuleSet.updateRuleSet(rules, docs);
    }

    public static RuleSet updateRuleSet(RuleSet rules, Iterator<Document> docs) {
        try {
            Object line = null;
            Object parentkey = null;
            while (docs.hasNext()) {
                String ruleType;
                Document ruleo = docs.next();
                System.out.println(ruleo);
                Document rule = null;
                if (ruleo instanceof Map) {
                    rule = new Document(ruleo);
                }
                if (ruleo instanceof Document) {
                    rule = ruleo;
                }
                if ((ruleType = rule.getString("type")) == null || ruleType.length() <= 0) continue;
                WordList wl = rules.getForPrefix(ruleType);
                boolean same = true;
                boolean ignore = false;
                String parent = rule.getString("parent");
                boolean isCustom = rule.getBoolean("custom", false);
                boolean childIsParent = false;
                if (parent == null || parent.length() == 0) {
                    childIsParent = true;
                }
                if (ruleType.charAt(0) == 'N') {
                    same = false;
                }
                if (ruleType.charAt(0) == 'E' || ruleType.charAt(0) == 'T') {
                    same = true;
                }
                if (ruleType.charAt(0) == 'I') {
                    ignore = true;
                }
                if (ruleType.charAt(0) == 'T') {
                    childIsParent = true;
                }
                List items = null;
                if (rule.get("items") instanceof List) {
                    items = (List)rule.get("items");
                } else {
                    Logger.getLogger("RuleSet").log(Level.SEVERE, parent + " has invalid items");
                }
                if (items == null || items.size() <= 0) continue;
                if (ignore) {
                    for (String word : items) {
                        wl.addWord(word, ruleType, isCustom);
                    }
                    continue;
                }
                if (ruleType.charAt(0) == 'T') {
                    wl.addWord(parent, parent, false, ruleType, isCustom);
                    for (String word : items) {
                        if (parent == null || word == null || word.equals(parent)) continue;
                        wl.addWord(word, parent, same, ruleType, isCustom);
                        if (!childIsParent) continue;
                        wl.addWord(parent, word, same, ruleType, isCustom);
                    }
                    continue;
                }
                for (String word : items) {
                    wl.addWord(word, (String)items.get(0), same, ruleType, isCustom);
                }
            }
        }
        catch (Exception io) {
            io.printStackTrace();
            Logger.getLogger("RuleSet").log(Level.SEVERE, "Rules could not be loaded from DB for the ruleset to load " + io.toString());
        }
        return rules;
    }

    public ControlledVocabularyWordList getKeyControlledVocabulary() {
        return this.keyCV;
    }

    public ControlledVocabularyWordList getRuleControlledVocabulary() {
        return this.ruleCV;
    }

    public ControlledVocabularyWordList getKeyLookup() {
        return this.keyLookup;
    }

    public ControlledVocabularyWordList getRuleLookup() {
        return this.ruleLookup;
    }

    public AnonymousWordList getKeyAnon() {
        return this.keyAnon;
    }

    public AnonymousWordList getRuleAnon() {
        return this.ruleAnon;
    }

    public static RuleSet emptyRuleSet() {
        return new RuleSet();
    }

    public static RuleSet createRuleSet(Document def) {
        RuleSet ruleSet = new RuleSet();
        ruleSet.keyAnon = def.getAsDocument("keyAnon").toObject(AnonymousWordList.class);
        ruleSet.keyCV = def.getAsDocument("keyCV").toObject(ControlledVocabularyWordList.class);
        ruleSet.keyLookup = def.getAsDocument("keyLookup").toObject(ControlledVocabularyWordList.class);
        ruleSet.ruleAnon = def.getAsDocument("ruleAnon").toObject(AnonymousWordList.class);
        ruleSet.ruleCV = def.getAsDocument("ruleCV").toObject(ControlledVocabularyWordList.class);
        ruleSet.ruleLookup = def.getAsDocument("ruleLookup").toObject(ControlledVocabularyWordList.class);
        return ruleSet;
    }
}

