/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.wordlist;

import com.entitystream.identiza.wordlist.RuleFactory;
import com.entitystream.identiza.wordlist.RuleSet;
import com.entitystream.monster.db.Document;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RuleSetMap
extends HashMap<String, RuleSet>
implements Serializable {
    private static final long serialVersionUID = 4178085864661851225L;

    public RuleSetMap(Map<String, RuleSet> mapin) {
        this.putAll(mapin);
    }

    public RuleSetMap() {
        this.clear();
    }

    public Document toDocument(boolean custom) {
        Document ret = new Document();
        for (String purpose : this.keySet()) {
            ret.append(purpose, ((RuleSet)this.get(purpose)).toDocuments(purpose, custom));
        }
        return ret;
    }

    public static RuleSetMap toMap(Document d) {
        RuleSetMap map = new RuleSetMap();
        for (Object purpose : d.keySet()) {
            RuleSet rs;
            Object purObject = d.get((String)purpose);
            if (purObject instanceof Document) {
                Document purpDoc = (Document)purObject;
                rs = RuleSet.createRuleSet(purpDoc);
                map.put((String)purpose, rs);
                continue;
            }
            List purDocs = d.getList((String)purpose);
            rs = RuleSet.createRuleSet(purDocs.iterator());
            map.put((String)purpose, rs);
        }
        return map;
    }

    public static RuleSetMap readMap(String schemaDir) {
        RuleSetMap map = new RuleSetMap();
        String mapfile = schemaDir + "/ruleset.map";
        String mapcust = schemaDir + "/ruleset.custom";
        File mapf = new File(mapfile);
        File mapc = new File(mapcust);
        try {
            if (mapf.exists()) {
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(mapf));
                Object o = ois.readObject();
                if (o instanceof RuleSetMap) {
                    map = (RuleSetMap)o;
                }
                ois.close();
            }
            if (mapc.exists()) {
                BufferedReader reader = new BufferedReader(new FileReader(mapc));
                String line = null;
                StringBuilder sb = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                }
                reader.close();
                Document rules = Document.parse(sb.toString());
                for (String matchClass : rules.keyString()) {
                    if (matchClass == null || rules == null || rules.get(matchClass) == null) continue;
                    RuleFactory.build(matchClass, (List)rules.get(matchClass));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public static void writeMap(String schemaDir, RuleSetMap map) {
        String mapcust = schemaDir + "/ruleset.custom";
        File mapc = new File(mapcust);
        try {
            FileWriter fos = new FileWriter(mapc);
            BufferedWriter bfw = new BufferedWriter(fos);
            bfw.write(map.toDocument(true).toJson());
            bfw.flush();
            bfw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String map2 = schemaDir + "/ruleset.map";
        File map2f = new File(map2);
        try {
            FileOutputStream fos = new FileOutputStream(map2f);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(map);
            oos.flush();
            oos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

