/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.wordlist;

import com.entitystream.identiza.entity.resolve.processing.IdentizaException;
import com.entitystream.identiza.entity.resolve.utils.NYSIIS;
import com.entitystream.identiza.wordlist.WordListInterface;
import com.entitystream.identiza.wordlist.WordObject;
import java.io.Serializable;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class WordList
implements WordListInterface,
Serializable {
    private static final long serialVersionUID = 4653120858149359117L;
    public static int WORDSWITHNUMBERS = 0;
    public static int ACRONYMS = 1;
    public static int VOCABULARY = 2;
    public static int PHONETIC = 3;
    public static int NAMES = 4;
    public static int ANONYMOUS = 5;
    public static int MATCH = 6;
    protected static int listType;
    private HashMap<String, WordObject> list;
    protected String fileLoc = null;
    protected char prefix = (char)86;
    private boolean isPhonetic = false;

    public WordList(int _listType) {
        this.setListType(_listType);
        if (_listType == WORDSWITHNUMBERS) {
            this.prefix = (char)79;
        }
        if (_listType == ACRONYMS) {
            this.prefix = (char)65;
        }
        if (_listType == VOCABULARY) {
            this.prefix = (char)86;
        }
        if (_listType == PHONETIC) {
            this.prefix = (char)80;
        }
        if (_listType == NAMES) {
            this.prefix = (char)78;
        }
        if (_listType == ANONYMOUS) {
            this.prefix = (char)90;
        }
        this.list = new HashMap();
    }

    public boolean isPhonetic() {
        return this.isPhonetic;
    }

    public void setPhonetic(boolean isPhonetic) {
        this.isPhonetic = isPhonetic;
    }

    public String addWord(String word, String parentString, boolean same, String type, boolean custom) {
        word = WordList.Singularize(word).toUpperCase().trim();
        String key = this.generateKey(word);
        WordObject wordo = this.getWord(word);
        if (wordo == null) {
            wordo = new WordObject(word, key, type);
        }
        wordo.setCustom(custom);
        wordo.addParent(parentString, same);
        this.list.put(key, wordo);
        return key;
    }

    public Map<String, WordObject> getList() {
        return this.list;
    }

    public String addWord(String word, String type, boolean custom) {
        String key = this.generateKey(word = WordList.Singularize(word).toUpperCase().trim());
        WordObject wordo = this.getWord(key);
        if (wordo == null) {
            wordo = new WordObject(word, key, type);
        }
        this.list.put(key, wordo);
        return key;
    }

    public double isStemmed(String word1, String word2) {
        String key1 = this.generateKey(word1);
        String key2 = this.generateKey(word2);
        if (key1 == null || key2 == null) {
            return 1.0;
        }
        WordObject wordo1 = this.getWord(key1);
        WordObject wordo2 = this.getWord(key2);
        if (wordo1 == null || wordo2 == null) {
            return 1.0;
        }
        ArrayList<String> parent1 = wordo1.getSameParents();
        ArrayList<String> parent2 = wordo2.getSameParents();
        if (parent1.contains(key2) || parent2.contains(key1)) {
            return 0.1;
        }
        for (String ky : parent1) {
            if (ky.toString().equals(key2.toString())) {
                return 0.15;
            }
            for (String ky2 : parent2) {
                if (!ky.toString().equals(ky2.toString())) continue;
                return 0.2;
            }
        }
        for (String ky : parent2) {
            if (ky.toString().equals(key1.toString())) {
                return 0.15;
            }
            for (String ky2 : parent1) {
                if (!ky.toString().equals(ky2.toString())) continue;
                return 0.2;
            }
        }
        return 1.0;
    }

    public String getStem(String word1) {
        String key1 = this.generateKey(word1);
        if (key1 == null) {
            return word1;
        }
        WordObject wordo1 = this.getWord(key1);
        if (wordo1 == null) {
            return word1;
        }
        ArrayList<String> parent1 = wordo1.getSameParents();
        if (parent1 == null || parent1.size() == 0) {
            return word1;
        }
        return parent1.get(0);
    }

    public WordObject getWord(String word) {
        if (word != null) {
            return this.list.get(this.generateKey(word));
        }
        return null;
    }

    public boolean inlist(String word) {
        word = WordList.Singularize(word).toUpperCase().trim();
        String key = this.generateKey(word);
        return this.list.containsKey(key);
    }

    public boolean isUseful(String word) {
        if ((word = WordList.Singularize(word).toUpperCase().trim()).length() < 2) {
            return false;
        }
        if (word.contains("@")) {
            return false;
        }
        if (word.contains("/")) {
            return false;
        }
        if (word.contains("\\")) {
            return false;
        }
        if (word.contains("" + word.charAt(0) + word.charAt(0) + word.charAt(0))) {
            return false;
        }
        return !this.list.containsKey(this.generateKey(word).toString());
    }

    public boolean isUsefulForComparison(String word, int min) {
        if ((word = WordList.Singularize(word).toUpperCase().trim()).length() < min) {
            return false;
        }
        return !this.list.containsKey(this.generateKey(word).toString());
    }

    public static boolean sisUsefulForComparison(String word, int min) {
        return (word = WordList.Singularize(word).toUpperCase().trim()).length() >= min;
    }

    private static int decodeSingle(char letter) {
        switch (letter) {
            case 'M': {
                return 1000;
            }
            case 'D': {
                return 500;
            }
            case 'C': {
                return 100;
            }
            case 'L': {
                return 50;
            }
            case 'X': {
                return 10;
            }
            case 'V': {
                return 5;
            }
            case 'I': {
                return 1;
            }
        }
        return 0;
    }

    public static String getNumber(String word) {
        if (word.matches("^M{0,4}(CM|CD|D?C{0,3})(XC|XL|L?X{0,3})(IX|IV|V?I{0,3})$")) {
            int result = 0;
            String uRoman = word.toUpperCase();
            for (int i = 0; i < uRoman.length() - 1; ++i) {
                if (WordList.decodeSingle(uRoman.charAt(i)) < WordList.decodeSingle(uRoman.charAt(i + 1))) {
                    result -= WordList.decodeSingle(uRoman.charAt(i));
                    continue;
                }
                result += WordList.decodeSingle(uRoman.charAt(i));
            }
            return "" + (result += WordList.decodeSingle(uRoman.charAt(uRoman.length() - 1)));
        }
        if (!word.matches("\\w*[a-zA-Z]\\w*")) {
            try {
                return NumberFormat.getInstance().parse(word).toString();
            }
            catch (ParseException e) {
                return word;
            }
        }
        return word;
    }

    public static boolean containsAnyNumbers(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        if (str.toUpperCase().matches("^M{0,4}(CM|CD|D?C{0,3})(XC|XL|L?X{0,3})(IX|IV|V?I{0,3})$")) {
            return true;
        }
        return !str.matches("[a-zA-Z]*");
    }

    public void setListType(int listType) {
        WordList.listType = listType;
    }

    public int getListType() {
        return listType;
    }

    private static boolean seemsPluralised(String name) {
        boolean es = name.toLowerCase().endsWith("es");
        boolean ies = name.toLowerCase().endsWith("ies");
        boolean s = name.toLowerCase().endsWith("s");
        boolean ss = name.toLowerCase().endsWith("ss");
        boolean result = name.length() > 3 && (es || s || ies) && !ss;
        return result;
    }

    public static String Singularize(String name) {
        String result = name;
        if (WordList.seemsPluralised(name)) {
            if (name.toLowerCase().endsWith("ies")) {
                result = name.substring(0, name.length() - 3) + "y";
            } else if (name.toLowerCase().endsWith("s")) {
                result = name.substring(0, name.length() - 1);
            }
        }
        return result;
    }

    @Override
    public String generateKey(String word) {
        word = word.toUpperCase().trim().replaceAll("[\\x01-\\x1F]", "");
        if (this.isPhonetic) {
            String[] words = WordList.split(word);
            StringBuilder sb = new StringBuilder();
            for (String wordo : words) {
                sb.append(NYSIIS.encode(wordo));
            }
            word = sb.toString();
        }
        return word;
    }

    public static String deInitialise(String in) {
        String temp2;
        int newlen;
        String temp = in + " ";
        int origlen = temp.length();
        if (origlen - (newlen = (temp2 = temp.replaceAll(" ", "")).length()) >= newlen) {
            return temp2;
        }
        return in;
    }

    public static String[] split(String value) {
        String[] res = value.toLowerCase().replaceAll("'", "").split("(\\.\\x20)|\\x20|\\-|,|!|\\?|:|;|&|<|>|=|\\r|\\n|\\t|=|\\+|\\*|/|\\)|\\(|\\]|\\[|\\{|\\}|&");
        ArrayList<String> temp = new ArrayList<String>();
        for (String newvalue : res) {
            if ((newvalue = newvalue.replaceAll("\\.", "").trim()).length() <= 0) continue;
            temp.add(newvalue);
        }
        return temp.toArray(new String[temp.size()]);
    }

    public static void main(String[] args) {
        for (String i : WordList.split("ABN AMRO Bank N.V {New York]")) {
            System.out.println(i);
        }
    }

    public static String clean(String val) {
        return val.replaceAll("[|\\.|,|!|?|:|;| |(|)|&|@|<|>|'|\"|\\[|\\]|(|)|/|\n|\r|\t|=|]|\\+|\\-|\\s|\\*", "").trim().toUpperCase();
    }

    public static String cleanLeaveDashes(String val) {
        return val.replaceAll("[|\\.|,|!|?|:|;| |(|)|&|@|<|>|'|\"|\\[|\\]|(|)|/|\n|\r|\t|=|]|\\+|\\s|\\*", "").trim().toUpperCase();
    }

    public static String cleanLeaveSpaces(String val) {
        if (val != null) {
            return val.replaceAll("[|:|;|(|)|'|\"|\\[|\\]|(|)|]|\n|\r|\\p{C}|\\x00\\x08\\x0B\\x0C\\x0E-\\x1F|\\u2122", "").trim();
        }
        return "";
    }

    public boolean load() throws IdentizaException {
        return false;
    }

    public String startsWith(String fullValue) {
        for (String key : this.list.keySet()) {
            if (!fullValue.startsWith(this.list.get(key).getWord())) continue;
            return this.list.get(key).getWord();
        }
        return "";
    }

    public String removeAnon(String fullValue) {
        for (String key : this.list.keySet()) {
            if (!fullValue.contains(this.list.get(key).getWord())) continue;
            fullValue = fullValue.replaceAll(this.list.get(key).getWord(), "");
        }
        return fullValue;
    }

    public static String serialiseArrayString(ArrayList<String> arrayList) {
        String res = "";
        for (String sr : arrayList) {
            res = res + ";" + sr;
        }
        if (res.length() > 1) {
            return res.substring(1);
        }
        return "";
    }

    public static ArrayList<String> deserialiseArrayString(String in) {
        String[] list = in.split(";");
        ArrayList<String> res = new ArrayList<String>();
        for (String s : list) {
            res.add(s);
        }
        return res;
    }

    public boolean isBadWords(String[] words, String[] comparitorWords) {
        for (String word : words) {
            Set<String> badWords;
            WordObject wordo = this.getWord(word);
            if (wordo == null || (badWords = wordo.getDiffParents()).size() <= 0) continue;
            for (String comparitor : comparitorWords) {
                for (String temp : badWords) {
                    if (!temp.trim().equalsIgnoreCase(comparitor.trim())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean load(boolean childisparent) throws IdentizaException {
        return false;
    }

    @Override
    public void setChildisParent(boolean childisparent) throws IdentizaException {
    }

    public void clear() {
        this.list.clear();
    }

    public static String printDifference(Date startDate, Date endDate) {
        long different = endDate.getTime() - startDate.getTime();
        long secondsInMilli = 1000L;
        long minutesInMilli = secondsInMilli * 60L;
        long hoursInMilli = minutesInMilli * 60L;
        long daysInMilli = hoursInMilli * 24L;
        long elapsedDays = different / daysInMilli;
        long elapsedHours = (different %= daysInMilli) / hoursInMilli;
        long elapsedMinutes = (different %= hoursInMilli) / minutesInMilli;
        long elapsedSeconds = (different %= minutesInMilli) / secondsInMilli;
        if (elapsedDays > 0L) {
            return elapsedDays + " day " + elapsedHours + " hours";
        }
        if (elapsedHours > 0L) {
            return elapsedHours + " hours " + elapsedMinutes + " min";
        }
        if (elapsedMinutes > 0L) {
            return elapsedMinutes + ":" + elapsedSeconds;
        }
        if (elapsedSeconds > 0L) {
            return elapsedSeconds + "s";
        }
        return "0 min";
    }
}

