/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.wordlist;

import com.entitystream.identiza.wordlist.Stringer;
import com.entitystream.monster.db.Document;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class WordObject
implements Serializable {
    private static final long serialVersionUID = 7418738679398167805L;
    private String word;
    private HashSet<Stringer> parent;
    private String parentLookup;
    private String key;
    private int weighting;
    private String type;
    private boolean custom;

    public WordObject(String _word, String key, String type) {
        this.word = _word;
        this.parent = new HashSet();
        this.type = type;
        this.setString(key);
    }

    public WordObject(String word, String key, String parent, boolean same, String type) {
        this(word, key, type);
        this.parent.add(new Stringer(parent, same));
        this.parentLookup = parent;
    }

    public void setWord(String word) {
        this.word = word;
    }

    public String getWord() {
        return this.word;
    }

    public void addParent(String parent, boolean same) {
        if (this.parentLookup == null) {
            this.parentLookup = parent;
        }
        if (parent != null) {
            this.parent.add(new Stringer(parent, same));
        }
    }

    public boolean hasParents() {
        return !this.parent.isEmpty();
    }

    public String getParent() {
        return this.parentLookup;
    }

    public ArrayList<String> getSameParents() {
        ArrayList<String> parentBack = new ArrayList<String>();
        for (Stringer stringer : this.parent) {
            if (!stringer.bool) continue;
            parentBack.add(stringer.string);
        }
        return parentBack;
    }

    public Set<String> getDiffParents() {
        HashSet<String> parentBack = new HashSet<String>();
        for (Stringer stringer : this.parent) {
            if (stringer.bool) continue;
            parentBack.add(stringer.string);
        }
        return parentBack;
    }

    public void setWeighting(int weighting) {
        this.weighting = weighting;
    }

    public int getWeighting() {
        return this.weighting;
    }

    public void setString(String key) {
        this.key = key;
    }

    public String getString() {
        return this.key;
    }

    public String getRuleType() {
        return this.type;
    }

    public Document toDocument(String purpose) {
        Document d = new Document("type", this.getRuleType());
        d.append("rulePurpose", purpose);
        if (this.getRuleType().startsWith("T")) {
            d.append("parent", this.word);
        }
        ArrayList<String> listp = new ArrayList<String>();
        if (!this.getRuleType().startsWith("T")) {
            listp.add(this.word);
        }
        for (Stringer stringer : this.parent) {
            listp.add(stringer.string);
        }
        d.append("items", listp);
        return d;
    }

    public boolean isCustom() {
        return this.custom;
    }

    public void setCustom(boolean custom) {
        this.custom = custom;
    }
}

