/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.monster.geo;

import com.entitystream.monster.geo.GeoType;
import com.entitystream.monster.geo.Line;
import com.entitystream.monster.geo.LineString;
import com.entitystream.monster.geo.Point;
import com.entitystream.monster.geo.Polygon;

public class Centre
implements GeoType {
    private Point centre;
    private double radius;

    public Centre(Point centre, double radius) {
        this.centre = centre;
        this.radius = radius;
    }

    public Point getFrom() {
        return this.centre;
    }

    public Point getTo() {
        return null;
    }

    @Override
    public Point[] getPoints() {
        return null;
    }

    public double getRadius() {
        return this.radius;
    }

    @Override
    public boolean checkInside(GeoType geo) {
        if (geo instanceof Point) {
            double x = ((Point)geo).getX();
            double y = ((Point)geo).getY();
            double dx = x - this.getFrom().getX();
            if (dx > this.getRadius()) {
                return false;
            }
            double dy = y - this.getFrom().getY();
            if (dy > this.getRadius()) {
                return false;
            }
            if (dx + dy <= this.getRadius()) {
                return true;
            }
            return dx * dx + dy * dy <= this.getRadius() * this.getRadius();
        }
        if (geo instanceof LineString) {
            for (Point point : ((LineString)geo).getPoints()) {
                if (this.checkInside(point)) continue;
                return false;
            }
            return true;
        }
        if (geo instanceof Line) {
            return this.checkInside(((Line)geo).getFrom()) && this.checkInside(((Line)geo).getTo());
        }
        if (geo instanceof Polygon) {
            for (Point point : ((Polygon)geo).getPoints()) {
                if (this.checkInside(point)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

