/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.monster.geo;

import com.entitystream.monster.db.Document;
import com.entitystream.monster.geo.Centre;
import com.entitystream.monster.geo.Line;
import com.entitystream.monster.geo.LineString;
import com.entitystream.monster.geo.Point;
import com.entitystream.monster.geo.Polygon;
import com.github.davidmoten.geo.Coverage;
import com.github.davidmoten.geo.GeoHash;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public interface GeoType {
    public boolean checkInside(GeoType var1);

    public Point[] getPoints();

    public static GeoType fromDoc(Document document) {
        if (document.containsKey("$geoWithin")) {
            document = document.getAsDocument("$geoWithin");
        }
        if (document.containsKey("type")) {
            List point;
            if (document.getString("type").equalsIgnoreCase("Polygon")) {
                for (Object coords : document.getList("coordinates")) {
                    if (!(coords instanceof List)) continue;
                    List coordinner = (List)coords;
                    Point[] points = new Point[coordinner.size()];
                    int posCo = -1;
                    for (Object point2 : coordinner) {
                        if (!(point2 instanceof List)) continue;
                        int pos = -1;
                        double x = 0.0;
                        double y = 0.0;
                        for (Object xy : (List)point2) {
                            if (++pos == 0) {
                                x = ((Number)xy).doubleValue();
                                continue;
                            }
                            y = ((Number)xy).doubleValue();
                        }
                        points[++posCo] = new Point(x, y);
                    }
                    return new Polygon(points);
                }
            } else if (document.getString("type").equalsIgnoreCase("LineString")) {
                List coords = document.getList("coordinates");
                if (coords instanceof List) {
                    List coordinner = coords;
                    Point[] points = new Point[coordinner.size()];
                    int posCo = -1;
                    for (Object point3 : coordinner) {
                        if (!(point3 instanceof List)) continue;
                        int pos = -1;
                        double x = 0.0;
                        double y = 0.0;
                        for (Object xy : (List)point3) {
                            if (++pos == 0) {
                                x = ((Number)xy).doubleValue();
                                continue;
                            }
                            y = ((Number)xy).doubleValue();
                        }
                        points[++posCo] = new Point(x, y);
                    }
                    return new LineString(points);
                }
            } else if (document.getString("type").equalsIgnoreCase("Line")) {
                List coords = document.getList("coordinates");
                if (coords instanceof List) {
                    List coordinner = coords;
                    Point[] points = new Point[coordinner.size()];
                    int posCo = -1;
                    for (Object point4 : coordinner) {
                        if (!(point4 instanceof List)) continue;
                        int pos = -1;
                        double x = 0.0;
                        double y = 0.0;
                        for (Object xy : (List)point4) {
                            if (++pos == 0) {
                                x = ((Number)xy).doubleValue();
                                continue;
                            }
                            y = ((Number)xy).doubleValue();
                        }
                        points[++posCo] = new Point(x, y);
                    }
                    return new LineString(points).toLine();
                }
            } else if (document.getString("type").equalsIgnoreCase("Point") && (point = document.getList("coordinates")) instanceof List) {
                int pos = -1;
                double x = 0.0;
                double y = 0.0;
                for (Object xy : point) {
                    if (++pos == 0) {
                        x = ((Number)xy).doubleValue();
                        continue;
                    }
                    y = ((Number)xy).doubleValue();
                }
                return new Point(x, y);
            }
        } else if (document.containsKey("$center")) {
            Point centre = null;
            double radius = 0.0;
            for (Object item : document.getList("$center")) {
                if (item instanceof List) {
                    int pos = -1;
                    double x = 0.0;
                    double y = 0.0;
                    for (Object xy : (List)item) {
                        if (++pos == 0) {
                            x = ((Number)xy).doubleValue();
                            continue;
                        }
                        y = ((Number)xy).doubleValue();
                    }
                    centre = new Point(x, y);
                    continue;
                }
                radius = ((Number)item).doubleValue();
            }
            return new Centre(centre, radius);
        }
        return null;
    }

    public static List<Line> filterIntersectingLines(List<Line> lines, double y) {
        LinkedList<Line> results = new LinkedList<Line>();
        for (Line line : lines) {
            if (!GeoType.isLineIntersectingAtY(line, y)) continue;
            results.add(line);
        }
        return results;
    }

    public static boolean isLineIntersectingAtY(Line line, double y) {
        double minY = Math.min(line.getFrom().getY(), line.getTo().getY());
        double maxY = Math.max(line.getFrom().getY(), line.getTo().getY());
        return y >= minY && y <= maxY;
    }

    public static List<Point> calculateIntersectionPoints(List<Line> lines, double y) {
        LinkedList<Point> results = new LinkedList<Point>();
        for (Line line : lines) {
            Point result = GeoType.calculateIntersectionPoint(line, y);
            if (result == null) continue;
            results.add(result);
        }
        return results;
    }

    public static Point calculateIntersectionPoint(Line line, double y) {
        double x = GeoType.calculateLineXAtY(line, y);
        if (x >= 0.0) {
            return new Point(x, y);
        }
        return null;
    }

    public static double calculateLineXAtY(Line line, double y) {
        Point from = line.getFrom();
        double slope = GeoType.calculateSlope(line);
        return from.getX() + (y - from.getY()) / slope;
    }

    public static double calculateSlope(Line line) {
        Point from = line.getFrom();
        Point to = line.getTo();
        return (to.getY() - from.getY()) / (to.getX() - from.getX());
    }

    public static void sortPointsByX(List<Point> points) {
        Collections.sort(points, new Comparator<Point>(){

            @Override
            public int compare(Point p1, Point p2) {
                return Double.compare(p1.getX(), p2.getX());
            }
        });
    }

    public static boolean calculateInside(List<Point> sortedPoints, Point p) {
        boolean inside = false;
        for (Point point : sortedPoints) {
            if (point.equals(p)) {
                return true;
            }
            if (p.getX() < point.getX()) break;
            inside = !inside;
        }
        return inside;
    }

    public static Point calculateLineIntersection(Line l1, Line l2) {
        double a1 = l1.getTo().getY() - l1.getFrom().getY();
        double b1 = l1.getFrom().getX() - l1.getTo().getX();
        double c1 = a1 * l1.getFrom().getX() + b1 * l1.getFrom().getY();
        double a2 = l2.getTo().getY() - l2.getFrom().getY();
        double b2 = l2.getFrom().getX() - l2.getTo().getX();
        double c2 = a2 * l2.getFrom().getX() + b2 * l2.getFrom().getY();
        double delta = a1 * b2 - a2 * b1;
        return new Point((b2 * c1 - b1 * c2) / delta, (a1 * c2 - a2 * c1) / delta);
    }

    public static Set<String> encodeGeohash(GeoType point, int bits) {
        if (point instanceof Point) {
            return Collections.singleton(GeoType.encodeGeohash((Point)point, bits));
        }
        if (point instanceof LineString) {
            return GeoType.encodeGeohash((LineString)point, bits);
        }
        if (point instanceof Polygon) {
            return GeoType.encodeGeohash((Polygon)point, bits);
        }
        if (point instanceof Line) {
            return GeoType.encodeGeohash((Line)point, bits);
        }
        if (point instanceof Centre) {
            return GeoType.encodeGeohash((Centre)point, bits);
        }
        return null;
    }

    public static Set<String> encodeGeohash(Line point, int bits) {
        double west = Math.min(point.getFrom().getX(), point.getTo().getX());
        double north = Math.max(point.getFrom().getY(), point.getTo().getY());
        double east = Math.max(point.getFrom().getX(), point.getTo().getX());
        double south = Math.min(point.getFrom().getY(), point.getTo().getY());
        int maxL = GeoHash.hashLengthToCoverBoundingBox((double)north, (double)west, (double)south, (double)east);
        Coverage coverage = GeoHash.coverBoundingBox((double)north, (double)west, (double)south, (double)east, (int)Math.min(bits, maxL));
        return coverage.getHashes();
    }

    public static Set<String> encodeGeohash(LineString linestring, int bits) {
        boolean start = true;
        double west = 0.0;
        double east = 0.0;
        double south = 0.0;
        double north = 0.0;
        for (Point point : linestring.getPoints()) {
            if (start) {
                west = point.getX();
                east = point.getX();
                north = point.getY();
                south = point.getY();
            } else {
                west = Math.min(west, point.getX());
                north = Math.max(north, point.getY());
                east = Math.max(east, point.getX());
                south = Math.min(south, point.getY());
            }
            start = false;
        }
        int maxL = GeoHash.hashLengthToCoverBoundingBox((double)north, (double)west, (double)south, (double)east);
        Coverage coverage = GeoHash.coverBoundingBox((double)north, (double)west, (double)south, (double)east, (int)Math.min(bits, maxL));
        return coverage.getHashes();
    }

    public static Set<String> encodeGeohash(Polygon poly, int bits) {
        boolean start = true;
        double west = 0.0;
        double east = 0.0;
        double south = 0.0;
        double north = 0.0;
        for (Point point : poly.getPoints()) {
            if (start) {
                west = point.getX();
                east = point.getX();
                north = point.getY();
                south = point.getY();
            } else {
                west = Math.min(west, point.getX());
                north = Math.max(north, point.getY());
                east = Math.max(east, point.getX());
                south = Math.min(south, point.getY());
            }
            start = false;
        }
        int maxL = GeoHash.hashLengthToCoverBoundingBox((double)north, (double)west, (double)south, (double)east);
        Coverage coverage = GeoHash.coverBoundingBox((double)north, (double)west, (double)south, (double)east, (int)Math.min(bits, maxL));
        return coverage.getHashes();
    }

    public static Set<String> encodeGeohash(Centre center, int bits) {
        double west = center.getFrom().getX() - center.getRadius();
        double east = center.getFrom().getX() + center.getRadius();
        double north = center.getFrom().getY() + center.getRadius();
        double south = center.getFrom().getY() - center.getRadius();
        int maxL = GeoHash.hashLengthToCoverBoundingBox((double)north, (double)west, (double)south, (double)east);
        Coverage coverage = GeoHash.coverBoundingBox((double)north, (double)west, (double)south, (double)east, (int)Math.min(bits, maxL));
        return coverage.getHashes();
    }

    public static String encodeGeohash(Point point, int bits) {
        return GeoHash.encodeHash((double)point.getX(), (double)point.getY(), (int)bits);
    }
}

