/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.monster.geo;

import com.entitystream.monster.geo.GeoType;
import com.entitystream.monster.geo.LineString;
import com.entitystream.monster.geo.Point;
import com.entitystream.monster.geo.Polygon;

public class Line
implements GeoType {
    private Point start;
    private Point end;

    public Line(Point start, Point end) {
        this.start = start;
        this.end = end;
    }

    public Point getFrom() {
        return this.start;
    }

    public Point getTo() {
        return this.end;
    }

    @Override
    public Point[] getPoints() {
        return new Point[]{this.start, this.end};
    }

    @Override
    public boolean checkInside(GeoType geo) {
        if (geo instanceof Point) {
            Point point = (Point)geo;
            return GeoType.calculateLineXAtY(this, point.getY()) == point.getX();
        }
        if (geo instanceof LineString) {
            Point lastpoint = null;
            for (Point point : ((LineString)geo).getPoints()) {
                if (lastpoint != null && !this.checkInside(new Line(lastpoint, point))) {
                    return false;
                }
                lastpoint = point;
            }
            return true;
        }
        if (geo instanceof Line) {
            return GeoType.calculateLineIntersection(this, (Line)geo).valid();
        }
        if (geo instanceof Polygon) {
            Point lastpoint = null;
            for (Point point : ((Polygon)geo).getPoints()) {
                if (lastpoint != null && !this.checkInside(new Line(lastpoint, point))) {
                    return false;
                }
                lastpoint = point;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return this.start.toString() + " -> " + this.end.toString();
    }
}

