/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.monster.geo;

import com.entitystream.monster.geo.GeoType;
import com.entitystream.monster.geo.Line;
import com.entitystream.monster.geo.Point;
import com.entitystream.monster.geo.Polygon;

public class LineString
implements GeoType {
    private Point[] points;

    public LineString(Point[] points) {
        this.points = points;
    }

    public Line[] getLines() {
        Point lastpoint = null;
        Line[] lines = new Line[this.getPoints().length - 1];
        int pos = -1;
        for (Point point : this.getPoints()) {
            if (lastpoint != null) {
                lines[++pos] = new Line(lastpoint, point);
            }
            lastpoint = point;
        }
        return lines;
    }

    public Point getFrom() {
        if (this.points.length > 0) {
            return this.points[0];
        }
        return null;
    }

    public Point getTo() {
        if (this.points.length > 0) {
            return this.points[this.points.length - 1];
        }
        return null;
    }

    @Override
    public Point[] getPoints() {
        return this.points;
    }

    public Line toLine() {
        return new Line(this.getFrom(), this.getTo());
    }

    @Override
    public boolean checkInside(GeoType geo) {
        if (geo instanceof Point) {
            Point point = (Point)geo;
            for (Line line : this.getLines()) {
                if (GeoType.calculateLineXAtY(line, point.getY()) != point.getX()) continue;
                return true;
            }
            return false;
        }
        if (geo instanceof LineString) {
            for (Line line : this.getLines()) {
                for (Line line2 : ((LineString)geo).getLines()) {
                    if (!GeoType.calculateLineIntersection(line, line2).valid()) continue;
                    return true;
                }
            }
            return false;
        }
        if (geo instanceof Line) {
            for (Line line2 : this.getLines()) {
                if (!GeoType.calculateLineIntersection((Line)geo, line2).valid()) continue;
                return true;
            }
            return false;
        }
        if (geo instanceof Polygon) {
            Point lastpoint = null;
            for (Point point : ((Polygon)geo).getPoints()) {
                if (lastpoint != null && !this.checkInside(new Line(lastpoint, point))) {
                    return false;
                }
                lastpoint = point;
            }
            return true;
        }
        return false;
    }
}

