/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.monster.geo;

import com.entitystream.monster.geo.GeoType;
import com.entitystream.monster.geo.Line;
import com.entitystream.monster.geo.LineString;
import com.entitystream.monster.geo.Polygon;

public class Point
implements GeoType {
    private double x;
    private double y;

    @Override
    public boolean checkInside(GeoType geo) {
        if (geo instanceof Point) {
            Point point = (Point)geo;
            return point.equals(this);
        }
        if (geo instanceof LineString) {
            for (Point point : ((LineString)geo).getPoints()) {
                if (this.checkInside(point)) continue;
                return false;
            }
            return true;
        }
        if (geo instanceof Line) {
            return this.checkInside(((Line)geo).getFrom()) && this.checkInside(((Line)geo).getTo());
        }
        if (geo instanceof Polygon) {
            for (Point point : ((Polygon)geo).getPoints()) {
                if (this.checkInside(point)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Point(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public boolean valid() {
        return this.x != Double.NEGATIVE_INFINITY && this.y != Double.NEGATIVE_INFINITY && this.x != Double.POSITIVE_INFINITY && this.y != Double.POSITIVE_INFINITY;
    }

    @Override
    public Point[] getPoints() {
        return new Point[]{new Point(this.x, this.y)};
    }

    public String toString() {
        return "[" + this.x + "," + this.y + "]";
    }

    public boolean equals(Point other) {
        return other.getX() == this.getX() && other.getY() == this.getY();
    }
}

