/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.monster.geo;

import com.entitystream.monster.geo.GeoType;
import com.entitystream.monster.geo.Line;
import com.entitystream.monster.geo.LineString;
import com.entitystream.monster.geo.Point;
import java.util.LinkedList;
import java.util.List;

public class Polygon
implements GeoType {
    private Point[] points;

    public Polygon(Point[] points) {
        this.points = points;
    }

    @Override
    public Point[] getPoints() {
        return this.points;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Polygon");
        for (Point p : this.getPoints()) {
            sb.append(" " + p.toString());
        }
        return sb.toString();
    }

    @Override
    public boolean checkInside(GeoType geo) {
        if (geo instanceof Point) {
            Point point = (Point)geo;
            List<Line> lines = this.calculateLines();
            List<Line> intersectionLines = GeoType.filterIntersectingLines(lines, point.getY());
            List<Point> intersectionPoints = GeoType.calculateIntersectionPoints(intersectionLines, point.getY());
            GeoType.sortPointsByX(intersectionPoints);
            return GeoType.calculateInside(intersectionPoints, point);
        }
        if (geo instanceof LineString) {
            for (Point point : ((LineString)geo).getPoints()) {
                if (this.checkInside(point)) continue;
                return false;
            }
            return true;
        }
        if (geo instanceof Line) {
            return this.checkInside(((Line)geo).getFrom()) && this.checkInside(((Line)geo).getTo());
        }
        if (geo instanceof Polygon) {
            for (Point point : ((Polygon)geo).getPoints()) {
                if (this.checkInside(point)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private List<Line> calculateLines() {
        LinkedList<Line> results = new LinkedList<Line>();
        Point[] points = this.getPoints();
        Point lastPoint = null;
        for (Point point : points) {
            if (lastPoint != null) {
                results.add(new Line(lastPoint, point));
            }
            lastPoint = point;
        }
        if (!lastPoint.equals(points[0])) {
            results.add(new Line(lastPoint, points[0]));
        }
        return results;
    }
}

