/**
 *
	MonsterDB - Collection Based Database with fuzzy matching
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.monster.db;

import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;

import com.entitystream.monster.thrift.Connection;
import com.entitystream.monster.thrift.Connection.Processor;

public class DBServer {
	private static ConnectionHandler handler;
	private static Processor processor;
	private static TThreadPoolServer server;


	public static void start(int port, int httpport, String authFile, String dbPath, String[] replicaSet, int node) {
		try {
			handler = new ConnectionHandler(authFile, dbPath, replicaSet, node);
			processor = new Connection.Processor(handler);
		
			Runnable secure = new Runnable() {
				public void run() {
					server(port,processor);
				}
			};
			
			Thread thread = new Thread(secure);
			thread.start();
			
			
			
		} catch (Exception x) {
			x.printStackTrace();
		}
	}

	public static void stop() {
	    server.stop();
	}

	public static void server(int port, Connection.Processor processor) {
		try {
			TServerTransport serverTransport = new TServerSocket(port);
			TThreadPoolServer.Args args = new TThreadPoolServer.Args(serverTransport).processor(processor);
			server = new TThreadPoolServer(args );
			System.out.println("Starting the MonsterDB thread pool server...");
		    System.out.println("Listening on " + port);
		    handler.setServer(server);
		    server.serve();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public static ConnectionHandler getHandler() {
	    return handler;
	}
	
	public static int getNodeNum() {
	    if (handler!=null)
	       return handler.getNodeNum();
	    else
		return -1;
	}
	
	public static void main(String[] args) {
	    	if (args.length==6)
		   start(Integer.parseInt(args[0]),Integer.parseInt(args[1]),args[2], args[3],args[4].split(","),Integer.parseInt(args[5])); 
 

//		start(27018,"/Users/roberthaynes/git/interstellar/target/auth.json", "/Users/roberthaynes/git/interstellar/target/one",new String[] {"robert2:123@localhost:27019"},1); 

//		start(27019,"/Users/roberthaynes/git/interstellar/target/auth.json", "/Users/roberthaynes/git/interstellar/target/two",new String[] {"robert2:123@localhost:27018"},0); 
	}
	
}
