/**
 *
	MonsterDB - Collection Based Database with fuzzy matching
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.monster.db;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Field implements Serializable{
	private String name;
	private FieldType type;
	private boolean unique;
	
	public Field(String name) {	
		this.setName(name);
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public FieldType getType() {
		return type;
	}
	public void setType(FieldType type) {
		this.type = type;
	}
	public static List<Field> singleton(String name) {
		List<Field> fl = new ArrayList<Field>(1);
		fl.add(new Field(name));
		return fl;
	}
	public static List<Field> multiple(String[] name) {
		
		List<Field> fl = new ArrayList<Field>(name.length);
		for (String nam : name)
		   fl.add(new Field(nam));
		return fl;
	}
	
	public static List<Field> singleton(String name, boolean unique) {
		List<Field> fl = new ArrayList<Field>(1);
		fl.add(new Field(name).setUnique(unique));
		return fl;
	}

	public boolean isUnique() {
		return unique;
	}
	public Field setUnique(boolean unique) {
		this.unique = unique;
		return this;
	}
}
