/**
 *
	MonsterDB - Collection Based Database with fuzzy matching
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.monster.db;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class Filters {

	public static Bson eq(String string, Pattern compile) {

		return new Bson(string, compile.pattern());
	}

	public static Bson eq(String string, Object string2) {
	
		return new Bson(string, string2);
	}

	public static Bson and(Document filter1, Document filter2) {
		List<Document> andFilterList = new ArrayList<Document>();
		andFilterList.add(filter1);
		andFilterList.add(filter2);
		return new Bson("$and", andFilterList);
	}
	
	public static Bson or(Document filter1, Document filter2) {
		List<Document> andFilterList = new ArrayList<Document>();
		andFilterList.add(filter1);
		andFilterList.add(filter2);
		return new Bson("$or", andFilterList);
	}

	public static Bson regex(String string, Pattern compile) {
		return new Bson(string, compile);
	}

}
