/**
 *
	MonsterDB - Collection Based Database with fuzzy matching
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.monster.db;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

import com.entitystream.identiza.wordlist.RuleSetMap;

public interface IBasicDB {

	void disconnect() throws Exception;

	IBasicDB useDatabase(String db);

	IBasicDB useCollection(String coll);

	DBCursor listDatabaseNames();

	DBCursor listCollectionNames();

	DBCursor listIndexes();

	void dropCollection();

	void dropDatabase();

	String createDatabase(String db);

	String createCollection(String coll, String hashKey);
	
	String createCollection(String coll, Document ranges);
	
	String currentDatabase();

	String createCollection(Document collDoc);

	String createFuzzyCollection(String name, String definitionFile, String ruleSetPath);
	
	String createFuzzyCollection(String name, String definitionFile, String ruleSetPath, String hashKey);
	
	String createFuzzyCollection(String name, String definitionFile, String ruleSetPath, Document ranges);

	String createCollection(String coll);

	Document describeCollection(String coll);

	int getNodeNum();

	
	void saveQualityRule(Document def);

	DBCursor findQualityRules(Document def);

	void setRuleSetPath(String path);

	void saveRuleSet(String path);

	void setRuleSet(RuleSetMap map);

	void createIndex(Document document);

	DBCursor find(Document findme);

	Stream<Document> aggregate(List<Document> pipeline);

	Document findOneAndUpdate(Document document, Document setUpdate, Document options);

	DBCursor find();

	<TResult> Iterable<TResult> distinct(String fieldName, Class<TResult> resultClass);

	Document updateOne(Document document, Document update, Document options);

	long count(Document where);

	Document findOneAndDelete(Document document);

	int deleteMany(Document document);

	Document insertOne(Document doc);

	Document findOneAndReplace(Document whereDoc, Document updatedDoc, Document options);

	Document findOneAndReplace(Document document, Document messageD);

	Document deleteOne(Document parser);

	int insertMany(List<Document> rdocs);

	Document updateOne(Document document, Document doc);

	Document getDefinition();

	void updateDefinition(Document def);

	DBCursor findTasks(Document filter);
	
	void resolveTask(Document taskData);
	
	Document updateTask(String id, Document doc);
	
	DBCursor aggregateTasks(ArrayList<Document> andlist);

	<TResult> Iterable<TResult> distinctRelationship(String string, Class<TResult> resultClass);

	Document saveRelationship(Document doc);

	DBCursor findRelationships(Document document);

	Document updateRelationship(Document filter, Document setUpdate, Document options);

	void deleteTasks(Document document);
	void deleteRelationships(Document document);

	/**
	 * @param code
	 */
	void setScriptCode(String code);
	void setScriptPath(String path);


}