/**
 *
	MonsterDB - Collection Based Database with fuzzy matching
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.monster.db;

import java.util.List;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;

/**
 * @author roberthaynes
 *
 */
public class Mocument extends Document{
    private MonsterClient client;
    private String collection;
    private String database;
    public Mocument(Object source, MonsterClient client) {
	super(source);
	this.database=client.database;
	this.collection=client.collection;
	this.client=client;
    }
    
    public DBCursor getRelationships(String relType){
	return client.useDatabase(database).useCollection(collection).findRelationships(new Document("relType",relType));
    }
    public Document saveRelationship(String toid, String relType, Document payLoad){
	Document values = new Document("fromCol", super.get("_id"));
	values.append("toCol", toid);
	values.append("relType", relType);
	values.putAll(payLoad);
	return client.useDatabase(database).useCollection(collection).saveRelationship(values);
    }
    
    public static Object parseListOrDoc(MonsterClient client, String jsonin) {
  	//chop up json 
  	List<String> chopper = getJsonFromString(jsonin);
  	BasicDBList returned = new BasicDBList();

  	for (String json : chopper) {
  	    try {
  		JsonParser parser = new JsonParser();
  		JsonElement p = parser.parse(json);

  		if (p.isJsonObject()) {
  		    JsonObject _jsonObject = (JsonObject)p;
  		    returned.add(new Mocument(_jsonObject, client));
  		}
  		if (p.isJsonArray()) {
  		    JsonArray _jsonObject = (JsonArray)p;
  		    BasicDBList list = new BasicDBList();
  		    for (JsonElement item : _jsonObject) {
  			if (item.isJsonObject())
  			    list.add(new Mocument(item,client));
  			else if (item.isJsonArray())
  			    list.add(parseListOrDoc(item.toString()));
  		    }
  		    returned.add(list);
  		}


  	    } catch (Exception e) {
  		return e.toString();
  	    }
  	}
  	return returned;
      }
    public static Object parseListOrDocument(MonsterClient client, String json) {
   	//chop up json 
   	try {
   	    JsonParser parser = new JsonParser();
   	    JsonElement p = parser.parse(json);

   	    if (p.isJsonObject()) {
   		JsonObject _jsonObject = (JsonObject)p;
   		return new Document(_jsonObject);
   	    }
   	    if (p.isJsonArray()) {
   		JsonArray _jsonObject = (JsonArray)p;
   		BasicDBList list = new BasicDBList();
   		for (JsonElement item : _jsonObject) {
   		    if (item.isJsonObject())
   			list.add(new Mocument(item, client));
   		    else if (item.isJsonArray())
   			list.add(parseListOrDoc(item.toString()));
   		}
   		return list;
   	    }


   	} catch (Exception e) {
   	    return e.toString();
   	}
   	return null;

       }
    
    public void delete() {
	String id=(String) this.getString("_id");
	client.useDatabase(database).useCollection(collection).findOneAndDelete(this);
	client.useDatabase(database).useCollection(collection).deleteTasks(new Document("Nodes", id));
	client.useDatabase(database).useCollection(collection).deleteRelationships(new Document("fromCol", id));
	client.useDatabase(database).useCollection(collection).deleteRelationships(new Document("toCol", id));
    }
    
}
