/**
 *
	MonsterDB - Collection Based Database with fuzzy matching

    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.monster.db;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.List;

import com.google.gson.Gson;

public class Users {
    public List<User> users = new ArrayList<User>();
    public Map<String, Document> roles  = new HashMap<String, Document>();

    public static Users build(String filename) {
	if (filename!=null)
	    filename=filename.replaceAll("'", "");
	if (filename==null || filename.trim().length()==0)
	    return null;
	else return new Users().load(filename);

    }
    
    public Map<String, Document> getRoles(){
	return roles;
    }

    public Users load(String filename) {

	if (filename!=null) {

	    File file = new File(filename);
	    if (file.exists()) {
		try {
		    Gson gson = new Gson();
		    BufferedReader br = new BufferedReader(new FileReader(file));
		    users = new ArrayList<User>();
		    br.lines().forEach(s -> {
			if (s!=null) {
			    if (s.indexOf("identifier")!=-1){
				User user = gson.fromJson(s, User.class);
				if (user!=null)
				    users.add(user);
			    } else if (s.indexOf("role")!=-1){
				Role role = gson.fromJson(s, Role.class);
				if (role!=null)
				    roles.put(role.getRole(), role.getAccessRights());
			    }
			}
		    });
		    System.out.println("Initialised " + users.size() + " users and " + roles.size() + " roles, anonymous logins are disabled");

		    br.close();
		} catch (Exception e) {
		    e.printStackTrace();
		}
	    }
	} else return null;

	return this;
    }

    public User ok(String name, String password) {
	for (User u : users) {
	    if (u.getIdentifier().equalsIgnoreCase(name)) {
		if (u.getPassword().equals(password))
		    return u;
	    }
	}
	return null;
    }


    
}
