/**
 *
	MonsterDB - Collection Based Database with fuzzy matching

    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.monster.external;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;


import com.entitystream.monster.db.Document;
import au.com.bytecode.opencsv.CSVReader;

/**
 * @author roberthaynes
 *
 */
public class ExternalData {

    /**
     * @param rfopt
     * @param in
     * @param options
     * @return

     */
    public static Stream<Document> readFile(Document rfopt, Stream<Document> in, Document options) {
	try {
	    if (rfopt.containsKey("filename")) {
		File f = new File(rfopt.getString("filename"));
		if (!f.exists())
		    return null;
	    }

	    if (rfopt.containsKey("filename")) {
		if (!rfopt.containsKey("type") || rfopt.getString("type").equalsIgnoreCase("JSON")) {
		    BufferedReader reader = new BufferedReader(new FileReader(rfopt.getString("filename")));
		    return reader.lines().parallel().map(line -> {
			Document out = Document.parse(line);
			return out;
		    });
		} else
		    if (rfopt.getString("type").equalsIgnoreCase("CSV")) {

			CSVReader csv = null;
			String charset="UTF8";
			if (rfopt.containsKey("charset"))
			    charset=rfopt.getString("charset");
			if (rfopt.containsKey("delimiter") && rfopt.containsKey("quote"))
			    csv=new CSVReader(new InputStreamReader(new FileInputStream(rfopt.getString("filename")),charset),
				    rfopt.getString("delimiter").charAt(0),
				    rfopt.getString("quote").charAt(0));
			else if (rfopt.containsKey("delimiter"))
			    csv=new CSVReader(new InputStreamReader(new FileInputStream(rfopt.getString("filename")),charset),
				    rfopt.getString("delimiter").charAt(0));
			else 
			    csv=new CSVReader(new InputStreamReader(new FileInputStream(rfopt.getString("filename")),charset));
			String[] columns = csv.readNext();
			List<String> cols = new ArrayList<String>();
			for (String col : columns) {
			    StringBuilder sb = new StringBuilder();
			    for (byte b: col.getBytes())
				if (b>0)
				    sb.append((char)b);
			    col=sb.toString();
			    cols.add(col);
			}
			return csv.readAll().parallelStream().map(dcolumns -> {
			    Document out = new Document();
			    int pos=-1;
			    for (String col : cols) {
				pos++;
				if (dcolumns.length>pos)
				    out.append(col, dcolumns[pos]);

			    }
			    return out;
			});
		    }
	    }
	} catch (Exception e) {
	    e.printStackTrace();
	}
	return null;
    }

    /**
     * @param rfopt
     * @param in
     * @param options
     * @return
     */
    public static Stream writeFile(Document rfopt, Stream<Document> in, Document options) {
	PrintWriter pw;
	try {
	    boolean overwrite=true;
	    if (rfopt.containsKey("overwrite")) {
		overwrite=rfopt.getBoolean("overwrite", true);
	    }
	    if (rfopt.containsKey("filename")) {
		File f = new File(rfopt.getString("filename"));
		if (f.exists() && overwrite)
		    pw = new PrintWriter(rfopt.getString("filename"));
		else if (f.exists() && !overwrite)
		    pw = new PrintWriter(new FileOutputStream(new File(rfopt.getString("filename")), true));
		else //doesnt exist
		    pw = new PrintWriter(rfopt.getString("filename"));
 		    
		if (!rfopt.containsKey("type") || rfopt.getString("type").equalsIgnoreCase("JSON")) {
		    in.sequential().forEach(doc -> {
			pw.println(doc.toJson());
		    });
		} else if (rfopt.containsKey("type") && rfopt.getString("type").equalsIgnoreCase("CSV")) {
		    in.sequential().forEach(doc -> {
			pw.println(doc.toCSV());
		    });
		}
		pw.flush();
		    pw.close();
	    }
	} catch (FileNotFoundException e) {
	    // TODO Auto-generated catch block
	    e.printStackTrace();
	}
	return null;
    }

    public static Stream readJDBC(Document settings, Stream<Document> in, Document options) {
	
	System.out.println("readJDBC Not supported in community edition");
	return Stream.builder().add(new Document("Error", "readJDBC Not supported in community edition")).build();
    }


    public static Stream readActiveMQ(Document settings, Stream<Document> in, Document options) {
	System.out.println("readActiveMQ Not supported in community edition");
	return Stream.builder().add(new Document("Error", "readActiveMQ Not supported in community edition")).build();

    }

    public static Stream writeActiveMQ(Document settings, Stream<Document> in, Document options) {
	System.out.println("writeActiveMQ Not supported in community edition");
	return Stream.builder().add(new Document("Error", "writeActiveMQ  Not supported in community edition")).build();

    }
}
