/**
 *
	MonsterDB - Collection Based Database with fuzzy matching

    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.monster.external;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.stream.Stream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;

import com.entitystream.monster.db.Document;

/**
 * @author roberthaynes
 *
 */
public class RestAPI {

    /**
     * @param restGetDefn
     * @param in
     * @param options
     * @return
     */
    public static Stream<Document> executeGet(Document restGetDefn, Stream<Document> in, Document options) {
	Stream<Document> out=null; 
	if (restGetDefn!=null && restGetDefn.containsKey("url")) {
	    //url is passed so ignore input
	    if (restGetDefn.containsKey("url")) {
		HttpClient client = HttpClientBuilder.create().build();
		HttpClientContext context = new HttpClientContext();
		HttpUriRequest request= new HttpGet(restGetDefn.getString("url")) ;
		
		if (restGetDefn.containsKey("headers"))
		    request.setHeaders(getHeaders(restGetDefn.getAsDocument("headers")));
		try {
		    HttpResponse response = client.execute(request);
		    HttpEntity entity = response.getEntity();
		    Document headers = getHeaders(response);
		    InputStream inputStream = entity.getContent();
		    BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
		    out= reader.lines().map(s -> {
			Document ret= Document.parse(s);
					
			return ret;
		    });
		} catch (Exception e) {
		    e.printStackTrace();
		}
	    }
	} else

	    out = in.map(i -> { 
		if (i.containsKey("url")) {
		    HttpClient client = HttpClientBuilder.create().build();
		    HttpClientContext context = new HttpClientContext();
		    HttpUriRequest request= new HttpGet(i.getString("url")) ;
		    
		    if (i.containsKey("headers"))
			request.setHeaders(getHeaders(i.getAsDocument("headers")));
		    else if (restGetDefn !=null && restGetDefn.containsKey("headers"))
			request.setHeaders(getHeaders(restGetDefn.getAsDocument("headers")));
		    try {
			HttpResponse response = client.execute(request,context);
			Document headers = getHeaders(response);
			
			HttpEntity entity = response.getEntity();
			InputStream inputStream = entity.getContent();
			BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
			return reader.lines().map(s -> {
			    Document ret= Document.parse(s);
			    return ret;
			}
				);
		    } catch (Exception e) {
			e.printStackTrace();
		    }

		}
		return null;
	    }).flatMap(c -> c);

	return out;
    }

    /**
     * @param restGetDefn
     * @return
     */
    private static Header[] getHeaders(Document header) {
	Header[] headers = new Header[header.size()];
	int i=0;
	for (Object key : header.keySet())
	    headers[i++]=new BasicHeader((String) key, header.getString((String) key));
	return headers;
    }

    /**
     * @param response
     * @return
     */
    private static Document getHeaders(HttpResponse response) {
	Document ret = new Document();
	for (Header h : response.getAllHeaders())
	    ret.append(h.getName(), h.getValue());
	return ret;
    }

}
