/**
 *
	MonsterDB - Collection Based Database with fuzzy matching

    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.monster.jndi;

import java.util.Enumeration;
import java.util.Hashtable;

import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

import com.entitystream.identiza.metadata.IdentizaSettings;
import com.entitystream.monster.db.DBServer;
import com.entitystream.monster.db.MonsterClient;

/**
 * @author roberthaynes
 *
 */
public class MonsterClientFactory implements ObjectFactory {

    /* (non-Javadoc)
     * @see javax.naming.spi.ObjectFactory#getObjectInstance(java.lang.Object, javax.naming.Name, javax.naming.Context, java.util.Hashtable)
     */
    @Override
    public Object getObjectInstance(Object obj, Name name2, Context nameCtx, Hashtable<?, ?> environment)
	    throws Exception {

	// Acquire an instance of our specified bean class
	MonsterClient bean = new MonsterClient();

	// Customize the bean properties from our attributes
	Reference ref = (Reference) obj;
	Enumeration addrs = ref.getAll();
	String connectionString=null;
	String startupString=null;
	while (addrs.hasMoreElements()) {
	    RefAddr addr = (RefAddr) addrs.nextElement();
	    String name = addr.getType();
	    String value = (String) addr.getContent();
	    if (name.equals("connectionString")) {
		connectionString=value;
	    } 
	    if (name.equals("startupString")) {
		startupString=value;
	    } 
	}
	if (startupString!=null) {
	    try {
		int port=27018;
		int httpport=-1;
		String authfile=null;
		String home=IdentizaSettings.getApplicationRootPath("db");
		String[] ss=startupString.split(" ");
		int pos=-1;
		for (String s : ss) {
		    pos++;
		    if (pos==0)
			port=Integer.parseInt(s);
		    if (pos==1)
			httpport=Integer.parseInt(s);
		    if (pos==2)
			authfile=s;
		    if (pos==3)
			home=s;
		}
		    
		DBServer.start(port, httpport, authfile, home, null,0); 
		Thread.sleep(1000);
		
	    } catch (Exception e1) {
		e1.printStackTrace();
	    }
	}

	if (connectionString!=null)
	    bean.connect(connectionString);
	// Return the customized instance
	return (bean);
    }

}
