/**
 *
	MonsterDB - Collection Based Database with fuzzy matching
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
/**
 * Autogenerated by Thrift Compiler (0.9.3)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
package com.entitystream.monster.thrift;

import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;

import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.apache.thrift.server.AbstractNonblockingServer.*;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.EnumMap;
import java.util.Set;
import java.util.HashSet;
import java.util.EnumSet;
import java.util.Collections;
import java.util.BitSet;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.annotation.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings({"cast", "rawtypes", "serial", "unchecked"})
@Generated(value = "Autogenerated by Thrift Compiler (0.9.3)", date = "2019-08-26")
public class Connection {

  public interface Iface {

    public long command(long connection, String database, String collection, String command, boolean remoteView) throws InvalidOperation, org.apache.thrift.TException;

    public long connect(String username, String password) throws InvalidOperation, org.apache.thrift.TException;

    public ByteBuffer cursorNext(long connection, long cursor, int count) throws InvalidOperation, org.apache.thrift.TException;

    public void closeCursor(long connection, long cursor) throws org.apache.thrift.TException;

    public void closeConnection(long connection) throws org.apache.thrift.TException;

  }

  public interface AsyncIface {

    public void command(long connection, String database, String collection, String command, boolean remoteView, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void connect(String username, String password, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void cursorNext(long connection, long cursor, int count, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void closeCursor(long connection, long cursor, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void closeConnection(long connection, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

  }

  public static class Client extends org.apache.thrift.TServiceClient implements Iface {
    public static class Factory implements org.apache.thrift.TServiceClientFactory<Client> {
      public Factory() {}
      public Client getClient(org.apache.thrift.protocol.TProtocol prot) {
        return new Client(prot);
      }
      public Client getClient(org.apache.thrift.protocol.TProtocol iprot, org.apache.thrift.protocol.TProtocol oprot) {
        return new Client(iprot, oprot);
      }
    }

    public Client(org.apache.thrift.protocol.TProtocol prot)
    {
      super(prot, prot);
    }

    public Client(org.apache.thrift.protocol.TProtocol iprot, org.apache.thrift.protocol.TProtocol oprot) {
      super(iprot, oprot);
    }

    public long command(long connection, String database, String collection, String command, boolean remoteView) throws InvalidOperation, org.apache.thrift.TException
    {
      send_command(connection, database, collection, command, remoteView);
      return recv_command();
    }

    public void send_command(long connection, String database, String collection, String command, boolean remoteView) throws org.apache.thrift.TException
    {
      command_args args = new command_args();
      args.setConnection(connection);
      args.setDatabase(database);
      args.setCollection(collection);
      args.setCommand(command);
      args.setRemoteView(remoteView);
      sendBase("command", args);
    }

    public long recv_command() throws InvalidOperation, org.apache.thrift.TException
    {
      command_result result = new command_result();
      receiveBase(result, "command");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ouch != null) {
        throw result.ouch;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "command failed: unknown result");
    }

    public long connect(String username, String password) throws InvalidOperation, org.apache.thrift.TException
    {
      send_connect(username, password);
      return recv_connect();
    }

    public void send_connect(String username, String password) throws org.apache.thrift.TException
    {
      connect_args args = new connect_args();
      args.setUsername(username);
      args.setPassword(password);
      sendBase("connect", args);
    }

    public long recv_connect() throws InvalidOperation, org.apache.thrift.TException
    {
      connect_result result = new connect_result();
      receiveBase(result, "connect");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ouch != null) {
        throw result.ouch;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "connect failed: unknown result");
    }

    public ByteBuffer cursorNext(long connection, long cursor, int count) throws InvalidOperation, org.apache.thrift.TException
    {
      send_cursorNext(connection, cursor, count);
      return recv_cursorNext();
    }

    public void send_cursorNext(long connection, long cursor, int count) throws org.apache.thrift.TException
    {
      cursorNext_args args = new cursorNext_args();
      args.setConnection(connection);
      args.setCursor(cursor);
      args.setCount(count);
      sendBase("cursorNext", args);
    }

    public ByteBuffer recv_cursorNext() throws InvalidOperation, org.apache.thrift.TException
    {
      cursorNext_result result = new cursorNext_result();
      receiveBase(result, "cursorNext");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ouch != null) {
        throw result.ouch;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "cursorNext failed: unknown result");
    }

    public void closeCursor(long connection, long cursor) throws org.apache.thrift.TException
    {
      send_closeCursor(connection, cursor);
      recv_closeCursor();
    }

    public void send_closeCursor(long connection, long cursor) throws org.apache.thrift.TException
    {
      closeCursor_args args = new closeCursor_args();
      args.setConnection(connection);
      args.setCursor(cursor);
      sendBase("closeCursor", args);
    }

    public void recv_closeCursor() throws org.apache.thrift.TException
    {
      closeCursor_result result = new closeCursor_result();
      receiveBase(result, "closeCursor");
      return;
    }

    public void closeConnection(long connection) throws org.apache.thrift.TException
    {
      send_closeConnection(connection);
    }

    public void send_closeConnection(long connection) throws org.apache.thrift.TException
    {
      closeConnection_args args = new closeConnection_args();
      args.setConnection(connection);
      sendBaseOneway("closeConnection", args);
    }

  }
  public static class AsyncClient extends org.apache.thrift.async.TAsyncClient implements AsyncIface {
    public static class Factory implements org.apache.thrift.async.TAsyncClientFactory<AsyncClient> {
      private org.apache.thrift.async.TAsyncClientManager clientManager;
      private org.apache.thrift.protocol.TProtocolFactory protocolFactory;
      public Factory(org.apache.thrift.async.TAsyncClientManager clientManager, org.apache.thrift.protocol.TProtocolFactory protocolFactory) {
        this.clientManager = clientManager;
        this.protocolFactory = protocolFactory;
      }
      public AsyncClient getAsyncClient(org.apache.thrift.transport.TNonblockingTransport transport) {
        return new AsyncClient(protocolFactory, clientManager, transport);
      }
    }

    public AsyncClient(org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.async.TAsyncClientManager clientManager, org.apache.thrift.transport.TNonblockingTransport transport) {
      super(protocolFactory, clientManager, transport);
    }

    public void command(long connection, String database, String collection, String command, boolean remoteView, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      command_call method_call = new command_call(connection, database, collection, command, remoteView, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class command_call extends org.apache.thrift.async.TAsyncMethodCall {
      private long connection;
      private String database;
      private String collection;
      private String command;
      private boolean remoteView;
      public command_call(long connection, String database, String collection, String command, boolean remoteView, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.connection = connection;
        this.database = database;
        this.collection = collection;
        this.command = command;
        this.remoteView = remoteView;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("command", org.apache.thrift.protocol.TMessageType.CALL, 0));
        command_args args = new command_args();
        args.setConnection(connection);
        args.setDatabase(database);
        args.setCollection(collection);
        args.setCommand(command);
        args.setRemoteView(remoteView);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Object getResult() throws InvalidOperation, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_command();
      }
    }

    public void connect(String username, String password, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      connect_call method_call = new connect_call(username, password, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class connect_call extends org.apache.thrift.async.TAsyncMethodCall {
      private String username;
      private String password;
      public connect_call(String username, String password, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.username = username;
        this.password = password;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("connect", org.apache.thrift.protocol.TMessageType.CALL, 0));
        connect_args args = new connect_args();
        args.setUsername(username);
        args.setPassword(password);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Object getResult() throws InvalidOperation, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_connect();
      }
    }

    public void cursorNext(long connection, long cursor, int count, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      cursorNext_call method_call = new cursorNext_call(connection, cursor, count, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class cursorNext_call extends org.apache.thrift.async.TAsyncMethodCall {
      private long connection;
      private long cursor;
      private int count;
      public cursorNext_call(long connection, long cursor, int count, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.connection = connection;
        this.cursor = cursor;
        this.count = count;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("cursorNext", org.apache.thrift.protocol.TMessageType.CALL, 0));
        cursorNext_args args = new cursorNext_args();
        args.setConnection(connection);
        args.setCursor(cursor);
        args.setCount(count);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public ByteBuffer getResult() throws InvalidOperation, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_cursorNext();
      }
    }

    public void closeCursor(long connection, long cursor, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      closeCursor_call method_call = new closeCursor_call(connection, cursor, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class closeCursor_call extends org.apache.thrift.async.TAsyncMethodCall {
      private long connection;
      private long cursor;
      public closeCursor_call(long connection, long cursor, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.connection = connection;
        this.cursor = cursor;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("closeCursor", org.apache.thrift.protocol.TMessageType.CALL, 0));
        closeCursor_args args = new closeCursor_args();
        args.setConnection(connection);
        args.setCursor(cursor);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Object getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_closeCursor();
        return null;
      }
    }

    public void closeConnection(long connection, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      closeConnection_call method_call = new closeConnection_call(connection, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class closeConnection_call extends org.apache.thrift.async.TAsyncMethodCall {
      private long connection;
      public closeConnection_call(long connection, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, true);
        this.connection = connection;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("closeConnection", org.apache.thrift.protocol.TMessageType.ONEWAY, 0));
        closeConnection_args args = new closeConnection_args();
        args.setConnection(connection);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Object getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return null;
      }
    }

  }

  public static class Processor<I extends Iface> extends org.apache.thrift.TBaseProcessor<I> implements org.apache.thrift.TProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(Processor.class.getName());
    public Processor(I iface) {
      super(iface, getProcessMap(new HashMap<String, org.apache.thrift.ProcessFunction<I, ? extends org.apache.thrift.TBase>>()));
    }

    protected Processor(I iface, Map<String,  org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> processMap) {
      super(iface, getProcessMap(processMap));
    }

    private static <I extends Iface> Map<String,  org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> getProcessMap(Map<String,  org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> processMap) {
      processMap.put("command", new command());
      processMap.put("connect", new connect());
      processMap.put("cursorNext", new cursorNext());
      processMap.put("closeCursor", new closeCursor());
      processMap.put("closeConnection", new closeConnection());
      return processMap;
    }

    public static class command<I extends Iface> extends org.apache.thrift.ProcessFunction<I, command_args> {
      public command() {
        super("command");
      }

      public command_args getEmptyArgsInstance() {
        return new command_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public command_result getResult(I iface, command_args args) throws org.apache.thrift.TException {
        command_result result = new command_result();
        try {
          result.success = iface.command(args.connection, args.database, args.collection, args.command, args.remoteView);
          result.setSuccessIsSet(true);
        } catch (InvalidOperation ouch) {
          result.ouch = ouch;
        }
        return result;
      }
    }

    public static class connect<I extends Iface> extends org.apache.thrift.ProcessFunction<I, connect_args> {
      public connect() {
        super("connect");
      }

      public connect_args getEmptyArgsInstance() {
        return new connect_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public connect_result getResult(I iface, connect_args args) throws org.apache.thrift.TException {
        connect_result result = new connect_result();
        try {
          result.success = iface.connect(args.username, args.password);
          result.setSuccessIsSet(true);
        } catch (InvalidOperation ouch) {
          result.ouch = ouch;
        }
        return result;
      }
    }

    public static class cursorNext<I extends Iface> extends org.apache.thrift.ProcessFunction<I, cursorNext_args> {
      public cursorNext() {
        super("cursorNext");
      }

      public cursorNext_args getEmptyArgsInstance() {
        return new cursorNext_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public cursorNext_result getResult(I iface, cursorNext_args args) throws org.apache.thrift.TException {
        cursorNext_result result = new cursorNext_result();
        try {
          result.success = iface.cursorNext(args.connection, args.cursor, args.count);
        } catch (InvalidOperation ouch) {
          result.ouch = ouch;
        }
        return result;
      }
    }

    public static class closeCursor<I extends Iface> extends org.apache.thrift.ProcessFunction<I, closeCursor_args> {
      public closeCursor() {
        super("closeCursor");
      }

      public closeCursor_args getEmptyArgsInstance() {
        return new closeCursor_args();
      }

      protected boolean isOneway() {
        return false;
      }

      public closeCursor_result getResult(I iface, closeCursor_args args) throws org.apache.thrift.TException {
        closeCursor_result result = new closeCursor_result();
        iface.closeCursor(args.connection, args.cursor);
        return result;
      }
    }

    public static class closeConnection<I extends Iface> extends org.apache.thrift.ProcessFunction<I, closeConnection_args> {
      public closeConnection() {
        super("closeConnection");
      }

      public closeConnection_args getEmptyArgsInstance() {
        return new closeConnection_args();
      }

      protected boolean isOneway() {
        return true;
      }

      public org.apache.thrift.TBase getResult(I iface, closeConnection_args args) throws org.apache.thrift.TException {
        iface.closeConnection(args.connection);
        return null;
      }
    }

  }

  public static class AsyncProcessor<I extends AsyncIface> extends org.apache.thrift.TBaseAsyncProcessor<I> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncProcessor.class.getName());
    public AsyncProcessor(I iface) {
      super(iface, getProcessMap(new HashMap<String, org.apache.thrift.AsyncProcessFunction<I, ? extends org.apache.thrift.TBase, ?>>()));
    }

    protected AsyncProcessor(I iface, Map<String,  org.apache.thrift.AsyncProcessFunction<I, ? extends  org.apache.thrift.TBase, ?>> processMap) {
      super(iface, getProcessMap(processMap));
    }

    private static <I extends AsyncIface> Map<String,  org.apache.thrift.AsyncProcessFunction<I, ? extends  org.apache.thrift.TBase,?>> getProcessMap(Map<String,  org.apache.thrift.AsyncProcessFunction<I, ? extends  org.apache.thrift.TBase, ?>> processMap) {
      processMap.put("command", new command());
      processMap.put("connect", new connect());
      processMap.put("cursorNext", new cursorNext());
      processMap.put("closeCursor", new closeCursor());
      processMap.put("closeConnection", new closeConnection());
      return processMap;
    }

    public static class command<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, command_args, Long> {
      public command() {
        super("command");
      }

      public command_args getEmptyArgsInstance() {
        return new command_args();
      }

      public AsyncMethodCallback<Long> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Long>() { 
          public void onComplete(Long o) {
            command_result result = new command_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            command_result result = new command_result();
            if (e instanceof InvalidOperation) {
                        result.ouch = (InvalidOperation) e;
                        result.setOuchIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, command_args args, org.apache.thrift.async.AsyncMethodCallback<Long> resultHandler) throws TException {
        iface.command(args.connection, args.database, args.collection, args.command, args.remoteView,resultHandler);
      }
    }

    public static class connect<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, connect_args, Long> {
      public connect() {
        super("connect");
      }

      public connect_args getEmptyArgsInstance() {
        return new connect_args();
      }

      public AsyncMethodCallback<Long> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Long>() { 
          public void onComplete(Long o) {
            connect_result result = new connect_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            connect_result result = new connect_result();
            if (e instanceof InvalidOperation) {
                        result.ouch = (InvalidOperation) e;
                        result.setOuchIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, connect_args args, org.apache.thrift.async.AsyncMethodCallback<Long> resultHandler) throws TException {
        iface.connect(args.username, args.password,resultHandler);
      }
    }

    public static class cursorNext<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, cursorNext_args, ByteBuffer> {
      public cursorNext() {
        super("cursorNext");
      }

      public cursorNext_args getEmptyArgsInstance() {
        return new cursorNext_args();
      }

      public AsyncMethodCallback<ByteBuffer> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<ByteBuffer>() { 
          public void onComplete(ByteBuffer o) {
            cursorNext_result result = new cursorNext_result();
            result.success = o;
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            cursorNext_result result = new cursorNext_result();
            if (e instanceof InvalidOperation) {
                        result.ouch = (InvalidOperation) e;
                        result.setOuchIsSet(true);
                        msg = result;
            }
             else 
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, cursorNext_args args, org.apache.thrift.async.AsyncMethodCallback<ByteBuffer> resultHandler) throws TException {
        iface.cursorNext(args.connection, args.cursor, args.count,resultHandler);
      }
    }

    public static class closeCursor<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, closeCursor_args, Void> {
      public closeCursor() {
        super("closeCursor");
      }

      public closeCursor_args getEmptyArgsInstance() {
        return new closeCursor_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            closeCursor_result result = new closeCursor_result();
            try {
              fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
              return;
            } catch (Exception e) {
              LOGGER.error("Exception writing to internal frame buffer", e);
            }
            fb.close();
          }
          public void onError(Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TBase msg;
            closeCursor_result result = new closeCursor_result();
            {
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
              return;
            } catch (Exception ex) {
              LOGGER.error("Exception writing to internal frame buffer", ex);
            }
            fb.close();
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, closeCursor_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.closeCursor(args.connection, args.cursor,resultHandler);
      }
    }

    public static class closeConnection<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, closeConnection_args, Void> {
      public closeConnection() {
        super("closeConnection");
      }

      public closeConnection_args getEmptyArgsInstance() {
        return new closeConnection_args();
      }

      public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
          }
          public void onError(Exception e) {
          }
        };
      }

      protected boolean isOneway() {
        return true;
      }

      public void start(I iface, closeConnection_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
        iface.closeConnection(args.connection,resultHandler);
      }
    }

  }

  public static class command_args implements org.apache.thrift.TBase<command_args, command_args._Fields>, java.io.Serializable, Cloneable, Comparable<command_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("command_args");

    private static final org.apache.thrift.protocol.TField CONNECTION_FIELD_DESC = new org.apache.thrift.protocol.TField("connection", org.apache.thrift.protocol.TType.I64, (short)1);
    private static final org.apache.thrift.protocol.TField DATABASE_FIELD_DESC = new org.apache.thrift.protocol.TField("database", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField COLLECTION_FIELD_DESC = new org.apache.thrift.protocol.TField("collection", org.apache.thrift.protocol.TType.STRING, (short)3);
    private static final org.apache.thrift.protocol.TField COMMAND_FIELD_DESC = new org.apache.thrift.protocol.TField("command", org.apache.thrift.protocol.TType.STRING, (short)4);
    private static final org.apache.thrift.protocol.TField REMOTE_VIEW_FIELD_DESC = new org.apache.thrift.protocol.TField("remoteView", org.apache.thrift.protocol.TType.BOOL, (short)5);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new command_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new command_argsTupleSchemeFactory());
    }

    public long connection; // required
    public String database; // required
    public String collection; // required
    public String command; // required
    public boolean remoteView; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CONNECTION((short)1, "connection"),
      DATABASE((short)2, "database"),
      COLLECTION((short)3, "collection"),
      COMMAND((short)4, "command"),
      REMOTE_VIEW((short)5, "remoteView");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // CONNECTION
            return CONNECTION;
          case 2: // DATABASE
            return DATABASE;
          case 3: // COLLECTION
            return COLLECTION;
          case 4: // COMMAND
            return COMMAND;
          case 5: // REMOTE_VIEW
            return REMOTE_VIEW;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __CONNECTION_ISSET_ID = 0;
    private static final int __REMOTEVIEW_ISSET_ID = 1;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CONNECTION, new org.apache.thrift.meta_data.FieldMetaData("connection", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      tmpMap.put(_Fields.DATABASE, new org.apache.thrift.meta_data.FieldMetaData("database", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.COLLECTION, new org.apache.thrift.meta_data.FieldMetaData("collection", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.COMMAND, new org.apache.thrift.meta_data.FieldMetaData("command", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.REMOTE_VIEW, new org.apache.thrift.meta_data.FieldMetaData("remoteView", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(command_args.class, metaDataMap);
    }

    public command_args() {
    }

    public command_args(
      long connection,
      String database,
      String collection,
      String command,
      boolean remoteView)
    {
      this();
      this.connection = connection;
      setConnectionIsSet(true);
      this.database = database;
      this.collection = collection;
      this.command = command;
      this.remoteView = remoteView;
      setRemoteViewIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public command_args(command_args other) {
      __isset_bitfield = other.__isset_bitfield;
      this.connection = other.connection;
      if (other.isSetDatabase()) {
        this.database = other.database;
      }
      if (other.isSetCollection()) {
        this.collection = other.collection;
      }
      if (other.isSetCommand()) {
        this.command = other.command;
      }
      this.remoteView = other.remoteView;
    }

    public command_args deepCopy() {
      return new command_args(this);
    }

    @Override
    public void clear() {
      setConnectionIsSet(false);
      this.connection = 0;
      this.database = null;
      this.collection = null;
      this.command = null;
      setRemoteViewIsSet(false);
      this.remoteView = false;
    }

    public long getConnection() {
      return this.connection;
    }

    public command_args setConnection(long connection) {
      this.connection = connection;
      setConnectionIsSet(true);
      return this;
    }

    public void unsetConnection() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __CONNECTION_ISSET_ID);
    }

    /** Returns true if field connection is set (has been assigned a value) and false otherwise */
    public boolean isSetConnection() {
      return EncodingUtils.testBit(__isset_bitfield, __CONNECTION_ISSET_ID);
    }

    public void setConnectionIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __CONNECTION_ISSET_ID, value);
    }

    public String getDatabase() {
      return this.database;
    }

    public command_args setDatabase(String database) {
      this.database = database;
      return this;
    }

    public void unsetDatabase() {
      this.database = null;
    }

    /** Returns true if field database is set (has been assigned a value) and false otherwise */
    public boolean isSetDatabase() {
      return this.database != null;
    }

    public void setDatabaseIsSet(boolean value) {
      if (!value) {
        this.database = null;
      }
    }

    public String getCollection() {
      return this.collection;
    }

    public command_args setCollection(String collection) {
      this.collection = collection;
      return this;
    }

    public void unsetCollection() {
      this.collection = null;
    }

    /** Returns true if field collection is set (has been assigned a value) and false otherwise */
    public boolean isSetCollection() {
      return this.collection != null;
    }

    public void setCollectionIsSet(boolean value) {
      if (!value) {
        this.collection = null;
      }
    }

    public String getCommand() {
      return this.command;
    }

    public command_args setCommand(String command) {
      this.command = command;
      return this;
    }

    public void unsetCommand() {
      this.command = null;
    }

    /** Returns true if field command is set (has been assigned a value) and false otherwise */
    public boolean isSetCommand() {
      return this.command != null;
    }

    public void setCommandIsSet(boolean value) {
      if (!value) {
        this.command = null;
      }
    }

    public boolean isRemoteView() {
      return this.remoteView;
    }

    public command_args setRemoteView(boolean remoteView) {
      this.remoteView = remoteView;
      setRemoteViewIsSet(true);
      return this;
    }

    public void unsetRemoteView() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __REMOTEVIEW_ISSET_ID);
    }

    /** Returns true if field remoteView is set (has been assigned a value) and false otherwise */
    public boolean isSetRemoteView() {
      return EncodingUtils.testBit(__isset_bitfield, __REMOTEVIEW_ISSET_ID);
    }

    public void setRemoteViewIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __REMOTEVIEW_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CONNECTION:
        if (value == null) {
          unsetConnection();
        } else {
          setConnection((Long)value);
        }
        break;

      case DATABASE:
        if (value == null) {
          unsetDatabase();
        } else {
          setDatabase((String)value);
        }
        break;

      case COLLECTION:
        if (value == null) {
          unsetCollection();
        } else {
          setCollection((String)value);
        }
        break;

      case COMMAND:
        if (value == null) {
          unsetCommand();
        } else {
          setCommand((String)value);
        }
        break;

      case REMOTE_VIEW:
        if (value == null) {
          unsetRemoteView();
        } else {
          setRemoteView((Boolean)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CONNECTION:
        return getConnection();

      case DATABASE:
        return getDatabase();

      case COLLECTION:
        return getCollection();

      case COMMAND:
        return getCommand();

      case REMOTE_VIEW:
        return isRemoteView();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CONNECTION:
        return isSetConnection();
      case DATABASE:
        return isSetDatabase();
      case COLLECTION:
        return isSetCollection();
      case COMMAND:
        return isSetCommand();
      case REMOTE_VIEW:
        return isSetRemoteView();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof command_args)
        return this.equals((command_args)that);
      return false;
    }

    public boolean equals(command_args that) {
      if (that == null)
        return false;

      boolean this_present_connection = true;
      boolean that_present_connection = true;
      if (this_present_connection || that_present_connection) {
        if (!(this_present_connection && that_present_connection))
          return false;
        if (this.connection != that.connection)
          return false;
      }

      boolean this_present_database = true && this.isSetDatabase();
      boolean that_present_database = true && that.isSetDatabase();
      if (this_present_database || that_present_database) {
        if (!(this_present_database && that_present_database))
          return false;
        if (!this.database.equals(that.database))
          return false;
      }

      boolean this_present_collection = true && this.isSetCollection();
      boolean that_present_collection = true && that.isSetCollection();
      if (this_present_collection || that_present_collection) {
        if (!(this_present_collection && that_present_collection))
          return false;
        if (!this.collection.equals(that.collection))
          return false;
      }

      boolean this_present_command = true && this.isSetCommand();
      boolean that_present_command = true && that.isSetCommand();
      if (this_present_command || that_present_command) {
        if (!(this_present_command && that_present_command))
          return false;
        if (!this.command.equals(that.command))
          return false;
      }

      boolean this_present_remoteView = true;
      boolean that_present_remoteView = true;
      if (this_present_remoteView || that_present_remoteView) {
        if (!(this_present_remoteView && that_present_remoteView))
          return false;
        if (this.remoteView != that.remoteView)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_connection = true;
      list.add(present_connection);
      if (present_connection)
        list.add(connection);

      boolean present_database = true && (isSetDatabase());
      list.add(present_database);
      if (present_database)
        list.add(database);

      boolean present_collection = true && (isSetCollection());
      list.add(present_collection);
      if (present_collection)
        list.add(collection);

      boolean present_command = true && (isSetCommand());
      list.add(present_command);
      if (present_command)
        list.add(command);

      boolean present_remoteView = true;
      list.add(present_remoteView);
      if (present_remoteView)
        list.add(remoteView);

      return list.hashCode();
    }

    @Override
    public int compareTo(command_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetConnection()).compareTo(other.isSetConnection());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetConnection()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.connection, other.connection);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetDatabase()).compareTo(other.isSetDatabase());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetDatabase()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.database, other.database);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetCollection()).compareTo(other.isSetCollection());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCollection()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.collection, other.collection);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetCommand()).compareTo(other.isSetCommand());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCommand()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.command, other.command);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetRemoteView()).compareTo(other.isSetRemoteView());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetRemoteView()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.remoteView, other.remoteView);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("command_args(");
      boolean first = true;

      sb.append("connection:");
      sb.append(this.connection);
      first = false;
      if (!first) sb.append(", ");
      sb.append("database:");
      if (this.database == null) {
        sb.append("null");
      } else {
        sb.append(this.database);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("collection:");
      if (this.collection == null) {
        sb.append("null");
      } else {
        sb.append(this.collection);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("command:");
      if (this.command == null) {
        sb.append("null");
      } else {
        sb.append(this.command);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("remoteView:");
      sb.append(this.remoteView);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class command_argsStandardSchemeFactory implements SchemeFactory {
      public command_argsStandardScheme getScheme() {
        return new command_argsStandardScheme();
      }
    }

    private static class command_argsStandardScheme extends StandardScheme<command_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, command_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // CONNECTION
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.connection = iprot.readI64();
                struct.setConnectionIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // DATABASE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.database = iprot.readString();
                struct.setDatabaseIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // COLLECTION
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.collection = iprot.readString();
                struct.setCollectionIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // COMMAND
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.command = iprot.readString();
                struct.setCommandIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 5: // REMOTE_VIEW
              if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
                struct.remoteView = iprot.readBool();
                struct.setRemoteViewIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, command_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(CONNECTION_FIELD_DESC);
        oprot.writeI64(struct.connection);
        oprot.writeFieldEnd();
        if (struct.database != null) {
          oprot.writeFieldBegin(DATABASE_FIELD_DESC);
          oprot.writeString(struct.database);
          oprot.writeFieldEnd();
        }
        if (struct.collection != null) {
          oprot.writeFieldBegin(COLLECTION_FIELD_DESC);
          oprot.writeString(struct.collection);
          oprot.writeFieldEnd();
        }
        if (struct.command != null) {
          oprot.writeFieldBegin(COMMAND_FIELD_DESC);
          oprot.writeString(struct.command);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(REMOTE_VIEW_FIELD_DESC);
        oprot.writeBool(struct.remoteView);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class command_argsTupleSchemeFactory implements SchemeFactory {
      public command_argsTupleScheme getScheme() {
        return new command_argsTupleScheme();
      }
    }

    private static class command_argsTupleScheme extends TupleScheme<command_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, command_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetConnection()) {
          optionals.set(0);
        }
        if (struct.isSetDatabase()) {
          optionals.set(1);
        }
        if (struct.isSetCollection()) {
          optionals.set(2);
        }
        if (struct.isSetCommand()) {
          optionals.set(3);
        }
        if (struct.isSetRemoteView()) {
          optionals.set(4);
        }
        oprot.writeBitSet(optionals, 5);
        if (struct.isSetConnection()) {
          oprot.writeI64(struct.connection);
        }
        if (struct.isSetDatabase()) {
          oprot.writeString(struct.database);
        }
        if (struct.isSetCollection()) {
          oprot.writeString(struct.collection);
        }
        if (struct.isSetCommand()) {
          oprot.writeString(struct.command);
        }
        if (struct.isSetRemoteView()) {
          oprot.writeBool(struct.remoteView);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, command_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(5);
        if (incoming.get(0)) {
          struct.connection = iprot.readI64();
          struct.setConnectionIsSet(true);
        }
        if (incoming.get(1)) {
          struct.database = iprot.readString();
          struct.setDatabaseIsSet(true);
        }
        if (incoming.get(2)) {
          struct.collection = iprot.readString();
          struct.setCollectionIsSet(true);
        }
        if (incoming.get(3)) {
          struct.command = iprot.readString();
          struct.setCommandIsSet(true);
        }
        if (incoming.get(4)) {
          struct.remoteView = iprot.readBool();
          struct.setRemoteViewIsSet(true);
        }
      }
    }

  }

  public static class command_result implements org.apache.thrift.TBase<command_result, command_result._Fields>, java.io.Serializable, Cloneable, Comparable<command_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("command_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.I64, (short)0);
    private static final org.apache.thrift.protocol.TField OUCH_FIELD_DESC = new org.apache.thrift.protocol.TField("ouch", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new command_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new command_resultTupleSchemeFactory());
    }

    public long success; // required
    public InvalidOperation ouch; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      OUCH((short)1, "ouch");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // OUCH
            return OUCH;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SUCCESS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      tmpMap.put(_Fields.OUCH, new org.apache.thrift.meta_data.FieldMetaData("ouch", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(command_result.class, metaDataMap);
    }

    public command_result() {
    }

    public command_result(
      long success,
      InvalidOperation ouch)
    {
      this();
      this.success = success;
      setSuccessIsSet(true);
      this.ouch = ouch;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public command_result(command_result other) {
      __isset_bitfield = other.__isset_bitfield;
      this.success = other.success;
      if (other.isSetOuch()) {
        this.ouch = new InvalidOperation(other.ouch);
      }
    }

    public command_result deepCopy() {
      return new command_result(this);
    }

    @Override
    public void clear() {
      setSuccessIsSet(false);
      this.success = 0;
      this.ouch = null;
    }

    public long getSuccess() {
      return this.success;
    }

    public command_result setSuccess(long success) {
      this.success = success;
      setSuccessIsSet(true);
      return this;
    }

    public void unsetSuccess() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    public void setSuccessIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
    }

    public InvalidOperation getOuch() {
      return this.ouch;
    }

    public command_result setOuch(InvalidOperation ouch) {
      this.ouch = ouch;
      return this;
    }

    public void unsetOuch() {
      this.ouch = null;
    }

    /** Returns true if field ouch is set (has been assigned a value) and false otherwise */
    public boolean isSetOuch() {
      return this.ouch != null;
    }

    public void setOuchIsSet(boolean value) {
      if (!value) {
        this.ouch = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Long)value);
        }
        break;

      case OUCH:
        if (value == null) {
          unsetOuch();
        } else {
          setOuch((InvalidOperation)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case OUCH:
        return getOuch();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case OUCH:
        return isSetOuch();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof command_result)
        return this.equals((command_result)that);
      return false;
    }

    public boolean equals(command_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      boolean this_present_ouch = true && this.isSetOuch();
      boolean that_present_ouch = true && that.isSetOuch();
      if (this_present_ouch || that_present_ouch) {
        if (!(this_present_ouch && that_present_ouch))
          return false;
        if (!this.ouch.equals(that.ouch))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true;
      list.add(present_success);
      if (present_success)
        list.add(success);

      boolean present_ouch = true && (isSetOuch());
      list.add(present_ouch);
      if (present_ouch)
        list.add(ouch);

      return list.hashCode();
    }

    @Override
    public int compareTo(command_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetOuch()).compareTo(other.isSetOuch());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetOuch()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ouch, other.ouch);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("command_result(");
      boolean first = true;

      sb.append("success:");
      sb.append(this.success);
      first = false;
      if (!first) sb.append(", ");
      sb.append("ouch:");
      if (this.ouch == null) {
        sb.append("null");
      } else {
        sb.append(this.ouch);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class command_resultStandardSchemeFactory implements SchemeFactory {
      public command_resultStandardScheme getScheme() {
        return new command_resultStandardScheme();
      }
    }

    private static class command_resultStandardScheme extends StandardScheme<command_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, command_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.success = iprot.readI64();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // OUCH
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ouch = new InvalidOperation();
                struct.ouch.read(iprot);
                struct.setOuchIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, command_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.isSetSuccess()) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeI64(struct.success);
          oprot.writeFieldEnd();
        }
        if (struct.ouch != null) {
          oprot.writeFieldBegin(OUCH_FIELD_DESC);
          struct.ouch.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class command_resultTupleSchemeFactory implements SchemeFactory {
      public command_resultTupleScheme getScheme() {
        return new command_resultTupleScheme();
      }
    }

    private static class command_resultTupleScheme extends TupleScheme<command_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, command_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetOuch()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          oprot.writeI64(struct.success);
        }
        if (struct.isSetOuch()) {
          struct.ouch.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, command_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = iprot.readI64();
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.ouch = new InvalidOperation();
          struct.ouch.read(iprot);
          struct.setOuchIsSet(true);
        }
      }
    }

  }

  public static class connect_args implements org.apache.thrift.TBase<connect_args, connect_args._Fields>, java.io.Serializable, Cloneable, Comparable<connect_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("connect_args");

    private static final org.apache.thrift.protocol.TField USERNAME_FIELD_DESC = new org.apache.thrift.protocol.TField("username", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField PASSWORD_FIELD_DESC = new org.apache.thrift.protocol.TField("password", org.apache.thrift.protocol.TType.STRING, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new connect_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new connect_argsTupleSchemeFactory());
    }

    public String username; // required
    public String password; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      USERNAME((short)2, "username"),
      PASSWORD((short)3, "password");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 2: // USERNAME
            return USERNAME;
          case 3: // PASSWORD
            return PASSWORD;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.USERNAME, new org.apache.thrift.meta_data.FieldMetaData("username", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.PASSWORD, new org.apache.thrift.meta_data.FieldMetaData("password", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(connect_args.class, metaDataMap);
    }

    public connect_args() {
    }

    public connect_args(
      String username,
      String password)
    {
      this();
      this.username = username;
      this.password = password;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public connect_args(connect_args other) {
      if (other.isSetUsername()) {
        this.username = other.username;
      }
      if (other.isSetPassword()) {
        this.password = other.password;
      }
    }

    public connect_args deepCopy() {
      return new connect_args(this);
    }

    @Override
    public void clear() {
      this.username = null;
      this.password = null;
    }

    public String getUsername() {
      return this.username;
    }

    public connect_args setUsername(String username) {
      this.username = username;
      return this;
    }

    public void unsetUsername() {
      this.username = null;
    }

    /** Returns true if field username is set (has been assigned a value) and false otherwise */
    public boolean isSetUsername() {
      return this.username != null;
    }

    public void setUsernameIsSet(boolean value) {
      if (!value) {
        this.username = null;
      }
    }

    public String getPassword() {
      return this.password;
    }

    public connect_args setPassword(String password) {
      this.password = password;
      return this;
    }

    public void unsetPassword() {
      this.password = null;
    }

    /** Returns true if field password is set (has been assigned a value) and false otherwise */
    public boolean isSetPassword() {
      return this.password != null;
    }

    public void setPasswordIsSet(boolean value) {
      if (!value) {
        this.password = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case USERNAME:
        if (value == null) {
          unsetUsername();
        } else {
          setUsername((String)value);
        }
        break;

      case PASSWORD:
        if (value == null) {
          unsetPassword();
        } else {
          setPassword((String)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case USERNAME:
        return getUsername();

      case PASSWORD:
        return getPassword();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case USERNAME:
        return isSetUsername();
      case PASSWORD:
        return isSetPassword();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof connect_args)
        return this.equals((connect_args)that);
      return false;
    }

    public boolean equals(connect_args that) {
      if (that == null)
        return false;

      boolean this_present_username = true && this.isSetUsername();
      boolean that_present_username = true && that.isSetUsername();
      if (this_present_username || that_present_username) {
        if (!(this_present_username && that_present_username))
          return false;
        if (!this.username.equals(that.username))
          return false;
      }

      boolean this_present_password = true && this.isSetPassword();
      boolean that_present_password = true && that.isSetPassword();
      if (this_present_password || that_present_password) {
        if (!(this_present_password && that_present_password))
          return false;
        if (!this.password.equals(that.password))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_username = true && (isSetUsername());
      list.add(present_username);
      if (present_username)
        list.add(username);

      boolean present_password = true && (isSetPassword());
      list.add(present_password);
      if (present_password)
        list.add(password);

      return list.hashCode();
    }

    @Override
    public int compareTo(connect_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetUsername()).compareTo(other.isSetUsername());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetUsername()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.username, other.username);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetPassword()).compareTo(other.isSetPassword());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetPassword()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.password, other.password);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("connect_args(");
      boolean first = true;

      sb.append("username:");
      if (this.username == null) {
        sb.append("null");
      } else {
        sb.append(this.username);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("password:");
      if (this.password == null) {
        sb.append("null");
      } else {
        sb.append(this.password);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class connect_argsStandardSchemeFactory implements SchemeFactory {
      public connect_argsStandardScheme getScheme() {
        return new connect_argsStandardScheme();
      }
    }

    private static class connect_argsStandardScheme extends StandardScheme<connect_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, connect_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 2: // USERNAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.username = iprot.readString();
                struct.setUsernameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // PASSWORD
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.password = iprot.readString();
                struct.setPasswordIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, connect_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.username != null) {
          oprot.writeFieldBegin(USERNAME_FIELD_DESC);
          oprot.writeString(struct.username);
          oprot.writeFieldEnd();
        }
        if (struct.password != null) {
          oprot.writeFieldBegin(PASSWORD_FIELD_DESC);
          oprot.writeString(struct.password);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class connect_argsTupleSchemeFactory implements SchemeFactory {
      public connect_argsTupleScheme getScheme() {
        return new connect_argsTupleScheme();
      }
    }

    private static class connect_argsTupleScheme extends TupleScheme<connect_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, connect_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetUsername()) {
          optionals.set(0);
        }
        if (struct.isSetPassword()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetUsername()) {
          oprot.writeString(struct.username);
        }
        if (struct.isSetPassword()) {
          oprot.writeString(struct.password);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, connect_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.username = iprot.readString();
          struct.setUsernameIsSet(true);
        }
        if (incoming.get(1)) {
          struct.password = iprot.readString();
          struct.setPasswordIsSet(true);
        }
      }
    }

  }

  public static class connect_result implements org.apache.thrift.TBase<connect_result, connect_result._Fields>, java.io.Serializable, Cloneable, Comparable<connect_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("connect_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.I64, (short)0);
    private static final org.apache.thrift.protocol.TField OUCH_FIELD_DESC = new org.apache.thrift.protocol.TField("ouch", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new connect_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new connect_resultTupleSchemeFactory());
    }

    public long success; // required
    public InvalidOperation ouch; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      OUCH((short)1, "ouch");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // OUCH
            return OUCH;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SUCCESS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      tmpMap.put(_Fields.OUCH, new org.apache.thrift.meta_data.FieldMetaData("ouch", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(connect_result.class, metaDataMap);
    }

    public connect_result() {
    }

    public connect_result(
      long success,
      InvalidOperation ouch)
    {
      this();
      this.success = success;
      setSuccessIsSet(true);
      this.ouch = ouch;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public connect_result(connect_result other) {
      __isset_bitfield = other.__isset_bitfield;
      this.success = other.success;
      if (other.isSetOuch()) {
        this.ouch = new InvalidOperation(other.ouch);
      }
    }

    public connect_result deepCopy() {
      return new connect_result(this);
    }

    @Override
    public void clear() {
      setSuccessIsSet(false);
      this.success = 0;
      this.ouch = null;
    }

    public long getSuccess() {
      return this.success;
    }

    public connect_result setSuccess(long success) {
      this.success = success;
      setSuccessIsSet(true);
      return this;
    }

    public void unsetSuccess() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    public void setSuccessIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
    }

    public InvalidOperation getOuch() {
      return this.ouch;
    }

    public connect_result setOuch(InvalidOperation ouch) {
      this.ouch = ouch;
      return this;
    }

    public void unsetOuch() {
      this.ouch = null;
    }

    /** Returns true if field ouch is set (has been assigned a value) and false otherwise */
    public boolean isSetOuch() {
      return this.ouch != null;
    }

    public void setOuchIsSet(boolean value) {
      if (!value) {
        this.ouch = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((Long)value);
        }
        break;

      case OUCH:
        if (value == null) {
          unsetOuch();
        } else {
          setOuch((InvalidOperation)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case OUCH:
        return getOuch();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case OUCH:
        return isSetOuch();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof connect_result)
        return this.equals((connect_result)that);
      return false;
    }

    public boolean equals(connect_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      boolean this_present_ouch = true && this.isSetOuch();
      boolean that_present_ouch = true && that.isSetOuch();
      if (this_present_ouch || that_present_ouch) {
        if (!(this_present_ouch && that_present_ouch))
          return false;
        if (!this.ouch.equals(that.ouch))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true;
      list.add(present_success);
      if (present_success)
        list.add(success);

      boolean present_ouch = true && (isSetOuch());
      list.add(present_ouch);
      if (present_ouch)
        list.add(ouch);

      return list.hashCode();
    }

    @Override
    public int compareTo(connect_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetOuch()).compareTo(other.isSetOuch());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetOuch()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ouch, other.ouch);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("connect_result(");
      boolean first = true;

      sb.append("success:");
      sb.append(this.success);
      first = false;
      if (!first) sb.append(", ");
      sb.append("ouch:");
      if (this.ouch == null) {
        sb.append("null");
      } else {
        sb.append(this.ouch);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class connect_resultStandardSchemeFactory implements SchemeFactory {
      public connect_resultStandardScheme getScheme() {
        return new connect_resultStandardScheme();
      }
    }

    private static class connect_resultStandardScheme extends StandardScheme<connect_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, connect_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.success = iprot.readI64();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // OUCH
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ouch = new InvalidOperation();
                struct.ouch.read(iprot);
                struct.setOuchIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, connect_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.isSetSuccess()) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeI64(struct.success);
          oprot.writeFieldEnd();
        }
        if (struct.ouch != null) {
          oprot.writeFieldBegin(OUCH_FIELD_DESC);
          struct.ouch.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class connect_resultTupleSchemeFactory implements SchemeFactory {
      public connect_resultTupleScheme getScheme() {
        return new connect_resultTupleScheme();
      }
    }

    private static class connect_resultTupleScheme extends TupleScheme<connect_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, connect_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetOuch()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          oprot.writeI64(struct.success);
        }
        if (struct.isSetOuch()) {
          struct.ouch.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, connect_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = iprot.readI64();
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.ouch = new InvalidOperation();
          struct.ouch.read(iprot);
          struct.setOuchIsSet(true);
        }
      }
    }

  }

  public static class cursorNext_args implements org.apache.thrift.TBase<cursorNext_args, cursorNext_args._Fields>, java.io.Serializable, Cloneable, Comparable<cursorNext_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("cursorNext_args");

    private static final org.apache.thrift.protocol.TField CONNECTION_FIELD_DESC = new org.apache.thrift.protocol.TField("connection", org.apache.thrift.protocol.TType.I64, (short)1);
    private static final org.apache.thrift.protocol.TField CURSOR_FIELD_DESC = new org.apache.thrift.protocol.TField("cursor", org.apache.thrift.protocol.TType.I64, (short)2);
    private static final org.apache.thrift.protocol.TField COUNT_FIELD_DESC = new org.apache.thrift.protocol.TField("count", org.apache.thrift.protocol.TType.I32, (short)3);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new cursorNext_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new cursorNext_argsTupleSchemeFactory());
    }

    public long connection; // required
    public long cursor; // required
    public int count; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CONNECTION((short)1, "connection"),
      CURSOR((short)2, "cursor"),
      COUNT((short)3, "count");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // CONNECTION
            return CONNECTION;
          case 2: // CURSOR
            return CURSOR;
          case 3: // COUNT
            return COUNT;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __CONNECTION_ISSET_ID = 0;
    private static final int __CURSOR_ISSET_ID = 1;
    private static final int __COUNT_ISSET_ID = 2;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CONNECTION, new org.apache.thrift.meta_data.FieldMetaData("connection", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      tmpMap.put(_Fields.CURSOR, new org.apache.thrift.meta_data.FieldMetaData("cursor", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      tmpMap.put(_Fields.COUNT, new org.apache.thrift.meta_data.FieldMetaData("count", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(cursorNext_args.class, metaDataMap);
    }

    public cursorNext_args() {
    }

    public cursorNext_args(
      long connection,
      long cursor,
      int count)
    {
      this();
      this.connection = connection;
      setConnectionIsSet(true);
      this.cursor = cursor;
      setCursorIsSet(true);
      this.count = count;
      setCountIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public cursorNext_args(cursorNext_args other) {
      __isset_bitfield = other.__isset_bitfield;
      this.connection = other.connection;
      this.cursor = other.cursor;
      this.count = other.count;
    }

    public cursorNext_args deepCopy() {
      return new cursorNext_args(this);
    }

    @Override
    public void clear() {
      setConnectionIsSet(false);
      this.connection = 0;
      setCursorIsSet(false);
      this.cursor = 0;
      setCountIsSet(false);
      this.count = 0;
    }

    public long getConnection() {
      return this.connection;
    }

    public cursorNext_args setConnection(long connection) {
      this.connection = connection;
      setConnectionIsSet(true);
      return this;
    }

    public void unsetConnection() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __CONNECTION_ISSET_ID);
    }

    /** Returns true if field connection is set (has been assigned a value) and false otherwise */
    public boolean isSetConnection() {
      return EncodingUtils.testBit(__isset_bitfield, __CONNECTION_ISSET_ID);
    }

    public void setConnectionIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __CONNECTION_ISSET_ID, value);
    }

    public long getCursor() {
      return this.cursor;
    }

    public cursorNext_args setCursor(long cursor) {
      this.cursor = cursor;
      setCursorIsSet(true);
      return this;
    }

    public void unsetCursor() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __CURSOR_ISSET_ID);
    }

    /** Returns true if field cursor is set (has been assigned a value) and false otherwise */
    public boolean isSetCursor() {
      return EncodingUtils.testBit(__isset_bitfield, __CURSOR_ISSET_ID);
    }

    public void setCursorIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __CURSOR_ISSET_ID, value);
    }

    public int getCount() {
      return this.count;
    }

    public cursorNext_args setCount(int count) {
      this.count = count;
      setCountIsSet(true);
      return this;
    }

    public void unsetCount() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __COUNT_ISSET_ID);
    }

    /** Returns true if field count is set (has been assigned a value) and false otherwise */
    public boolean isSetCount() {
      return EncodingUtils.testBit(__isset_bitfield, __COUNT_ISSET_ID);
    }

    public void setCountIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __COUNT_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CONNECTION:
        if (value == null) {
          unsetConnection();
        } else {
          setConnection((Long)value);
        }
        break;

      case CURSOR:
        if (value == null) {
          unsetCursor();
        } else {
          setCursor((Long)value);
        }
        break;

      case COUNT:
        if (value == null) {
          unsetCount();
        } else {
          setCount((Integer)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CONNECTION:
        return getConnection();

      case CURSOR:
        return getCursor();

      case COUNT:
        return getCount();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CONNECTION:
        return isSetConnection();
      case CURSOR:
        return isSetCursor();
      case COUNT:
        return isSetCount();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof cursorNext_args)
        return this.equals((cursorNext_args)that);
      return false;
    }

    public boolean equals(cursorNext_args that) {
      if (that == null)
        return false;

      boolean this_present_connection = true;
      boolean that_present_connection = true;
      if (this_present_connection || that_present_connection) {
        if (!(this_present_connection && that_present_connection))
          return false;
        if (this.connection != that.connection)
          return false;
      }

      boolean this_present_cursor = true;
      boolean that_present_cursor = true;
      if (this_present_cursor || that_present_cursor) {
        if (!(this_present_cursor && that_present_cursor))
          return false;
        if (this.cursor != that.cursor)
          return false;
      }

      boolean this_present_count = true;
      boolean that_present_count = true;
      if (this_present_count || that_present_count) {
        if (!(this_present_count && that_present_count))
          return false;
        if (this.count != that.count)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_connection = true;
      list.add(present_connection);
      if (present_connection)
        list.add(connection);

      boolean present_cursor = true;
      list.add(present_cursor);
      if (present_cursor)
        list.add(cursor);

      boolean present_count = true;
      list.add(present_count);
      if (present_count)
        list.add(count);

      return list.hashCode();
    }

    @Override
    public int compareTo(cursorNext_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetConnection()).compareTo(other.isSetConnection());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetConnection()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.connection, other.connection);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetCursor()).compareTo(other.isSetCursor());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCursor()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.cursor, other.cursor);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetCount()).compareTo(other.isSetCount());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCount()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.count, other.count);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("cursorNext_args(");
      boolean first = true;

      sb.append("connection:");
      sb.append(this.connection);
      first = false;
      if (!first) sb.append(", ");
      sb.append("cursor:");
      sb.append(this.cursor);
      first = false;
      if (!first) sb.append(", ");
      sb.append("count:");
      sb.append(this.count);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class cursorNext_argsStandardSchemeFactory implements SchemeFactory {
      public cursorNext_argsStandardScheme getScheme() {
        return new cursorNext_argsStandardScheme();
      }
    }

    private static class cursorNext_argsStandardScheme extends StandardScheme<cursorNext_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, cursorNext_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // CONNECTION
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.connection = iprot.readI64();
                struct.setConnectionIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // CURSOR
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.cursor = iprot.readI64();
                struct.setCursorIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // COUNT
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.count = iprot.readI32();
                struct.setCountIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, cursorNext_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(CONNECTION_FIELD_DESC);
        oprot.writeI64(struct.connection);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(CURSOR_FIELD_DESC);
        oprot.writeI64(struct.cursor);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(COUNT_FIELD_DESC);
        oprot.writeI32(struct.count);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class cursorNext_argsTupleSchemeFactory implements SchemeFactory {
      public cursorNext_argsTupleScheme getScheme() {
        return new cursorNext_argsTupleScheme();
      }
    }

    private static class cursorNext_argsTupleScheme extends TupleScheme<cursorNext_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, cursorNext_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetConnection()) {
          optionals.set(0);
        }
        if (struct.isSetCursor()) {
          optionals.set(1);
        }
        if (struct.isSetCount()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.isSetConnection()) {
          oprot.writeI64(struct.connection);
        }
        if (struct.isSetCursor()) {
          oprot.writeI64(struct.cursor);
        }
        if (struct.isSetCount()) {
          oprot.writeI32(struct.count);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, cursorNext_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.connection = iprot.readI64();
          struct.setConnectionIsSet(true);
        }
        if (incoming.get(1)) {
          struct.cursor = iprot.readI64();
          struct.setCursorIsSet(true);
        }
        if (incoming.get(2)) {
          struct.count = iprot.readI32();
          struct.setCountIsSet(true);
        }
      }
    }

  }

  public static class cursorNext_result implements org.apache.thrift.TBase<cursorNext_result, cursorNext_result._Fields>, java.io.Serializable, Cloneable, Comparable<cursorNext_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("cursorNext_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRING, (short)0);
    private static final org.apache.thrift.protocol.TField OUCH_FIELD_DESC = new org.apache.thrift.protocol.TField("ouch", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new cursorNext_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new cursorNext_resultTupleSchemeFactory());
    }

    public ByteBuffer success; // required
    public InvalidOperation ouch; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      OUCH((short)1, "ouch");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // OUCH
            return OUCH;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      tmpMap.put(_Fields.OUCH, new org.apache.thrift.meta_data.FieldMetaData("ouch", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRUCT)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(cursorNext_result.class, metaDataMap);
    }

    public cursorNext_result() {
    }

    public cursorNext_result(
      ByteBuffer success,
      InvalidOperation ouch)
    {
      this();
      this.success = org.apache.thrift.TBaseHelper.copyBinary(success);
      this.ouch = ouch;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public cursorNext_result(cursorNext_result other) {
      if (other.isSetSuccess()) {
        this.success = org.apache.thrift.TBaseHelper.copyBinary(other.success);
      }
      if (other.isSetOuch()) {
        this.ouch = new InvalidOperation(other.ouch);
      }
    }

    public cursorNext_result deepCopy() {
      return new cursorNext_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.ouch = null;
    }

    public byte[] getSuccess() {
      setSuccess(org.apache.thrift.TBaseHelper.rightSize(success));
      return success == null ? null : success.array();
    }

    public ByteBuffer bufferForSuccess() {
      return org.apache.thrift.TBaseHelper.copyBinary(success);
    }

    public cursorNext_result setSuccess(byte[] success) {
      this.success = success == null ? (ByteBuffer)null : ByteBuffer.wrap(Arrays.copyOf(success, success.length));
      return this;
    }

    public cursorNext_result setSuccess(ByteBuffer success) {
      this.success = org.apache.thrift.TBaseHelper.copyBinary(success);
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    public InvalidOperation getOuch() {
      return this.ouch;
    }

    public cursorNext_result setOuch(InvalidOperation ouch) {
      this.ouch = ouch;
      return this;
    }

    public void unsetOuch() {
      this.ouch = null;
    }

    /** Returns true if field ouch is set (has been assigned a value) and false otherwise */
    public boolean isSetOuch() {
      return this.ouch != null;
    }

    public void setOuchIsSet(boolean value) {
      if (!value) {
        this.ouch = null;
      }
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((ByteBuffer)value);
        }
        break;

      case OUCH:
        if (value == null) {
          unsetOuch();
        } else {
          setOuch((InvalidOperation)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case OUCH:
        return getOuch();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case OUCH:
        return isSetOuch();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof cursorNext_result)
        return this.equals((cursorNext_result)that);
      return false;
    }

    public boolean equals(cursorNext_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_ouch = true && this.isSetOuch();
      boolean that_present_ouch = true && that.isSetOuch();
      if (this_present_ouch || that_present_ouch) {
        if (!(this_present_ouch && that_present_ouch))
          return false;
        if (!this.ouch.equals(that.ouch))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_success = true && (isSetSuccess());
      list.add(present_success);
      if (present_success)
        list.add(success);

      boolean present_ouch = true && (isSetOuch());
      list.add(present_ouch);
      if (present_ouch)
        list.add(ouch);

      return list.hashCode();
    }

    @Override
    public int compareTo(cursorNext_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetOuch()).compareTo(other.isSetOuch());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetOuch()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ouch, other.ouch);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("cursorNext_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.success, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("ouch:");
      if (this.ouch == null) {
        sb.append("null");
      } else {
        sb.append(this.ouch);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class cursorNext_resultStandardSchemeFactory implements SchemeFactory {
      public cursorNext_resultStandardScheme getScheme() {
        return new cursorNext_resultStandardScheme();
      }
    }

    private static class cursorNext_resultStandardScheme extends StandardScheme<cursorNext_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, cursorNext_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.success = iprot.readBinary();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // OUCH
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ouch = new InvalidOperation();
                struct.ouch.read(iprot);
                struct.setOuchIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, cursorNext_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeBinary(struct.success);
          oprot.writeFieldEnd();
        }
        if (struct.ouch != null) {
          oprot.writeFieldBegin(OUCH_FIELD_DESC);
          struct.ouch.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class cursorNext_resultTupleSchemeFactory implements SchemeFactory {
      public cursorNext_resultTupleScheme getScheme() {
        return new cursorNext_resultTupleScheme();
      }
    }

    private static class cursorNext_resultTupleScheme extends TupleScheme<cursorNext_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, cursorNext_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetOuch()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          oprot.writeBinary(struct.success);
        }
        if (struct.isSetOuch()) {
          struct.ouch.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, cursorNext_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = iprot.readBinary();
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.ouch = new InvalidOperation();
          struct.ouch.read(iprot);
          struct.setOuchIsSet(true);
        }
      }
    }

  }

  public static class closeCursor_args implements org.apache.thrift.TBase<closeCursor_args, closeCursor_args._Fields>, java.io.Serializable, Cloneable, Comparable<closeCursor_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("closeCursor_args");

    private static final org.apache.thrift.protocol.TField CONNECTION_FIELD_DESC = new org.apache.thrift.protocol.TField("connection", org.apache.thrift.protocol.TType.I64, (short)1);
    private static final org.apache.thrift.protocol.TField CURSOR_FIELD_DESC = new org.apache.thrift.protocol.TField("cursor", org.apache.thrift.protocol.TType.I64, (short)2);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new closeCursor_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new closeCursor_argsTupleSchemeFactory());
    }

    public long connection; // required
    public long cursor; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CONNECTION((short)1, "connection"),
      CURSOR((short)2, "cursor");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // CONNECTION
            return CONNECTION;
          case 2: // CURSOR
            return CURSOR;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __CONNECTION_ISSET_ID = 0;
    private static final int __CURSOR_ISSET_ID = 1;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CONNECTION, new org.apache.thrift.meta_data.FieldMetaData("connection", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      tmpMap.put(_Fields.CURSOR, new org.apache.thrift.meta_data.FieldMetaData("cursor", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(closeCursor_args.class, metaDataMap);
    }

    public closeCursor_args() {
    }

    public closeCursor_args(
      long connection,
      long cursor)
    {
      this();
      this.connection = connection;
      setConnectionIsSet(true);
      this.cursor = cursor;
      setCursorIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public closeCursor_args(closeCursor_args other) {
      __isset_bitfield = other.__isset_bitfield;
      this.connection = other.connection;
      this.cursor = other.cursor;
    }

    public closeCursor_args deepCopy() {
      return new closeCursor_args(this);
    }

    @Override
    public void clear() {
      setConnectionIsSet(false);
      this.connection = 0;
      setCursorIsSet(false);
      this.cursor = 0;
    }

    public long getConnection() {
      return this.connection;
    }

    public closeCursor_args setConnection(long connection) {
      this.connection = connection;
      setConnectionIsSet(true);
      return this;
    }

    public void unsetConnection() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __CONNECTION_ISSET_ID);
    }

    /** Returns true if field connection is set (has been assigned a value) and false otherwise */
    public boolean isSetConnection() {
      return EncodingUtils.testBit(__isset_bitfield, __CONNECTION_ISSET_ID);
    }

    public void setConnectionIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __CONNECTION_ISSET_ID, value);
    }

    public long getCursor() {
      return this.cursor;
    }

    public closeCursor_args setCursor(long cursor) {
      this.cursor = cursor;
      setCursorIsSet(true);
      return this;
    }

    public void unsetCursor() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __CURSOR_ISSET_ID);
    }

    /** Returns true if field cursor is set (has been assigned a value) and false otherwise */
    public boolean isSetCursor() {
      return EncodingUtils.testBit(__isset_bitfield, __CURSOR_ISSET_ID);
    }

    public void setCursorIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __CURSOR_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CONNECTION:
        if (value == null) {
          unsetConnection();
        } else {
          setConnection((Long)value);
        }
        break;

      case CURSOR:
        if (value == null) {
          unsetCursor();
        } else {
          setCursor((Long)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CONNECTION:
        return getConnection();

      case CURSOR:
        return getCursor();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CONNECTION:
        return isSetConnection();
      case CURSOR:
        return isSetCursor();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof closeCursor_args)
        return this.equals((closeCursor_args)that);
      return false;
    }

    public boolean equals(closeCursor_args that) {
      if (that == null)
        return false;

      boolean this_present_connection = true;
      boolean that_present_connection = true;
      if (this_present_connection || that_present_connection) {
        if (!(this_present_connection && that_present_connection))
          return false;
        if (this.connection != that.connection)
          return false;
      }

      boolean this_present_cursor = true;
      boolean that_present_cursor = true;
      if (this_present_cursor || that_present_cursor) {
        if (!(this_present_cursor && that_present_cursor))
          return false;
        if (this.cursor != that.cursor)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_connection = true;
      list.add(present_connection);
      if (present_connection)
        list.add(connection);

      boolean present_cursor = true;
      list.add(present_cursor);
      if (present_cursor)
        list.add(cursor);

      return list.hashCode();
    }

    @Override
    public int compareTo(closeCursor_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetConnection()).compareTo(other.isSetConnection());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetConnection()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.connection, other.connection);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = Boolean.valueOf(isSetCursor()).compareTo(other.isSetCursor());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCursor()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.cursor, other.cursor);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("closeCursor_args(");
      boolean first = true;

      sb.append("connection:");
      sb.append(this.connection);
      first = false;
      if (!first) sb.append(", ");
      sb.append("cursor:");
      sb.append(this.cursor);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class closeCursor_argsStandardSchemeFactory implements SchemeFactory {
      public closeCursor_argsStandardScheme getScheme() {
        return new closeCursor_argsStandardScheme();
      }
    }

    private static class closeCursor_argsStandardScheme extends StandardScheme<closeCursor_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, closeCursor_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // CONNECTION
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.connection = iprot.readI64();
                struct.setConnectionIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // CURSOR
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.cursor = iprot.readI64();
                struct.setCursorIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, closeCursor_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(CONNECTION_FIELD_DESC);
        oprot.writeI64(struct.connection);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(CURSOR_FIELD_DESC);
        oprot.writeI64(struct.cursor);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class closeCursor_argsTupleSchemeFactory implements SchemeFactory {
      public closeCursor_argsTupleScheme getScheme() {
        return new closeCursor_argsTupleScheme();
      }
    }

    private static class closeCursor_argsTupleScheme extends TupleScheme<closeCursor_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, closeCursor_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetConnection()) {
          optionals.set(0);
        }
        if (struct.isSetCursor()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetConnection()) {
          oprot.writeI64(struct.connection);
        }
        if (struct.isSetCursor()) {
          oprot.writeI64(struct.cursor);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, closeCursor_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.connection = iprot.readI64();
          struct.setConnectionIsSet(true);
        }
        if (incoming.get(1)) {
          struct.cursor = iprot.readI64();
          struct.setCursorIsSet(true);
        }
      }
    }

  }

  public static class closeCursor_result implements org.apache.thrift.TBase<closeCursor_result, closeCursor_result._Fields>, java.io.Serializable, Cloneable, Comparable<closeCursor_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("closeCursor_result");


    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new closeCursor_resultStandardSchemeFactory());
      schemes.put(TupleScheme.class, new closeCursor_resultTupleSchemeFactory());
    }


    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
;

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(closeCursor_result.class, metaDataMap);
    }

    public closeCursor_result() {
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public closeCursor_result(closeCursor_result other) {
    }

    public closeCursor_result deepCopy() {
      return new closeCursor_result(this);
    }

    @Override
    public void clear() {
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof closeCursor_result)
        return this.equals((closeCursor_result)that);
      return false;
    }

    public boolean equals(closeCursor_result that) {
      if (that == null)
        return false;

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      return list.hashCode();
    }

    @Override
    public int compareTo(closeCursor_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
      }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("closeCursor_result(");
      boolean first = true;

      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class closeCursor_resultStandardSchemeFactory implements SchemeFactory {
      public closeCursor_resultStandardScheme getScheme() {
        return new closeCursor_resultStandardScheme();
      }
    }

    private static class closeCursor_resultStandardScheme extends StandardScheme<closeCursor_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, closeCursor_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, closeCursor_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class closeCursor_resultTupleSchemeFactory implements SchemeFactory {
      public closeCursor_resultTupleScheme getScheme() {
        return new closeCursor_resultTupleScheme();
      }
    }

    private static class closeCursor_resultTupleScheme extends TupleScheme<closeCursor_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, closeCursor_result struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, closeCursor_result struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
      }
    }

  }

  public static class closeConnection_args implements org.apache.thrift.TBase<closeConnection_args, closeConnection_args._Fields>, java.io.Serializable, Cloneable, Comparable<closeConnection_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("closeConnection_args");

    private static final org.apache.thrift.protocol.TField CONNECTION_FIELD_DESC = new org.apache.thrift.protocol.TField("connection", org.apache.thrift.protocol.TType.I64, (short)1);

    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    static {
      schemes.put(StandardScheme.class, new closeConnection_argsStandardSchemeFactory());
      schemes.put(TupleScheme.class, new closeConnection_argsTupleSchemeFactory());
    }

    public long connection; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      CONNECTION((short)1, "connection");

      private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

      static {
        for (_Fields field : EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // CONNECTION
            return CONNECTION;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      public static _Fields findByName(String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final String _fieldName;

      _Fields(short thriftId, String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __CONNECTION_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.CONNECTION, new org.apache.thrift.meta_data.FieldMetaData("connection", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      metaDataMap = Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(closeConnection_args.class, metaDataMap);
    }

    public closeConnection_args() {
    }

    public closeConnection_args(
      long connection)
    {
      this();
      this.connection = connection;
      setConnectionIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public closeConnection_args(closeConnection_args other) {
      __isset_bitfield = other.__isset_bitfield;
      this.connection = other.connection;
    }

    public closeConnection_args deepCopy() {
      return new closeConnection_args(this);
    }

    @Override
    public void clear() {
      setConnectionIsSet(false);
      this.connection = 0;
    }

    public long getConnection() {
      return this.connection;
    }

    public closeConnection_args setConnection(long connection) {
      this.connection = connection;
      setConnectionIsSet(true);
      return this;
    }

    public void unsetConnection() {
      __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __CONNECTION_ISSET_ID);
    }

    /** Returns true if field connection is set (has been assigned a value) and false otherwise */
    public boolean isSetConnection() {
      return EncodingUtils.testBit(__isset_bitfield, __CONNECTION_ISSET_ID);
    }

    public void setConnectionIsSet(boolean value) {
      __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __CONNECTION_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, Object value) {
      switch (field) {
      case CONNECTION:
        if (value == null) {
          unsetConnection();
        } else {
          setConnection((Long)value);
        }
        break;

      }
    }

    public Object getFieldValue(_Fields field) {
      switch (field) {
      case CONNECTION:
        return getConnection();

      }
      throw new IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new IllegalArgumentException();
      }

      switch (field) {
      case CONNECTION:
        return isSetConnection();
      }
      throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof closeConnection_args)
        return this.equals((closeConnection_args)that);
      return false;
    }

    public boolean equals(closeConnection_args that) {
      if (that == null)
        return false;

      boolean this_present_connection = true;
      boolean that_present_connection = true;
      if (this_present_connection || that_present_connection) {
        if (!(this_present_connection && that_present_connection))
          return false;
        if (this.connection != that.connection)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      List<Object> list = new ArrayList<Object>();

      boolean present_connection = true;
      list.add(present_connection);
      if (present_connection)
        list.add(connection);

      return list.hashCode();
    }

    @Override
    public int compareTo(closeConnection_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = Boolean.valueOf(isSetConnection()).compareTo(other.isSetConnection());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetConnection()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.connection, other.connection);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
    }

    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder("closeConnection_args(");
      boolean first = true;

      sb.append("connection:");
      sb.append(this.connection);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class closeConnection_argsStandardSchemeFactory implements SchemeFactory {
      public closeConnection_argsStandardScheme getScheme() {
        return new closeConnection_argsStandardScheme();
      }
    }

    private static class closeConnection_argsStandardScheme extends StandardScheme<closeConnection_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, closeConnection_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // CONNECTION
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.connection = iprot.readI64();
                struct.setConnectionIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, closeConnection_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(CONNECTION_FIELD_DESC);
        oprot.writeI64(struct.connection);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class closeConnection_argsTupleSchemeFactory implements SchemeFactory {
      public closeConnection_argsTupleScheme getScheme() {
        return new closeConnection_argsTupleScheme();
      }
    }

    private static class closeConnection_argsTupleScheme extends TupleScheme<closeConnection_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, closeConnection_args struct) throws org.apache.thrift.TException {
        TTupleProtocol oprot = (TTupleProtocol) prot;
        BitSet optionals = new BitSet();
        if (struct.isSetConnection()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetConnection()) {
          oprot.writeI64(struct.connection);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, closeConnection_args struct) throws org.apache.thrift.TException {
        TTupleProtocol iprot = (TTupleProtocol) prot;
        BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.connection = iprot.readI64();
          struct.setConnectionIsSet(true);
        }
      }
    }

  }

}
