/**
 *
	MonsterDB - Collection Based Database with fuzzy matching
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.morphia;


import java.lang.reflect.Field;

import com.entitystream.monster.db.MonsterClient;
import com.entitystream.morphia.annotations.Entity;

/**
 * @author roberthaynes
 *
 */
@SuppressWarnings({"unchecked", "UnusedReturnValue", "unused", "removal"})
public interface Datastore {

    public <T> T save(T entity);

    /**
     * @return
     */
    public MonsterClient getMonsterDB();

    /**
     * @param <T>
     * @param <T>
     * @param class1
     * @return
     */
    public <T> Query createQuery(Class<T> class1);

    /**
     * @param class1
     * @return
     */
    public <T> Query<T> find(Class<T> class1);


    /**
     * @param clazz
     * @return
     */
    public <T> UpdateOperations createUpdateOperations(Class<T> clazz);

    /**
     * @param q
     * @param up
     */
    public void update(Query q, UpdateOperations up);
    
    public <T> T replace(Query q, T entity);

    /**
     * @param q
     * @return
     */
    public <T> T findAndDelete(Query q);

    /**
     * @param class1
     * @param string
     * @param podName
     * @return
     */
    public <T> Query<T> find(Class<T> class1, String string, String podName);

   
    /**
     * @param entity
     */
    public <T> T delete(T entity);

    /**
     * 
     */
    public void ensureIndexes();

}
