/**
 *
	MonsterDB - Collection Based Database with fuzzy matching
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.morphia;

import java.util.ArrayList;
import java.util.List;


import com.entitystream.monster.db.Document;
import com.entitystream.monster.db.MonsterClient;

/**
 * @author roberthaynes
 *
 */
public class Query<T> {

    private Document query=new Document();
    private T type;
    private  MonsterDatastore ds;
    private Document order;
    public Query(T type, MonsterDatastore ds) {
	this.type=type;
	this.ds=ds;
    }
    
    public T getType() {
	return type;
    }
    
    public Field field(String key) {
	Field field = new Field(key, this, query);
	query.append(key, field);
	return field;
    }
    /**
     * @return
     */
    public List<T> asList() {
	return ds.find(this);
    }

    /**
     * @return
     */
    public  T get() {
	if (!ds.find(this).isEmpty())
	   return ds.find(this).iterator().next();
	else return null;
    }

    /**
     * @param string
     * @return
     */
    public Field criteria(String string) {
	
	return new Field(string, this, query);
    }

    /**
     * @param equal
     * @param equal2
     */
    public Query and(Query equal, Query equal2) {
	Query ret = new Query(type, ds);
	List<Document> list = new ArrayList();
	list.add(equal.getQuery());
	list.add(equal2.getQuery());
	ret.query.append("$and", list);
	return ret;
	
    }

    /**
     * @param equal
     * @param equal2
     */
    public Query or(Query equal, Query equal2) {
	Query ret = new Query(type, ds);
	List<Document> list = new ArrayList();
	list.add(equal.getQuery());
	list.add(equal2.getQuery());
	ret.query.append("$or", list);
	return ret;
	
    }
    
    /**
     * @return
     */
    public long count() {
	return ds.find(this).size();
    }

    /**
     * @param document
     * @return
     */
    public Query order(Document document) {
	this.order=document;
	return this;
    }

    /**
     * @param object
     * @return
     */
    public List<T>  asList(FindOptions object) {
	return ds.find(this, object);
    }

    /**
     * @return
     */
    public Document getQuery() {
	
	return query;
    }

    public Document getOrder() {
	return order;
    }

   

    
}
