/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.monster.db;

import com.entitystream.identiza.metadata.IdentizaSettings;
import com.entitystream.monster.db.Collection;
import com.entitystream.monster.db.DBCursor;
import com.entitystream.monster.db.DBServer;
import com.entitystream.monster.db.Document;
import com.entitystream.monster.db.ICollection;
import com.entitystream.monster.external.ExternalData;
import com.entitystream.monster.external.RestAPI;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.text.StrLookup;
import org.apache.commons.lang3.text.StrSubstitutor;

public class AggregateIterable
implements Iterable<Document> {
    private List<Document> pipeline;
    private Document options;
    private DBCursor lazy = null;
    private ICollection collection;
    private List<Document> in;
    private Map<String, PrintWriter> peekers = new HashMap<String, PrintWriter>();
    private boolean allowDiskUse = false;
    private Document context;

    public AggregateIterable(ICollection c, List<Document> pipeline, Document options) {
        this.pipeline = pipeline;
        this.options = options;
        this.collection = c;
    }

    public AggregateIterable(ICollection c, List<Document> in, List<Document> pipeline, Document options) {
        this.pipeline = pipeline;
        this.options = options;
        this.collection = c;
        this.in = in;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Stream aggregateStage(Document pipeStage, Stream<Document> in, Document options) {
        ICollection collection = this.collection;
        Document stageoptions = options;
        if (pipeStage.containsKey("options")) {
            stageoptions = pipeStage.getAsDocument("options");
            pipeStage.remove("options");
        }
        if (stageoptions.containsKey("node")) {
            int nodeid = 0;
            if (stageoptions.get("node") instanceof String && !stageoptions.getString("node").equalsIgnoreCase("default")) {
                nodeid = Integer.parseInt(stageoptions.getString("node"));
            }
            if (stageoptions.get("node") instanceof Number) {
                nodeid = stageoptions.getInteger("node");
            }
            if (nodeid != DBServer.getNodeNum()) {
                collection = this.collection.getReplicaConnections().get(nodeid);
            }
        }
        if (pipeStage.containsKey("$match")) {
            return collection.match(this.processContext(pipeStage.getAsDocument("$match")), in, stageoptions);
        }
        if (pipeStage.containsKey("$find")) {
            return collection.match(this.processContext(pipeStage.getAsDocument("$find")), in, stageoptions);
        }
        if (pipeStage.containsKey("$findTasks")) {
            return collection.findTasks(this.processContext(pipeStage.getAsDocument("$findTasks"))).stream();
        }
        if (pipeStage.containsKey("$analyze")) {
            return collection.analyse(this.processContext(pipeStage.getAsDocument("$analyze")), in, stageoptions);
        }
        if (pipeStage.containsKey("$deltas")) {
            return collection.getDeltas();
        }
        if (in == null) {
            in = collection.findStream(new Document());
        }
        if (pipeStage.containsKey("$limit")) {
            return collection.limit(pipeStage.getLong("$limit"), in, stageoptions);
        }
        if (pipeStage.containsKey("$validate")) {
            return collection.validate(pipeStage.getString("$validate"), in, stageoptions);
        }
        if (pipeStage.containsKey("$task")) {
            return collection.task(this.processContext(pipeStage.getAsDocument("$task")), in, stageoptions);
        }
        if (pipeStage.containsKey("$applyType")) {
            return this.applyType(this.processContext(pipeStage.getAsDocument("$applyType")), this.mappings(in, pipeStage.getAsDocument("$applyType")));
        }
        if (pipeStage.containsKey("$lookup")) {
            return collection.lookup(this.processContext(pipeStage.getAsDocument("$lookup")), in, stageoptions);
        }
        if (pipeStage.containsKey("$saveContext")) {
            if (pipeStage.get("$saveContext") instanceof Map) {
                this.context = pipeStage.getAsDocument("$saveContext");
                return Stream.empty();
            } else {
                Optional<Document> newcontext = in.findFirst();
                if (!newcontext.isPresent()) return Stream.empty();
                this.context = newcontext.get();
            }
            return Stream.empty();
        }
        if (pipeStage.containsKey("$join")) {
            return collection.join(this.processContext(pipeStage.getAsDocument("$join")), in, stageoptions);
        }
        if (pipeStage.containsKey("$minus")) {
            return collection.minus(this.processContext(pipeStage.getAsDocument("$minus")), in, stageoptions);
        }
        if (pipeStage.containsKey("$skip")) {
            return collection.skip(pipeStage.getLong("$skip"), in, stageoptions);
        }
        if (pipeStage.containsKey("$group")) {
            return collection.group(this.processContext(pipeStage.getAsDocument("$group")), in, stageoptions);
        }
        if (pipeStage.containsKey("$out")) {
            return collection.out(pipeStage.getString("$out"), in, stageoptions);
        }
        if (pipeStage.containsKey("$writeRel")) {
            return collection.writeRel(this.processContext(pipeStage.getAsDocument("$writeRel")), in, stageoptions);
        }
        if (pipeStage.containsKey("$sort")) {
            return collection.sort(this.processContext(pipeStage.getAsDocument("$sort")), in, stageoptions);
        }
        if (pipeStage.containsKey("$bucket")) {
            return collection.bucket(this.processContext(pipeStage.getAsDocument("$bucket")), in, stageoptions);
        }
        if (pipeStage.containsKey("$fuzzySearch")) {
            return collection.fuzzySearch(pipeStage.getString("$fuzzySearch"), in, stageoptions);
        }
        if (pipeStage.containsKey("$fuzzy")) {
            return collection.fuzzyMatch(this.processContext(pipeStage.getAsDocument("$fuzzy")), in, stageoptions);
        }
        if (pipeStage.containsKey("$unwind")) {
            return collection.unwind(this.processContext(pipeStage.getAsDocument("$unwind")), in, stageoptions);
        }
        if (pipeStage.containsKey("$filter")) {
            return ICollection.filter(this.processContext(pipeStage.getAsDocument("$filter")), in, stageoptions);
        }
        if (pipeStage.containsKey("$spinOut")) {
            return collection.spinOut(this.processContext(pipeStage.getAsDocument("$spinOut")), in, stageoptions);
        }
        if (pipeStage.containsKey("$getRelated")) {
            return collection.getRelated(this.processContext(pipeStage.getAsDocument("$getRelated")), in, stageoptions);
        }
        if (pipeStage.containsKey("$rematch")) {
            return collection.rematch(this.processContext(pipeStage.getAsDocument("$rematch")), in, stageoptions);
        }
        if (pipeStage.containsKey("$classifierBuild")) {
            return collection.classifierBuild(this.processContext(pipeStage.getAsDocument("$classifierBuild")), in, stageoptions);
        }
        if (pipeStage.containsKey("$classifierPredict")) {
            return collection.classifierPredict(this.processContext(pipeStage.getAsDocument("$classifierPredict")), in, stageoptions);
        }
        if (pipeStage.containsKey("$arrf")) {
            return collection.arrf(this.processContext(pipeStage.getAsDocument("$arrf")), in, stageoptions);
        }
        if (pipeStage.containsKey("$classifierTree")) {
            return collection.classifierTree(this.processContext(pipeStage.getAsDocument("$classifierTree")), in, stageoptions);
        }
        if (pipeStage.containsKey("$coerce")) {
            return collection.coerce(this.processContext(pipeStage.getAsDocument("$coerce")), in, stageoptions);
        }
        if (pipeStage.containsKey("$compare")) {
            return collection.compare(this.processContext(pipeStage.getAsDocument("$compare")), in, stageoptions);
        }
        if (pipeStage.containsKey("$count")) {
            return collection.count(this.processContext(pipeStage.getAsDocument("$count")), in, stageoptions);
        }
        if (pipeStage.containsKey("$first")) {
            return collection.first(this.processContext(pipeStage.getAsDocument("$first")), in, stageoptions);
        }
        if (pipeStage.containsKey("$last")) {
            return collection.last(this.processContext(pipeStage.getAsDocument("$last")), in, stageoptions);
        }
        if (pipeStage.containsKey("$between")) {
            return collection.between(this.processContext(pipeStage.getAsDocument("$between")), in, stageoptions);
        }
        if (pipeStage.containsKey("$cluster")) {
            return collection.cluster(this.processContext(pipeStage.getAsDocument("$cluster")), in, stageoptions);
        }
        if (pipeStage.containsKey("$project")) {
            return collection.project(this.processContext(pipeStage.getAsDocument("$project")), in, stageoptions);
        }
        if (pipeStage.containsKey("$restGet")) {
            return RestAPI.executeGet(this.processContext(pipeStage.getAsDocument("$restGet")), in, stageoptions);
        }
        if (pipeStage.containsKey("$readFile")) {
            return ExternalData.readFile(this.processContext(pipeStage.getAsDocument("$readFile")), in, stageoptions);
        }
        if (pipeStage.containsKey("$writeFile")) {
            return ExternalData.writeFile(this.processContext(pipeStage.getAsDocument("$writeFile")), in, stageoptions);
        }
        if (pipeStage.containsKey("$log")) {
            return in.peek(doc -> System.out.println(doc.toJson()));
        }
        if (pipeStage.containsKey("$peek")) {
            return in.peek(doc -> this.peekTo(pipeStage.getString("$peek"), (Document)doc));
        }
        if (pipeStage.containsKey("$readJDBC")) {
            return ExternalData.readJDBC(this.processContext(pipeStage.getAsDocument("$readJDBC")), in, stageoptions);
        }
        if (pipeStage.containsKey("$writeActiveMQ")) {
            return ExternalData.writeActiveMQ(this.processContext(pipeStage.getAsDocument("$writeActiveMQ")), in, stageoptions);
        }
        if (pipeStage.containsKey("$readActiveMQ")) {
            return ExternalData.readActiveMQ(this.processContext(pipeStage.getAsDocument("$readActiveMQ")), in, stageoptions);
        }
        if (pipeStage.containsKey("$distinct")) {
            return in.collect(Collectors.toSet()).stream();
        }
        if (pipeStage.containsKey("$empty")) {
            return Stream.empty();
        }
        if (pipeStage.containsKey("$new")) {
            return Stream.of(this.processContext(pipeStage.getAsDocument("$new")));
        }
        if (pipeStage.containsKey("$evaluate")) {
            return collection.evaluate(this.processContext(pipeStage.getAsDocument("$evaluate")), in, stageoptions);
        }
        if (pipeStage.containsKey("$union")) {
            void var7_14;
            Document innerStage = this.processContext(pipeStage.getAsDocument("$union"));
            Document document = new Document();
            if (innerStage.containsKey("filter")) {
                Document document2 = innerStage.getAsDocument("filter");
            }
            if (!innerStage.containsKey("with")) return in;
            return Stream.concat(in, collection.getDatabase().getCollection(innerStage.getString("with")).find((Document)var7_14).stream());
        }
        if (pipeStage.containsKey("$switch")) {
            Document innerStage = this.processContext(pipeStage.getAsDocument("$switch"));
            if (innerStage.containsKey("to")) {
                collection = (Collection)collection.getDatabase().getCollection(innerStage.getString("to"));
            }
            if (!innerStage.containsKey("filter")) return collection.find(new Document()).stream();
            if (innerStage.get("filter") instanceof Map) {
                return collection.find(innerStage.getAsDocument("filter")).stream();
            }
            if (!(innerStage.get("filter") instanceof String)) return in;
            return collection.find(Document.parse(innerStage.getString("filter"))).stream();
        }
        if (!pipeStage.containsKey("$split")) return in;
        try {
            void var7_19;
            Object innerPipelineText = pipeStage.get("$split");
            Object var7_15 = null;
            if (innerPipelineText instanceof String) {
                List list = (List)Document.parseListOrDocument((String)innerPipelineText);
                if (list.size() > 0) {
                    ArrayList<Document> olist = new ArrayList<Document>();
                    for (Object e : list) {
                        if (e instanceof String || e instanceof JsonPrimitive) {
                            String[] aggString;
                            String string = e.toString();
                            ArrayList<Document> pipeline = new ArrayList<Document>();
                            for (String argString : aggString = string.split("\\|")) {
                                if ((argString = argString.replaceAll("&pipe;", "|")).indexOf("(") == -1) continue;
                                String command2 = argString.substring(0, argString.indexOf("("));
                                if (command2.startsWith("\"")) {
                                    command2 = command2.substring(1);
                                }
                                if ((argString = argString.substring(argString.indexOf("(") + 1)).indexOf(")") != -1) {
                                    argString = argString.substring(0, argString.lastIndexOf(")"));
                                }
                                if (argString.startsWith("{") && argString.indexOf("\\") > -1) {
                                    argString = argString.replaceAll(Matcher.quoteReplacement("\\"), "");
                                }
                                Object args = null;
                                if (argString.length() != 0 && argString.trim().startsWith("{")) {
                                    Document argso = Document.parse(argString);
                                    pipeline.add(new Document("$" + command2.trim().replaceAll("\\\"|'|\\\\|", ""), argso));
                                    continue;
                                }
                                pipeline.add(new Document("$" + command2.trim().replaceAll("\\\"|'|\\\\|", ""), argString.trim().replaceAll("\\\"|'|\\\\|", "")));
                            }
                            olist.add(new Document("pipeline", pipeline));
                            continue;
                        }
                        if (!(e instanceof Document)) continue;
                        olist.add((Document)e);
                    }
                    ArrayList<Document> arrayList = olist;
                }
            } else {
                List list = pipeStage.getList("$split");
            }
            Map<Document, List<Document>> ret = collection.split((List<Document>)var7_19, in, stageoptions);
            Stream<Document> out = null;
            for (Document path : ret.keySet()) {
                List innerPipeline = path.getList("pipeline");
                List<Document> innerIn = ret.get(path);
                Document innerOptions = path.getAsDocument("options");
                AggregateIterable aggInner = new AggregateIterable(collection, innerIn, innerPipeline, innerOptions);
                if (out == null) {
                    out = aggInner.evaluateStream();
                    continue;
                }
                out = Stream.concat(out, aggInner.evaluateStream());
            }
            return out;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return in;
    }

    private Stream<Document> mappings(Stream<Document> in, Document stage) {
        if (stage.containsKey("mappings")) {
            return this.collection.script(stage.getAsDocument("mappings"), in, stage.getAsDocument("metadata"));
        }
        return in;
    }

    private Stream<Document> applyType(Document definition, Stream<Document> in) {
        return in.map(doc -> doc);
    }

    private Document processContext(Document indoc) {
        if (this.context == null && indoc == null) {
            return indoc;
        }
        StrSubstitutor sub = new StrSubstitutor((StrLookup)new DocumentStrLookup(this.context));
        for (Object key : indoc.keySet()) {
            Object value = indoc.get((String)key);
            if (value instanceof String) {
                if (!((String)value).contains("${")) continue;
                value = sub.replace((String)value);
                indoc.append((String)key, value);
                continue;
            }
            if (value instanceof Map) {
                value = this.processContext(new Document(value));
                indoc.append((String)key, value);
                continue;
            }
            if (!(value instanceof List)) continue;
            ArrayList newList = new ArrayList();
            for (Object listVal : (List)value) {
                if (listVal instanceof String) {
                    if (((String)listVal).contains("${")) {
                        listVal = StrSubstitutor.replace((Object)((String)listVal), (Map)this.context);
                    }
                } else if (listVal instanceof Map) {
                    listVal = this.processContext(new Document(listVal));
                }
                newList.add(listVal);
            }
            indoc.append((String)key, newList);
        }
        return indoc;
    }

    public Document getMetadata() {
        Stream output = null;
        if (this.in != null) {
            output = this.in.stream();
        }
        for (Document pipeStage : this.pipeline) {
            if (pipeStage.containsKey("$out") || pipeStage.containsKey("$writeRel") || pipeStage.containsKey("$writeFile") || pipeStage.containsKey("$writeActiveMQ") || pipeStage.containsKey("$snowFlakeStage") || pipeStage.containsKey("$soap")) continue;
            output = this.aggregateStage(pipeStage, output, this.options);
        }
        Document outputD = new Document();
        if (output != null) {
            output.limit(1000L).forEach(doc -> outputD.putAll((Map)doc));
        }
        return outputD;
    }

    private synchronized Document peekTo(String where, Document doc) {
        boolean first = false;
        where = where.replaceAll("\\\"|'", "");
        try {
            if (!this.peekers.containsKey(where)) {
                File dest = new File(IdentizaSettings.getApplicationRootPath((String)"tmp") + File.separator + where);
                File fpath = new File(dest.getAbsolutePath().substring(0, dest.getAbsolutePath().lastIndexOf(File.separator)));
                if (!fpath.exists()) {
                    fpath.mkdirs();
                }
                this.peekers.put(where, new PrintWriter(dest));
                first = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PrintWriter peek = this.peekers.get(where);
        if (!first) {
            peek.println(",");
        }
        peek.print(doc.toJson());
        peek.flush();
        return doc;
    }

    private DBCursor evaluate() {
        if (this.lazy == null) {
            Stream output = null;
            if (this.in != null) {
                output = this.in.stream();
            }
            for (Document pipeStage : this.pipeline) {
                output = this.aggregateStage(pipeStage, output, this.options);
            }
            if (output != null) {
                this.lazy = new DBCursor(output.collect(Collectors.toList()));
            }
        }
        return this.lazy;
    }

    protected Stream<Document> evaluateStream() {
        Stream output = null;
        if (this.in != null) {
            output = this.in.stream();
        }
        for (Document pipeStage : this.pipeline) {
            output = this.aggregateStage(pipeStage, output, this.options);
        }
        return output;
    }

    @Override
    public Iterator<Document> iterator() {
        return this.evaluate();
    }

    public AggregateIterable allowDiskUse(boolean allow) {
        this.allowDiskUse = allow;
        return this;
    }

    public Document first() {
        return this.evaluate().first();
    }

    private class DocumentStrLookup
    extends StrLookup {
        private Document doc;

        public DocumentStrLookup(Document doc) {
            this.doc = doc;
        }

        public String lookup(String key) {
            return (String)this.doc.getProjection(key);
        }
    }
}

