/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.monster.db;

import com.entitystream.identiza.db.Node;
import com.entitystream.identiza.entity.resolve.match.Indexable;
import com.entitystream.identiza.entity.resolve.match.MatchRecordInterface;
import com.entitystream.identiza.entity.resolve.match.MatchRule;
import com.entitystream.identiza.entity.resolve.match.Matchable;
import com.entitystream.identiza.entity.resolve.metadata.IIndex;
import com.entitystream.identiza.entity.resolve.metadata.IPurpose;
import com.entitystream.identiza.entity.resolve.metadata.IRule;
import com.entitystream.identiza.entity.resolve.metadata.ISchemaMeta;
import com.entitystream.identiza.entity.resolve.metadata.ITable;
import com.entitystream.identiza.entity.resolve.metadata.ITableColumn;
import com.entitystream.identiza.entity.resolve.metadata.Index;
import com.entitystream.identiza.entity.resolve.metadata.Purpose;
import com.entitystream.identiza.entity.resolve.metadata.PurposeColumn;
import com.entitystream.identiza.entity.resolve.metadata.PurposeColumnMap;
import com.entitystream.identiza.entity.resolve.metadata.Rule;
import com.entitystream.identiza.entity.resolve.metadata.SchemaMeta;
import com.entitystream.identiza.entity.resolve.metadata.Table;
import com.entitystream.identiza.entity.resolve.types.Standardized;
import com.entitystream.identiza.metadata.IdentizaSettings;
import com.entitystream.monster.db.AggregateIterable;
import com.entitystream.monster.db.CollectionLocal;
import com.entitystream.monster.db.CollectionRemote;
import com.entitystream.monster.db.Container;
import com.entitystream.monster.db.DBCursor;
import com.entitystream.monster.db.Database;
import com.entitystream.monster.db.Document;
import com.entitystream.monster.db.ICollection;
import com.entitystream.monster.db.MonsterClient;
import com.entitystream.monster.db.ReplicaType;
import com.entitystream.monster.db.Session;
import com.entitystream.monster.db.User;
import com.entitystream.monster.db.ValueComparator;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.infinispan.commons.util.concurrent.ConcurrentHashSet;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.evaluation.Evaluation;
import weka.classifiers.evaluation.NominalPrediction;
import weka.core.Drawable;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.SerializedObject;
import weka.core.converters.JSONLoader;
import weka.core.json.JSONInstances;
import weka.core.json.JSONNode;

public class Collection
extends Indexable
implements Serializable,
ICollection,
Matchable {
    private static final long serialVersionUID = -4586850884783086753L;
    private Map<Integer, ICollection> replicaConnections = new HashMap<Integer, ICollection>();
    private List<String> replicaSet;
    private Database parent;
    private Document definition;
    private CollectionLocal localCollection;
    private boolean explaining = false;
    private transient Logger logger = Logger.getAnonymousLogger();
    private int nodeNum;

    public Collection() {
    }

    public Collection(Database db, Document collDoc, boolean initialised) {
        this.parent = db;
        this.definition = collDoc;
        this.localCollection = new CollectionLocal(this, collDoc, false);
        this.nodeNum = this.parent.getNodeNum();
        this.replicaConnections.put(this.nodeNum, this.localCollection);
        if (collDoc.containsKey("Definition")) {
            this.schDoc = SchemaMeta.createSchemaMeta((Document)collDoc.getAsDocument("Definition"));
            this.initialiseCollection();
        }
        if (this.parent.getReplicaSet() != null) {
            this.replicaSet = this.parent.getReplicaSet();
            if (this.replicaSet.size() > 0) {
                for (String r : this.replicaSet) {
                    try {
                        MonsterClient client = new MonsterClient(r);
                        CollectionRemote collection = new CollectionRemote(client, this.parent.getName(), collDoc, initialised);
                        if (client.isConnected()) {
                            if (!this.replicaConnections.containsKey(client.getNodeNum())) {
                                this.replicaConnections.put(client.getNodeNum(), collection);
                                System.out.println("Node #" + client.getNodeNum() + " is up!");
                                continue;
                            }
                            System.err.println("Node #" + client.getNodeNum() + " is already allocated, you need to change the -n settings on the node");
                            continue;
                        }
                        System.err.println("Node #" + client.getNodeNum() + " is not available, restart it and this node afterwards");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public Collection(Database parent, Document collDoc) {
        this(parent, collDoc, true);
    }

    private ISchemaMeta getSchDoc() {
        if (this.schDoc == null) {
            if (this.definition.containsKey("Definition")) {
                this.schDoc = SchemaMeta.createSchemaMeta((Document)this.definition.getAsDocument("Definition"));
            } else {
                this.schDoc = SchemaMeta.createSchemaMeta((Document)new Document());
                this.definition.append("Definition", this.schDoc.toDocument());
            }
        }
        return this.schDoc;
    }

    @Override
    public void createIndex(Document fields, Document options) {
        for (ICollection collection : this.replicaConnections.values()) {
            collection.createIndex(fields, options);
        }
    }

    @Override
    public void createUniqueIndex(Document fields) {
        for (ICollection collection : this.replicaConnections.values()) {
            collection.createUniqueIndex(fields);
        }
    }

    @Override
    public void createIndex(Document document) {
        for (ICollection collection : this.replicaConnections.values()) {
            collection.createIndex(document);
        }
    }

    @Override
    public DBCursor find(Document filter) {
        ConcurrentHashMap set = new ConcurrentHashMap();
        this.replicaConnections.values().parallelStream().forEach(collection -> collection.find(filter).stream().forEach(doc -> {
            if (doc != null) {
                set.put(doc.getString("_id"), doc);
            }
        }));
        return new DBCursor(set.values());
    }

    @Override
    public Stream<Document> findStream(Document filter) {
        return this.replicaConnections.values().stream().map(collection -> collection.findStream(filter)).flatMap(s -> s);
    }

    @Override
    public DBCursor find() {
        ConcurrentHashMap set = new ConcurrentHashMap();
        this.replicaConnections.values().parallelStream().forEach(collection -> collection.find().stream().forEach(doc -> {
            if (doc != null) {
                set.put(doc.getString("_id"), doc);
            }
        }));
        return new DBCursor(set.values());
    }

    @Override
    public Document save(Document doc) {
        if (!doc.containsKey("_id")) {
            String _id = UUID.randomUUID().toString();
            doc.append("_id", _id);
        }
        Document retdoc = null;
        for (Integer key : this.replicaConnections.keySet()) {
            ICollection collection = this.replicaConnections.get(key);
            retdoc = collection.save(doc);
        }
        return retdoc;
    }

    @Override
    public Document insertOne(Document doc) {
        if (!doc.containsKey("_id")) {
            String _id = UUID.randomUUID().toString();
            doc.append("_id", _id);
        }
        Document retdoc = null;
        for (ICollection collection : this.replicaConnections.values()) {
            retdoc = collection.insertOne(doc);
        }
        return retdoc;
    }

    @Override
    public long count(Document query) {
        if (this.replicaConnections.size() == 1) {
            AtomicLong count = new AtomicLong(0L);
            this.replicaConnections.values().parallelStream().forEach(collection -> count.addAndGet(collection.count(query)));
            return count.get();
        }
        return this.find(query).count();
    }

    @Override
    public Document findOneAndReplace(Document filter, Document replacement, Document options) {
        ConcurrentHashMap cursor = new ConcurrentHashMap();
        if (options.getBoolean("upsert", false)) {
            options.append("_id", UUID.randomUUID().toString());
        }
        this.replicaConnections.values().parallelStream().forEach(collection -> {
            Document _cursor = collection.findOneAndReplace(filter, replacement, options);
            if (_cursor != null) {
                cursor.put(_cursor.getString("_id"), _cursor);
            }
        });
        if (cursor.size() > 0) {
            return (Document)cursor.values().iterator().next();
        }
        return null;
    }

    @Override
    public Document findOneAndReplace(Document filter, Document replacement) {
        ConcurrentHashMap cursor = new ConcurrentHashMap();
        this.replicaConnections.values().parallelStream().forEach(collection -> {
            Document _cursor = collection.findOneAndReplace(filter, replacement);
            if (_cursor != null) {
                cursor.put(_cursor.getString("_id"), _cursor);
            }
        });
        if (cursor.size() > 0) {
            return (Document)cursor.values().iterator().next();
        }
        return null;
    }

    @Override
    public Document findOneAndUpdate(Document filter, Document amendments) {
        ConcurrentHashMap cursor = new ConcurrentHashMap();
        this.replicaConnections.values().parallelStream().forEach(collection -> {
            Document _cursor = collection.findOneAndUpdate(filter, amendments);
            if (_cursor != null) {
                cursor.put(_cursor.getString("_id"), _cursor);
            }
        });
        if (cursor.size() > 0) {
            return (Document)cursor.values().iterator().next();
        }
        return null;
    }

    @Override
    public Document findOneAndUpdate(Document filter, Document amendments, Document options) {
        ConcurrentHashMap cursor = new ConcurrentHashMap();
        if (options.getBoolean("upsert", false)) {
            options.append("_id", UUID.randomUUID().toString());
        }
        this.replicaConnections.values().parallelStream().forEach(collection -> {
            Document _cursor = collection.findOneAndUpdate(filter, amendments, options);
            if (_cursor != null) {
                cursor.put(_cursor.getString("_id"), _cursor);
            }
        });
        if (cursor.size() > 0) {
            return (Document)cursor.values().iterator().next();
        }
        return null;
    }

    @Override
    public Document updateOne(Document filter, Document amendments) {
        ConcurrentHashMap cursor = new ConcurrentHashMap();
        this.replicaConnections.values().parallelStream().forEach(collection -> {
            Document _cursor = collection.updateOne(filter, amendments);
            if (_cursor != null) {
                cursor.put(_cursor.getString("_id"), _cursor);
            }
        });
        if (cursor.size() > 0) {
            return (Document)cursor.values().iterator().next();
        }
        return null;
    }

    @Override
    public Document updateOne(Document filter, Document amendments, Document options) {
        ConcurrentHashMap cursor = new ConcurrentHashMap();
        if (options.getBoolean("upsert", false)) {
            options.append("_id", UUID.randomUUID().toString());
        }
        this.replicaConnections.values().parallelStream().forEach(collection -> {
            Document _cursor = collection.updateOne(filter, amendments, options);
            if (_cursor != null) {
                cursor.put(_cursor.getString("_id"), _cursor);
            }
        });
        if (cursor.size() > 0) {
            return (Document)cursor.values().iterator().next();
        }
        return null;
    }

    @Override
    public int updateMany(Document filter, Document amendments, Document options) {
        AtomicInteger count = new AtomicInteger(0);
        this.replicaConnections.values().parallelStream().forEach(collection -> count.addAndGet(collection.updateMany(filter, amendments, options)));
        return count.get();
    }

    @Override
    public int updateMany(Document filter, Document amendments) {
        AtomicInteger count = new AtomicInteger(0);
        this.replicaConnections.values().parallelStream().forEach(collection -> count.addAndGet(collection.updateMany(filter, amendments, new Document())));
        return count.get();
    }

    @Override
    public int insertMany(List<Document> listRecs) {
        for (Document doc : listRecs) {
            if (doc.containsKey("_id")) continue;
            String _id = UUID.randomUUID().toString();
            doc.append("_id", _id);
        }
        AtomicInteger count = new AtomicInteger(0);
        this.replicaConnections.values().parallelStream().forEach(collection -> count.addAndGet(collection.insertMany(listRecs)));
        return count.get();
    }

    @Override
    public Document findOneAndDelete(Document filter) {
        ConcurrentHashMap cursor = new ConcurrentHashMap();
        this.replicaConnections.values().parallelStream().forEach(collection -> {
            Document _cursor = collection.findOneAndDelete(filter);
            if (_cursor != null) {
                cursor.put(_cursor.getString("_id"), _cursor);
            }
        });
        if (cursor.size() > 0) {
            return (Document)cursor.values().iterator().next();
        }
        return null;
    }

    @Override
    public Document deleteOne(Document filter) {
        ConcurrentHashMap cursor = new ConcurrentHashMap();
        this.replicaConnections.values().parallelStream().forEach(collection -> {
            Document _cursor = collection.findOneAndDelete(filter);
            if (_cursor != null) {
                cursor.put(_cursor.getString("_id"), _cursor);
            }
        });
        if (cursor.size() > 0) {
            return (Document)cursor.values().iterator().next();
        }
        return null;
    }

    @Override
    public int deleteMany(Document filter) {
        AtomicInteger count = new AtomicInteger(0);
        this.replicaConnections.values().parallelStream().forEach(collection -> count.addAndGet(collection.deleteMany(filter)));
        if (filter.keySet().size() == 0 && this.schDoc != null) {
            this.getRelCollection().deleteMany(new Document());
            this.getTaskCollection().deleteMany(new Document());
        }
        return count.get();
    }

    protected String getName() {
        return this.getDefinition().getString("Name");
    }

    protected Collection getRelCollection() {
        return (Collection)this.getDatabase().getRelCollection(this.getDefinition().getString("Name") + "_RELS");
    }

    protected Collection getTaskCollection() {
        return (Collection)this.getDatabase().getTaskCollection(this.getDefinition().getString("Name") + "_TASKS");
    }

    @Override
    public Stream<Document> aggregate(List<Document> pipeline, Document options) {
        return new AggregateIterable(this, pipeline, options).evaluateStream();
    }

    @Override
    public Stream<Document> aggregate(List<Document> pipeline) {
        return new AggregateIterable(this, pipeline, new Document()).evaluateStream();
    }

    @Override
    public Stream<Document> aggregate(List<Document> in, List<Document> pipeline) {
        return new AggregateIterable(this, in, pipeline, new Document()).evaluateStream();
    }

    @Override
    public Document aggregateMetadata(List<Document> in, List<Document> pipeline) {
        return new AggregateIterable(this, in, pipeline, new Document()).getMetadata();
    }

    @Override
    public Document aggregateMetadata(List<Document> pipeline) {
        return new AggregateIterable(this, pipeline, new Document()).getMetadata();
    }

    @Override
    public DBCursor listIndexes() {
        return this.localCollection.listIndexes();
    }

    @Override
    public void rebuildIndex(String name) {
        for (ICollection collection : this.replicaConnections.values()) {
            collection.rebuildIndex(name);
        }
    }

    @Override
    public void dropIndex(String name) {
        for (ICollection collection : this.replicaConnections.values()) {
            collection.dropIndex(name);
        }
    }

    @Override
    public int saveMany(List<Document> records) {
        boolean isreplicated = this.localCollection.getReplicaType() == ReplicaType.Replicated;
        for (Document doc : records) {
            if (doc.containsKey("_id")) continue;
            String _id = UUID.randomUUID().toString();
            doc.append("_id", _id);
        }
        AtomicInteger count = new AtomicInteger(0);
        this.replicaConnections.keySet().parallelStream().forEach(collectionID -> {
            ICollection collection = this.replicaConnections.get(collectionID);
            int inc = collection.saveMany(records);
            if (!isreplicated) {
                count.addAndGet(inc);
            } else {
                count.set(inc);
            }
        });
        return count.get();
    }

    @Override
    public void disconnect() throws Exception {
        for (ICollection collection : this.replicaConnections.values()) {
            collection.disconnect();
        }
    }

    @Override
    public void setExplaining(boolean explain) {
        this.explaining = explain;
        for (ICollection collection : this.replicaConnections.values()) {
            collection.setExplaining(explain);
        }
    }

    @Override
    public DBCursor find(Document filter, Document explain) {
        ConcurrentHashMap set = new ConcurrentHashMap();
        this.replicaConnections.values().parallelStream().forEach(collection -> collection.find(filter, explain).stream().forEach(doc -> {
            if (doc != null) {
                set.put(doc.getString("_id"), doc);
            }
        }));
        return new DBCursor(set.values());
    }

    @Override
    public DBCursor executeCommand(String command2, User user, Session session) {
        long start = System.currentTimeMillis();
        DBCursor ret = Container.executeCommand(this, command2, user, session);
        if (System.currentTimeMillis() - start > 10000L) {
            Object c = command2;
            if (((String)c).length() > 40) {
                c = ((String)c).substring(0, 37) + "...";
            }
            System.out.println("Command (" + (String)c + ") completed in " + (System.currentTimeMillis() - start) + "ms");
        }
        return ret;
    }

    @Override
    public void drop() {
        for (ICollection collection : this.replicaConnections.values()) {
            collection.drop();
        }
    }

    @Override
    public <TResult> Iterable<TResult> distinct(String fieldName, Class<TResult> resultClass) {
        HashSet<TResult> set = new HashSet<TResult>();
        for (ICollection collection : this.replicaConnections.values()) {
            Iterator<TResult> it = collection.distinct(fieldName, resultClass).iterator();
            while (it.hasNext()) {
                set.add(it.next());
            }
        }
        return set;
    }

    @Override
    public <TResult> Iterable<TResult> distinctRelationship(String fieldName, Class<TResult> resultClass) {
        HashSet<TResult> set = new HashSet<TResult>();
        for (ICollection collection : this.replicaConnections.values()) {
            Iterator<TResult> it = collection.distinctRelationship(fieldName, resultClass).iterator();
            while (it.hasNext()) {
                set.add(it.next());
            }
        }
        return set;
    }

    @Override
    public Document getStandardised(String indexName, String id) {
        HashSet set = new HashSet();
        this.replicaConnections.values().parallelStream().forEach(collection -> {
            Document interrim = collection.getStandardised(indexName, id);
            if (interrim != null) {
                set.add(interrim);
            }
        });
        if (set.size() > 0) {
            return (Document)set.iterator().next();
        }
        return null;
    }

    @Override
    public Document getIndexPrefixSubMap(String indexName, String key, boolean b) {
        Document set = new Document();
        this.replicaConnections.values().parallelStream().forEach(collection -> {
            Document interrim = collection.getIndexPrefixSubMap(indexName, key, b);
            set.putAll((Map)interrim);
        });
        return set;
    }

    @Override
    public Document getDocument(Object pointer) {
        ConcurrentHashMap set = new ConcurrentHashMap();
        Optional<Document> ret = this.replicaConnections.values().parallelStream().map(collection -> collection.getDocument(pointer)).filter(f -> f != null).findFirst();
        if (ret.isPresent()) {
            return ret.get();
        }
        return null;
    }

    @Override
    public Document keyCount(String indexName) {
        ConcurrentHashSet mapout = new ConcurrentHashSet();
        if (this.localCollection.getReplicaType() == ReplicaType.Replicated) {
            return this.localCollection.keyCount(indexName);
        }
        this.replicaConnections.values().parallelStream().forEach(collection -> {
            Document o = collection.keyCount(indexName);
            if (o != null) {
                mapout.add((Object)o);
            }
        });
        Document out = new Document();
        for (Document in : mapout) {
            for (Object inKey : in.keySet()) {
                if (out.containsKey(inKey)) {
                    out.put(inKey, (Object)((Long)out.get(inKey) + (Long)in.get(inKey)));
                    continue;
                }
                out.put(inKey, in.get(inKey));
            }
        }
        return out;
    }

    @Override
    public Document conceptCount(String indexName) {
        ConcurrentHashSet mapout = new ConcurrentHashSet();
        if (this.localCollection.getReplicaType() == ReplicaType.Replicated) {
            return this.localCollection.conceptCount(indexName);
        }
        this.replicaConnections.values().parallelStream().forEach(collection -> mapout.add((Object)collection.conceptCount(indexName)));
        Document out = new Document();
        for (Document in : mapout) {
            for (Object inKey : in.keySet()) {
                if (out.containsKey(inKey)) {
                    out.put(inKey, (Object)((Long)out.get(inKey) + (Long)in.get(inKey)));
                    continue;
                }
                out.put(inKey, in.get(inKey));
            }
        }
        return out;
    }

    public ICollection getLocalCollection() {
        return this.localCollection;
    }

    @Override
    public void saveTable(Document def) {
        for (ICollection collection : this.replicaConnections.values()) {
            collection.saveTable(def);
        }
        this.getSchDoc().addTable((ITable)def.toObject(Table.class));
        this.updateDefinition(this.getSchDoc().toDocument());
    }

    @Override
    public void setAutoMatch(boolean a) {
        if (this.schDoc != null) {
            for (ICollection collection : this.replicaConnections.values()) {
                collection.setAutoMatch(a);
                this.schDoc.setAutoMatch(a);
                this.updateDefinition(this.getSchDoc().toDocument());
            }
        }
    }

    @Override
    public void addTrigger(String name) {
        this.definition.append("Trigger", name);
        this.parent.storeCollection(this.getCollectionName(), this);
        for (ICollection collection : this.replicaConnections.values()) {
            collection.addTrigger(name);
        }
    }

    public String getCollectionName() {
        return this.definition.getString("Name");
    }

    @Override
    public void updateDefinition(Document doc) {
        if (doc != null) {
            this.definition.append("Definition", doc);
        } else {
            this.definition.remove("Definition");
        }
        this.parent.storeCollection(this.getCollectionName(), this);
        for (ICollection collection : this.replicaConnections.values()) {
            collection.updateDefinition(doc);
        }
    }

    @Override
    public void updateDelta(Document doc) {
        if (doc != null) {
            this.definition.append("Delta", doc);
        } else {
            this.definition.remove("Delta");
        }
        this.parent.storeCollection(this.getCollectionName(), this);
        for (ICollection collection : this.replicaConnections.values()) {
            collection.updateDelta(doc);
        }
    }

    @Override
    public void deleteTable(String def) {
        this.getSchDoc().deleteTable(def);
        this.updateDefinition(this.getSchDoc().toDocument());
    }

    @Override
    public void saveConceptGroup(Document def) {
        ISchemaMeta schd = this.getSchDoc();
        schd.addPurpose((IPurpose)def.toObject(Purpose.class));
        for (Object o : def.getList("purposeColumns")) {
            List pcms;
            Document d = new Document((Map)o);
            PurposeColumn pc = d.toObject(PurposeColumn.class);
            if (!d.containsKey("purposeColumnMaps")) continue;
            if (d.getList("purposeColumnMaps").size() > 0) {
                pcms = schd.getPurposeColumnMaps(pc);
                for (PurposeColumnMap pcm : pcms) {
                    schd.deletePurposeColumnMap(pcm);
                }
                for (Object oo : d.getList("purposeColumnMaps")) {
                    Document dd = new Document((Map)oo);
                    schd.addPurposeColumnMap(dd.toObject(PurposeColumnMap.class));
                }
                continue;
            }
            pcms = schd.getPurposeColumnMaps(pc);
            for (PurposeColumnMap pcm : pcms) {
                schd.deletePurposeColumnMap(pcm);
            }
        }
        this.updateDefinition(schd.toDocument());
    }

    @Override
    public void deleteConceptGroup(String def) {
        this.getSchDoc().deletePurpose(def);
        this.updateDefinition(this.getSchDoc().toDocument());
    }

    @Override
    public void saveConcept(Document def) {
        this.getSchDoc().addPurposeColumn(def.toObject(PurposeColumn.class));
        this.updateDefinition(this.getSchDoc().toDocument());
    }

    @Override
    public void deleteConcept(String purposeName, String purposeColumn) {
        this.getSchDoc().deletePurposeColumn(purposeName, purposeColumn);
        this.updateDefinition(this.getSchDoc().toDocument());
    }

    @Override
    public void saveConceptMapping(Document def) {
        this.getSchDoc().addPurposeColumnMap(def.toObject(PurposeColumnMap.class));
        this.updateDefinition(this.getSchDoc().toDocument());
    }

    @Override
    public void deleteConceptMapping(Document def) {
        this.getSchDoc().deletePurposeColumnMap(def.toObject(PurposeColumnMap.class));
        this.updateDefinition(this.getSchDoc().toDocument());
    }

    @Override
    public void saveMatchRule(Document def) {
        this.getSchDoc().addRule((IRule)def.toObject(Rule.class));
        this.updateDefinition(this.getSchDoc().toDocument());
    }

    @Override
    public void saveMatchRules(List<Document> defs) {
        ISchemaMeta _schDoc = this.getSchDoc();
        for (IRule rule : _schDoc.getRules(null)) {
            _schDoc.deleteMatchRule((long)rule.getOrder());
        }
        for (Document def : defs) {
            _schDoc.addRule((IRule)def.toObject(Rule.class));
        }
        this.updateDefinition(_schDoc.toDocument());
    }

    @Override
    public void deleteMatchRule(long order) {
        this.getSchDoc().deleteMatchRule(order);
        this.updateDefinition(this.getSchDoc().toDocument());
    }

    @Override
    public void saveFuzzyIndex(Document def) {
        this.getSchDoc().addIndex((IIndex)def.toObject(Index.class));
        this.updateDefinition(this.getSchDoc().toDocument());
    }

    @Override
    public void saveFuzzyIndexes(List<Document> def) {
        ISchemaMeta _sch = this.getSchDoc();
        for (IIndex i : _sch.getIndexes()) {
            _sch.deleteIndex(i.getIndexName());
        }
        for (Document de : def) {
            _sch.addIndex((IIndex)de.toObject(Index.class));
        }
        this.updateDefinition(_sch.toDocument());
    }

    @Override
    public void deleteFuzzyIndex(String name) {
        this.getSchDoc().deleteIndex(name);
        this.updateDefinition(this.getSchDoc().toDocument());
    }

    @Override
    public void removeFuzzy() {
        this.schDoc = null;
        this.updateDefinition(null);
    }

    @Override
    public Document getDefinition() {
        return this.definition;
    }

    @Override
    public Database getDatabase() {
        return this.parent;
    }

    @Override
    public Document getTable(String def) {
        return this.localCollection.getTable(def);
    }

    @Override
    public DBCursor peekQueue() {
        DBCursor queue = null;
        for (ICollection collection : this.replicaConnections.values()) {
            DBCursor ex = collection.peekQueue();
            if (ex == null) continue;
            if (queue == null) {
                ex = queue;
                continue;
            }
            queue.extend(ex);
        }
        return queue;
    }

    @Override
    public String getTrigger() {
        return this.definition.getString("Trigger");
    }

    public Document filter(Document in, User user, String action) {
        Object bestRole = null;
        int bestAction = 0;
        for (Document role : user.pullRoles(null)) {
            if (role == null) continue;
            List privs = role.getList("privileges");
            for (Document priv : privs) {
                Document res = priv.getAsDocument("resource");
                Document actions = priv.getAsDocument("actions");
                if (res == null || actions == null) continue;
                Object raction = actions.get(action);
                if (!res.getString("db").equalsIgnoreCase(this.getDatabase().getName()) || !res.getString("collection").equalsIgnoreCase(this.getCollectionName()) || raction == null || !(raction instanceof Integer ? (Integer)raction > bestAction : ICollection.filter(in, (Document)raction))) continue;
                return in;
            }
        }
        return null;
    }

    @Override
    public Map<Integer, ICollection> getReplicaConnections() {
        return this.replicaConnections;
    }

    @Override
    public Stream<Document> fuzzyMatch(Document fuzzyOptions, Stream<Document> in, Document options) {
        if (in == null) {
            in = this.find().stream();
        }
        if (this.schDoc == null) {
            System.out.println("No fuzzy artifacts found on collection: " + this.definition.getString("Name") + ", bypassing $fuzzy stage");
            return in;
        }
        ArrayList<IIndex> _indexes = new ArrayList<IIndex>();
        if (fuzzyOptions.containsKey("Index")) {
            _indexes.add(this.getSchDoc().getIndex(fuzzyOptions.getString("Index")));
        } else {
            for (IIndex ind : this.getSchDoc().getIndexes()) {
                if (!ind.isMatch()) continue;
                _indexes.add(ind);
                break;
            }
        }
        return ((Stream)in.parallel()).map(doc -> this.fuzzyMatch((Document)doc, (List<IIndex>)_indexes)).filter(c -> c != null);
    }

    @Override
    public Stream<Document> fuzzySearch(String textQuery, Stream<Document> in, Document options) {
        if (this.schDoc == null) {
            System.out.println("No fuzzy artifacts found on collection: " + this.definition.getString("Name") + ", bypassing $fuzzy stage");
            return in;
        }
        return this.findFuzzyStream(textQuery);
    }

    public Stream<Document> findFuzzyStream(String searchText) {
        Stream ret = null;
        for (IIndex matchI : this.getSchDoc().getIndexes()) {
            if (!matchI.isSearch()) continue;
            Stream t = this.searchInternal(searchText, matchI).collect(Collectors.toList()).stream();
            if (ret == null) {
                ret = t;
                continue;
            }
            ret = Stream.concat(ret, t);
        }
        if (ret != null) {
            return ret;
        }
        return Stream.empty();
    }

    private void initialiseCollection() {
        if (this.definition.containsKey("Definition")) {
            super.initialize(this.schDoc);
            for (IIndex index : this.getSchDoc().getIndexes()) {
                if (this.indexCatalogCache.containsKey(index.getIndexName())) continue;
                String matchProcsString = new Gson().toJson((Object)this.getSchDoc().getMatchProcs(index.getIndexName(), "" + index.getInstance(), ""));
                this.indexCatalogCache.put(index.getIndexName(), new Document("Options", new Document("fuzzy", true).append("matchProcs", matchProcsString).append("name", index.getIndexName())));
            }
        }
    }

    protected DBCursor findFuzzy(String searchText, Document explainPlan) {
        DBCursor cursor = new DBCursor();
        for (IIndex matchI : this.getSchDoc().getIndexes()) {
            if (!matchI.isSearch()) continue;
            List<Document> ret = this.searchInternal(searchText, matchI).collect(Collectors.toList());
            cursor.extend(new DBCursor(ret));
        }
        return cursor;
    }

    private Stream<Document> searchInternal(String searchText, IIndex matchI) {
        String indexName = matchI.getIndexName();
        java.util.Collection useKeyList = this.getMatchKeys(searchText, matchI);
        return ((Stream)useKeyList.parallelStream().map(useKeys -> {
            String key = null;
            if (matchI.isSearch() && useKeys.length() > 0) {
                key = "S:" + useKeys;
            }
            if (key != null) {
                Document entry = this.getIndexPrefixSubMap(indexName, key, true);
                return entry.values();
            }
            return new ArrayList();
        }).parallel()).flatMap(c -> c.stream()).distinct().map(pointer -> {
            Document current = this.getDocument(pointer);
            return current;
        }).filter(c -> c != null);
    }

    @Override
    public DBCursor findFuzzy(String textQuery) {
        Document explainPlan = new Document();
        long t = System.currentTimeMillis();
        DBCursor _return = this.findFuzzy(textQuery, explainPlan);
        t = System.currentTimeMillis() - t;
        if (this.explaining) {
            explainPlan.append("Elapsed", t + "ms");
            this.logger.info(explainPlan.toJson());
        }
        return _return;
    }

    @Override
    public DBCursor findFuzzy(Document filter) {
        Document explainPlan = new Document();
        long t = System.currentTimeMillis();
        DBCursor _return = this.findFuzzy(filter, explainPlan, true);
        t = System.currentTimeMillis() - t;
        if (this.explaining) {
            explainPlan.append("Elapsed", t + "ms");
            this.logger.info(explainPlan.toJson());
        }
        return _return;
    }

    protected DBCursor findFuzzy(Document filter, Document explainPlan, boolean isSearch) {
        String tableName = filter.getString("Table", this.definition.getString("Name"));
        DBCursor cursor = new DBCursor();
        if (tableName != null) {
            for (IIndex matchI : this.getSchDoc().getIndexes()) {
                if ((!matchI.isSearch() || !isSearch) && (!matchI.isMatch() || isSearch)) continue;
                DBCursor temp = this.indexSeekFuzzy(matchI, filter, isSearch);
                while (temp.hasNext()) {
                    Document d = temp.next();
                    d.append("_data", this.getDocument(d.getString("_id")));
                    cursor.add(d);
                }
            }
        }
        return cursor;
    }

    private DBCursor indexSeekFuzzy(IIndex matchI, Document filter, boolean isSearch) {
        String tableName = filter.getString("Table", this.definition.getString("Name"));
        if (tableName != null) {
            ITable table = this.getSchDoc().getTable(tableName);
            if (table == null) {
                table = (ITable)this.getSchDoc().getTables().iterator().next();
                System.out.println("Table was not defined, assuming " + table.getTableName());
            }
            if (table == null) {
                return new DBCursor(new Document("Error", "Fuzzy table was not specified and one could not be found"));
            }
            return new DBCursor(this.matchInternal(filter, matchI, isSearch, table).collect(Collectors.toList()));
        }
        return new DBCursor();
    }

    private Stream<Document> matchInternal(Document filter, IIndex matchI, boolean isSearch, ITable table) {
        String indexName = matchI.getIndexName();
        java.util.Collection useKeyList = this.getMatchKeys(filter, table, matchI, false);
        if (!filter.containsKey("standardized")) {
            filter.append("standardized", this.localCollection.standardise(filter));
        }
        if (table != null) {
            filter.putIfAbsent("Table", table.getTableName());
        }
        String _id = filter.getString("_id");
        return ((Stream)useKeyList.parallelStream().map(useKeys -> {
            String key = null;
            if (matchI.isSearch() && useKeys.length() > 0) {
                key = "S:" + useKeys;
            }
            if ((matchI.isMatch() || !matchI.isSearch() && !matchI.isMatch()) && useKeys.length() > 0) {
                key = matchI.getIndexName() + ":" + useKeys;
            }
            if (key != null) {
                Document entry = this.getIndexPrefixSubMap(indexName, key, true);
                return entry.values();
            }
            return new ArrayList();
        }).parallel()).flatMap(c -> c.stream()).distinct().map(pointer -> {
            Document current;
            if (!pointer.equals(_id) && (current = this.getDocument(pointer)) != null) {
                current.append("standardized", this.localCollection.standardise(current));
                current.putIfAbsent("Table", table.getTableName());
                Document result = this.score(filter, current, isSearch);
                if (result != null && (isSearch || !isSearch && result.getDouble("score") > 0.0)) {
                    result.append("_id", current.getString("_id"));
                    return result;
                }
            }
            return null;
        }).filter(c -> c != null);
    }

    @Override
    public Stream<Document> arrf(Document options, Stream<Document> in, Document goptions) {
        Document headerDoc = new Document();
        if (options == null) {
            options = new Document();
        }
        if (options.containsKey("relation")) {
            headerDoc.append("relation", options.getString("relation"));
        } else {
            headerDoc.append("relation", "default");
        }
        String className = "";
        if (options.containsKey("className")) {
            className = options.getString("className");
        }
        Document _definition = new Document();
        if (options.containsKey("definition")) {
            _definition = options.getAsDocument("definition");
        }
        Document definition = _definition;
        ArrayList<Document> attrs = new ArrayList<Document>();
        headerDoc.append("attributes", attrs);
        ArrayList data = new ArrayList();
        Document header = new Document();
        ((Stream)in.sequential()).forEach(doc -> {
            HashMap ret = new HashMap();
            Node.flattenDoc((String)"", (Object)doc, ret, (String)"");
            ret.remove("_id");
            for (Object key : ret.keySet()) {
                Object type;
                Object value = ret.get(key);
                if (header.containsKey(key)) {
                    type = header.get((String)key);
                    if (!(type instanceof HashSet)) continue;
                    ((HashSet)type).add((String)value);
                    header.append((String)key, type);
                    continue;
                }
                if (definition.containsKey(key)) {
                    type = definition.get(key);
                    if (type instanceof String && ((String)type).equalsIgnoreCase("nominal")) {
                        type = new HashSet();
                    }
                    if (type instanceof List) {
                        type = new HashSet();
                        ((AbstractCollection)type).addAll((List)definition.get(key));
                    }
                } else {
                    type = this.typeOf(value);
                }
                if (type instanceof HashSet) {
                    ((HashSet)type).add((String)value);
                }
                header.append((String)key, type);
            }
            ArrayList<Object> values = new ArrayList<Object>();
            for (Object key : header.keySet()) {
                if (ret.containsKey(key)) {
                    values.add(ret.get(key));
                    continue;
                }
                values.add("");
            }
            data.add(new Document("sparse", false).append("weight", 1.0).append("values", values));
        });
        int count = 0;
        for (Object name : header.keySet()) {
            boolean isclass;
            boolean last = header.keySet().size() == ++count;
            boolean bl = isclass = className.equalsIgnoreCase((String)name) || last;
            if (header.get(name) instanceof String) {
                attrs.add(new Document("name", name).append("type", header.get(name)).append("weight", 1.0).append("class", isclass));
                continue;
            }
            attrs.add(new Document("name", name).append("type", "nominal").append("weight", 1.0).append("class", isclass).append("labels", header.get(name)));
        }
        return Collections.singletonList(new Document("header", headerDoc).append("data", data)).stream();
    }

    private Object typeOf(Object value) {
        if (value instanceof Number) {
            return "numeric";
        }
        if (value instanceof String) {
            String temp = (String)value;
            try {
                Double.parseDouble(temp);
                return "numeric";
            }
            catch (Exception exception) {
                HashSet set = new HashSet();
                return set;
            }
        }
        if (value instanceof Date) {
            return "date " + DateFormat.getDateTimeInstance().toString();
        }
        return "string";
    }

    @Override
    public Stream<Document> classifierTree(Document definition, Stream<Document> in, Document options) {
        if (definition.containsKey("modelFilter")) {
            definition = definition.getAsDocument("modelFilter");
            String from = definition.getString("from");
            Document filter = definition.getAsDocument("filter");
            ICollection c2 = this;
            if (!this.getCollectionName().equalsIgnoreCase(from)) {
                c2 = this.getDatabase().getCollection(from);
            }
            definition = c2.find(filter).first();
        }
        try {
            Gson gson = new Gson();
            Class<?> clazz = Class.forName("weka.classifiers." + definition.getString("classifier"));
            SerializedObject classifierSO = (SerializedObject)gson.fromJson(definition.getAsDocument("model").toJson(), SerializedObject.class);
            AbstractClassifier classifier = (AbstractClassifier)classifierSO.getObject();
            if (classifier instanceof Drawable && ((Drawable)classifier).graphType() != 0) {
                if (((Drawable)classifier).graphType() != 2) {
                    return Collections.singletonList(new Document("dotNotation", ((Drawable)classifier).graph())).stream();
                }
                return Collections.singletonList(new Document("xmlBIFF", ((Drawable)classifier).graph())).stream();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public Stream<Object> evaluate(Document evalOptions, Stream<Document> in, Document options) {
        if (in != null) {
            return ((Stream)in.parallel()).map(doc -> Document.translate$(evalOptions, doc));
        }
        return null;
    }

    @Override
    public Stream<Document> sort(final Document object, Stream<Document> in, Document options) {
        return in.sorted(new Comparator(){

            public int compare(Object doc1, Object doc2) {
                int c = 0;
                for (Object key : object.keySet()) {
                    Object v1 = ((Document)doc1).get(key);
                    Object v2 = ((Document)doc2).get(key);
                    int dir = object.getInteger((String)key, 1);
                    c = v1 instanceof String && v2 instanceof String ? v1.toString().compareTo(v2.toString()) * dir : (v1 instanceof Number && v2 instanceof Number ? Double.valueOf(((Number)v1).doubleValue()).compareTo(((Number)v2).doubleValue()) * dir : (v1 instanceof Date && v2 instanceof Date ? ((Date)v1).compareTo((Date)v2) * dir : (v1 instanceof Boolean && v2 instanceof Boolean ? ((Boolean)v1).compareTo((Boolean)v2) * dir : dir)));
                    if (c == 0) continue;
                    return c;
                }
                return c;
            }
        }).collect(Collectors.toList()).stream();
    }

    @Override
    public Stream compare(Document asDocument, Stream<Document> in, Document options) {
        if (in != null) {
            if (options == null) {
                options = new Document();
            }
            HashMap<CallSite, Document> results = new HashMap<CallSite, Document>();
            List docs = in.collect(Collectors.toList());
            for (Document prep : docs) {
                prep.append("standardized", this.localCollection.standardise(prep));
            }
            for (Document filter : docs) {
                for (Document current : docs) {
                    if (results.containsKey(current.getString("_id") + "/" + filter.getString("_id"))) continue;
                    Document result = this.score(filter, current, false);
                    result.append("from", filter.getString("_id"));
                    result.append("to", current.getString("_id"));
                    if (!(result.getDouble("score") > 0.0)) continue;
                    results.put((CallSite)((Object)(filter.getString("_id") + "/" + current.getString("_id"))), result);
                }
            }
            return results.values().parallelStream();
        }
        return null;
    }

    @Override
    public Stream<Document> classifierBuild(Document definition, Stream<Document> in, Document options) {
        ArrayList<Document> result = new ArrayList<Document>();
        Gson gson = new Gson();
        try {
            JSONLoader loader = this.streamToLoader(in, null);
            HashMap<String, AbstractClassifier> classifiers = new HashMap<String, AbstractClassifier>();
            for (Object modelNameo : definition.keySet()) {
                String modelName = (String)modelNameo;
                Class<?> clazz = Class.forName("weka.classifiers." + modelName);
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                AbstractClassifier classifier = (AbstractClassifier)constructor.newInstance(new Object[0]);
                classifiers.put(modelName, classifier);
            }
            Document header = null;
            for (String classifiern : classifiers.keySet()) {
                Classifier classifier = (Classifier)classifiers.get(classifiern);
                int classIndex = loader.getStructure().numAttributes() - 1;
                int numFolds = 10;
                if (definition.getAsDocument(classifiern) != null) {
                    if (definition.getAsDocument(classifiern).containsKey("numFolds")) {
                        numFolds = definition.getAsDocument(classifiern).getInteger("numFolds");
                    }
                    String defClass = definition.getAsDocument(classifiern).getString("className");
                    for (int a = 0; a < loader.getStructure().numAttributes(); ++a) {
                        if (!loader.getStructure().attribute(a).name().equalsIgnoreCase(defClass)) continue;
                        classIndex = a;
                    }
                    loader.getStructure().setClassIndex(classIndex);
                    JSONNode json = JSONInstances.toJSON((Instances)loader.getStructure());
                    StringBuffer buffer = new StringBuffer();
                    json.toString(buffer);
                    header = Document.parse(buffer.toString());
                }
                Instances[] train = new Instances[numFolds];
                Instances[] test = new Instances[numFolds];
                for (int numFold = 0; numFold < numFolds; ++numFold) {
                    train[numFold] = loader.getDataSet().trainCV(numFolds, numFold);
                    test[numFold] = loader.getDataSet().testCV(numFolds, numFold);
                    train[numFold].setClassIndex(classIndex);
                    test[numFold].setClassIndex(classIndex);
                }
                FastVector predictions = new FastVector();
                for (int i = 0; i < numFolds; ++i) {
                    Evaluation evaluation = new Evaluation(train[i]);
                    classifier.buildClassifier(train[i]);
                    evaluation.evaluateModel(classifier, test[i], new Object[0]);
                    predictions.appendElements((java.util.Collection)evaluation.predictions());
                }
                double accuracy = this.calculateAccuracy(predictions);
                Document predResult = null;
                predResult = definition.getAsDocument(classifiern) != null ? definition.getAsDocument(classifiern) : new Document();
                predResult.append("classifier", classifiern).append("accuracy", accuracy).append("createDate", new Date()).append("header", header.getAsDocument("header")).append("model", new Document(gson.toJson((Object)new SerializedObject((Object)classifier))));
                result.add(predResult);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result.stream();
    }

    private double calculateAccuracy(FastVector predictions) {
        double correct = 0.0;
        for (int i = 0; i < predictions.size(); ++i) {
            NominalPrediction np = (NominalPrediction)predictions.elementAt(i);
            if (np.predicted() != np.actual()) continue;
            correct += 1.0;
        }
        return 100.0 * correct / (double)predictions.size();
    }

    private JSONLoader streamToLoader(Stream<Document> in, Document header) throws IOException {
        JSONLoader loader = new JSONLoader();
        Gson gson = new Gson();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        AtomicBoolean first = new AtomicBoolean(true);
        ((Stream)in.sequential()).forEach(doc -> {
            try {
                if (header != null) {
                    doc.append("header", header);
                }
                byte[] bytes = doc.toJson().getBytes();
                if (!first.getAndSet(false)) {
                    bos.write(new byte[]{44});
                }
                bos.write(bytes);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        loader.setSource((InputStream)bis);
        loader.getStructure();
        return loader;
    }

    @Override
    public Stream<Document> classifierPredict(Document definition, Stream<Document> in, Document options) {
        if (definition.containsKey("modelFilter")) {
            definition = definition.getAsDocument("modelFilter");
            String from = definition.getString("from");
            Document filter = definition.getAsDocument("filter");
            ICollection c2 = this.getDatabase().getCollection(from);
            definition = c2.find(filter).first();
        }
        try {
            Gson gson = new Gson();
            Class<?> clazz = Class.forName("weka.classifiers." + definition.getString("classifier"));
            SerializedObject classifierSO = (SerializedObject)gson.fromJson(definition.getAsDocument("model").toJson(), SerializedObject.class);
            AbstractClassifier classifier = (AbstractClassifier)classifierSO.getObject();
            JSONLoader loader = this.streamToLoader(in, definition.getAsDocument("header"));
            String defClass = definition.getString("className");
            int classIndex = -1;
            for (int a = 0; a < loader.getStructure().numAttributes(); ++a) {
                if (!loader.getStructure().attribute(a).name().equalsIgnoreCase(defClass)) continue;
                classIndex = a;
            }
            loader.getStructure().setClassIndex(classIndex);
            Instances dataSet = loader.getDataSet();
            dataSet.setClassIndex(classIndex);
            return dataSet.parallelStream().map(inst -> {
                try {
                    double result = classifier.classifyInstance(inst);
                    Document doc = Collection.toJSON(inst);
                    String prediction = inst.classAttribute().value((int)result);
                    doc.append(defClass, prediction);
                    return doc;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected static Document toJSON(Instance inst) {
        Document result = new Document();
        for (int a = 0; a < inst.numAttributes(); ++a) {
            if (!inst.attribute(a).isNumeric()) {
                result.append(inst.attribute(a).name(), inst.stringValue(a));
                continue;
            }
            result.append(inst.attribute(a).name(), inst.value(a));
        }
        return result;
    }

    @Override
    public Document fuzzyMatch(Document doc, List<IIndex> indexes) {
        String tableName = doc.getString("Table", this.definition.getString("Name"));
        if (tableName == null || indexes == null || indexes.size() == 0) {
            return null;
        }
        Document r = new Document();
        r.append("_id", doc.getString("_id"));
        if (tableName != null) {
            ITable table = this.getSchDoc().getTable(tableName);
            ArrayList matches = new ArrayList();
            for (IIndex index : indexes) {
                List m = this.matchInternal(doc, index, false, table).collect(Collectors.toList());
                if (matches == null) continue;
                matches.addAll(m);
            }
            if (matches.size() > 0) {
                r.append("Matches", matches);
                r.append("Count", matches.size());
            } else {
                return null;
            }
        }
        return r;
    }

    @Override
    public DBCursor findRelationships(Document filter) {
        ConcurrentHashMap set = new ConcurrentHashMap();
        this.replicaConnections.values().parallelStream().forEach(collection -> collection.findRelationships(filter).stream().forEach(doc -> {
            if (doc != null) {
                set.put(doc.getString("_id"), doc);
            }
        }));
        return new DBCursor(set.values());
    }

    @Override
    public DBCursor findTasks(Document filter) {
        ConcurrentHashMap set = new ConcurrentHashMap();
        this.replicaConnections.values().parallelStream().forEach(collection -> collection.findTasks(filter).stream().forEach(doc -> {
            if (doc != null) {
                set.put(doc.getString("_id"), doc);
            }
        }));
        return new DBCursor(set.values());
    }

    @Override
    public Document saveRelationship(Document relationship) {
        if (!relationship.containsKey("_id")) {
            String _id = UUID.randomUUID().toString();
            relationship.append("_id", _id);
        }
        Document retdoc = null;
        for (Integer key : this.replicaConnections.keySet()) {
            ICollection collection = this.replicaConnections.get(key);
            retdoc = collection.saveRelationship(relationship);
        }
        return retdoc;
    }

    @Override
    public Document saveTask(Document task) {
        if (!task.containsKey("_id")) {
            String _id = UUID.randomUUID().toString();
            task.append("_id", _id);
        }
        Document retdoc = null;
        for (Integer key : this.replicaConnections.keySet()) {
            ICollection collection = this.replicaConnections.get(key);
            retdoc = collection.saveTask(task);
        }
        return retdoc;
    }

    @Override
    public void resolveTask(Document taskData) {
        this.replicaConnections.values().parallelStream().forEach(collection -> collection.resolveTask(taskData));
    }

    @Override
    public DBCursor aggregateTasks(ArrayList<Document> andlist) {
        ConcurrentHashMap set = new ConcurrentHashMap();
        this.replicaConnections.values().parallelStream().forEach(collection -> collection.aggregateTasks(andlist).stream().forEach(doc -> {
            if (doc != null) {
                set.put(doc.getString("_id"), doc);
            }
        }));
        return new DBCursor(set.values());
    }

    @Override
    public Document updateTask(String id, Document doc) {
        Document retdoc = null;
        for (Integer key : this.replicaConnections.keySet()) {
            ICollection collection = this.replicaConnections.get(key);
            Document _retdoc = collection.updateTask(id, doc);
            if (_retdoc == null) continue;
            retdoc = _retdoc;
            break;
        }
        return retdoc;
    }

    @Override
    public Document updateRelationship(Document document, Document setUpdate, Document options) {
        Document retdoc = null;
        for (Integer key : this.replicaConnections.keySet()) {
            ICollection collection = this.replicaConnections.get(key);
            Document _retdoc = collection.updateRelationship(document, setUpdate, options);
            if (_retdoc == null) continue;
            retdoc = _retdoc;
            break;
        }
        return retdoc;
    }

    @Override
    public void deleteTasks(Document document) {
        this.replicaConnections.values().parallelStream().forEach(collection -> collection.deleteTasks(document));
    }

    @Override
    public void deleteRelationships(Document document) {
        this.replicaConnections.values().parallelStream().forEach(collection -> collection.deleteRelationships(document));
    }

    @Override
    public Stream<Document> limit(long limit, Stream<Document> in, Document options) {
        return in.limit(limit);
    }

    @Override
    public Stream<Document> lookup(Document object, Stream<Document> in, Document options) {
        String from = object.getString("from");
        String localField = object.getString("localField");
        String foreignField = object.getString("foreignField");
        String as = object.getString("as");
        return ((Stream)in.parallel()).map(doc -> {
            Object value1 = doc.get(localField);
            List<Object> values = value1 instanceof List ? (List<Object>)value1 : Collections.singletonList(value1);
            ArrayList l = new ArrayList();
            for (Object value : values) {
                value = Document.translate$(value, doc);
                Document filter = new Document(foreignField, value);
                ICollection c2 = this.parent.getCollection(from);
                if (c2 == null) continue;
                DBCursor cur = c2.find(filter);
                l.addAll(cur.stream().collect(Collectors.toList()));
            }
            if (l.size() > 0) {
                doc.append(as, l);
            }
            return doc;
        });
    }

    @Override
    public Stream<Document> join(Document object, Stream<Document> in, Document options) {
        String to = object.getString("with");
        Object joinon = object.get("on");
        String as = object.getString("into");
        return ((Stream)in.parallel()).map(doc -> {
            ICollection c2;
            Object filter;
            ArrayList l = new ArrayList();
            if (joinon instanceof Map && (filter = Document.translateJoin$(object.getAsDocument("on"), doc)) != null && (c2 = this.parent.getCollection(to)) != null) {
                DBCursor cur = c2.find(new Document(filter));
                l.addAll(cur.stream().collect(Collectors.toList()));
            }
            if (l.size() > 0) {
                doc.append(as, l);
                return doc;
            }
            return null;
        }).filter(doc -> doc != null);
    }

    @Override
    public Stream<Document> minus(Document object, Stream<Document> in, Document options) {
        String from = object.getString("from");
        Document fields = object.getAsDocument("fields");
        return ((Stream)in.parallel()).filter(doc -> {
            Document filter = new Document();
            for (Object localField : fields.keySet()) {
                Object value = doc.get(localField);
                String foreignName = (String)localField;
                if (fields.get(foreignName) instanceof String) {
                    foreignName = fields.getString(foreignName);
                }
                filter.append(foreignName, value);
            }
            ICollection c2 = this.parent.getCollection(from);
            boolean found = false;
            if (c2 != null) {
                found = c2.find(filter).count() > 0;
            }
            return !found;
        });
    }

    @Override
    public Stream<Document> skip(long skip, Stream<Document> in, Document options) {
        return in.skip(skip);
    }

    @Override
    public Stream<Document> group(Document object, Stream<Document> in, Document options) {
        Object _id = object.get("_id");
        LinkedHashMap out = new LinkedHashMap();
        ((Stream)in.sequential()).forEach(doc -> {
            try {
                for (Object newfield : object.keySet()) {
                    Document currKeyDoc;
                    String fieldName = (String)newfield;
                    if (fieldName.equalsIgnoreCase("_id")) continue;
                    Document aggFn = object.getAsDocument(fieldName);
                    Object key = Document.translate$(_id, doc);
                    if (key == null) {
                        key = "ALL";
                    }
                    if ((currKeyDoc = (Document)out.get(key.hashCode())) == null) {
                        currKeyDoc = new Document();
                        if (!key.equals("ALL")) {
                            currKeyDoc.append("_id", key);
                        }
                    }
                    Document currentValue = currKeyDoc.getAsDocument(fieldName);
                    Object additive = Document.translate$(aggFn, doc);
                    currentValue = (Document)Document.translateFn$((String)aggFn.keySet().iterator().next() + "Map", additive, currentValue);
                    currKeyDoc.append(fieldName, currentValue);
                    out.put(key.hashCode(), currKeyDoc);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        return out.keySet().stream().map(key -> {
            Document doc = (Document)out.get(key);
            for (Object newfield : object.keySet()) {
                String fieldName = (String)newfield;
                if (fieldName.equalsIgnoreCase("_id")) continue;
                Document aggFn = object.getAsDocument(fieldName);
                Document agg = doc.getAsDocument(fieldName);
                doc.append(fieldName, Document.translateFn$((String)aggFn.keySet().iterator().next() + "Finalize", aggFn, agg));
            }
            return doc;
        });
    }

    @Override
    public Stream bucket(Document bucketDef, Stream<Document> in, Document options) {
        TreeMap<Double, CollectionLocal.BucketRange> output = new TreeMap<Double, CollectionLocal.BucketRange>();
        Double last = null;
        for (Number boundary : (List)bucketDef.get("boundaries")) {
            if (last != null) {
                output.put(last, new CollectionLocal.BucketRange(boundary.doubleValue(), new Document("_id", boundary.doubleValue())));
            }
            last = boundary.doubleValue();
        }
        Document defaultDoc = new Document("_id", bucketDef.get("default"));
        Document outputDef = bucketDef.getAsDocument("output");
        Object groupByField = bucketDef.get("groupBy");
        ((Stream)in.sequential()).forEach(doc -> {
            Double groupByValue = ((Number)Document.translate$(groupByField, doc)).doubleValue();
            Map.Entry entry = output.floorEntry(groupByValue);
            Document doc2use = defaultDoc;
            if (entry != null && groupByValue < ((CollectionLocal.BucketRange)entry.getValue()).upper) {
                doc2use = ((CollectionLocal.BucketRange)entry.getValue()).document;
            }
            for (Object outkey : outputDef.keySet()) {
                Object outvaluedef = outputDef.get(outkey);
                this.bucket_merge(outvaluedef, (Document)doc, doc2use, (String)outkey);
                if (entry == null) continue;
                ((CollectionLocal.BucketRange)entry.getValue()).document = doc2use;
                output.put(entry.getKey(), (CollectionLocal.BucketRange)entry.getValue());
            }
        });
        return output.values().stream().map(br -> {
            for (Object outkey : outputDef.keySet()) {
                Object outvaluedef = outputDef.get(outkey);
                this.bucket_finalize(outvaluedef, br.document, (String)outkey);
            }
            return br.document;
        });
    }

    public void bucket_merge(Object definition, Document evaluatedDoc, Document bucketDoc, String bucketKey) {
        Object additive = Document.translate$(definition, evaluatedDoc);
        Object out = null;
        if (definition instanceof Document) {
            for (Object inner : ((Document)definition).keySet()) {
                out = Document.translateFn$((String)inner + "Map", additive, bucketDoc.getAsDocument(bucketKey));
            }
        } else {
            out = Document.translateFn$((String)definition + "Map", additive, bucketDoc.getAsDocument(bucketKey));
        }
        bucketDoc.append(bucketKey, out);
    }

    public void bucket_finalize(Object definition, Document bucketDoc, String bucketKey) {
        Object out = null;
        if (definition instanceof Document) {
            for (Object inner : ((Document)definition).keySet()) {
                out = Document.translateFn$((String)inner + "Finalize", null, bucketDoc.getAsDocument(bucketKey));
            }
        } else {
            out = Document.translateFn$((String)definition + "Finalize", null, bucketDoc.getAsDocument(bucketKey));
        }
        bucketDoc.append(bucketKey, out);
    }

    @Override
    public Stream<Object> unwind(Document unwindOptions, Stream<Document> in, Document options) {
        if (in != null) {
            return ((Stream)in.parallel()).map(doc -> this.unwind((Document)doc, unwindOptions)).flatMap(c -> c.stream());
        }
        return null;
    }

    private List<Document> unwind(Document doc, Object unwindOptions) {
        String path = "";
        if (unwindOptions instanceof Document) {
            path = ((Document)unwindOptions).getString("path");
        } else if (unwindOptions instanceof String) {
            path = (String)unwindOptions;
        }
        String includeArrayIndex = ((Document)unwindOptions).getString("includeArrayIndex");
        boolean preserveNullAndEmptyArrays = ((Document)unwindOptions).getBoolean("preserveNullAndEmptyArrays", false);
        ArrayList<Document> out = new ArrayList<Document>();
        if (path != null) {
            Object proj = doc.getProjection(path);
            if (proj != null && proj instanceof List) {
                int count = 0;
                for (Object item : (List)proj) {
                    Document newDoc = new Document(doc);
                    newDoc.setProjection(path, item);
                    if (includeArrayIndex != null) {
                        newDoc.append(includeArrayIndex, count);
                    }
                    out.add(newDoc);
                    ++count;
                }
                if (count == 0 && preserveNullAndEmptyArrays) {
                    out.add(doc);
                }
            } else if (preserveNullAndEmptyArrays) {
                out.add(doc);
            }
        }
        return out;
    }

    @Override
    public Stream<Document> count(Document asDocument, Stream<Document> in, Document options) {
        return Collections.singletonList(new Document("count", in.count())).stream();
    }

    @Override
    public Stream<Document> first(Document asDocument, Stream<Document> in, Document options) {
        Optional<Document> o = in.findFirst();
        if (o.isPresent()) {
            return Collections.singletonList(o.get()).stream();
        }
        return null;
    }

    @Override
    public Stream<Document> last(Document asDocument, Stream<Document> in, Document options) {
        Document o = in.reduce((first, second) -> second).orElse(null);
        if (o != null) {
            return Collections.singletonList(o).stream();
        }
        return null;
    }

    @Override
    public Stream<Document> between(Document asDocument, Stream<Document> in, Document options) {
        if (options != null) {
            long start = 0L;
            if (options.containsKey("start")) {
                start = options.getLong("start");
            }
            long end = Long.MAX_VALUE;
            if (options.containsKey("end")) {
                end = options.getLong("end");
            }
            return in.skip(start).limit(end - start + 1L);
        }
        return in;
    }

    public Document score(Document base, Document comparitor, boolean forSearch) {
        try {
            MatchRecordInterface mr = this.calculateScore(base, comparitor, forSearch);
            return mr.toDocument();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document validate(ITable table, Document doc) {
        boolean failed = false;
        boolean warning = false;
        StringBuilder error = new StringBuilder();
        try {
            for (ITableColumn col : table.getColumns()) {
                Object v;
                Object vo = v = doc.getProjection(col.getColName());
                String lu = col.getDisplayType();
                String su = col.getSpecialUse();
                boolean validationMandatory = col.isSensitivityField();
                if (col.isNotNull() && (v == null || v.toString().isEmpty())) {
                    failed = true;
                    error.append(col.getColName() + " is Mandatory and is blank or empty");
                } else if (lu != null && lu.length() != 0) {
                    Serializable vn;
                    if (lu.equals("string")) {
                        if (v != null && v instanceof String) {
                            if (su != null && su.length() > 0 && v != null && !((String)v).matches(su)) {
                                if (validationMandatory) {
                                    failed = true;
                                    error.append("[Error] " + col.getColName() + " does not match required text pattern, ");
                                } else {
                                    warning = true;
                                    error.append("[Warning] " + col.getColName() + " does not match required text pattern, ");
                                }
                            }
                        } else if (v != null) {
                            failed = true;
                            error.append("[Error] " + col.getColName() + " is not a text value, ");
                        } else if (v == null) {
                            if (validationMandatory) {
                                failed = true;
                                error.append("[Error] " + col.getColName() + " is blank, ");
                            } else {
                                warning = true;
                                error.append("[Warning] " + col.getColName() + " is blank, ");
                            }
                        }
                    } else if (lu.equals("List")) {
                        if (!(v instanceof List)) {
                            failed = true;
                            error.append("[Error] " + col.getColName() + " is not a list, ");
                        }
                    } else if (lu.equals("Structure")) {
                        if (!(v instanceof Map)) {
                            failed = true;
                            error.append("[Error] " + col.getColName() + " is not a structure, ");
                        }
                    } else if (lu.equals("date")) {
                        vn = this.tryParseDate(table.getDateFormat(), v);
                        if (v != null && vn == null) {
                            failed = true;
                            error.append("[Error] " + col.getColName() + " is not a date, ");
                        }
                        v = vn;
                    } else if (lu.equals("number")) {
                        vn = this.tryParseNumber(v);
                        if (v != null && vn == null) {
                            failed = true;
                            error.append("[Error] " + col.getColName() + " is not a number, ");
                        }
                        if ((v = vn) != null && su != null && su.length() > 0) {
                            Number n2;
                            Number n1;
                            String[] parts = new String[]{};
                            if (su.contains(">")) {
                                parts = su.split(">");
                                if (parts.length == 1) {
                                    n1 = this.tryParseNumber(parts[0]);
                                    if (!(((Number)v).doubleValue() < n1.doubleValue())) {
                                        if (validationMandatory) {
                                            failed = true;
                                            error.append("[Error] " + col.getColName() + " is too small, ");
                                        } else {
                                            warning = true;
                                            error.append("[Warning] " + col.getColName() + " is too small, ");
                                        }
                                    }
                                } else if (parts.length == 2) {
                                    n1 = this.tryParseNumber(parts[0]);
                                    n2 = this.tryParseNumber(parts[1]);
                                    if (!(((Number)v).doubleValue() > n1.doubleValue())) {
                                        if (validationMandatory) {
                                            failed = true;
                                            error.append("[Error] " + col.getColName() + " is out of range, too small ");
                                        } else {
                                            warning = true;
                                            error.append("[Warning] " + col.getColName() + " is out of range, too small, ");
                                        }
                                    }
                                    if (!(((Number)v).doubleValue() < n2.doubleValue())) {
                                        if (validationMandatory) {
                                            failed = true;
                                            error.append("[Error] " + col.getColName() + " is out of range, too large, ");
                                        } else {
                                            warning = true;
                                            error.append("[Warning] " + col.getColName() + " is out of range, too large, ");
                                        }
                                    }
                                }
                            } else if (su.contains("<")) {
                                parts = su.split("<");
                                if (parts.length == 1) {
                                    n1 = this.tryParseNumber(parts[0]);
                                    if (!(((Number)v).doubleValue() > n1.doubleValue())) {
                                        if (validationMandatory) {
                                            failed = true;
                                            error.append("[Error] " + col.getColName() + " is too large, ");
                                        } else {
                                            warning = true;
                                            error.append("[Warning] " + col.getColName() + " is too large, ");
                                        }
                                    }
                                } else if (parts.length == 2) {
                                    n1 = this.tryParseNumber(parts[0]);
                                    n2 = this.tryParseNumber(parts[1]);
                                    if (((Number)v).doubleValue() > n1.doubleValue() && ((Number)v).doubleValue() < n2.doubleValue()) {
                                        if (validationMandatory) {
                                            failed = true;
                                            error.append("[Error] " + col.getColName() + " is not out of range, ");
                                        } else {
                                            warning = true;
                                            error.append("[Warning] " + col.getColName() + " is not in out of range, ");
                                        }
                                    }
                                }
                            }
                        }
                    } else if (v != null && lu.equals("boolean") && !this.tryParseBoolean(v).booleanValue()) {
                        vn = this.tryParseBoolean(v);
                        if (v != null && vn == null) {
                            failed = true;
                            error.append("[Error] " + col.getColName() + " is not a boolean, ");
                        }
                        v = vn;
                    } else if (v != null && lu.equals("image")) {
                        try {
                            new URL((String)v);
                        }
                        catch (Exception e) {
                            failed = true;
                            error.append("[Error] " + col.getColName() + " is not a url, ");
                        }
                    } else if (lu.startsWith("table:")) {
                        if (v != null) {
                            String[] bits = lu.substring(6).split("!");
                            if (bits.length == 2) {
                                String k;
                                DBCursor c;
                                ICollection icoll = this;
                                if (!bits[0].trim().equalsIgnoreCase("undefined") && !bits[0].trim().equalsIgnoreCase(this.getCollectionName())) {
                                    icoll = this.parent.getCollection(bits[0].trim());
                                }
                                if ((c = icoll.find(new Document(k = this.getSchDoc().getTable(bits[1].trim()).getKeyField(), v))).count() == 0) {
                                    failed = true;
                                    error.append("[Error] " + col.getColName() + " is not a valid " + bits[1] + ", ");
                                }
                            }
                        } else if (validationMandatory) {
                            failed = true;
                            error.append("[Error] " + col.getColName() + " is a blank link, ");
                        } else {
                            error.append("[Warning] " + col.getColName() + " is a blank link, ");
                            warning = true;
                        }
                    }
                }
                doc.setProjection(col.getColName(), v);
            }
        }
        catch (Exception e) {
            failed = true;
            error.append(e.toString());
        }
        finally {
            if (error.length() > 0) {
                doc.append("Error", error.toString());
            } else {
                doc.append("Error", "");
            }
            if (failed) {
                doc.append("Status", "Invalid");
            } else if (warning) {
                doc.append("Status", "Warning");
            } else {
                doc.append("Status", "Valid");
            }
            doc.append("Table", table.getTableName());
        }
        return doc;
    }

    private Date tryParseDate(String dateformat, Object in) {
        try {
            if (in instanceof String) {
                if (dateformat == null) {
                    try {
                        return new Date(Date.parse((String)in));
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
                if (dateformat != null) {
                    SimpleDateFormat df = new SimpleDateFormat(dateformat);
                    return df.parse((String)in);
                }
            } else {
                if (in instanceof Long) {
                    return Date.from(Instant.ofEpochMilli((Long)in));
                }
                if (in instanceof Date) {
                    return (Date)in;
                }
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    private Number tryParseNumber(Object in) {
        if (in instanceof String) {
            try {
                return Double.parseDouble((String)in);
            }
            catch (Exception exception) {
                try {
                    return Float.valueOf(Float.parseFloat((String)in));
                }
                catch (Exception exception2) {
                    try {
                        return Long.parseLong((String)in);
                    }
                    catch (Exception exception3) {
                        try {
                            return Integer.parseInt((String)in);
                        }
                        catch (Exception exception4) {
                        }
                    }
                }
            }
        } else {
            if (in instanceof Long) {
                return (Long)in;
            }
            if (in instanceof Integer) {
                return (Integer)in;
            }
            if (in instanceof Double) {
                return (Double)in;
            }
            if (in instanceof Float) {
                return (Float)in;
            }
        }
        return null;
    }

    private Boolean tryParseBoolean(Object in) {
        if (in instanceof String) {
            try {
                return Boolean.parseBoolean((String)in);
            }
            catch (Exception exception) {
            }
        } else if (in instanceof Boolean) {
            return (Boolean)in;
        }
        return null;
    }

    @Override
    public Stream<Document> validate(String options, Stream<Document> in, Document globalOptions) {
        ITable table;
        if (in != null && (table = this.getSchDoc().getTable(options.replaceAll("\\\"|\\\\|\\'", ""))) != null) {
            return ((Stream)in.parallel()).map(doc -> this.validate(table, (Document)doc));
        }
        return null;
    }

    @Override
    public Stream<Document> task(Document options, Stream<Document> in, Document globalOptions) {
        if (in != null) {
            return in.map(doc -> {
                String status;
                if (doc.containsKey("Status") && !(status = doc.getString("Status")).equalsIgnoreCase("Valid")) {
                    Document task = new Document();
                    String attr = options.getString("Message");
                    if (attr.contains("$")) {
                        StringBuilder sb = new StringBuilder();
                        for (String token : this.tokenise(attr)) {
                            if (token.startsWith("$")) {
                                sb.append(doc.getProjection(token.substring(1)));
                                continue;
                            }
                            sb.append(token);
                        }
                        attr = sb.toString();
                    }
                    task.append("Task", attr);
                    Calendar c = Calendar.getInstance();
                    task.append("Created", c.getTime().toGMTString());
                    Number days = this.tryParseNumber(options.getString("TimeFrameDays"));
                    if (days != null) {
                        c.add(5, days.intValue());
                    }
                    task.append("Due", c.getTime().toGMTString());
                    task.append("Tablename", "[" + doc.getString("Table") + "]");
                    task.append("Resolved", "false");
                    task.append("Table", "Tasks");
                    task.append("Type", status);
                    task.append("Comment", doc.getString("Error"));
                    if (doc.get("_id") != null) {
                        task.append("Nodes", List.of(doc.getString("_id")));
                        task.append("_id", doc.getString("_id") + doc.hashCode());
                    } else {
                        task.append("_id", "" + doc.hashCode());
                    }
                    if (options.containsKey("overrite") && options.getBoolean("overrite", false)) {
                        this.saveTask(task);
                    } else {
                        DBCursor cc = this.findTasks(new Document("_id", task.getString("_id")));
                        if (!cc.hasNext()) {
                            this.saveTask(task);
                        } else {
                            Document d = cc.first();
                            if (!d.getBoolean("Resolved", false)) {
                                this.saveTask(task);
                            }
                        }
                    }
                }
                return doc;
            });
        }
        return null;
    }

    private List<String> tokenise(String attr) {
        char[] ca = attr.toCharArray();
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean intoken = false;
        for (int i = 0; i < ca.length; ++i) {
            if (ca[i] == '$') {
                tokens.add(sb.toString());
                sb.setLength(0);
                intoken = true;
            }
            if (intoken && (ca[i] == ' ' || ca[i] == ',' || ca[i] == ';' || ca[i] == ')' || ca[i] == '(' || ca[i] == ':')) {
                intoken = false;
                tokens.add(sb.toString());
                sb.setLength(0);
            }
            sb.append(ca[i]);
        }
        if (sb.length() > 0) {
            tokens.add(sb.toString());
        }
        return tokens;
    }

    @Override
    public Stream<Document> cluster(Document options, Stream<Document> in, Document globalOptions) {
        if (in != null) {
            if (options == null) {
                options = new Document();
            }
            double score = 0.0;
            if (options.containsKey("score")) {
                score = options.getDouble("score");
            }
            HashMap<CallSite, Document> results = new HashMap<CallSite, Document>();
            List docs = in.collect(Collectors.toList());
            for (Document prep : docs) {
                prep.append("standardized", this.localCollection.standardise(prep));
            }
            for (Document filter : docs) {
                for (Object current : docs) {
                    if (((Document)current).getString("_id").equalsIgnoreCase(filter.getString("_id")) || results.containsKey(((Document)current).getString("_id") + "/" + filter.getString("_id"))) continue;
                    Document result = this.score(filter, (Document)current, false);
                    result.append("from", filter.getString("_id"));
                    result.append("to", ((Document)current).getString("_id"));
                    if (!(result.getDouble("score") >= score)) continue;
                    results.put((CallSite)((Object)(filter.getString("_id") + "/" + ((Document)current).getString("_id"))), result);
                }
            }
            HashMap<String, Long> clusters = new HashMap<String, Long>();
            long clusterID = 0L;
            for (Document result : results.values()) {
                long currentClusterFrom = -1L;
                long currentClusterTo = -1L;
                if (clusters.containsKey(result.getString("from"))) {
                    currentClusterFrom = (Long)clusters.get(result.getString("from"));
                }
                if (clusters.containsKey(result.getString("to"))) {
                    currentClusterTo = (Long)clusters.get(result.getString("to"));
                }
                if (currentClusterTo != -1L && currentClusterFrom != -1L) {
                    for (String key : clusters.keySet()) {
                        if ((Long)clusters.get(key) != currentClusterFrom) continue;
                        clusters.replace(key, currentClusterTo);
                    }
                    clusters.put(result.getString("to"), currentClusterTo);
                    clusters.put(result.getString("from"), currentClusterTo);
                    continue;
                }
                if (currentClusterTo != -1L) {
                    clusters.put(result.getString("to"), currentClusterTo);
                    clusters.put(result.getString("from"), currentClusterTo);
                    continue;
                }
                if (currentClusterFrom != -1L) {
                    clusters.put(result.getString("to"), currentClusterFrom);
                    clusters.put(result.getString("from"), currentClusterFrom);
                    continue;
                }
                clusters.put(result.getString("to"), ++clusterID);
                clusters.put(result.getString("from"), clusterID);
            }
            ValueComparator bvc = new ValueComparator(clusters);
            TreeMap<String, Long> sortedmap = new TreeMap<String, Long>(bvc);
            sortedmap.putAll(clusters);
            long lastCluster = -1L;
            HashSet<Document> ret = new HashSet<Document>();
            ArrayList<Document> cluster = new ArrayList<Document>();
            for (String node : sortedmap.keySet()) {
                long clusterNo = (Long)clusters.get(node);
                if (clusterNo != lastCluster && lastCluster != -1L) {
                    ret.add(new Document("_id", clusterNo).append("size", cluster.size()).append("cluster", cluster));
                    cluster = new ArrayList();
                }
                cluster.add(this.getDocument(node));
                lastCluster = clusterNo;
            }
            if (lastCluster != -1L && cluster.size() > 0) {
                ret.add(new Document("_id", lastCluster).append("size", cluster.size()).append("cluster", cluster));
            }
            return ret.parallelStream();
        }
        return null;
    }

    @Override
    public Stream<Document> out(String string, Stream<Document> in, Document options) {
        ICollection c2 = this.parent.createCollection(string);
        ArrayList out = new ArrayList();
        in.forEach(doc -> {
            c2.save((Document)doc);
            if (!options.containsKey("noOutput") || options.getBoolean("noOutput", false)) {
                out.add(doc);
            }
        });
        return out.stream();
    }

    @Override
    public Stream<Document> writeRel(Document options, Stream<Document> in, Document goptions) {
        String direction = options.getString("direction");
        if (direction == null) {
            direction = "BOTH";
        }
        String _direction = direction;
        String idField = options.getString("idField");
        String parentField = options.getString("parentField");
        String relTypeField = "relType";
        if (options.containsKey("relTypeField")) {
            relTypeField = options.getString("relTypeField");
        }
        String relType = options.getString("relType");
        String _relTypeField = relTypeField;
        return in.map(doc -> {
            String id = doc.getString(idField);
            String parent = doc.getString(parentField);
            if (id != null && parent != null) {
                Document thisDoc = this.find(new Document(idField, id)).first();
                Document parentDoc = this.find(new Document(idField, parent)).first();
                String _relType = relType;
                if (thisDoc != null && parentDoc != null) {
                    Document relationship;
                    if (doc.containsKey(_relTypeField)) {
                        _relType = doc.getString(_relTypeField);
                    }
                    HashSet<Document> related = new HashSet<Document>();
                    if (_direction.equalsIgnoreCase("BOTH") || _direction.equalsIgnoreCase("TO")) {
                        relationship = new Document("relType", _relType);
                        relationship.append("fromCol", thisDoc.getString("_id"));
                        relationship.append("toCol", parentDoc.getString("_id"));
                        related.add(this.saveRelationship(relationship));
                    }
                    if (_direction.equalsIgnoreCase("BOTH") || _direction.equalsIgnoreCase("FROM")) {
                        relationship = new Document("relType", _relType);
                        relationship.append("fromCol", parentDoc.getString("_id"));
                        relationship.append("toCol", thisDoc.getString("_id"));
                        related.add(this.saveRelationship(relationship));
                    }
                    doc.append(relType, related);
                }
            }
            return doc;
        });
    }

    @Override
    public Stream<Document> match(Document filter, Stream<Document> in, Document options) {
        if (in == null) {
            return this.findStream(filter);
        }
        return ((Stream)in.parallel()).filter(doc -> ICollection.filter(doc, filter));
    }

    @Override
    public Stream analyse(Document fuzzyOptions, Stream<Document> in, Document options) {
        if (in != null) {
            in.collect(Collectors.toList());
        }
        ArrayList<Document> ret = new ArrayList<Document>();
        IIndex _index = null;
        if (fuzzyOptions.containsKey("Index")) {
            IIndex index = _index = this.getSchDoc().getIndex(fuzzyOptions.getString("Index"));
            if (fuzzyOptions.containsKey("InspectKey")) {
                Document entries = this.getIndexPrefixSubMap(index.getIndexName(), index.getIndexName() + ":" + fuzzyOptions.getString("InspectKey") + "|", true);
                return entries.values().stream().map(id -> this.getDocument(id));
            }
            if (fuzzyOptions.containsKey("GenerateKeyForID")) {
                Document doc = this.getDocument(fuzzyOptions.get("GenerateKeyForID"));
                String tableName = doc.getString("Table");
                ITable table = this.getSchDoc().getTable(tableName);
                java.util.Collection useKeyList = this.getMatchKeys(doc, table, index, false);
                for (String k : useKeyList) {
                    ret.add(new Document("Key", k));
                }
                return ret.stream();
            }
            Document mapout = this.keyCount(fuzzyOptions.getString("Index"));
            long mcount = 0L;
            if (mapout != null) {
                for (Object key : mapout.keySet()) {
                    if ((Long)mapout.get(key) <= 1L) continue;
                    ret.add(new Document("key", (String)key).append("count", mapout.get(key)));
                }
            }
            ret.add(new Document("key", "ALLOTHERS").append("count", mcount));
            return this.sort(new Document("count", 1), ret.stream(), new Document());
        }
        if (fuzzyOptions.containsKey("Standardize")) {
            String std = fuzzyOptions.getString("Standardize");
            if (fuzzyOptions.containsKey("StandardizeForID")) {
                Document doc = this.getDocument(fuzzyOptions.get("StandardizeForID"));
                Document standardised = this.localCollection.standardise(doc);
                ret.add(standardised);
                return ret.stream();
            }
            if (fuzzyOptions.containsKey("InspectStandardized")) {
                Document doc = this.getDocument(fuzzyOptions.get("InspectStandardized"));
                if (doc == null) {
                    ret.add(new Document("Cause", "Record not found by ID"));
                } else {
                    Document mr;
                    Document storedStandardised = this.getStandardised("STD_1", fuzzyOptions.getString("InspectStandardized"));
                    Document standardised = this.localCollection.standardise(doc);
                    ret.add(standardised.append("Origin", "CALCULATED"));
                    if (storedStandardised != null) {
                        ret.add(storedStandardised.append("Origin", "STORED"));
                    }
                    if ((mr = this.score(doc.append("standardized", standardised), new Document("standardized", storedStandardised).append("Table", doc.getString("Table")), false)) == null || mr.getDouble("score") != 100.0) {
                        Document r = new Document("Action", "db." + this.definition.getString("Name") + ".rebuildIndex(\"" + std + "\")");
                        if (mr == null || storedStandardised == null) {
                            r.append("Cause", "Stored Standardised value was not found");
                        } else {
                            r.append("Cause", "Stored Standardised value was out of date, score=" + mr.getDouble("score"));
                        }
                        ret.add(r);
                    } else if (mr != null || mr.getDouble("score") == 100.0) {
                        Document r = new Document("Action", "NONE");
                        r.append("Cause", "Stored Standardised value was correct, score=" + mr.getDouble("score"));
                        ret.add(r);
                    }
                }
                return ret.stream();
            }
            Document retSumm = new Document();
            Document mapout = this.conceptCount(std);
            long mcount = 0L;
            for (Object key : mapout.keySet()) {
                ret.add(new Document("concept", (String)key).append("count", mapout.get(key)));
            }
            ret.add(new Document("concept", "total_documents").append("count", this.count(new Document())));
            return this.sort(new Document("count", 1), ret.stream(), new Document());
        }
        return null;
    }

    @Override
    public Stream<Document> spinOut(Document spinOptions, Stream<Document> in, Document options) {
        if (in != null) {
            return ((Stream)in.parallel()).map(doc -> this.spinOut((Document)doc, spinOptions)).filter(doc -> doc != null);
        }
        return null;
    }

    @Override
    public Stream<Document> getRelated(Document spinOptions, Stream<Document> in, Document options) {
        if (in != null) {
            return ((Stream)in.parallel()).map(doc -> this.getRelated((Document)doc, spinOptions)).filter(doc -> doc != null);
        }
        return null;
    }

    @Override
    public DBCursor traverseTop(Document from, String relType) {
        if (relType == null) {
            relType = "parent";
        }
        Document relFilter = new Document("relType", relType).append("fromCol", from.get("_id"));
        ArrayList<Document> list = new ArrayList<Document>();
        list.add(this.getDocument(from.getString("_id")));
        DBCursor c = null;
        do {
            Optional<Document> first;
            if ((first = (c = this.findRelationships(relFilter)).stream().findFirst()).isPresent()) {
                Document doc = first.get();
                relFilter.append("fromCol", doc.get("toCol"));
                list.add(this.getDocument(doc.getString("toCol")));
                continue;
            }
            c = null;
        } while (c != null);
        return new DBCursor(list);
    }

    private Document getRelated(Document doc, Document relOptions) {
        String relType = null;
        String into = "children";
        String idField = "_id";
        String nameField = null;
        int recurseLevels = 1;
        int currentLevel = 0;
        int direction = 0;
        if (relOptions != null) {
            if (relOptions.containsKey("relType")) {
                relType = relOptions.getString("relType");
            }
            if (relOptions.containsKey("_idName")) {
                idField = relOptions.getString("_idName");
            }
            if (relOptions.containsKey("into")) {
                into = relOptions.getString("into");
            }
            if (relOptions.containsKey("nameField")) {
                nameField = relOptions.getString("nameField");
            }
            if (relOptions.containsKey("recurse")) {
                recurseLevels = relOptions.getInteger("recurse");
            }
            if (relOptions.containsKey("level")) {
                currentLevel = relOptions.getInteger("level");
            }
            if (relOptions.containsKey("direction")) {
                direction = relOptions.getInteger("direction");
            }
        } else {
            relOptions = new Document();
        }
        HashSet<Document> list = new HashSet<Document>();
        ArrayList<Document> orlist = new ArrayList<Document>();
        if (direction <= 0) {
            orlist.add(new Document("fromCol", doc.get("_id")));
        }
        if (direction >= 0) {
            orlist.add(new Document("toCol", doc.get("_id")));
        }
        Document filter = new Document("$or", orlist);
        if (relType != null) {
            filter.append("relType", relType);
        }
        DBCursor c = this.findRelationships(filter);
        relOptions.append("level", ++currentLevel);
        while (c.hasNext()) {
            Document toDoc;
            Document rel = c.next();
            String toID = rel.getString("toCol");
            if (toID.equalsIgnoreCase(doc.getString("_id"))) {
                toID = rel.getString("fromCol");
            }
            if ((toDoc = this.getDocument(toID)) == null) continue;
            if (currentLevel < recurseLevels) {
                toDoc = this.getRelated(toDoc, relOptions.append("level", ++currentLevel));
            }
            if (!idField.equalsIgnoreCase("_id")) {
                toDoc.remove("_id");
                toDoc.append(idField, toID);
            }
            if (nameField != null) {
                toDoc.append("name", toDoc.getString(nameField));
            }
            list.add(toDoc);
        }
        doc.append(into, list);
        if (!idField.equalsIgnoreCase("_id")) {
            doc.append(idField, doc.get("_id"));
            doc.remove("_id");
        }
        if (nameField != null) {
            doc.append("name", doc.getString(nameField));
        }
        return doc;
    }

    private Document rematch(Document doc, Document rematchOptions) {
        this.localCollection.match(doc);
        return doc;
    }

    @Override
    public Stream<Document> rematch(Document rematchOptions, Stream<Document> in, Document options) {
        if (in != null) {
            return ((Stream)in.parallel()).map(doc -> this.rematch((Document)doc, rematchOptions));
        }
        return null;
    }

    private Document spinOut(Document doc, Document spinOptions) {
        if (spinOptions != null) {
            String type = "Inner";
            if (spinOptions.containsKey("joinType")) {
                type = spinOptions.getString("joinType");
            }
            String relType = spinOptions.getString("relationshipType");
            String into = spinOptions.getString("into");
            List projectors = spinOptions.getList("fields");
            ArrayList<Document> list = new ArrayList<Document>();
            Document filter = new Document("fromCol", doc.get("_id"));
            if (relType != null) {
                filter.append("relType", relType);
            }
            DBCursor c = this.findRelationships(filter);
            if (into == null) {
                into = relType;
            }
            while (c.hasNext()) {
                Document rel = c.next();
                Document to = new Document();
                for (String projField : projectors) {
                    String toID = rel.getString("toCol");
                    Document toDoc = this.getDocument(toID);
                    if (toDoc == null) continue;
                    Object proj = toDoc.getProjection(projField);
                    to.append(projField, proj);
                }
                list.add(to);
            }
            doc.append(into, list);
            if (type.equalsIgnoreCase("Inner") && list.size() > 0 || type.equalsIgnoreCase("Outer")) {
                return doc;
            }
        }
        return null;
    }

    @Override
    public Stream<Document> coerce(Document options, Stream<Document> in, Document globalOptions) {
        if (in != null) {
            if (options == null) {
                options = new Document();
            }
            Document _options = options;
            return ((Stream)in.parallel()).map(doc -> {
                if (doc.containsKey("cluster")) {
                    List cluster = doc.getList("cluster");
                    doc.remove("cluster");
                    for (Document cldoc : cluster) {
                        Document std = this.localCollection.standardise(cldoc);
                        Set keySet = std.keySet();
                        if (_options.containsKey("concepts")) {
                            keySet = _options.getAsDocument("concepts").keySet();
                        }
                        for (Object purpose : keySet) {
                            for (Object stdy : MatchRule.deserialise((List)std.getList((String)purpose))) {
                                StringBuilder value = new StringBuilder();
                                for (String v : ((Standardized)stdy).getComparitorWords()) {
                                    value.append(v + " ");
                                }
                                doc.append((String)purpose, value.toString().trim());
                            }
                        }
                        if (!_options.containsKey("projection")) continue;
                        Document projections = _options.getAsDocument("projection");
                        for (Object key : projections.keySet()) {
                            String projType = projections.getString((String)key);
                            if (projType == null || projType.equalsIgnoreCase("1")) {
                                projType = "first";
                            }
                            if (projType.equalsIgnoreCase("first")) {
                                if (cldoc.get(key) == null) continue;
                                doc.append((String)key, cldoc.get(key));
                                projections.replace(key, "done");
                                _options.append("projection", projections);
                                continue;
                            }
                            if (!projType.equalsIgnoreCase("last") || cldoc.get(key) == null) continue;
                            doc.append((String)key, cldoc.get(key));
                        }
                    }
                    return doc;
                }
                return null;
            });
        }
        return null;
    }

    @Override
    public Map<Document, List<Document>> split(List<Document> splitter, Stream<Document> in, Document globalOptions) {
        if (in != null) {
            if (splitter == null) {
                splitter = new ArrayList<Document>();
                splitter.add(new Document("filter", new Document()));
            }
            HashMap<Document, Document> groupBy = new HashMap<Document, Document>();
            for (Map map : splitter) {
                Document splitStep = new Document(map);
                Document pipeline = null;
                Document filter = null;
                pipeline = splitStep.containsKey("pipeline") ? new Document("pipeline", splitStep.getList("pipeline")).append("options", globalOptions) : new Document("pipeline", new ArrayList()).append("options", globalOptions);
                filter = splitStep.containsKey("filter") ? splitStep.getAsDocument("filter") : new Document();
                groupBy.put(pipeline, filter);
            }
            HashMap<Document, List<Document>> ret = new HashMap<Document, List<Document>>();
            for (Document pipeline : groupBy.keySet()) {
                ret.put(pipeline, new ArrayList());
            }
            in.forEach(doc -> {
                for (Document pipeline : groupBy.keySet()) {
                    Document filter = (Document)groupBy.get(pipeline);
                    if (!ICollection.filter(doc, filter)) continue;
                    ((List)ret.get(pipeline)).add(doc);
                }
            });
            return ret;
        }
        return null;
    }

    private Document groupingBy(Document doc, ArrayList<Document> groupBy) {
        Document key = new Document();
        for (Document filter : groupBy) {
            if (!ICollection.filter(doc, filter)) continue;
            key = filter;
            break;
        }
        return key;
    }

    @Override
    public Stream<Document> project(Document options, Stream<Document> in, Document globalOptions) {
        if (in != null) {
            if (options == null) {
                options = new Document();
            }
            Document _options = options;
            return ((Stream)in.parallel()).map(doc -> {
                Document ret = new Document();
                for (Object member : _options.keySet()) {
                    if (_options.getInteger((String)member, 0) != 1) continue;
                    ret.append((String)member, doc.getProjection((String)member));
                }
                return ret;
            });
        }
        return null;
    }

    @Override
    public Stream<Document> script(Document scriptStatements, Stream<Document> in, Document metadata) {
        StringBuilder sb = new StringBuilder("var target={};\n");
        for (Object target : scriptStatements.keySet()) {
            sb.append("target['" + target + "'] =" + scriptStatements.get(target) + ";\n");
        }
        sb.append("JSON.stringify(target);");
        ScriptEngine engine = new ScriptEngineManager(null).getEngineByName("nashorn");
        String script = sb.toString();
        return in.map(doc -> {
            try {
                SimpleBindings bindings = new SimpleBindings();
                for (Object source : doc.keySet()) {
                    if (source == null || ((String)source).length() <= 0 || doc.get(source) == null) continue;
                    bindings.put((String)source, doc.get(source));
                }
                String output = (String)engine.eval(script, (Bindings)bindings);
                Document dout = Document.parse(output);
                return Collection.expandDoc(dout, metadata);
            }
            catch (ScriptException e) {
                e.printStackTrace();
                return doc;
            }
        });
    }

    private static Document expandDoc(Document flatdoc, Document metadata) {
        Document temp = new Document();
        for (Object key : flatdoc.keySet()) {
            Object value = flatdoc.get(key);
            if (key == null || value == null || value instanceof String && ((String)value).length() == 0) continue;
            String[] parts = ((String)key).split("\\.");
            Document parent = temp;
            Object partInc = "";
            for (String part : parts) {
                Object newParent;
                partInc = (String)partInc + part;
                String colName = ((String)partInc).replaceAll("\\[[0-9]*?\\]", "");
                String type = null;
                if (metadata.getProjection(colName) instanceof List) {
                    type = "List";
                } else if (metadata.getProjection(colName) instanceof Map) {
                    type = "Structure";
                }
                if (type == null || type.length() == 0) {
                    type = "text";
                }
                int levelinstance = 0;
                if (part.contains("[")) {
                    String[] partSplit = part.split("\\[");
                    part = partSplit[0];
                    levelinstance = Integer.parseInt(partSplit[1].replace("]", ""));
                }
                if (type.equalsIgnoreCase("Structure")) {
                    newParent = new Document();
                    if (parent instanceof Document) {
                        if (!parent.containsKey(part)) {
                            parent.append(part, newParent);
                        } else {
                            newParent = parent.get(part);
                        }
                    } else if (parent instanceof ArrayList) {
                        Document listparent;
                        Document listitem;
                        if (levelinstance > ((ArrayList)((Object)parent)).size() - 1) {
                            for (int expand = ((ArrayList)((Object)parent)).size() - 1; expand < levelinstance; ++expand) {
                                ((ArrayList)((Object)parent)).add(new Document());
                            }
                        }
                        if ((listitem = (Document)(listparent = (Document)((ArrayList)((Object)parent)).get(levelinstance)).get(part)) == null) {
                            listitem = new Document();
                        }
                        if (!listparent.containsKey(part)) {
                            listparent.append(part, newParent);
                        } else {
                            newParent = listitem;
                        }
                    }
                    parent = newParent;
                } else if (type.equalsIgnoreCase("List")) {
                    newParent = new ArrayList();
                    if (parent instanceof Document) {
                        if (!parent.containsKey(part)) {
                            parent.append(part, newParent);
                        } else {
                            newParent = parent.get(part);
                        }
                    } else if (parent instanceof ArrayList) {
                        if (levelinstance > ((ArrayList)((Object)parent)).size() - 1) {
                            for (int expand = ((ArrayList)((Object)parent)).size() - 1; expand < levelinstance - 1; ++expand) {
                                ((ArrayList)((Object)parent)).add(new Document());
                            }
                        }
                        ((ArrayList)((Object)parent)).set(levelinstance, new Document(part, newParent));
                    }
                    parent = newParent;
                } else if (parent instanceof Document) {
                    parent.append(part, value);
                } else if (parent instanceof ArrayList) {
                    Document instancearray = null;
                    if (((ArrayList)((Object)parent)).size() > levelinstance) {
                        instancearray = (Document)((ArrayList)((Object)parent)).get(levelinstance);
                    }
                    if (instancearray == null) {
                        instancearray = new Document();
                    }
                    if (instancearray instanceof Document) {
                        instancearray.append(part, value);
                    }
                }
                partInc = (String)partInc + ".";
            }
        }
        return temp;
    }

    @Override
    public DBCursor getMatchTypes() {
        Map mt = this.getSchDoc().getMatchTypes();
        ArrayList<Document> out = new ArrayList<Document>();
        for (String k : mt.keySet()) {
            out.add(((Document)mt.get(k)).append("Name", k));
        }
        return new DBCursor(out);
    }

    @Override
    public DBCursor getFlows() {
        return this.getResources("FLW");
    }

    @Override
    public DBCursor getFlow(String name) {
        return this.getResource(name);
    }

    @Override
    public DBCursor getBooks() {
        return this.getResources("GML");
    }

    private DBCursor getResources(String suffix) {
        File file = new File(IdentizaSettings.getApplicationRootPath((String)"") + File.separator + "root" + File.separator + this.getDatabase().getName() + File.separator + this.getName());
        ArrayList<Document> out = new ArrayList<Document>();
        if (file.isDirectory()) {
            for (File d : file.listFiles()) {
                if (!d.isFile() || !d.getName().toUpperCase().endsWith("." + suffix)) continue;
                Document metadoc = this.parent.getCollection("$custom").find(new Document("collection", this.getName()).append("database", this.parent.getName()).append("name", d.getName())).first();
                if (metadoc == null) {
                    metadoc = new Document();
                }
                metadoc.append("Name", d.getName()).append("Path", d.getAbsolutePath());
                out.add(metadoc);
            }
        }
        return new DBCursor(out);
    }

    private DBCursor getResource(String name) {
        File file = new File(IdentizaSettings.getApplicationRootPath((String)"") + File.separator + "root" + File.separator + this.getDatabase().getName() + File.separator + this.getName() + File.separator + name);
        if (file.exists() && file.isFile()) {
            JsonParser parser = new JsonParser();
            try {
                StringBuilder sb = new StringBuilder();
                BufferedReader br = new BufferedReader(new FileReader(file));
                ((Stream)br.lines().sequential()).forEach(line -> sb.append((String)line));
                JsonElement json = parser.parse(sb.toString());
                return new DBCursor(new Document(json));
            }
            catch (JsonIOException | JsonSyntaxException | FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public Stream<Document> getDeltas() {
        return this.replicaConnections.values().stream().map(collection -> collection.getDeltas()).flatMap(s -> s);
    }

    @Override
    public Stream<Document> getNodes() {
        Document out = new Document();
        for (Integer nodenum : this.replicaConnections.keySet()) {
            out.append("" + nodenum, this.replicaConnections.get(nodenum).getDefinition());
        }
        return Stream.of(out);
    }
}

