/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.monster.db;

import com.entitystream.identiza.db.INode;
import com.entitystream.identiza.entity.resolve.match.Indexable;
import com.entitystream.identiza.entity.resolve.match.MatchRecordInterface;
import com.entitystream.identiza.entity.resolve.match.Matchable;
import com.entitystream.identiza.entity.resolve.metadata.IIndex;
import com.entitystream.identiza.entity.resolve.metadata.IPurpose;
import com.entitystream.identiza.entity.resolve.metadata.IRule;
import com.entitystream.identiza.entity.resolve.metadata.ISchemaMeta;
import com.entitystream.identiza.entity.resolve.metadata.ITable;
import com.entitystream.identiza.entity.resolve.metadata.Index;
import com.entitystream.identiza.entity.resolve.metadata.Purpose;
import com.entitystream.identiza.entity.resolve.metadata.PurposeColumn;
import com.entitystream.identiza.entity.resolve.metadata.PurposeColumnMap;
import com.entitystream.identiza.entity.resolve.metadata.Rule;
import com.entitystream.identiza.entity.resolve.metadata.SchemaMeta;
import com.entitystream.identiza.entity.resolve.metadata.Table;
import com.entitystream.identiza.entity.resolve.types.MatchProcDefinition;
import com.entitystream.identiza.entity.resolve.types.MatchProcInterface;
import com.entitystream.identiza.entity.resolve.types.Standardized;
import com.entitystream.identiza.wordlist.WordList;
import com.entitystream.monster.db.Collection;
import com.entitystream.monster.db.CollectionRemote;
import com.entitystream.monster.db.Container;
import com.entitystream.monster.db.DBCursor;
import com.entitystream.monster.db.Database;
import com.entitystream.monster.db.Document;
import com.entitystream.monster.db.ICollection;
import com.entitystream.monster.db.MatchCollection;
import com.entitystream.monster.db.ReplicaType;
import com.entitystream.monster.db.Session;
import com.entitystream.monster.db.StopIterationException;
import com.entitystream.monster.db.User;
import com.entitystream.monster.geo.GeoType;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.script.ScriptEngine;
import org.apache.commons.io.FileUtils;
import org.mapdb.BTreeMap;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.HTreeMap;
import org.mapdb.IndexTreeList;
import org.mapdb.Serializer;
import org.mapdb.serializer.SerializerCompressionWrapper;

public class CollectionLocal
extends Indexable
implements Serializable,
ICollection,
Matchable {
    private static final String STANDARDINDEX = "STD_1";
    private transient DB _catalog = null;
    private HTreeMap indexCatalogStore;
    private HTreeMap data;
    private Map indexes;
    private Document definition;
    private Database owningDB;
    private Collection parent;
    private Map<Object, Lock> indexLock;
    private boolean explaining = false;
    private Logger logger = Logger.getAnonymousLogger();
    private ISchemaMeta schDoc;
    private String schemaName;
    private MatchCollection matchCollection;
    private Document replicaRouter = new Document();
    private ReplicaType replicaType = ReplicaType.Replicated;
    private int nodeNum = 0;
    private String myKey;
    private List<String> replicaSet = new ArrayList<String>();
    private String hashKey = "_id";
    private Map<String, IIndex> indexs = new HashMap<String, IIndex>();
    private Map<String, ITable> tables = new HashMap<String, ITable>();
    private Map rollupCubeIO = new HashMap();
    private Map rollupCube = new HashMap();
    private Map<String, String> formulaMap = new HashMap<String, String>();
    private ScriptEngine engine;
    private IndexTreeList delta;
    private Lock deltaLock;

    private DB getData() {
        return this.getData(this.owningDB.isReadOnly());
    }

    private DB getData(boolean allowRO) {
        if (this._catalog == null) {
            File fpath = new File(this.definition.getString("DBPath") + this.definition.getString("Path"));
            if (!fpath.exists()) {
                fpath.mkdirs();
            }
            String path = fpath.getAbsolutePath() + File.separator + this.definition.getString("Name");
            DBMaker.Maker _data = DBMaker.fileDB((String)path).fileMmapEnable().checksumHeaderBypass().closeOnJvmShutdown();
            try {
                if (allowRO) {
                    _data = _data.readOnly();
                }
                if (_data != null) {
                    this._catalog = _data.make();
                }
            }
            catch (Exception e) {
                this.logger.severe("Collections can't be created on a non existent database, " + e.toString());
            }
        }
        return this._catalog;
    }

    protected CollectionLocal(Collection parent, Document collDoc, boolean initialised) {
        this.definition = collDoc;
        this.myKey = this.definition.getString("HostKey");
        this.parent = parent;
        this.owningDB = parent.getDatabase();
        this.definition.append("DBPath", this.owningDB.getDataPath());
        this.nodeNum = this.owningDB.getNodeNum();
        if (this.definition.containsKey("Ranges")) {
            this.replicaSet = this.owningDB.getReplicaSet();
            this.definition.append("ReplicaSet", this.replicaSet);
            this.replicaType = ReplicaType.Range;
            this.replicaRouter = this.definition.getAsDocument("Ranges").getAsDocument("" + this.nodeNum);
            if (this.replicaRouter == null) {
                this.replicaRouter = new Document();
            }
        }
        if (this.definition.containsKey("HashKey")) {
            this.replicaSet = this.owningDB.getReplicaSet();
            this.definition.append("ReplicaSet", this.replicaSet);
            this.replicaType = ReplicaType.Hash;
            this.hashKey = this.definition.getString("HashKey");
        }
        try {
            this.indexLock = new LinkedHashMap<Object, Lock>();
            this.indexCatalogStore = this.getData().hashMap(this.definition.getString("Name") + "_Cat").keySerializer((Serializer)Serializer.STRING).createOrOpen();
            this.data = this.getData().hashMap(this.definition.getString("Name") + "_Data").keySerializer((Serializer)Serializer.STRING).valueSerializer((Serializer)SerializerCompressionWrapper.JAVA).createOrOpen();
            this.indexes = new LinkedHashMap();
            if (!initialised) {
                this.initialiseCollection();
            }
            this.store(this.owningDB);
            this.getRelCollection();
            this.getTaskCollection();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isSpecialCollection() {
        return this.definition.getString("Name").endsWith("_TASKS") || this.definition.getString("Name").endsWith("_RELS");
    }

    private void initialiseCollection() {
        if (!this.indexCatalogStore.containsKey((Object)"_id_1")) {
            this.indexCatalogStore.put((Object)"_id_1", (Object)new Document("Fields", Collections.singletonList(new Document("Name", "_id").append("Order", 1))).append("Options", new Document("name", "_id_1").append("dirty", 1)));
        }
        if (this.definition.containsKey("Delta")) {
            this.deltaLock = new ReentrantLock();
            this.delta = (IndexTreeList)this.getData().indexTreeList("Delta", (Serializer)SerializerCompressionWrapper.STRING).createOrOpen();
        }
        if (this.definition.containsKey("Definition")) {
            if (!this.indexes.containsKey(STANDARDINDEX)) {
                this.indexes.put(STANDARDINDEX, this.getData().treeMap(STANDARDINDEX).keySerializer(Serializer.BYTE_ARRAY).valueSerializer(Serializer.JAVA).createOrOpen());
            }
            this.schDoc = SchemaMeta.createSchemaMeta((Document)this.definition.getAsDocument("Definition"));
            super.initialize(this.schDoc);
            this.schemaName = this.getSchDoc().getName();
            for (IIndex index : this.getSchDoc().getIndexes()) {
                if (this.indexCatalogStore.containsKey((Object)index.getIndexName())) continue;
                String matchProcsString = new Gson().toJson((Object)this.getSchDoc().getMatchProcs(index.getIndexName(), "" + index.getInstance(), ""));
                this.indexCatalogStore.put((Object)index.getIndexName(), (Object)new Document("Options", new Document("fuzzy", true).append("matchProcs", matchProcsString).append("name", index.getIndexName())));
            }
            this.indexLock.put(STANDARDINDEX, new ReentrantLock());
            if (this.schDoc.isAutoMatch()) {
                if (this.matchCollection == null) {
                    this.matchCollection = new MatchCollection(this.parent, this.getRelCollection(), this.getTaskCollection(), this.schDoc);
                } else {
                    this.matchCollection.initialize(this.schDoc);
                }
            }
        }
        for (Object id : this.indexCatalogStore.keySet()) {
            this.indexLock.put(id, new ReentrantLock());
            if (this.indexes.containsKey(id)) continue;
            Document indexDoc = (Document)this.indexCatalogStore.get(id);
            List fieldsList = indexDoc.getList("Fields");
            Document cidoc = new Document();
            for (Map fldoc : fieldsList) {
                cidoc.append((String)fldoc.get("Name"), fldoc.get("Order"));
            }
            this.createIndex(cidoc, indexDoc.getAsDocument("Options"));
        }
        this.indexs = new HashMap<String, IIndex>();
        this.tables = new HashMap<String, ITable>();
        this.indexCatalogCache.putAll(this.indexCatalogStore);
    }

    protected CollectionLocal(Collection parent, Document collDoc) {
        this(parent, collDoc, false);
    }

    @Override
    public void disconnect() {
        if (this.matchCollection != null) {
            this.matchCollection.disconnect();
        }
        this.matchCollection = null;
        if (this.data != null && !this.data.isClosed()) {
            this.data.close();
        }
    }

    @Override
    public void setAutoMatch(boolean a) {
        if (this.schDoc != null) {
            this.schDoc.setAutoMatch(a);
            if (!a) {
                if (this.matchCollection != null) {
                    this.matchCollection.disconnect();
                }
                this.matchCollection = null;
            }
            this.updateDefinition();
        }
    }

    @Override
    public void addTrigger(String name) {
        if (this.matchCollection != null) {
            this.matchCollection.addTrigger(name);
            this.definition.append("Trigger", name);
        } else {
            System.out.println("Trigger (" + name + ") was attempted to be applied to non fuzzy collection " + this.getCollectionName());
        }
    }

    @Override
    public String getTrigger() {
        return this.definition.getString("Trigger");
    }

    private void store(Database parent) throws Exception {
        if (this.owningDB == null) {
            throw new Exception("Collection could not be altered");
        }
        this.owningDB.storeCollection(this.definition.getString("Name"), this.parent);
    }

    @Override
    public void createUniqueIndex(Document fields) {
        Document options = new Document("unique", true);
        this.createIndex(fields, options);
    }

    @Override
    public void createIndex(Document fields, Document options) {
        try {
            Object name = "";
            Boolean unique = options.getBoolean("unique", false);
            Boolean fuzzy = options.getBoolean("fuzzy", false);
            ArrayList<Document> newfields = new ArrayList<Document>();
            for (Object k : fields.keySet()) {
                Document df = new Document("Name", k);
                df.append("Order", 1);
                if (fields.get((String)k) instanceof Integer) {
                    df.append("Order", fields.getInteger((String)k));
                } else if (fields.get((String)k) instanceof String) {
                    if (fields.getString((String)k).equalsIgnoreCase("2d")) {
                        options.append("geo", "2d");
                    } else if (fields.getString((String)k).equalsIgnoreCase("2dsphere")) {
                        options.append("geo", "2dsphere");
                    }
                }
                newfields.add(df);
                if (((String)name).length() != 0) {
                    name = (String)name + "_";
                }
                name = (String)name + (String)k;
            }
            name = (String)name + "_1";
            if (options.getString("name") != null) {
                name = options.getString("name");
            }
            if (fuzzy.booleanValue()) {
                String matchProcsJson = options.getString("matchProcs");
                Type listType = new TypeToken<List<MatchProcDefinition>>(){}.getType();
                List defs = (List)new Gson().fromJson(matchProcsJson, listType);
                if (!this.matchProcs.containsKey(name)) {
                    this.matchProcs.put(name, new LinkedHashMap());
                }
                for (MatchProcDefinition def : defs) {
                    String procname = def.getProcName();
                    ((Map)this.matchProcs.get(name)).put(procname, def.build());
                }
            }
            if (!this.indexCatalogStore.containsKey(name) && !this.owningDB.isReadOnly()) {
                this.indexCatalogStore.put(name, (Object)new Document("Fields", newfields).append("Options", options).append("dirty", 1));
            }
            this.indexLock.put(name, new ReentrantLock());
            if (!this.indexes.containsKey(name)) {
                BTreeMap datIndex = this.getData().treeMap((String)name).keySerializer(Serializer.BYTE_ARRAY).valueSerializer(Serializer.STRING).createOrOpen();
                this.indexes.put(name, datIndex);
                Document indexC = (Document)this.indexCatalogStore.get(name);
                if (indexC.getInteger("dirty", 0) == 1) {
                    indexC.remove("dirty");
                    this.indexCatalogStore.put(name, (Object)indexC);
                    this.indexCatalogCache.putAll(this.indexCatalogStore);
                    this.rebuildIndex((String)name);
                }
            }
            this.store(this.owningDB);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void createIndex(Document document) {
        this.createIndex(document, new Document());
    }

    @Override
    public void dropIndex(String name) {
        if (!this.owningDB.isReadOnly()) {
            this.indexLock.get(name).lock();
            if (this.indexCatalogStore.containsKey((Object)name)) {
                this.indexCatalogStore.remove((Object)name);
            }
            this.indexCatalogCache.clear();
            this.indexCatalogCache.putAll(this.indexCatalogStore);
            if (this.indexes.containsKey(name)) {
                ((BTreeMap)this.indexes.get(name)).clear();
                this.indexes.remove(name);
            }
            this.indexLock.get(name).unlock();
            if (this.indexLock.containsKey(name)) {
                this.indexLock.remove(name);
            }
        }
    }

    @Override
    public void rebuildIndex(String indexName) {
        Document indexC = (Document)this.indexCatalogStore.get((Object)indexName);
        if (indexC != null && indexC.getInteger("dirty", 0) == 1) {
            System.out.println("Index rebuild already in progress, request ignored " + indexName);
            this.indexLock.get(indexName).unlock();
            return;
        }
        if (!this.owningDB.isReadOnly()) {
            if (indexC != null) {
                indexC.append("dirty", 1);
                this.indexCatalogStore.put((Object)indexName, (Object)indexC);
            }
            if (this.indexLock.containsKey(indexName)) {
                this.indexLock.get(indexName).lock();
                BTreeMap index = (BTreeMap)this.indexes.get(indexName);
                index.clear();
                this.indexLock.get(indexName).unlock();
                this.bulkIndex(indexName, this.data.values().stream());
                if (indexC != null) {
                    indexC.remove("dirty");
                    this.indexCatalogStore.put((Object)indexName, (Object)indexC);
                }
            }
        }
    }

    public String getCollectionName() {
        return this.definition.getString("Name");
    }

    @Override
    public DBCursor find(Document filter) {
        Document explainPlan = new Document();
        long t = System.currentTimeMillis();
        DBCursor _return = this.find(filter, explainPlan);
        t = System.currentTimeMillis() - t;
        if (this.explaining) {
            explainPlan.append("Elapsed", t + "ms");
            this.logger.info(explainPlan.toJson());
        }
        return _return;
    }

    @Override
    public DBCursor find() {
        Document explainPlan = new Document();
        long t = System.currentTimeMillis();
        DBCursor _return = this.find(explainPlan);
        t = System.currentTimeMillis() - t;
        if (this.explaining) {
            explainPlan.append("Elapsed", t + "ms");
            this.logger.info(explainPlan.toJson());
        }
        return _return;
    }

    public Stream<Document> findStream(Document filter, Document explainPlan) {
        int eval = this.evaluate(filter, explainPlan);
        List hints = explainPlan.getList("Hint");
        explainPlan.append("Streamed", "true");
        if (eval > 0 && hints.size() == 0) {
            return this.fullScanStream(filter, explainPlan);
        }
        if (eval > 0 && hints.size() > 0) {
            return this.indexScan(filter, explainPlan, hints).stream();
        }
        ArrayList<Document> results = new ArrayList<Document>();
        boolean basic = true;
        if (filter == null) {
            filter = new Document();
        }
        for (Object k : filter.keySet()) {
            if (!((String)k).startsWith("$")) continue;
            ArrayList<Document> innerExplainList = new ArrayList<Document>();
            explainPlan.append((String)k, innerExplainList);
            basic = false;
            if (((String)k).equalsIgnoreCase("$or")) {
                for (Document innerFilter : (List)filter.get(k)) {
                    Document innerExplain = new Document();
                    innerExplainList.add(innerExplain);
                    for (Document martin : this.find(innerFilter, innerExplain)) {
                        results.add(martin);
                    }
                }
            }
            if (!((String)k).equalsIgnoreCase("$and")) continue;
            boolean first = true;
            HashSet<String> keyList = new HashSet<String>();
            for (Document innerFilter : (List)filter.get(k)) {
                Document innerExplain = new Document();
                innerExplainList.add(innerExplain);
                if (first) {
                    for (Document martin : this.find(innerFilter, innerExplain)) {
                        keyList.add(martin.getString("_id"));
                        results.add(martin);
                    }
                } else {
                    DBCursor newSet = this.find(innerFilter, innerExplain);
                    HashSet<String> newKeyList = new HashSet<String>();
                    for (Document martin : newSet) {
                        newKeyList.add(martin.getString("_id"));
                    }
                    HashSet<String> deleteKeyList = new HashSet<String>();
                    deleteKeyList.addAll(keyList);
                    deleteKeyList.removeAll(newKeyList);
                    HashSet<Document> deleteDocs = new HashSet<Document>();
                    for (Document martin : results) {
                        if (!deleteKeyList.contains(martin.getString("_id"))) continue;
                        deleteDocs.add(martin);
                    }
                    results.removeAll(deleteDocs);
                }
                first = false;
            }
        }
        if (basic) {
            return this.findInternal(filter, explainPlan);
        }
        return results.stream();
    }

    @Override
    public DBCursor find(Document filter, Document explainPlan) {
        int eval = this.evaluate(filter, explainPlan);
        List hints = explainPlan.getList("Hint");
        if (eval > 0 && hints.size() == 0) {
            return this.fullScan(filter, explainPlan);
        }
        if (eval > 0 && hints.size() > 0) {
            return this.indexScan(filter, explainPlan, hints);
        }
        ArrayList<Document> results = new ArrayList<Document>();
        boolean basic = true;
        for (Object k : filter.keySet()) {
            if (!((String)k).startsWith("$")) continue;
            ArrayList<Document> innerExplainList = new ArrayList<Document>();
            explainPlan.append((String)k, innerExplainList);
            basic = false;
            if (((String)k).equalsIgnoreCase("$or")) {
                for (Document innerFilter : (List)filter.get(k)) {
                    Document innerExplain = new Document();
                    innerExplainList.add(innerExplain);
                    for (Document martin : this.find(innerFilter, innerExplain)) {
                        results.add(martin);
                    }
                }
            }
            if (!((String)k).equalsIgnoreCase("$and")) continue;
            boolean first = true;
            HashSet<String> keyList = new HashSet<String>();
            for (Document innerFilter : (List)filter.get(k)) {
                Document innerExplain = new Document();
                innerExplainList.add(innerExplain);
                if (first) {
                    for (Document martin : this.find(innerFilter, innerExplain)) {
                        keyList.add(martin.getString("_id"));
                        results.add(martin);
                    }
                } else {
                    DBCursor newSet = this.find(innerFilter, innerExplain);
                    HashSet<String> newKeyList = new HashSet<String>();
                    for (Document martin : newSet) {
                        newKeyList.add(martin.getString("_id"));
                    }
                    HashSet<String> deleteKeyList = new HashSet<String>();
                    deleteKeyList.addAll(keyList);
                    deleteKeyList.removeAll(newKeyList);
                    HashSet<Document> deleteDocs = new HashSet<Document>();
                    for (Document martin : results) {
                        if (!deleteKeyList.contains(martin.getString("_id"))) continue;
                        deleteDocs.add(martin);
                    }
                    results.removeAll(deleteDocs);
                }
                first = false;
            }
        }
        if (basic) {
            return new DBCursor(this.findInternal(filter, explainPlan).collect(Collectors.toList()));
        }
        return new DBCursor(results);
    }

    private DBCursor indexScan(Document filter, Document explainPlan, List hints) {
        explainPlan.append("Collection", this.definition.getString("Name")).append("Filter", filter).append("Plan", "IndexScan");
        String indexName = (String)hints.get(0);
        BTreeMap indx = (BTreeMap)this.indexes.get(indexName);
        return new DBCursor(((Stream)indx.values().stream().parallel()).map(pointer -> (Document)this.data.get(pointer)).filter(doc -> ICollection.filter(doc, filter)).collect(Collectors.toList()));
    }

    public int evaluate(Document filter, Document explainPlan) {
        int fullscans = 0;
        Object bestIndex = null;
        if (filter != null) {
            for (Object k : filter.keySet()) {
                if (((String)k).startsWith("$")) {
                    if (((String)k).equalsIgnoreCase("$or")) {
                        for (Document innerFilter : (List)filter.get(k)) {
                            fullscans += this.evaluate(innerFilter, explainPlan);
                        }
                    }
                    if (!((String)k).equalsIgnoreCase("$and")) continue;
                    List filters = (List)filter.get(k);
                    for (Document innerFilter : filters) {
                        int _fullscans = this.evaluate(innerFilter, explainPlan);
                        if (_fullscans < filters.size()) continue;
                        ++fullscans;
                    }
                    continue;
                }
                Document _index = this.getIndex(filter);
                if (_index.getString("IndexName").equalsIgnoreCase("DataScan")) {
                    ++fullscans;
                    continue;
                }
                if (!explainPlan.containsKey("Hint")) {
                    explainPlan.append("Hint", new ArrayList());
                }
                explainPlan.getList("Hint").add(_index.getString("IndexName"));
            }
        }
        if (fullscans > 0) {
            explainPlan.append("ScanCostReduction", 100 - 100 / fullscans + "%");
        } else {
            explainPlan.append("ScanCostReduction", "0%");
        }
        return fullscans;
    }

    private Set indexSeek(BTreeMap indx, Set<Object> keys, Document indexPlan) {
        double hitRatio = indexPlan.getDouble("HitRatio");
        boolean uniqueIndex = indexPlan.getBoolean("Unique", false);
        String indexMethod = indexPlan.getString("IndexMethod");
        HashSet<Object> output = new HashSet<Object>();
        for (Object key : keys) {
            Object entry = null;
            if (indexMethod.equalsIgnoreCase("IndexLookup")) {
                entry = hitRatio == 1.0 ? (uniqueIndex ? indx.get((Object)((String)key).getBytes()) : indx.prefixSubMap((Object)((String)key + "|").getBytes(), true)) : indx.prefixSubMap((Object)((String)key).getBytes(), true);
            } else if (indexMethod.equalsIgnoreCase("IndexRangeScan")) {
                entry = indx.prefixSubMap((Object)((String)key).getBytes(), true);
            } else if (indexMethod.equalsIgnoreCase("IndexScan")) {
                indx.getKeys().parallelStream().forEach(ikeyb -> {
                    String ikey = new String((byte[])ikeyb);
                    if (key instanceof Pattern) {
                        if (((Pattern)key).matcher(ikey).find()) {
                            output.add(indx.get(ikeyb));
                        }
                    } else if (ikey.startsWith((String)key)) {
                        output.add(indx.get(ikeyb));
                    }
                });
            }
            if (entry == null) continue;
            if (entry instanceof Map) {
                for (Object set : ((Map)entry).values()) {
                    if (set instanceof Set) {
                        output.addAll((Set)set);
                        continue;
                    }
                    if (!(set instanceof String)) continue;
                    output.add(set);
                }
                continue;
            }
            if (entry instanceof Set) {
                output.addAll((Set)entry);
                continue;
            }
            if (!(entry instanceof String)) continue;
            output.add(entry);
        }
        return output;
    }

    private Stream<Document> findInternal(Document filter, Document explainPlan) {
        Document bestIndex = this.getIndex(filter);
        String indexName = (String)bestIndex.get("IndexName");
        Set<Object> ifind = this.calculateForIndex(indexName, filter, bestIndex.getString("IndexMethod"));
        explainPlan.append("Collection", this.definition.getString("Name")).append("Filter", filter).append("Plan", bestIndex);
        if (ifind != null && ifind.size() > 0) {
            BTreeMap idx = (BTreeMap)this.indexes.get(indexName);
            Set<Set> o = this.indexSeek(idx, ifind, bestIndex);
            if (o != null) {
                if (!(o instanceof HashSet)) {
                    o = Collections.singleton(o);
                }
                return ((Stream)o.stream().parallel()).map(pointer -> (Document)this.data.get(pointer)).filter(doc -> ICollection.filter(doc, filter));
            }
        } else {
            return this.fullScanStream(filter, explainPlan);
        }
        return Stream.empty();
    }

    private DBCursor fullScan(Document filter, Document explainPlan) {
        explainPlan.append("Collection", this.definition.getString("Name")).append("Filter", filter).append("Plan", "DataScan");
        return new DBCursor(this.fullScanStream(filter, explainPlan).collect(Collectors.toList()));
    }

    private Stream<Document> fullScanStream(Document filter, Document explainPlan) {
        explainPlan.append("Collection", this.definition.getString("Name")).append("Filter", filter).append("Plan", "DataScan");
        return ((Stream)this.data.getKeys().stream().parallel()).map(key -> (Document)this.data.get(key)).filter(doc -> ICollection.filter(doc, filter));
    }

    private Set<Object> calculateForIndex(String ikey, Document document, String indexMethod) {
        if (ikey.equalsIgnoreCase("DataScan")) {
            return null;
        }
        String geoType = null;
        int geoAccuracy = 12;
        List ifields = null;
        boolean caseInsensitive = false;
        Document ic = (Document)this.indexCatalogCache.get(ikey);
        if (ic != null) {
            ifields = ic.getList("Fields");
            Document options = ic.getAsDocument("Options");
            if (options != null) {
                if (options.get("geo") != null) {
                    geoType = options.getString("geo");
                }
                if (options.get("accuracy") != null) {
                    geoAccuracy = options.getInteger("accuracy");
                }
                if (options.get("caseInsensitive") != null) {
                    caseInsensitive = options.getBoolean("caseInsensitive", false);
                }
            }
        }
        StringBuilder key = new StringBuilder();
        ArrayList<java.util.Collection> fieldValues = new ArrayList<java.util.Collection>();
        if (ifields != null) {
            Object val;
            Map ifieldName;
            Iterator iterator = ifields.iterator();
            while (iterator.hasNext() && document.containsProjection((String)(ifieldName = (Map)iterator.next()).get("Name")) && (val = document.getProjection((String)ifieldName.get("Name"))) != null) {
                Set hash;
                GeoType point;
                if (geoType == null) {
                    if (val instanceof Set || val instanceof List) {
                        fieldValues.add((java.util.Collection)val);
                    } else if (val instanceof String) {
                        if (caseInsensitive) {
                            fieldValues.add(Collections.singleton(((String)val).toUpperCase()));
                        } else {
                            fieldValues.add(Collections.singleton(val));
                        }
                    } else {
                        fieldValues.add(Collections.singleton(val));
                    }
                    if (!this.isPattern(val)) continue;
                    break;
                }
                if (!geoType.equalsIgnoreCase("2d")) continue;
                if (val instanceof Set || val instanceof List) {
                    HashSet newVal = new HashSet();
                    for (Object obj : (Iterable)val) {
                        Set hash2;
                        GeoType point2;
                        if (!(obj instanceof Document) || (point2 = GeoType.fromDoc((Document)((Document)obj))) == null || (hash2 = GeoType.encodeGeohash((GeoType)point2, (int)geoAccuracy)) == null) continue;
                        newVal.addAll(hash2);
                    }
                    fieldValues.add(newVal);
                    continue;
                }
                if (val instanceof Map) {
                    val = new Document(val);
                }
                if (!(val instanceof Document) || (point = GeoType.fromDoc((Document)((Document)val))) == null || (hash = GeoType.encodeGeohash((GeoType)point, (int)geoAccuracy)) == null) continue;
                fieldValues.add(hash);
            }
            return this.processKey(fieldValues, 0, "", indexMethod);
        }
        return null;
    }

    private Document getIndex(Document filter) {
        Document bestIndex = new Document("HitRatio", 0.0).append("IndexName", "DataScan").append("IndexMethod", "DataScan");
        String indexMethod = "IndexLookup";
        for (Object ikey : this.indexCatalogCache.keySet()) {
            Document indexDoc = (Document)this.indexCatalogCache.get(ikey);
            if (indexDoc.getInteger("dirty", 0) != 0) continue;
            double indexHit = 0.0;
            HashSet<String> indexFields = new HashSet<String>();
            List ifields = indexDoc.getList("Fields");
            boolean unique = indexDoc.getAsDocument("Options").getBoolean("unique", false);
            block1: for (Map ifieldName : ifields) {
                for (Object fkeyo : filter.keySet()) {
                    String fkey = (String)fkeyo;
                    if (!fkey.startsWith("$") && fkey.equalsIgnoreCase((String)ifieldName.get("Name"))) {
                        if (this.isPattern(filter.getProjection(fkey))) {
                            if (this.isPrefixPattern(filter.getProjection(fkey))) {
                                indexHit += 1.0;
                                indexFields.add((String)ifieldName.get("Name"));
                                indexMethod = "IndexRangeScan";
                                continue block1;
                            }
                            indexMethod = "IndexScan";
                            indexFields.add((String)ifieldName.get("Name"));
                            indexHit += 1.0;
                            continue block1;
                        }
                        indexHit += 1.0;
                        indexFields.add((String)ifieldName.get("Name"));
                    }
                    if (!(filter.get(fkey) instanceof Document) || !filter.getAsDocument(fkey).containsKey("$geoWithin")) continue;
                    indexMethod = "IndexRangeScan";
                }
            }
            double thisHit = indexHit / (double)ifields.size();
            if (!(thisHit > bestIndex.getDouble("HitRatio"))) continue;
            bestIndex.append("IndexName", (String)ikey);
            bestIndex.append("IndexMethod", indexMethod);
            bestIndex.append("HitRatio", thisHit);
            bestIndex.append("IndexFields", indexFields);
            bestIndex.append("Unique", unique);
        }
        return bestIndex;
    }

    private boolean hash(Document doc, String hashKey) {
        Object o = doc.get(hashKey);
        int value = o instanceof Integer ? ((Integer)o).intValue() : o.hashCode();
        return this.nodeNum == Math.abs(value) % (this.replicaSet.size() + 1);
    }

    private Document routerFilter(Document doc) {
        if (this.replicaType == ReplicaType.Range) {
            if (ICollection.filter(doc, this.replicaRouter)) {
                return doc;
            }
            return null;
        }
        if (this.replicaType == ReplicaType.Hash) {
            if (this.hash(doc, this.hashKey)) {
                return doc;
            }
            return null;
        }
        if (this.replicaType == ReplicaType.Replicated) {
            return doc;
        }
        return doc;
    }

    @Override
    public Document save(Document docIn) {
        Object _id = docIn.get("_id");
        Document doc = this.routerFilter(docIn);
        if (doc != null) {
            if (this.index(doc)) {
                this.data.put(_id, (Object)doc);
            }
            this.preProcess(doc);
            this.match(doc);
        } else if (this.index(docIn)) {
            this.data.remove(_id);
            this.deindex(docIn);
        }
        return doc;
    }

    private void preProcessReplacement(Document before, Document node) {
    }

    private void preProcess(Document node) {
        this.preProcess(Stream.of(node));
    }

    private void preProcess(Stream<Document> in) {
        try {
            in.forEach(node -> {
                if (this.definition.containsKey("Delta") && ICollection.filter(node, this.definition.getAsDocument("Delta"))) {
                    this.delta.add((Object)node.getString("_id"));
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Stream<Document> getDeltas() {
        return Stream.generate(new Supplier<Document>(){

            @Override
            public Document get() {
                try {
                    String id = null;
                    if (CollectionLocal.this.delta != null && CollectionLocal.this.delta.getSize() > 0) {
                        id = (String)CollectionLocal.this.delta.removeAt(CollectionLocal.this.delta.getSize() - 1);
                    }
                    if (id != null) {
                        return CollectionLocal.this.getDocument(id);
                    }
                    Thread.sleep(100L);
                }
                catch (StopIterationException ex) {
                    throw ex;
                }
                catch (InterruptedException ex2) {
                    throw new StopIterationException(ex2.toString());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return null;
            }
        }).filter(o -> o != null);
    }

    @Override
    public int saveMany(List<Document> docs) {
        this.insertMany(docs);
        return docs.size();
    }

    @Override
    public Document insertOne(Document doc) {
        return this.save(doc);
    }

    @Override
    public long count(Document query) {
        if (query == null) {
            return this.data.sizeLong();
        }
        return this.find(query).count();
    }

    @Override
    public Document findOneAndReplace(Document filter, Document replacement, Document options) {
        Document docIn = this.find(filter).first();
        if (docIn != null) {
            Document doc = this.routerFilter(docIn);
            if (doc != null) {
                String _id = doc.getString("_id");
                replacement.append("_id", _id);
                this.deindex(doc);
                if (this.index(replacement)) {
                    this.data.put((Object)_id, (Object)replacement);
                }
                this.preProcess(replacement);
                this.match(replacement);
                return replacement;
            }
            this.deindex(docIn);
            String _id = docIn.getString("_id");
            this.data.remove((Object)_id);
        } else if (options.getBoolean("upsert", false)) {
            if (!replacement.containsKey("_id")) {
                replacement.append("_id", options.get("_id"));
            }
            this.save(replacement);
        }
        return null;
    }

    @Override
    public Document findOneAndReplace(Document filter, Document replacement) {
        return this.findOneAndReplace(filter, replacement, new Document());
    }

    @Override
    public Document findOneAndUpdate(Document filter, Document amendments) {
        Document doc = this.find(filter).first();
        this.updateInternal(doc, amendments, new Document());
        return doc;
    }

    @Override
    public Document findOneAndUpdate(Document filter, Document amendments, Document updateOpts) {
        Document doc = this.find(filter).first();
        this.updateInternal(doc, amendments, updateOpts);
        return doc;
    }

    private void updateInternal(Document doc, Document amendments, Document options) {
        if (doc == null && options.getBoolean("upsert", false)) {
            doc = new Document("_id", options.get("_id"));
        }
        if (doc != null) {
            doc.applyUpdate(amendments);
            this.save(doc);
            this.match(doc);
        } else {
            System.out.println("not updating " + amendments.toJson());
        }
    }

    @Override
    public Document updateOne(Document filter, Document amendments) {
        return this.findOneAndUpdate(filter, amendments, new Document());
    }

    @Override
    public Document updateOne(Document filter, Document amendments, Document options) {
        return this.findOneAndUpdate(filter, amendments, options);
    }

    @Override
    public int updateMany(Document filter, Document amendments, Document options) {
        AtomicInteger count = new AtomicInteger(0);
        this.find(filter).stream().forEach(doc -> {
            count.incrementAndGet();
            this.updateInternal((Document)doc, amendments, options);
        });
        return count.get();
    }

    @Override
    public int updateMany(Document filter, Document amendments) {
        AtomicInteger count = new AtomicInteger(0);
        this.find(filter).stream().forEach(doc -> {
            count.incrementAndGet();
            this.updateInternal((Document)doc, amendments, new Document());
        });
        return count.get();
    }

    @Override
    public int insertMany(List<Document> listRecs) {
        AtomicInteger count = new AtomicInteger(0);
        this.bulkIndex(listRecs.stream()).parallelStream().forEach(doc -> {
            String _id = (String)doc.get("_id");
            Document d = this.routerFilter((Document)doc);
            if (d != null) {
                this.data.put((Object)_id, (Object)d);
                this.preProcess(d);
                this.match(d);
                count.incrementAndGet();
            }
        });
        return count.get();
    }

    @Override
    public Document findOneAndDelete(Document filter) {
        Document doc = this.find(filter).first();
        if (doc != null) {
            this.data.remove((Object)doc.getString("_id"));
            this.deindex(doc);
        }
        return doc;
    }

    @Override
    public Document deleteOne(Document filter) {
        return this.findOneAndDelete(filter);
    }

    @Override
    public int deleteMany(Document filter) {
        if (filter.keySet().size() > 0) {
            AtomicInteger count = new AtomicInteger(0);
            this.find(filter).stream().forEach(doc -> {
                if (this.data.remove((Object)doc.getString("_id")) != null) {
                    count.incrementAndGet();
                    this.deindex((Document)doc);
                }
            });
            return count.get();
        }
        int s = this.data.getSize();
        System.out.println("Truncating " + s + " records from " + this.definition.getString("Name") + "...");
        this.data.clear();
        for (Object indexName : this.indexes.keySet()) {
            ((BTreeMap)this.indexes.get(indexName)).clear();
        }
        if (this.indexes.containsKey(STANDARDINDEX)) {
            ((BTreeMap)this.indexes.get(STANDARDINDEX)).clear();
        }
        return s;
    }

    private IIndex getCacheIndex(String indexName) {
        if (!this.indexs.containsKey(indexName)) {
            this.indexs.put(indexName, this.getSchDoc().getIndex(indexName));
        }
        return this.indexs.get(indexName);
    }

    private ITable getCacheTable(String tableName) {
        if (!this.tables.containsKey(tableName)) {
            this.tables.put(tableName, this.getSchDoc().getTable(tableName));
        }
        return this.tables.get(tableName);
    }

    public Document standardise(Document record) {
        BTreeMap stdIndex = (BTreeMap)this.indexes.get(STANDARDINDEX);
        if (stdIndex != null) {
            Document stds = null;
            if (record.getString("_id") != null) {
                stds = (Document)stdIndex.get((Object)record.getString("_id").getBytes());
            }
            if ((stds = null) == null || stds.size() == 0) {
                String tableName = record.getString("Table", this.definition.getString("Name"));
                stds = new Document();
                List tp = this.getSchDoc().getPurposes(tableName);
                for (IPurpose p : tp) {
                    List pcs = this.getSchDoc().getPurposeColumns(p.getPurposeName(), tableName);
                    for (PurposeColumn pc : pcs) {
                        List pcms = this.getSchDoc().getPurposeColumnMaps(pc.getPurposeName(), pc.getColumn(), tableName);
                        MatchProcInterface proc = pc.createMatchProc();
                        ArrayList<Standardized> sa = null;
                        try {
                            sa = new ArrayList<Standardized>();
                            Object[] objects = INode.getWords((Document)record, (List)pcms, (WordList)pc.popRuleSet().getRuleAnon(), (Date)new Date());
                            ArrayList baseTokensALL = (ArrayList)objects[0];
                            String originalText = (String)objects[1];
                            for (ArrayList baseTokens : baseTokensALL) {
                                Standardized stdItem = proc.standardise(originalText, baseTokens.toArray(new String[baseTokens.size()]));
                                if (stdItem.getCalculatedWords() == null) continue;
                                sa.add(stdItem);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (sa.size() <= 0) continue;
                        stds.append(pc.getColumn(), INode.serialize(sa));
                    }
                }
            }
            return stds;
        }
        return null;
    }

    private boolean checkDocumentForAllIndexes(Document doc) {
        boolean allowUpdate = true;
        for (Object ikey : this.indexCatalogCache.keySet()) {
            String indexName = (String)ikey;
            boolean unique = this.isUniqueIndex(indexName);
            if (!unique) continue;
            String _id = doc.getString("_id");
            boolean found = false;
            String _cid = null;
            Set s = this.existsInIndex(indexName, doc);
            if (s.size() > 0 && _id != null) {
                for (Object _cid1 : s) {
                    if (!((String)_cid1).equalsIgnoreCase(_id)) continue;
                    _cid = (String)_cid1;
                    found = true;
                    break;
                }
            }
            if (found) continue;
            if (_id == null) {
                doc.append("_id", _cid);
                continue;
            }
            if (s.size() <= 0) continue;
            allowUpdate = false;
        }
        return allowUpdate;
    }

    private List<Document> bulkIndex(Stream<Document> docs) {
        List<Document> idocs = ((Stream)docs.parallel()).filter(doc -> this.checkDocumentForAllIndexes((Document)doc)).collect(Collectors.toList());
        for (Object ikey : this.indexCatalogCache.keySet()) {
            String indexName = (String)ikey;
            this.bulkIndex(indexName, idocs.stream());
        }
        if (this.indexes.containsKey(STANDARDINDEX)) {
            this.bulkIndex(STANDARDINDEX, idocs.stream());
        }
        return idocs;
    }

    private boolean index(Document doc) {
        if (this.checkDocumentForAllIndexes(doc)) {
            for (Object ikey : this.indexCatalogCache.keySet()) {
                String indexName = (String)ikey;
                this.index(indexName, doc);
            }
            if (this.indexes.containsKey(STANDARDINDEX)) {
                this.index(STANDARDINDEX, doc);
            }
            return true;
        }
        return false;
    }

    private boolean deindex(Document doc) {
        for (Object ikey : this.indexCatalogCache.keySet()) {
            String indexName = (String)ikey;
            if (this.existsInIndex(indexName, doc).size() <= 0) continue;
            this.deindex(indexName, doc);
        }
        if (this.indexes.containsKey(STANDARDINDEX)) {
            this.deindex(STANDARDINDEX, doc);
        }
        return true;
    }

    private boolean deindex(String indexName, Document doc) {
        block6: {
            block5: {
                if (!indexName.equalsIgnoreCase(STANDARDINDEX)) break block5;
                BTreeMap index = (BTreeMap)this.indexes.get(indexName);
                index.remove((Object)doc.getString("_id").getBytes());
                break block6;
            }
            boolean unique = this.isUniqueIndex(indexName);
            Set<Object> indexky = this.calculateForIndex(indexName, doc, "IndexLookup");
            if (indexky == null || indexky.size() <= 0) break block6;
            BTreeMap index = (BTreeMap)this.indexes.get(indexName);
            if (unique) {
                for (Object indexkey : indexky) {
                    index.remove((Object)((String)indexkey).getBytes());
                }
            } else {
                for (Object indexkey : indexky) {
                    for (Object pointer : this.indexSeek(index, Collections.singleton(indexkey), new Document("HitRatio", 1.0).append("Unique", unique).append("IndexMethod", "IndexLookup"))) {
                        index.remove((Object)(indexkey + "|" + pointer).getBytes());
                    }
                }
            }
        }
        return true;
    }

    private boolean isUniqueIndex(String indexName) {
        Object ic = this.indexCatalogCache.get(indexName);
        if (ic != null) {
            Document options = ((Document)ic).getAsDocument("Options");
            return options.getBoolean("unique", false);
        }
        return false;
    }

    private boolean isFuzzyIndex(String indexName) {
        Object ic = this.indexCatalogCache.get(indexName);
        if (ic != null) {
            Document options = ((Document)ic).getAsDocument("Options");
            return options.getBoolean("fuzzy", false);
        }
        return false;
    }

    private String geoIndexType(String indexName) {
        Object ic = this.indexCatalogCache.get(indexName);
        if (ic != null) {
            Document options = ((Document)ic).getAsDocument("Geo");
            return options.getString("geo");
        }
        return null;
    }

    private boolean bulkIndex(String indexName, Stream<Document> docs) {
        if (!this.indexes.containsKey(indexName)) {
            System.out.println("Index is not found " + indexName);
            return false;
        }
        if (docs != null) {
            long start = System.currentTimeMillis();
            this.indexLock.get(indexName).lock();
            BTreeMap index = (BTreeMap)this.indexes.get(indexName);
            boolean isFuzzy = this.isFuzzyIndex(indexName);
            boolean unique = this.isUniqueIndex(indexName);
            IIndex matchI = this.getCacheIndex(indexName);
            ((Stream)docs.parallel()).forEach(doc -> {
                block8: {
                    String id;
                    block10: {
                        ITable table;
                        block9: {
                            if (this.routerFilter((Document)doc) == null) break block8;
                            id = doc.getString("_id");
                            if (!indexName.equalsIgnoreCase(STANDARDINDEX) || id == null) break block9;
                            index.put((Object)id.getBytes(), (Object)this.standardise((Document)doc));
                            break block8;
                        }
                        if (!isFuzzy || id == null) break block10;
                        String tableName = doc.getString("Table", this.definition.getString("Name"));
                        if (tableName == null || (table = this.getCacheTable(tableName)) == null) break block8;
                        Object pkey = doc.getProjection(table.getKeyField());
                        java.util.Collection useKeyList = this.getMatchKeys((Document)doc, table, matchI, false);
                        for (String useKeys : useKeyList) {
                            try {
                                if (matchI.isSearch() && useKeys.length() > 0) {
                                    index.put((Object)("S:" + useKeys + "|" + id).getBytes(), (Object)id);
                                }
                                if (!matchI.isMatch() && (matchI.isSearch() || matchI.isMatch()) || useKeys.length() <= 0) continue;
                                index.put((Object)(matchI.getIndexName() + ":" + useKeys + "|" + id).getBytes(), (Object)id);
                            }
                            catch (Exception e) {
                                if (index == null) {
                                    System.out.println(matchI.getIndexName());
                                }
                                e.printStackTrace();
                            }
                        }
                        break block8;
                    }
                    Set<Object> indexky = this.calculateForIndex(indexName, (Document)doc, "IndexLookup");
                    if (indexky.size() > 0) {
                        for (Object indexkey : indexky) {
                            if (!unique) {
                                index.put((Object)(indexkey + "|" + id).getBytes(), (Object)id);
                                continue;
                            }
                            byte[] keyBytes = ((String)indexkey).getBytes();
                            index.put((Object)keyBytes, (Object)id);
                        }
                    }
                }
            });
            try {
                this.indexLock.get(indexName).unlock();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    private boolean index(String indexName, Document doc) {
        if (doc != null) {
            String tableName;
            String id = doc.getString("_id");
            boolean normalIndex = true;
            if (indexName.equalsIgnoreCase(STANDARDINDEX)) {
                BTreeMap index = (BTreeMap)this.indexes.get(STANDARDINDEX);
                if (index != null) {
                    normalIndex = false;
                    this.indexLock.get(indexName).lock();
                    index.put((Object)id.getBytes(), (Object)this.standardise(doc));
                    this.indexLock.get(indexName).unlock();
                }
            } else if (this.isFuzzyIndex(indexName) && id != null && (tableName = doc.getString("Table", this.definition.getString("Name"))) != null && doc != null) {
                ITable table = this.getSchDoc().getTable(tableName);
                if (table != null) {
                    normalIndex = false;
                    Object pkey = doc.getProjection(table.getKeyField());
                    IIndex matchI = this.getSchDoc().getIndex(indexName);
                    java.util.Collection useKeyList = this.getMatchKeys(doc, table, matchI, false);
                    BTreeMap index = (BTreeMap)this.indexes.get(indexName);
                    this.indexLock.get(indexName).lock();
                    for (String useKeys : useKeyList) {
                        try {
                            if (matchI.isSearch() && useKeys.length() > 0) {
                                index.put((Object)("S:" + useKeys + "|" + id).getBytes(), (Object)id);
                            }
                            if (!matchI.isMatch() && (matchI.isSearch() || matchI.isMatch()) || useKeys.length() <= 0) continue;
                            index.put((Object)(matchI.getIndexName() + ":" + useKeys + "|" + id).getBytes(), (Object)id);
                        }
                        catch (Exception e) {
                            if (index == null) {
                                System.out.println(matchI.getIndexName());
                            }
                            e.printStackTrace();
                        }
                    }
                    this.indexLock.get(indexName).unlock();
                }
                return true;
            }
            if (normalIndex) {
                boolean unique = this.isUniqueIndex(indexName);
                Set<Object> indexky = this.calculateForIndex(indexName, doc, "IndexLookup");
                if (indexky.size() > 0) {
                    BTreeMap index = (BTreeMap)this.indexes.get(indexName);
                    this.indexLock.get(indexName).lock();
                    for (Object indexkey : indexky) {
                        if (!unique) {
                            index.put((Object)(indexkey + "|" + id).getBytes(), (Object)id);
                            continue;
                        }
                        index.put((Object)((String)indexkey).getBytes(), (Object)id);
                    }
                    try {
                        this.indexLock.get(indexName).unlock();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private Set existsInIndex(String indexName, Document doc) {
        BTreeMap index = (BTreeMap)this.indexes.get(indexName);
        Set<Object> indexky = this.calculateForIndex(indexName, doc, "IndexLookup");
        Document indexdef = (Document)this.indexCatalogCache.get(indexName);
        Set s = this.indexSeek(index, indexky, new Document("HitRatio", 0.0).append("Unique", indexdef.getAsDocument("Options").getBoolean("unique", false)).append("IndexMethod", "IndexLookup"));
        return s;
    }

    public static void drop(Document definition) {
        ArrayList<File> dirs = new ArrayList<File>();
        dirs.add(new File(definition.getString("DBPath") + definition.getString("Path") + File.separator + definition.getString("Name")));
        dirs.add(new File(definition.getString("DBPath") + definition.getString("Path") + File.separator + definition.getString("Name") + "_RELS"));
        dirs.add(new File(definition.getString("DBPath") + definition.getString("Path") + File.separator + definition.getString("Name") + "_TASKS"));
        dirs.add(new File(definition.getString("DBPath") + definition.getString("Path") + File.separator + definition.getString("Name") + "_Queue"));
        for (File dir : dirs) {
            try {
                if (!dir.exists()) continue;
                FileUtils.forceDelete((File)dir);
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public void drop() {
        ArrayList<File> dirs = new ArrayList<File>();
        dirs.add(new File(this.definition.getString("DBPath") + this.definition.getString("Path") + File.separator + this.definition.getString("Name")));
        dirs.add(new File(this.definition.getString("DBPath") + this.definition.getString("Path") + File.separator + this.definition.getString("Name") + "_RELS"));
        dirs.add(new File(this.definition.getString("DBPath") + this.definition.getString("Path") + File.separator + this.definition.getString("Name") + "_TASKS"));
        dirs.add(new File(this.definition.getString("DBPath") + this.definition.getString("Path") + File.separator + this.definition.getString("Name") + "_Queue"));
        for (File dir : dirs) {
            try {
                if (!dir.exists()) continue;
                FileUtils.forceDelete((File)dir);
            }
            catch (IOException iOException) {}
        }
        try {
            if (this.indexes != null) {
                for (Object index : this.indexes.values()) {
                    ((BTreeMap)index).clear();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (this.indexes != null) {
                this.indexes.clear();
            }
            if (this.indexCatalogStore != null && !this.indexCatalogStore.isClosed()) {
                this.indexCatalogStore.clear();
            }
            this.disconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Stream<Document> aggregate(List<Document> in, List<Document> pipeline) {
        try {
            throw new Exception("Aggregate iterable cannot be called at the local level");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Stream<Document> aggregate(List<Document> pipeline, Document options) {
        try {
            throw new Exception("Aggregate iterable cannot be called at the local level");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Stream<Document> aggregate(List<Document> pipeline) {
        try {
            return this.parent.aggregate(pipeline);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Document aggregateMetadata(List<Document> in, List<Document> pipeline) {
        try {
            return this.parent.aggregateMetadata(in, pipeline);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Document aggregateMetadata(List<Document> pipeline) {
        try {
            return this.parent.aggregateMetadata(pipeline);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public DBCursor listIndexes() {
        HashSet<Document> indexOut = new HashSet<Document>();
        for (Object name : this.indexCatalogCache.keySet()) {
            indexOut.add(new Document("name", name).append("Fields", this.indexCatalogCache.get(name)));
        }
        return new DBCursor(indexOut);
    }

    public boolean isExplaining() {
        return this.explaining;
    }

    @Override
    public void setExplaining(boolean explaining) {
        this.explaining = explaining;
    }

    @Override
    public DBCursor executeCommand(String command2, User user, Session session) {
        long start = System.currentTimeMillis();
        DBCursor ret = Container.executeCommand(this, command2, user, session);
        if (System.currentTimeMillis() - start > 10000L) {
            Object c = command2;
            if (((String)c).length() > 40) {
                c = ((String)c).substring(0, 37) + "...";
            }
            System.out.println("Command (" + (String)c + ") completed in " + (System.currentTimeMillis() - start) + "ms");
        }
        return ret;
    }

    @Override
    public <TResult> Iterable<TResult> distinct(String fieldName, Class<TResult> resultClass) {
        HashSet<Object> set = new HashSet<Object>();
        DBCursor f = this.find();
        while (f.hasNext()) {
            set.add(f.next().getProjection(fieldName));
        }
        return set;
    }

    @Override
    public Stream bucket(Document bucketDef, Stream<Document> in, Document options) {
        try {
            throw new Exception("bucket iterable cannot be called at the local level");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Document getDocument(Object pointer) {
        return (Document)this.data.get(pointer);
    }

    @Override
    public Document getIndexPrefixSubMap(String indexName, String key, boolean b) {
        Document d = new Document();
        BTreeMap i = (BTreeMap)this.indexes.get(indexName);
        if (i != null) {
            d.putAll((Map)i.prefixSubMap((Object)key.getBytes(), b));
        }
        return d;
    }

    @Override
    public Document keyCount(String indexName) {
        BTreeMap collIndex = (BTreeMap)this.indexes.get(indexName);
        if (collIndex != null) {
            return new Document((HashMap)collIndex.keySet().stream().map(key -> {
                String keyValue = new String((byte[])key);
                keyValue = keyValue.split(":|\\|")[1];
                return keyValue;
            }).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())));
        }
        return null;
    }

    @Override
    public Document conceptCount(String indexName) {
        BTreeMap collIndex = (BTreeMap)this.indexes.get(indexName);
        return new Document((HashMap)collIndex.values().stream().map(doc -> doc.keySet()).flatMap(c -> c.stream()).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())));
    }

    @Override
    public Document getStandardised(String indexName, String id) {
        return (Document)((BTreeMap)this.indexes.get(indexName)).get((Object)id.getBytes());
    }

    @Override
    public void saveTable(Document def) {
        this.getSchDoc().addTable((ITable)def.toObject(Table.class));
        this.updateDefinition();
    }

    @Override
    public Document getTable(String def) {
        Gson gson = new Gson();
        return Document.parse(gson.toJson((Object)this.getSchDoc().getTable(def), Table.class));
    }

    @Override
    public void deleteTable(String def) {
        this.getSchDoc().deleteTable(def);
        this.updateDefinition();
    }

    @Override
    public void saveConceptGroup(Document def) {
        this.getSchDoc().addPurpose((IPurpose)def.toObject(Purpose.class));
        this.updateDefinition();
    }

    @Override
    public void deleteConceptGroup(String def) {
        this.getSchDoc().deletePurpose(def);
        this.updateDefinition();
    }

    @Override
    public void saveConcept(Document def) {
        this.getSchDoc().addPurpose((IPurpose)def.toObject(Purpose.class));
        this.updateDefinition();
    }

    @Override
    public void deleteConcept(String purposeName, String purposeColumn) {
        this.getSchDoc().deletePurposeColumn(purposeName, purposeColumn);
        this.updateDefinition();
    }

    @Override
    public void saveConceptMapping(Document def) {
        this.getSchDoc().addPurposeColumnMap(def.toObject(PurposeColumnMap.class));
        this.updateDefinition();
    }

    @Override
    public void deleteConceptMapping(Document def) {
        this.getSchDoc().deletePurposeColumnMap(def.toObject(PurposeColumnMap.class));
        this.updateDefinition();
    }

    @Override
    public void saveMatchRule(Document def) {
        this.getSchDoc().addRule((IRule)def.toObject(Rule.class));
        this.updateDefinition();
    }

    @Override
    public void saveMatchRules(List<Document> defs) {
        ISchemaMeta _schDoc = this.getSchDoc();
        for (IRule rule : _schDoc.getRules(null)) {
            _schDoc.deleteMatchRule((long)rule.getOrder());
        }
        for (Document def : defs) {
            _schDoc.addRule((IRule)def.toObject(Rule.class));
        }
        this.schDoc = _schDoc;
        this.updateDefinition();
    }

    @Override
    public void deleteMatchRule(long order) {
        this.getSchDoc().deleteMatchRule(order);
        this.updateDefinition();
    }

    @Override
    public void saveFuzzyIndex(Document def) {
        this.getSchDoc().addIndex((IIndex)def.toObject(Index.class));
        this.updateDefinition();
    }

    @Override
    public void deleteFuzzyIndex(String def) {
        this.getSchDoc().deleteIndex(def);
        this.updateDefinition();
    }

    @Override
    public void removeFuzzy() {
        this.schDoc = null;
        this.updateDefinition();
    }

    private ISchemaMeta getSchDoc() {
        if (this.schDoc == null) {
            this.schDoc = SchemaMeta.createSchemaMeta((Document)new Document());
        }
        return this.schDoc;
    }

    @Override
    public Document getDefinition() {
        return this.parent.getDefinition();
    }

    private void updateDefinition() {
        if (this.schDoc != null) {
            Document doc = this.schDoc.toDocument();
            this.definition.append("Definition", doc);
            this.parent.updateDefinition(doc);
        } else {
            this.definition.remove("Definition");
            this.parent.updateDefinition(null);
        }
        this.initialiseCollection();
    }

    public ReplicaType getReplicaType() {
        return this.replicaType;
    }

    public void setReplicaType(ReplicaType replicaType) {
        this.replicaType = replicaType;
    }

    public ICollection getParent() {
        return this.parent;
    }

    @Override
    public void updateDefinition(Document def) {
        this.definition.append("Definition", def);
        this.schDoc = SchemaMeta.createSchemaMeta((Document)def);
        this.initialiseCollection();
    }

    public boolean match(Document node) {
        if (this.matchCollection != null && node.containsKey("Table")) {
            this.matchCollection.offer(node);
            return true;
        }
        return false;
    }

    @Override
    public DBCursor peekQueue() {
        if (this.matchCollection != null) {
            return this.matchCollection.peekAll();
        }
        return new DBCursor();
    }

    @Override
    public void resolveTask(Document mr) {
        if (this.matchCollection != null) {
            this.matchCollection.resolveTask(mr);
        }
    }

    @Override
    public Stream<Document> findStream(Document filter) {
        Document explainPlan = new Document();
        long t = System.currentTimeMillis();
        Stream<Document> _return = this.findStream(filter, explainPlan);
        t = System.currentTimeMillis() - t;
        if (this.explaining) {
            explainPlan.append("Elapsed", t + "ms");
            this.logger.info(explainPlan.toJson());
        }
        return _return;
    }

    @Override
    public Map<Integer, ICollection> getReplicaConnections() {
        return this.parent.getReplicaConnections();
    }

    public Stream<Document> skip(long skip, Stream in, Document options) {
        try {
            throw new Exception("skip is not to be called at the local level");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Stream<Document> limit(long limit, Stream in, Document options) {
        try {
            throw new Exception("limit is not to be called at the local level");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Stream out(String target, Stream<Document> in, Document options) {
        try {
            throw new Exception("out is not to be called at the local level");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Stream<Document> group(Document object, Stream<Document> in, Document options) {
        try {
            throw new Exception("group is not to be called at the local level");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Stream<Document> lookup(Document object, Stream<Document> in, Document options) {
        try {
            throw new Exception("lookup is not to be called at the local level");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Stream<Document> join(Document object, Stream<Document> in, Document options) {
        try {
            throw new Exception("join is not to be called at the local level");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Stream<Document> minus(Document object, Stream<Document> in, Document options) {
        try {
            throw new Exception("minus is not to be called at the local level");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Stream<Object> unwind(Document unwindOptions, Stream<Document> in, Document options) {
        try {
            throw new Exception("unwind is not to be called at the local level");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Stream<Document> count(Document options, Stream<Document> in, Document globalOptions) {
        try {
            throw new Exception("count is not to be called at the local level");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Stream<Document> first(Document options, Stream<Document> in, Document globalOptions) {
        try {
            throw new Exception("first is not to be called at the local level");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Stream<Document> last(Document options, Stream<Document> in, Document globalOptions) {
        try {
            throw new Exception("last is not to be called at the local level");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Stream<Document> between(Document options, Stream<Document> in, Document globalOptions) {
        try {
            throw new Exception("between is not to be called at the local level");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Stream<Document> cluster(Document options, Stream<Document> in, Document globalOptions) {
        try {
            throw new Exception("cluster is not to be called at the local level");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected Collection getRelCollection() {
        if (!this.isSpecialCollection()) {
            return (Collection)this.getDatabase().getRelCollection(this.getDefinition().getString("Name") + "_RELS");
        }
        return null;
    }

    protected Collection getTaskCollection() {
        if (!this.isSpecialCollection()) {
            return (Collection)this.getDatabase().getTaskCollection(this.getDefinition().getString("Name") + "_TASKS");
        }
        return null;
    }

    @Override
    public DBCursor findRelationships(Document filter) {
        return this.getRelCollection().find(filter);
    }

    @Override
    public Document saveRelationship(Document relationship) {
        Document filter = new Document("fromCol", relationship.get("fromCol")).append("toCol", relationship.get("toCol")).append("relType", relationship.get("relType"));
        return this.getRelCollection().findOneAndReplace(filter, relationship, new Document("upsert", true));
    }

    @Override
    public DBCursor findTasks(Document filter) {
        return this.getTaskCollection().find(filter);
    }

    @Override
    public DBCursor aggregateTasks(ArrayList<Document> andlist) {
        return new DBCursor(this.getTaskCollection().aggregate(andlist));
    }

    @Override
    public Document updateTask(String id, Document doc) {
        return this.getTaskCollection().findOneAndUpdate(new Document("_id", id), doc);
    }

    @Override
    public Document updateRelationship(Document document, Document setUpdate, Document options) {
        return this.getRelCollection().findOneAndUpdate(document, setUpdate, options);
    }

    @Override
    public <TResult> Iterable<TResult> distinctRelationship(String fieldName, Class<TResult> resultClass) {
        return this.getRelCollection().distinct(fieldName, resultClass);
    }

    @Override
    public void deleteTasks(Document document) {
        this.getTaskCollection().deleteMany(document);
    }

    @Override
    public void deleteRelationships(Document document) {
        this.getRelCollection().deleteMany(document);
    }

    @Override
    public Database getDatabase() {
        return this.owningDB;
    }

    public Document score(Document base, Document comparitor, boolean forSearch) {
        try {
            MatchRecordInterface mr = this.calculateScore(base, comparitor, forSearch);
            return mr.toDocument();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public DBCursor findFuzzy(Document filter) {
        return null;
    }

    @Override
    public DBCursor findFuzzy(String textQuery) {
        return null;
    }

    @Override
    public Stream match(Document asDocument, Stream<Document> in, Document options) {
        return null;
    }

    public Stream match(Document asDocument, long nodeid, long connectionid, long cursorid, Document options) {
        ICollection remote = this.getReplicaConnections().get((int)nodeid);
        if (remote instanceof CollectionRemote) {
            Stream<Document> in = ((CollectionRemote)remote).getClient().remoteGetStream(connectionid, cursorid);
            return this.getParent().match(asDocument, in, options);
        }
        return Stream.empty();
    }

    @Override
    public Stream analyse(Document asDocument, Stream<Document> in, Document options) {
        return null;
    }

    @Override
    public Stream sort(Document asDocument, Stream<Document> in, Document options) {
        return null;
    }

    @Override
    public Stream fuzzySearch(String string, Stream<Document> in, Document options) {
        return null;
    }

    @Override
    public Stream fuzzyMatch(Document asDocument, Stream<Document> in, Document options) {
        return null;
    }

    @Override
    public Stream spinOut(Document asDocument, Stream<Document> in, Document options) {
        return null;
    }

    @Override
    public Stream getRelated(Document asDocument, Stream<Document> in, Document options) {
        return null;
    }

    @Override
    public Stream rematch(Document asDocument, Stream<Document> in, Document options) {
        return null;
    }

    @Override
    public Stream classifierBuild(Document asDocument, Stream<Document> in, Document options) {
        return null;
    }

    @Override
    public Stream classifierPredict(Document asDocument, Stream<Document> in, Document options) {
        return null;
    }

    @Override
    public DBCursor traverseTop(Document from, String relType) {
        return null;
    }

    @Override
    public Stream arrf(Document asDocument, Stream<Document> in, Document options) {
        return null;
    }

    @Override
    public Stream classifierTree(Document asDocument, Stream<Document> in, Document options) {
        return null;
    }

    @Override
    public Stream coerce(Document asDocument, Stream<Document> in, Document options) {
        return null;
    }

    @Override
    public Stream compare(Document asDocument, Stream<Document> in, Document options) {
        return null;
    }

    @Override
    public Stream project(Document asDocument, Stream<Document> in, Document options) {
        return null;
    }

    @Override
    public Stream evaluate(Document asDocument, Stream<Document> in, Document options) {
        return null;
    }

    @Override
    public Map<Document, List<Document>> split(List<Document> list, Stream<Document> in, Document options) {
        return null;
    }

    @Override
    public Document fuzzyMatch(Document matchNode, List<IIndex> matchIndexes) {
        return null;
    }

    @Override
    public void updateDelta(Document def) {
        this.definition.append("Delta", def);
        this.initialiseCollection();
    }

    @Override
    public Stream<Document> writeRel(Document options, Stream<Document> in, Document goptions) {
        return null;
    }

    @Override
    public Stream<Document> script(Document scriptStatements, Stream<Document> in, Document stageoptions) {
        return null;
    }

    @Override
    public DBCursor getMatchTypes() {
        Map mt = this.getSchDoc().getMatchTypes();
        ArrayList<Document> out = new ArrayList<Document>();
        for (String k : mt.keySet()) {
            out.add(((Document)mt.get(k)).append("Name", k));
        }
        return new DBCursor(out);
    }

    @Override
    public void saveFuzzyIndexes(List<Document> def) {
        ISchemaMeta _sch = this.getSchDoc();
        for (IIndex i : _sch.getIndexes()) {
            _sch.deleteIndex(i.getIndexName());
        }
        for (Document de : def) {
            _sch.addIndex((IIndex)de.toObject(Index.class));
        }
        this.updateDefinition(_sch.toDocument());
    }

    @Override
    public DBCursor getFlows() {
        return null;
    }

    @Override
    public DBCursor getBooks() {
        return null;
    }

    @Override
    public DBCursor getFlow(String name) {
        return null;
    }

    @Override
    public Stream<Document> validate(String string, Stream<Document> in, Document stageoptions) {
        return null;
    }

    @Override
    public Stream<Document> task(Document options, Stream<Document> in, Document globalOptions) {
        return null;
    }

    @Override
    public Document saveTask(Document task) {
        return this.getTaskCollection().save(task);
    }

    @Override
    public Stream<Document> getNodes() {
        return null;
    }

    static class BucketRange {
        public Double upper;
        public Document document;

        public BucketRange(Double u, Document d) {
            this.upper = u;
            this.document = d;
        }
    }
}

