/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.monster.db;

import com.entitystream.identiza.entity.resolve.metadata.IIndex;
import com.entitystream.monster.db.DBCursor;
import com.entitystream.monster.db.Database;
import com.entitystream.monster.db.Document;
import com.entitystream.monster.db.ICollection;
import com.entitystream.monster.db.MonsterClient;
import com.entitystream.monster.db.Session;
import com.entitystream.monster.db.User;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CollectionRemote
implements ICollection,
Serializable {
    private MonsterClient client = null;
    private String dbName;
    private String collName;
    private int nodeNum;
    private ConcurrentHashMap<Long, MonsterClient> threads = new ConcurrentHashMap();

    public MonsterClient getClient() {
        long threadid = Thread.currentThread().getId() % 50L;
        MonsterClient client = null;
        try {
            if (this.threads.containsKey(threadid)) {
                client = this.getClientInternal(this.threads.get(threadid));
            } else {
                MonsterClient clientinn = this.getClientInternal(this.client.clone());
                this.threads.put(threadid, clientinn);
                client = clientinn;
            }
            client.setRemoteView(true);
        }
        catch (Exception e) {
            System.out.println("Remote Server is Offline, results will be affected");
        }
        return client;
    }

    private MonsterClient getClientInternal(MonsterClient client) {
        try {
            if (!client.isConnected() && !client.reconnect()) {
                throw new Exception("replica is down, command is rejected");
            }
            client.database = this.dbName;
            client.collection = this.collName;
            return client;
        }
        catch (Exception e) {
            System.out.println("Replica failed to come online, command is rejected " + e.toString());
            return null;
        }
    }

    public CollectionRemote(MonsterClient connection, String dbName, Document collDoc, boolean initialised) {
        System.out.println("Opening connection to: " + connection.getNodeNum() + " for collection " + collDoc.getString("Name"));
        this.nodeNum = connection.getNodeNum();
        if (!collDoc.getBoolean("remoteCall", false)) {
            connection.createDatabase(dbName);
            System.out.println("Sending Collection description:" + collDoc.toString());
            connection.createCollection(collDoc.append("remoteCall", true));
        }
        this.dbName = dbName;
        this.collName = collDoc.getString("Name");
        this.client = connection;
        this.client.setRemoteView(true);
        MonsterClient client = this.getClient();
        if (client != null) {
            client.useDatabase(dbName);
            client.useCollection(this.collName);
        }
    }

    @Override
    public void createIndex(Document fields, Document options) {
        MonsterClient client = this.getClient();
        if (client != null) {
            client.createIndex(fields, options);
        }
    }

    @Override
    public void createIndex(Document fields) {
        MonsterClient client = this.getClient();
        if (client != null) {
            client.createIndex(fields);
        }
    }

    @Override
    public void createUniqueIndex(Document fields) {
        MonsterClient client = this.getClient();
        if (client != null) {
            client.createIndex(fields);
        }
    }

    @Override
    public DBCursor find(Document filter) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.find(filter);
        }
        return new DBCursor();
    }

    @Override
    public DBCursor find() {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.find();
        }
        return new DBCursor();
    }

    @Override
    public DBCursor findFuzzy(Document filter) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.findFuzzy(filter);
        }
        return new DBCursor();
    }

    @Override
    public DBCursor findFuzzy(String textQuery) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.findFuzzy(textQuery);
        }
        return new DBCursor();
    }

    @Override
    public Document save(Document doc) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.save(doc);
        }
        return null;
    }

    @Override
    public Document insertOne(Document doc) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.insertOne(doc);
        }
        return null;
    }

    @Override
    public long count(Document query) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.count(query);
        }
        return 0L;
    }

    @Override
    public Document findOneAndReplace(Document filter, Document replacement, Document options) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.findOneAndReplace(filter, replacement, options);
        }
        return null;
    }

    @Override
    public Document findOneAndReplace(Document filter, Document replacement) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.findOneAndReplace(filter, replacement);
        }
        return null;
    }

    @Override
    public Document findOneAndUpdate(Document filter, Document amendments) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.findOneAndUpdate(filter, amendments);
        }
        return null;
    }

    @Override
    public Document findOneAndUpdate(Document filter, Document amendments, Document updateOpts) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.findOneAndUpdate(filter, amendments, updateOpts);
        }
        return null;
    }

    @Override
    public Document updateOne(Document filter, Document amendments) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.updateOne(filter, amendments);
        }
        return null;
    }

    @Override
    public Document updateOne(Document filter, Document amendments, Document options) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.updateOne(filter, amendments, options);
        }
        return null;
    }

    @Override
    public int updateMany(Document filter, Document amendments, Document options) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.updateMany(filter, amendments, options);
        }
        return 0;
    }

    @Override
    public int updateMany(Document filter, Document amendments) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.updateMany(filter, amendments, new Document());
        }
        return 0;
    }

    @Override
    public int insertMany(List<Document> listRecs) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.insertMany(listRecs);
        }
        return 0;
    }

    @Override
    public Document findOneAndDelete(Document filter) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.findOneAndDelete(filter);
        }
        return null;
    }

    @Override
    public Document deleteOne(Document filter) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.deleteOne(filter);
        }
        return null;
    }

    @Override
    public int deleteMany(Document filter) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.deleteMany(filter);
        }
        return 0;
    }

    @Override
    public Stream<Document> aggregate(List<Document> pipeline, Document options) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.aggregate(pipeline, options);
        }
        return Stream.empty();
    }

    @Override
    public Stream<Document> aggregate(List<Document> pipeline) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.aggregate(pipeline);
        }
        return Stream.empty();
    }

    @Override
    public Stream<Document> aggregate(List<Document> in, List<Document> pipeline) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.aggregate(in, pipeline);
        }
        return Stream.empty();
    }

    @Override
    public Document aggregateMetadata(List<Document> in, List<Document> pipeline) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.aggregateMetadata(in, pipeline);
        }
        return new Document();
    }

    @Override
    public Document aggregateMetadata(List<Document> pipeline) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.aggregateMetadata(pipeline);
        }
        return new Document();
    }

    @Override
    public DBCursor listIndexes() {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.listIndexes();
        }
        return new DBCursor();
    }

    @Override
    public void rebuildIndex(String name) {
        MonsterClient client = this.getClient();
        if (client != null) {
            client.rebuildIndex(name);
        }
    }

    @Override
    public void dropIndex(String name) {
        MonsterClient client = this.getClient();
        if (client != null) {
            client.dropIndex(name);
        }
    }

    @Override
    public int saveMany(List<Document> records) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.saveMany(records);
        }
        return 0;
    }

    @Override
    public void disconnect() throws Exception {
        MonsterClient client = this.getClient();
        if (client != null) {
            client.disconnect();
        }
    }

    @Override
    public void setExplaining(boolean explain) {
        MonsterClient client = this.getClient();
        if (client != null) {
            client.setExplaining(explain);
        }
    }

    @Override
    public DBCursor find(Document query, Document explain) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.find(query, explain);
        }
        return new DBCursor();
    }

    @Override
    public synchronized DBCursor executeCommand(String command2, User user, Session session) {
        MonsterClient client = this.getClient();
        if (client != null) {
            DBCursor ret = client.executeCommand(command2, user, session);
            return ret;
        }
        return new DBCursor();
    }

    @Override
    public void drop() {
        MonsterClient client = this.getClient();
        if (client != null) {
            client.drop();
        }
    }

    @Override
    public <TResult> Iterable<TResult> distinct(String fieldName, Class<TResult> resultClass) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.distinct(fieldName, resultClass);
        }
        return null;
    }

    @Override
    public Document getDocument(Object pointer) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.getDocument(pointer);
        }
        return null;
    }

    @Override
    public Document getIndexPrefixSubMap(String indexName, String key, boolean b) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.getIndexPrefixSubMap(indexName, key, b);
        }
        return null;
    }

    @Override
    public Document keyCount(String indexName) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.keyCount(indexName);
        }
        return null;
    }

    @Override
    public Document conceptCount(String indexName) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.conceptCount(indexName);
        }
        return null;
    }

    @Override
    public Document getStandardised(String indexName, String id) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.getStandardised(indexName, id);
        }
        return null;
    }

    @Override
    public void saveTable(Document def) {
        MonsterClient client = this.getClient();
        if (client != null) {
            client.saveTable(def);
        }
    }

    @Override
    public void setAutoMatch(boolean b) {
        MonsterClient client = this.getClient();
        if (client != null) {
            client.setAutoMatch(b);
        }
    }

    @Override
    public void deleteTable(String def) {
        MonsterClient client = this.getClient();
        if (client != null) {
            client.deleteTable(def);
        }
    }

    @Override
    public void saveConceptGroup(Document def) {
        MonsterClient client = this.getClient();
        if (client != null) {
            client.saveConceptGroup(def);
        }
    }

    @Override
    public void deleteConceptGroup(String def) {
        MonsterClient client = this.getClient();
        if (client != null) {
            client.deleteConceptGroup(def);
        }
    }

    @Override
    public void saveConcept(Document def) {
        MonsterClient client = this.getClient();
        if (client != null) {
            client.saveConcept(def);
        }
    }

    @Override
    public void deleteConcept(String purposeName, String purposeColumn) {
        MonsterClient client = this.getClient();
        if (client != null) {
            client.deleteConcept(purposeName, purposeColumn);
        }
    }

    @Override
    public void saveConceptMapping(Document def) {
        MonsterClient client = this.getClient();
        if (client != null) {
            client.saveConceptMapping(def);
        }
    }

    @Override
    public void deleteConceptMapping(Document def) {
        MonsterClient client = this.getClient();
        if (client != null) {
            client.deleteConceptMapping(def);
        }
    }

    @Override
    public void saveMatchRule(Document def) {
        MonsterClient client = this.getClient();
        if (client != null) {
            client.saveMatchRule(def);
        }
    }

    @Override
    public void saveMatchRules(List<Document> defs) {
        MonsterClient client = this.getClient();
        if (client != null) {
            client.saveMatchRules(defs);
        }
    }

    @Override
    public void deleteMatchRule(long order) {
        MonsterClient client = this.getClient();
        if (client != null) {
            client.deleteMatchRule(order);
        }
    }

    @Override
    public void saveFuzzyIndex(Document def) {
        MonsterClient client = this.getClient();
        if (client != null) {
            client.saveFuzzyIndex(def);
        }
    }

    @Override
    public void deleteFuzzyIndex(String def) {
        MonsterClient client = this.getClient();
        if (client != null) {
            client.deleteFuzzyIndex(def);
        }
    }

    @Override
    public Document getDefinition() {
        return null;
    }

    @Override
    public void removeFuzzy() {
        MonsterClient client = this.getClient();
        if (client != null) {
            client.removeFuzzy();
        }
    }

    @Override
    public Document getTable(String def) {
        return null;
    }

    @Override
    public void updateDefinition(Document def) {
    }

    @Override
    public void addTrigger(String name) {
        MonsterClient client = this.getClient();
        if (client != null) {
            client.addTrigger(name);
        }
    }

    @Override
    public DBCursor findRelationships(Document filter) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.findRelationships(filter);
        }
        return null;
    }

    @Override
    public DBCursor findTasks(Document filter) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.findTasks(filter);
        }
        return null;
    }

    @Override
    public Document saveRelationship(Document relationship) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.saveRelationship(relationship);
        }
        return null;
    }

    @Override
    public void resolveTask(Document taskData) {
        MonsterClient client = this.getClient();
        if (client != null) {
            client.resolveTask(taskData);
        }
    }

    @Override
    public DBCursor aggregateTasks(ArrayList<Document> andlist) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.aggregateTasks(andlist);
        }
        return null;
    }

    @Override
    public Document updateTask(String id, Document doc) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.updateTask(id, doc);
        }
        return null;
    }

    @Override
    public <TResult> Iterable<TResult> distinctRelationship(String fieldName, Class<TResult> resultClass) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.distinct(fieldName, resultClass);
        }
        return null;
    }

    @Override
    public Document updateRelationship(Document document, Document setUpdate, Document options) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.updateRelationship(document, setUpdate, options);
        }
        return null;
    }

    @Override
    public DBCursor peekQueue() {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.peekQueue();
        }
        return null;
    }

    @Override
    public void deleteTasks(Document document) {
        MonsterClient client = this.getClient();
        if (client != null) {
            client.deleteTasks(document);
        }
    }

    @Override
    public void deleteRelationships(Document document) {
        MonsterClient client = this.getClient();
        if (client != null) {
            client.deleteTasks(document);
        }
    }

    @Override
    public Stream<Document> findStream(Document filter) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.findStream(filter);
        }
        return Stream.empty();
    }

    @Override
    public Map<Integer, ICollection> getReplicaConnections() {
        try {
            throw new Exception("Replicas cannot be seen from a Remote Collection");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Database getDatabase() {
        try {
            throw new Exception("Database cannot be seen from a Remote Collection");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String getTrigger() {
        try {
            throw new Exception("Triggers cannot be seen from a Remote Collection");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Map<Document, List<Document>> split(List<Document> list, Stream<Document> in, Document options) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.split(list, in, options);
        }
        return null;
    }

    @Override
    public Document fuzzyMatch(Document matchNode, List<IIndex> matchIndexes) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.fuzzyMatch(matchNode, matchIndexes);
        }
        return null;
    }

    @Override
    public Stream<Document> match(Document asDocument, Stream<Document> in, Document options) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.match(asDocument, in, options).collect(Collectors.toList()).stream();
        }
        return null;
    }

    @Override
    public Stream<Document> analyse(Document asDocument, Stream<Document> in, Document options) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.analyse(asDocument, in, options).collect(Collectors.toList()).stream();
        }
        return null;
    }

    @Override
    public Stream<Document> limit(long amount, Stream<Document> in, Document options) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.limit(amount, in, options).collect(Collectors.toList()).stream();
        }
        return null;
    }

    @Override
    public Stream<Document> lookup(Document asDocument, Stream<Document> in, Document options) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.lookup(asDocument, in, options).collect(Collectors.toList()).stream();
        }
        return null;
    }

    @Override
    public Stream<Document> join(Document asDocument, Stream<Document> in, Document options) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.join(asDocument, in, options).collect(Collectors.toList()).stream();
        }
        return null;
    }

    @Override
    public Stream<Document> minus(Document asDocument, Stream<Document> in, Document options) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.minus(asDocument, in, options).collect(Collectors.toList()).stream();
        }
        return null;
    }

    @Override
    public Stream<Document> skip(long amount, Stream<Document> in, Document options) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.skip(amount, in, options).collect(Collectors.toList()).stream();
        }
        return null;
    }

    @Override
    public Stream<Document> group(Document asDocument, Stream<Document> in, Document options) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.group(asDocument, in, options).collect(Collectors.toList()).stream();
        }
        return null;
    }

    @Override
    public Stream<Document> out(String collectionName, Stream<Document> in, Document options) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.out(collectionName, in, options).collect(Collectors.toList()).stream();
        }
        return null;
    }

    @Override
    public Stream<Document> sort(Document asDocument, Stream<Document> in, Document options) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.sort(asDocument, in, options).collect(Collectors.toList()).stream();
        }
        return null;
    }

    @Override
    public Stream<Document> bucket(Document asDocument, Stream<Document> in, Document options) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.bucket(asDocument, in, options).collect(Collectors.toList()).stream();
        }
        return null;
    }

    @Override
    public Stream<Document> fuzzySearch(String string, Stream<Document> in, Document options) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.fuzzySearch(string, in, options).collect(Collectors.toList()).stream();
        }
        return null;
    }

    @Override
    public Stream<Document> fuzzyMatch(Document asDocument, Stream<Document> in, Document options) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.fuzzyMatch(asDocument, in, options).collect(Collectors.toList()).stream();
        }
        return null;
    }

    @Override
    public Stream<Document> unwind(Document asDocument, Stream<Document> in, Document options) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.unwind(asDocument, in, options).collect(Collectors.toList()).stream();
        }
        return null;
    }

    @Override
    public Stream<Document> spinOut(Document asDocument, Stream<Document> in, Document options) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.spinOut(asDocument, in, options).collect(Collectors.toList()).stream();
        }
        return null;
    }

    @Override
    public Stream<Document> getRelated(Document asDocument, Stream<Document> in, Document options) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.getRelated(asDocument, in, options).collect(Collectors.toList()).stream();
        }
        return null;
    }

    @Override
    public Stream<Document> rematch(Document asDocument, Stream<Document> in, Document options) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.rematch(asDocument, in, options).collect(Collectors.toList()).stream();
        }
        return null;
    }

    @Override
    public Stream<Document> classifierBuild(Document asDocument, Stream<Document> in, Document options) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.classifierBuild(asDocument, in, options).collect(Collectors.toList()).stream();
        }
        return null;
    }

    @Override
    public Stream<Document> classifierPredict(Document asDocument, Stream<Document> in, Document options) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.classifierPredict(asDocument, in, options).collect(Collectors.toList()).stream();
        }
        return null;
    }

    @Override
    public Stream<Document> arrf(Document asDocument, Stream<Document> in, Document options) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.arrf(asDocument, in, options).collect(Collectors.toList()).stream();
        }
        return null;
    }

    @Override
    public Stream<Document> classifierTree(Document asDocument, Stream<Document> in, Document options) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.classifierTree(asDocument, in, options).collect(Collectors.toList()).stream();
        }
        return null;
    }

    @Override
    public Stream<Document> coerce(Document asDocument, Stream<Document> in, Document options) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.coerce(asDocument, in, options).collect(Collectors.toList()).stream();
        }
        return null;
    }

    @Override
    public Stream<Document> compare(Document asDocument, Stream<Document> in, Document options) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.compare(asDocument, in, options).collect(Collectors.toList()).stream();
        }
        return null;
    }

    @Override
    public Stream<Document> count(Document asDocument, Stream<Document> in, Document options) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.count(asDocument, in, options).collect(Collectors.toList()).stream();
        }
        return null;
    }

    @Override
    public Stream<Document> first(Document asDocument, Stream<Document> in, Document options) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.first(asDocument, in, options).collect(Collectors.toList()).stream();
        }
        return null;
    }

    @Override
    public Stream<Document> last(Document asDocument, Stream<Document> in, Document options) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.last(asDocument, in, options).collect(Collectors.toList()).stream();
        }
        return null;
    }

    @Override
    public Stream<Document> between(Document asDocument, Stream<Document> in, Document options) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.between(asDocument, in, options).collect(Collectors.toList()).stream();
        }
        return null;
    }

    @Override
    public Stream<Document> cluster(Document asDocument, Stream<Document> in, Document options) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.cluster(asDocument, in, options).collect(Collectors.toList()).stream();
        }
        return null;
    }

    @Override
    public Stream<Document> project(Document asDocument, Stream<Document> in, Document options) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.project(asDocument, in, options).collect(Collectors.toList()).stream();
        }
        return null;
    }

    @Override
    public Stream<Document> evaluate(Document asDocument, Stream<Document> in, Document options) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.evaluate(asDocument, in, options).collect(Collectors.toList()).stream();
        }
        return null;
    }

    @Override
    public DBCursor traverseTop(Document from, String relType) {
        return null;
    }

    @Override
    public Stream<Document> writeRel(Document options, Stream<Document> in, Document goptions) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.writeRel(options, in, goptions).collect(Collectors.toList()).stream();
        }
        return null;
    }

    @Override
    public Stream<Document> script(Document scriptStatements, Stream<Document> in, Document stageoptions) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.script(scriptStatements, in, stageoptions).collect(Collectors.toList()).stream();
        }
        return null;
    }

    @Override
    public DBCursor getMatchTypes() {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.getMatchTypes();
        }
        return new DBCursor();
    }

    @Override
    public void saveFuzzyIndexes(List<Document> def) {
        MonsterClient client = this.getClient();
        if (client != null) {
            client.saveFuzzyIndexes(def);
        }
    }

    @Override
    public DBCursor getFlows() {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.getFlows();
        }
        return new DBCursor();
    }

    @Override
    public DBCursor getBooks() {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.getBooks();
        }
        return new DBCursor();
    }

    @Override
    public DBCursor getFlow(String name) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.getFlow(name);
        }
        return new DBCursor();
    }

    @Override
    public Stream<Document> validate(String type, Stream<Document> in, Document globalOptions) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.validate(type, in, globalOptions);
        }
        return null;
    }

    @Override
    public Stream<Document> task(Document options, Stream<Document> in, Document globalOptions) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.task(options, in, globalOptions);
        }
        return null;
    }

    @Override
    public Document saveTask(Document task) {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.saveTask(task);
        }
        return null;
    }

    @Override
    public Stream<Document> getDeltas() {
        MonsterClient client = this.getClient();
        if (client != null) {
            return client.getDeltas();
        }
        return null;
    }

    @Override
    public void updateDelta(Document doc) {
    }

    @Override
    public Stream<Document> getNodes() {
        return null;
    }
}

