/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.monster.db;

import com.entitystream.monster.db.Collection;
import com.entitystream.monster.db.CollectionLocal;
import com.entitystream.monster.db.Container;
import com.entitystream.monster.db.DBCursor;
import com.entitystream.monster.db.Database;
import com.entitystream.monster.db.Document;
import com.entitystream.monster.db.ICollection;
import com.entitystream.monster.db.Session;
import com.entitystream.monster.db.StopIterationException;
import com.entitystream.monster.db.User;
import com.entitystream.monster.db.Users;
import com.entitystream.monster.thrift.Connection;
import com.entitystream.monster.thrift.InvalidOperation;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.thrift.TException;
import org.apache.thrift.server.TThreadPoolServer;

public class ConnectionHandler
implements Connection.Iface {
    private Map<Long, Session> sessions = new HashMap<Long, Session>();
    private Container client;
    private Thread ticker;
    private Users authFile;
    private TThreadPoolServer server;
    private String dbPath;
    private String[] replicaSet;
    private User user;
    private Map<String, Document> roles;
    private int nodenum;
    private ClassLoader classLoader;

    public ConnectionHandler(String authFile, String dbPath, String[] replicaSet, int nodeNum) {
        this.authFile = Users.build(authFile);
        this.roles = this.authFile != null ? this.authFile.getRoles() : new HashMap<String, Document>();
        this.setDbPath(dbPath);
        this.replicaSet = replicaSet;
        if (this.replicaSet == null) {
            this.replicaSet = new String[0];
        }
        this.client = new Container(dbPath, this.replicaSet, nodeNum);
        this.nodenum = nodeNum;
        this.ticker = new Thread(new Runnable(){

            @Override
            public void run() {
                while (ConnectionHandler.this.sessions.size() != -1) {
                    try {
                        ArrayList<Long> removeit = new ArrayList<Long>();
                        for (Long cur : ConnectionHandler.this.sessions.keySet()) {
                            if (ConnectionHandler.this.sessions.get((Object)cur).lastTouch == -1L || ConnectionHandler.this.sessions.get((Object)cur).lastTouch + 60000L >= System.currentTimeMillis()) continue;
                            boolean anyActive = false;
                            for (AtomicBoolean ab : ConnectionHandler.this.sessions.get((Object)cur).cursorActive.values()) {
                                if (!ab.get()) continue;
                                anyActive = true;
                                break;
                            }
                            if (anyActive) continue;
                            ConnectionHandler.this.sessions.get(cur).disconnect();
                            removeit.add(cur);
                        }
                        if (removeit.size() > 0) {
                            for (long cur : removeit) {
                                ConnectionHandler.this.sessions.remove(cur);
                            }
                            System.out.println("Session pool is now " + ConnectionHandler.this.sessions.size());
                        }
                        Thread.sleep(10000L);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                System.out.println("Connection handler terminated");
            }
        });
        this.ticker.start();
        System.out.println("Server " + nodeNum + " is UP!");
        if (replicaSet != null) {
            System.out.println("Replicas are " + Arrays.toString(replicaSet));
        }
        this.loadLibs();
    }

    @Override
    public long command(long connection, String database, String collection, String command2, boolean remoteView) throws TException {
        long cursorID;
        block11: {
            cursorID = UUID.randomUUID().getLeastSignificantBits();
            try {
                if (this.sessions.containsKey(connection)) {
                    Session session = this.sessions.get(connection);
                    session.isRemote(remoteView);
                    if (command2 == null) break block11;
                    if (database != null) {
                        if (collection != null) {
                            ICollection coll = Container.getDatabase(database).getCollection(collection);
                            if (remoteView && coll instanceof Collection) {
                                coll = ((Collection)coll).getLocalCollection();
                            } else if (!remoteView && coll instanceof CollectionLocal) {
                                coll = ((CollectionLocal)coll).getParent();
                            }
                            if (remoteView && !(coll instanceof CollectionLocal)) {
                                throw new Exception("Recursive Call from Remote View to Collection (Global)");
                            }
                            if (!remoteView && !(coll instanceof Collection)) {
                                throw new Exception("Illegal Local Collection Call");
                            }
                            return session.execute(coll, command2);
                        }
                        Database db = Container.getDatabase(database);
                        return session.execute(db, command2);
                    }
                    if (command2.equalsIgnoreCase("{\"MethodName\":\"shutdown\"}")) {
                        this.client.shutdown();
                        System.exit(0);
                        break block11;
                    }
                    return session.execute(this.client, command2);
                }
                InvalidOperation io = new InvalidOperation();
                io.why = "Session Invalid";
                throw io;
            }
            catch (Exception e) {
                Logger.getGlobal().severe(e.toString());
                e.printStackTrace();
                return -1L;
            }
        }
        return cursorID;
    }

    public long addCursor(long connectionID, DBCursor cursor, String command2) {
        Session session = this.sessions.get(connectionID);
        if (session != null) {
            return session.addCursor(cursor, command2);
        }
        return -1L;
    }

    @Override
    public long connect(String username, String password) throws TException {
        if (this.authFile == null && username == null || this.authFile == null && username.equalsIgnoreCase("guest") && password.equalsIgnoreCase("guest") || this.authFile != null && (this.user = this.authFile.ok(username, password)) != null) {
            long sessionid = UUID.randomUUID().getLeastSignificantBits();
            ArrayList<Document> uroles = new ArrayList();
            if (this.user != null) {
                uroles = this.user.pullRoles(this.roles);
            }
            Session session = new Session(sessionid, this.user, uroles);
            this.sessions.put(sessionid, session);
            System.out.println("Session pool is now " + this.sessions.size());
            return sessionid;
        }
        if (this.authFile != null) {
            System.out.println("AuthFile is " + this.authFile.toString());
        }
        System.out.println("Failed to authenticate user " + username);
        return -1L;
    }

    @Override
    public ByteBuffer cursorNext(long connection, long cursor, int count) throws TException {
        int counter;
        StringBuffer sb;
        block13: {
            sb = new StringBuffer();
            try {
                sb.append("[");
                Session sess = this.sessions.get(connection);
                if (sess != null) {
                    DBCursor dbcursor = sess.getCursor(cursor);
                    if (dbcursor != null && !dbcursor.isStream()) {
                        for (counter = 0; dbcursor.hasNext() && (count == -1 || counter < count); ++counter) {
                            Document doc = dbcursor.next();
                            if (counter > 0) {
                                sb.append(",");
                            }
                            sb.append(doc.toJson());
                        }
                        if (!dbcursor.hasNext()) {
                            this.sessions.get(connection).removeCursor(cursor);
                        }
                    } else if (dbcursor != null && dbcursor.isStream()) {
                        Document readAhead = dbcursor.streamGet();
                        if (readAhead != null) {
                            sb.append(readAhead.toJson());
                            ++counter;
                        } else {
                            this.sessions.get(connection).removeCursor(cursor);
                        }
                    }
                    break block13;
                }
                InvalidOperation io = new InvalidOperation();
                io.why = "Session Invalid";
                throw io;
            }
            catch (StopIterationException sess) {
            }
            catch (Exception e) {
                InvalidOperation io = new InvalidOperation();
                io.why = e.toString();
                throw io;
            }
        }
        sb.append("]");
        if (counter != 0) {
            return ByteBuffer.wrap(sb.toString().getBytes());
        }
        return ByteBuffer.allocate(0);
    }

    @Override
    public void closeCursor(long connection, long cursor) throws TException {
        this.sessions.get(connection).removeCursor(cursor);
    }

    @Override
    public void closeConnection(long connection) throws TException {
        this.sessions.get(connection).disconnect();
        this.sessions.remove(connection);
    }

    public void setServer(TThreadPoolServer server2) {
        this.server = server2;
    }

    public String getDbPath() {
        return this.dbPath;
    }

    public void setDbPath(String dbPath) {
        this.dbPath = dbPath;
    }

    public int getNodeNum() {
        return this.nodenum;
    }

    public void installLib(File file) {
        try {
            File lib = new File(this.dbPath + File.separator + "libs" + File.separator + file.getName());
            FileUtils.copyFile((File)file, (File)lib);
            this.loadLibs();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public void loadLibs() {
        try {
            File libs = new File(this.dbPath + File.separator + "libs" + File.separator);
            File[] flibs = libs.listFiles();
            if (flibs != null) {
                URL[] ulibs = new URL[flibs.length];
                for (int p = 0; p < flibs.length; ++p) {
                    ulibs[p] = flibs[p].toURL();
                }
                this.classLoader = URLClassLoader.newInstance(ulibs, Thread.currentThread().getContextClassLoader());
            } else {
                this.classLoader = Thread.currentThread().getContextClassLoader();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Cannot load libraries from custom jar files. Reason: " + ex.getMessage());
        }
    }
}

