/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.monster.db;

import com.entitystream.identiza.metadata.IdentizaSettings;
import com.entitystream.identiza.wordlist.RuleFactory;
import com.entitystream.identiza.wordlist.RuleSet;
import com.entitystream.identiza.wordlist.RuleSetMap;
import com.entitystream.monster.db.BasicDBList;
import com.entitystream.monster.db.DBCursor;
import com.entitystream.monster.db.Database;
import com.entitystream.monster.db.Document;
import com.entitystream.monster.db.ICollection;
import com.entitystream.monster.db.MethodNotFoundException;
import com.entitystream.monster.db.MonsterClient;
import com.entitystream.monster.db.Session;
import com.entitystream.monster.db.User;
import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ClassUtils;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import weka.classifiers.AbstractClassifier;
import weka.core.Drawable;

public class Container {
    private static Map<String, Database> databases = new HashMap<String, Database>();
    private static String dataPath;
    private static String rulePath;
    private static String[] replicaSet;
    private static boolean debug;
    private static int nodeNum;
    private static boolean remoteView;

    public Container(String dbPath, String[] replicaSet1, int node) {
        IdentizaSettings.setWorkingDir((String)dbPath);
        RuleFactory.setOffline();
        rulePath = IdentizaSettings.getApplicationRootPath((String)"rules");
        new File(rulePath).mkdirs();
        RuleFactory.setRuleSetMap((RuleSetMap)RuleSetMap.readMap((String)rulePath));
        dataPath = IdentizaSettings.getApplicationRootPath((String)"db");
        new File(dataPath).mkdirs();
        replicaSet = replicaSet1;
        nodeNum = node;
    }

    public static Database getDatabase(String name) {
        if (databases.containsKey(name)) {
            return databases.get(name);
        }
        Database newone = new Database(name, false, replicaSet, nodeNum);
        databases.put(name, newone);
        newone.setExplain(debug);
        return newone;
    }

    public static Database createDatabase(String name) {
        if (!databases.containsKey(name)) {
            Database newone = new Database(name, false, replicaSet, nodeNum);
            databases.put(name, newone);
            newone.setExplain(debug);
            return newone;
        }
        return databases.get(name);
    }

    public static void dropDatabase(String name) {
        if (databases.containsKey(name)) {
            databases.get(name).drop();
            databases.remove(name);
        } else {
            new Database(name, false, replicaSet, nodeNum).drop();
        }
    }

    public static Database getDatabaseRO(String name) {
        if (databases.containsKey(name)) {
            return databases.get(name);
        }
        Database newone = new Database(name, true, replicaSet, nodeNum);
        newone.setExplain(debug);
        databases.put(name, newone);
        return newone;
    }

    public BasicDBList listClassifiers() {
        BasicDBList list = new BasicDBList();
        Reflections reflections = new Reflections("weka.classifiers", new Scanner[0]);
        Set classes = reflections.getSubTypesOf(AbstractClassifier.class);
        classes.retainAll(reflections.getSubTypesOf(Drawable.class));
        for (Class implClass : classes) {
            list.add(implClass.getName().replaceAll("weka.classifiers.", ""));
        }
        return list;
    }

    public BasicDBList listDatabaseNames() {
        File fpath = new File(dataPath);
        if (!fpath.exists()) {
            fpath.mkdirs();
        }
        BasicDBList list = new BasicDBList();
        File[] lp = fpath.listFiles();
        if (lp != null) {
            for (File filename : lp) {
                if (filename.isDirectory() || filename.getName().startsWith(".")) continue;
                list.add(filename.getName());
            }
        }
        return list;
    }

    public static void setDebug(boolean ddebug) {
        debug = ddebug;
    }

    public void disconnect(String dbn) throws Exception {
        System.out.println("Closing " + dbn);
        Database db = databases.get(dbn);
        if (db != null) {
            db.close();
            databases.remove(dbn);
        }
        System.out.println("Closed " + dbn);
    }

    public DBCursor executeCommand(String command2, User user, Session session) {
        return Container.executeCommand(this, command2, user, session);
    }

    public static DBCursor executeCommand(Object on, String command2, User user, Session session) {
        block15: {
            try {
                Document cmdDoc = Document.parse(command2);
                if (cmdDoc.getString("MethodName") == null || cmdDoc.getString("MethodName").length() == 0) {
                    return null;
                }
                ArrayList<String> nparts = null;
                if (cmdDoc.containsKey("nextParts")) {
                    nparts = new ArrayList<String>();
                    for (String o : cmdDoc.getString("nextParts").split(",(?=([^\"]*\"[^\"]*\")*[^\"]*$)")) {
                        if (o.length() <= 0) continue;
                        nparts.add(o.replaceFirst("^.", ""));
                    }
                    cmdDoc.remove("nextParts");
                }
                Method methodToUse = null;
                Object[] args = null;
                for (Method m : on.getClass().getMethods()) {
                    if (!m.getName().equals(cmdDoc.getString("MethodName"))) continue;
                    int found = 0;
                    args = new Object[m.getParameterCount()];
                    int pos = 0;
                    for (Parameter p : m.getParameters()) {
                        ++pos;
                        for (String key : cmdDoc.keyString()) {
                            if (!key.equalsIgnoreCase("" + pos) || !ClassUtils.isAssignable(p.getType(), cmdDoc.get(key).getClass(), (boolean)true) && !p.getType().isAssignableFrom(cmdDoc.get(key).getClass())) continue;
                            args[found] = cmdDoc.get(key);
                            ++found;
                        }
                    }
                    if (found != m.getParameterCount() || found != cmdDoc.size() - 1) continue;
                    methodToUse = m;
                    break;
                }
                if (methodToUse != null) {
                    try {
                        Object ret = methodToUse.invoke(on, args);
                        if (ret != null) {
                            DBCursor dbc = null;
                            dbc = ret instanceof DBCursor ? (DBCursor)ret : new DBCursor(ret);
                            if (dbc != null && nparts != null && nparts.size() > 0) {
                                for (String part : nparts) {
                                    if (part.length() <= 0) continue;
                                    dbc = Container.followOn(dbc, part, user, session);
                                }
                            }
                            return dbc;
                        }
                        break block15;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break block15;
                }
                if (args == null) {
                    throw new MethodNotFoundException(on.getClass().getSimpleName() + "." + cmdDoc.getString("MethodName") + "()");
                }
                throw new MethodNotFoundException(on.getClass().getSimpleName() + "." + cmdDoc.getString("MethodName") + "(" + cmdDoc.toJson() + ")");
            }
            catch (Exception e) {
                e.printStackTrace();
                Logger.getLogger("").severe(e.toString());
                return new DBCursor(new Document("Error", e.toString()));
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static DBCursor followOn(DBCursor dbc, String argString, User user, Session session) {
        String command2 = argString;
        if (argString.indexOf("(") != -1) {
            command2 = argString.substring(0, argString.indexOf("("));
            if ((argString = argString.substring(argString.indexOf("(") + 1)).indexOf(")") != -1) {
                argString = argString.substring(0, argString.indexOf(")"));
            }
        }
        ArrayList<Object> args = null;
        if (argString.length() != 0) {
            if (argString.trim().startsWith("{") || argString.trim().startsWith("[")) {
                Object argso = Document.parseListOrDoc(argString);
                if (argso instanceof String) {
                    System.err.println("Error: " + (String)argso);
                    return null;
                }
                args = (List)argso;
            } else {
                String[] arganaught = argString.split(",");
                if (arganaught.length > 0) {
                    void var9_12;
                    args = new ArrayList<Object>();
                    String[] stringArray = arganaught;
                    int n = stringArray.length;
                    boolean bl = false;
                    while (var9_12 < n) {
                        String a = stringArray[var9_12];
                        if (a.trim().startsWith("\"") || a.trim().startsWith("'")) {
                            args.add(a.replaceAll("\\\"|'", "").trim());
                        } else {
                            try {
                                args.add(Double.parseDouble(a.trim()));
                            }
                            catch (NumberFormatException n2) {
                                try {
                                    args.add(Boolean.parseBoolean(a.trim()));
                                }
                                catch (Exception e) {
                                    args.add(a);
                                }
                            }
                        }
                        ++var9_12;
                    }
                }
            }
        }
        if (args != null && args.size() == 0) {
            args = null;
        }
        int count = 0;
        Document argDc = null;
        if (args != null) {
            argDc = new Document();
            for (Object e : args) {
                argDc.put("" + ++count, e);
            }
            argDc.append("MethodName", command2);
        } else {
            argDc = new Document("MethodName", command2);
        }
        return Container.executeCommand(dbc, argDc.toJson(), user, session);
    }

    public void shutdown() throws Exception {
        for (String dbn : databases.keySet()) {
            this.disconnect(dbn);
        }
    }

    public int getNodeNum() {
        return nodeNum;
    }

    public void setDBPath(String dbPath) {
        dataPath = dbPath;
    }

    public static void setRuleSet(RuleSetMap map) {
        RuleFactory.setOffline();
        RuleFactory.setRuleSetMap((RuleSetMap)map);
        RuleSetMap.writeMap((String)rulePath, (RuleSetMap)map);
    }

    public static void setRuleSet(Document doc) {
        RuleFactory.setOffline();
        RuleSetMap map = RuleSetMap.toMap((Document)Document.parse(doc.toJson()));
        RuleFactory.setRuleSetMap((RuleSetMap)map);
        RuleSetMap.writeMap((String)rulePath, (RuleSetMap)map);
    }

    public static String getRuleSetPath() {
        return rulePath;
    }

    public static void installRules() {
        Container.installRules("MatchCompanyName,MatchPersonName,MatchCountry");
    }

    public static void installRules(String list2) {
        String[] list = list2.split(",");
        ArrayList<String> cleanList = new ArrayList<String>();
        for (String fi : list) {
            cleanList.add(fi.trim());
        }
        RuleFactory.invalidate();
        for (String purpose : cleanList) {
            ArrayList elemlist = (ArrayList)RuleFactory.executeApiCall((String)("rule/" + purpose));
            if (elemlist == null) continue;
            System.out.println("Installing " + elemlist.size() + " " + purpose + " rules");
            RuleFactory.build((String)purpose, (List)elemlist);
        }
        RuleSetMap rsm = RuleFactory.getRuleSetMap();
        System.out.println("Writing to " + rulePath);
        RuleSetMap.writeMap((String)rulePath, (RuleSetMap)rsm);
        for (String client : replicaSet) {
            MonsterClient clientC = new MonsterClient(client);
            clientC.setRuleSet(rsm);
            try {
                clientC.disconnect();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Container.setRuleSet(rsm);
    }

    public static void setRuleSetPath(String path) {
        RuleFactory.setOffline();
        RuleSetMap rsm = RuleSetMap.readMap((String)path);
        for (String client : replicaSet) {
            MonsterClient clientC = new MonsterClient(client);
            clientC.setRuleSet(rsm);
            try {
                clientC.disconnect();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Container.setRuleSet(rsm);
    }

    public static void saveRuleSet(String path) {
        RuleSetMap rsm = RuleFactory.getRuleSetMap();
        RuleSetMap.writeMap((String)path, (RuleSetMap)rsm);
    }

    public void saveQualityRule(Document def) {
        RuleSet rules = (RuleSet)RuleFactory.getRuleSetMap().get((Object)def.getString("rulePurpose"));
        RuleSet.updateRuleSet((RuleSet)rules, Collections.singletonList(def).iterator());
        Container.saveRuleSet(rulePath);
    }

    public DBCursor findQualityRules(Document def) {
        String p = def.getString("rulePurpose");
        Set<Object> purps = new HashSet();
        purps = p != null ? Collections.singleton(p) : RuleFactory.getRuleSetMap().keySet();
        ArrayList docs = new ArrayList();
        for (String string : purps) {
            RuleSet rules = (RuleSet)RuleFactory.getRuleSetMap().get((Object)string);
            docs.addAll(rules.toDocuments(string, false));
            docs.addAll(rules.toDocuments(string, true));
        }
        return new DBCursor(ICollection.filter(def, docs.stream(), new Document()).collect(Collectors.toList()));
    }

    public void setRemoteView(boolean remoteViw) {
        remoteView = remoteViw;
    }

    static {
        rulePath = IdentizaSettings.getApplicationRootPath((String)"rules");
        remoteView = false;
    }
}

