/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.monster.db;

import com.entitystream.monster.db.AggregateIterable;
import com.entitystream.monster.db.Document;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DBCursor
implements Iterable<Document>,
Iterator<Document> {
    private List<Document> cursor;
    private Stream<Document> stream;
    private int position = 0;
    private Iterator<Document> intIterator;
    LinkedBlockingQueue<Document> blockering;
    Thread background;
    private AtomicBoolean inProgress;
    AtomicBoolean stop = new AtomicBoolean(false);
    private String statement;

    DBCursor(List<Document> inlist) {
        this.cursor = inlist;
    }

    public DBCursor() {
        this.cursor = new ArrayList<Document>();
    }

    public DBCursor(Object ret) {
        if (ret == null) {
            this.cursor = new ArrayList<Document>();
        } else if (ret instanceof Document) {
            this.cursor = new ArrayList<Document>();
            this.cursor.add((Document)ret);
        } else if (ret instanceof String) {
            this.cursor = new ArrayList<Document>();
            this.cursor.add(new Document("String", ret));
        } else if (ret instanceof Number) {
            this.cursor = new ArrayList<Document>();
            this.cursor.add(new Document("Number", ret));
        } else if (ret instanceof List) {
            this.cursor = new ArrayList<Document>();
            for (Object o : (List)ret) {
                if (o instanceof Document) {
                    this.cursor.add((Document)o);
                    continue;
                }
                if (o instanceof Map) {
                    this.cursor.add(new Document((Map)o));
                    continue;
                }
                this.cursor.add(new Document("value", o));
            }
        } else if (ret instanceof Set) {
            this.cursor = new ArrayList<Document>();
            for (Object o : (Set)ret) {
                if (o instanceof Document) {
                    this.cursor.add((Document)o);
                    continue;
                }
                if (o instanceof Map) {
                    this.cursor.add(new Document((Map)o));
                    continue;
                }
                this.cursor.add(new Document("value", o));
            }
        } else if (ret instanceof AggregateIterable) {
            this.cursor = new ArrayList<Document>();
            Iterator<Document> it = ((AggregateIterable)ret).iterator();
            if (it != null) {
                while (it.hasNext()) {
                    Document o = it.next();
                    if (o instanceof Document) {
                        this.cursor.add(o);
                        continue;
                    }
                    this.cursor.add(new Document("value", o));
                }
            }
        } else if (ret instanceof Iterable) {
            this.cursor = new ArrayList<Document>();
            Iterable it = (Iterable)ret;
            if (it != null) {
                for (Object o : it) {
                    if (o instanceof Document) {
                        this.cursor.add((Document)o);
                        continue;
                    }
                    this.cursor.add(new Document("value", o));
                }
            }
        } else if (ret instanceof Stream) {
            this.stream = (Stream)ret;
        }
    }

    public DBCursor extend(DBCursor more) {
        if (this.cursor != null) {
            this.cursor.addAll(more.list());
        }
        return this;
    }

    public void add(Document d) {
        if (this.cursor != null) {
            this.cursor.add(d);
        }
    }

    public Collection<? extends Document> list() {
        if (this.cursor != null) {
            return this.cursor;
        }
        return null;
    }

    @Override
    public Iterator<Document> iterator() {
        if (this.cursor != null) {
            return this.cursor.iterator();
        }
        if (this.stream != null) {
            if (this.intIterator == null) {
                this.intIterator = this.stream.iterator();
            }
            return this.intIterator;
        }
        return null;
    }

    public DBCursor limit(long limit) {
        if (this.cursor != null) {
            return new DBCursor(this.cursor.stream().limit(limit).collect(Collectors.toList()));
        }
        if (this.stream != null) {
            return new DBCursor(this.stream.limit(limit));
        }
        return null;
    }

    public DBCursor skip(long skip) {
        if (this.cursor != null) {
            return new DBCursor(this.cursor.stream().skip(skip).collect(Collectors.toList()));
        }
        if (this.stream != null) {
            return new DBCursor(this.stream.skip(skip));
        }
        return null;
    }

    public Document first() {
        if (this.cursor.size() > 0) {
            return this.cursor.get(0);
        }
        if (this.stream != null && this.iterator().hasNext()) {
            this.iterator().next();
        }
        return null;
    }

    public Document last() {
        if (this.cursor.size() > 0) {
            return this.cursor.get(this.cursor.size() - 1);
        }
        if (this.stream != null) {
            this.iterator().next();
        }
        return null;
    }

    public int count() {
        if (this.cursor != null) {
            return this.cursor.size();
        }
        return 0;
    }

    public Stream<Document> stream() {
        if (this.stream == null && this.cursor != null) {
            return this.cursor.stream();
        }
        return this.stream;
    }

    @Override
    public boolean hasNext() {
        if (this.cursor != null) {
            return this.position < this.cursor.size();
        }
        if (this.stream != null) {
            return this.iterator().hasNext();
        }
        return false;
    }

    @Override
    public Document next() {
        if (this.cursor != null && this.hasNext()) {
            this.toggleInProgress(true);
            Document next = this.cursor.get(this.position++);
            if (next instanceof Document) {
                this.toggleInProgress(false);
                return next;
            }
        }
        this.toggleInProgress(false);
        return null;
    }

    public Iterable<Document> sort(final Document object) {
        return this.cursor.stream().sorted(new Comparator(){

            public int compare(Object doc1, Object doc2) {
                int c = 0;
                if (object != null) {
                    for (Object key : object.keySet()) {
                        Object v1 = ((Document)doc1).getProjection((String)key);
                        Object v2 = ((Document)doc2).getProjection((String)key);
                        int dir = object.getInteger((String)key, 1);
                        if (v1 instanceof String && v2 instanceof String) {
                            c = v1.toString().compareTo(v2.toString()) * dir;
                        } else if (v1 instanceof Number && v2 instanceof Number) {
                            c = Double.valueOf(((Number)v1).doubleValue()).compareTo(((Number)v2).doubleValue()) * dir;
                        } else if (v1 instanceof Date && v2 instanceof Date) {
                            c = ((Date)v1).compareTo((Date)v2) * dir;
                        } else if (v1 instanceof Boolean && v2 instanceof Boolean) {
                            c = ((Boolean)v1).compareTo((Boolean)v2) * dir;
                        } else if (v1 instanceof List && v2 instanceof List) {
                            Iterator iterator = ((List)v1).iterator();
                            if (iterator.hasNext()) {
                                Object it1 = iterator.next();
                                Iterator iterator2 = ((List)v2).iterator();
                                if (iterator2.hasNext()) {
                                    Object it2 = iterator2.next();
                                    int _c = 0;
                                    if (it1 instanceof String && it2 instanceof String) {
                                        _c = v1.toString().compareTo(v2.toString()) * dir;
                                    } else if (it1 instanceof Number && it2 instanceof Number) {
                                        _c = Double.valueOf(((Number)it1).doubleValue()).compareTo(((Number)it2).doubleValue()) * dir;
                                    } else if (it1 instanceof Date && it2 instanceof Date) {
                                        _c = ((Date)it1).compareTo((Date)it2) * dir;
                                    } else if (it1 instanceof Boolean && it2 instanceof Boolean) {
                                        _c = ((Boolean)it1).compareTo((Boolean)it2) * dir;
                                    }
                                    c = _c;
                                }
                            }
                        } else {
                            c = dir;
                        }
                        if (c == 0) continue;
                        return c;
                    }
                }
                return c;
            }
        }).collect(Collectors.toList());
    }

    public Iterable<Document> projection(Document projection) {
        return ((Stream)this.cursor.stream().parallel()).map(doc -> {
            Document doco = new Document();
            for (Object k : projection.keySet()) {
                doco.append((String)k, doc.getProjection((String)k));
            }
            return doco;
        }).collect(Collectors.toList());
    }

    public DBCursor allowDiskUse(boolean b) {
        if (this.cursor instanceof AggregateIterable) {
            ((AggregateIterable)((Object)this.cursor)).allowDiskUse(b);
        }
        return this;
    }

    public boolean isStream() {
        return this.stream != null;
    }

    public Document streamGet() {
        if (this.blockering == null) {
            this.blockering = new LinkedBlockingQueue(100);
            this.background = new Thread(new Runnable(){

                @Override
                public void run() {
                    DBCursor.this.stream().forEach(doc -> {
                        try {
                            while (!DBCursor.this.blockering.offer((Document)doc, 100L, TimeUnit.MILLISECONDS)) {
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    });
                    DBCursor.this.stop.set(true);
                }
            });
            this.background.start();
        }
        try {
            Document d = null;
            while (!(d != null || this.stop.get() && this.blockering.peek() == null)) {
                this.toggleInProgress(true);
                d = this.blockering.poll(1000L, TimeUnit.MILLISECONDS);
            }
            this.toggleInProgress(false);
            return d;
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    public void destroy() {
        if (this.blockering != null) {
            this.blockering.clear();
        }
        if (this.background != null) {
            this.background.interrupt();
        }
        this.blockering = null;
        this.background = null;
        this.stream = null;
        this.cursor = null;
    }

    public void toggleInProgress(boolean b) {
        if (this.inProgress == null) {
            this.inProgress = new AtomicBoolean(b);
        } else {
            this.inProgress.set(b);
        }
    }

    public void setInProgress(AtomicBoolean ab) {
        this.inProgress = ab;
    }

    public void setStatement(String statement) {
        this.statement = statement;
    }
}

