/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.monster.db;

import com.entitystream.monster.db.ConnectionHandler;
import com.entitystream.monster.thrift.Connection;
import org.apache.thrift.TProcessor;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;

public class DBServer {
    private static ConnectionHandler handler;
    private static Connection.Processor processor;
    private static TThreadPoolServer server;

    public static void start(final int port, int httpport, String authFile, String dbPath, String[] replicaSet, int node) {
        try {
            handler = new ConnectionHandler(authFile, dbPath, replicaSet, node);
            processor = new Connection.Processor<ConnectionHandler>(handler);
            Runnable secure = new Runnable(){

                @Override
                public void run() {
                    DBServer.server(port, processor);
                }
            };
            Thread thread = new Thread(secure);
            thread.start();
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public static void stop() {
        server.stop();
    }

    public static void server(int port, Connection.Processor processor) {
        try {
            TServerSocket serverTransport = new TServerSocket(port);
            TThreadPoolServer.Args args = (TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)serverTransport).processor((TProcessor)processor);
            server = new TThreadPoolServer(args);
            System.out.println("Starting the MonsterDB thread pool server...");
            System.out.println("Listening on " + port);
            handler.setServer(server);
            server.serve();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ConnectionHandler getHandler() {
        return handler;
    }

    public static int getNodeNum() {
        if (handler != null) {
            return handler.getNodeNum();
        }
        return -1;
    }

    public static void main(String[] args) {
        if (args.length == 6) {
            DBServer.start(Integer.parseInt(args[0]), Integer.parseInt(args[1]), args[2], args[3], args[4].split(","), Integer.parseInt(args[5]));
        }
    }
}

