/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.monster.db;

import com.entitystream.identiza.metadata.IdentizaSettings;
import com.entitystream.monster.db.BasicDBList;
import com.entitystream.monster.db.Collection;
import com.entitystream.monster.db.CollectionLocal;
import com.entitystream.monster.db.Container;
import com.entitystream.monster.db.DBCursor;
import com.entitystream.monster.db.Document;
import com.entitystream.monster.db.ICollection;
import com.entitystream.monster.db.MonsterClient;
import com.entitystream.monster.db.NoDatabaseException;
import com.entitystream.monster.db.Session;
import com.entitystream.monster.db.User;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.apache.commons.io.FileUtils;
import org.mapdb.DB;
import org.mapdb.DBMaker;

public class Database
implements Serializable {
    private String dataPath;
    private transient DB data;
    private Map<String, Document> collections;
    private Map<String, ICollection> openCollections = new HashMap<String, ICollection>();
    private String name;
    private boolean ro = false;
    private boolean explain = false;
    private List<String> replicaSet = new ArrayList<String>();
    private int nodeNum;
    private boolean remoteView = false;
    private Invocable invocable;

    Database(String name, boolean allowRO, String[] replicaSet, int node) {
        if (replicaSet != null) {
            for (String rp : replicaSet) {
                this.replicaSet.add(rp);
            }
        }
        this.nodeNum = node;
        this.dataPath = IdentizaSettings.getApplicationRootPath((String)"db");
        File fpath = new File(this.dataPath);
        if (!fpath.exists()) {
            fpath.mkdirs();
        }
        this.name = name;
        this.ro = allowRO;
        DB _data = this.getData(this.ro);
        if (_data != null) {
            try {
                this.collections = _data.hashMap("Collections").createOrOpen();
            }
            catch (Exception e) {
                throw new NoDatabaseException("Read Only databases must exist before connected to");
            }
        }
        this.setupJS();
    }

    private void setupJS() {
        File jsPath = new File(this.dataPath + File.separator + this.name + ".js");
        if (jsPath.exists()) {
            try {
                ScriptEngineManager manager = new ScriptEngineManager();
                ScriptEngine engine = manager.getEngineByName("JavaScript");
                engine.eval(Files.newBufferedReader(Paths.get(jsPath.getAbsolutePath(), new String[0]), StandardCharsets.UTF_8));
                this.invocable = (Invocable)((Object)engine);
                try {
                    this.invocable.invokeFunction("init", this);
                }
                catch (NoSuchMethodException e) {
                    System.out.println("Warning: No init function defined in " + jsPath.getAbsolutePath());
                }
            }
            catch (Exception e) {
                System.out.println("Scripting engine failed to start..." + jsPath.getAbsolutePath());
                System.out.println(e.toString());
            }
        }
    }

    private DB getData() {
        return this.getData(false);
    }

    private DB getData(boolean allowRO) {
        if (this.data == null) {
            DBMaker.Maker _data = DBMaker.fileDB((String)(this.dataPath + File.separator + this.name)).fileMmapEnable().checksumHeaderBypass().closeOnJvmShutdown();
            try {
                if (allowRO) {
                    _data = _data.readOnly();
                }
                this.data = _data.make();
            }
            catch (Exception e) {
                Logger.getAnonymousLogger().severe("Database can not be found: " + e.toString());
            }
        }
        return this.data;
    }

    public java.util.Collection getTempStore(String name) {
        return (java.util.Collection)this.getData().hashSet(name).createOrOpen();
    }

    public ICollection getRelCollection(String name) throws NoDatabaseException {
        ICollection relCollection = null;
        if (!this.collections.containsKey(name = this.cleanName(name))) {
            Document collDoc = new Document("Name", name).append("DBPath", this.dataPath).append("Path", File.separator + this.name + "_Collections" + File.separator).append("Internal", true).append("ReplicaSet", this.replicaSet);
            relCollection = this.createCollection(collDoc);
            if (relCollection != null) {
                relCollection.createIndex(new Document("fromCol", 1));
                relCollection.createIndex(new Document("toCol", 1));
            }
        } else {
            relCollection = this.getCollection(name);
        }
        return relCollection;
    }

    public ICollection getTaskCollection(String name) throws NoDatabaseException {
        name = this.cleanName(name);
        ICollection taskCollection = null;
        if (!this.collections.containsKey(name)) {
            Document collDoc = new Document("Name", name).append("DBPath", this.dataPath).append("Path", File.separator + this.name + "_Collections" + File.separator).append("Internal", true).append("ReplicaSet", this.replicaSet);
            taskCollection = this.createCollection(collDoc);
            if (taskCollection != null) {
                taskCollection.createIndex(new Document("Table", 1));
                taskCollection.createIndex(new Document("TaskID", 1), new Document("unique", true));
            }
        } else {
            taskCollection = this.getCollection(name);
        }
        return taskCollection;
    }

    public ICollection getCollection(String name) throws NoDatabaseException {
        try {
            name = this.cleanName(name);
            ICollection collObject = this.openCollections.get(name);
            if (collObject == null) {
                Document collDoc = this.collections.get(name);
                if (collDoc == null) {
                    collObject = this.createCollection(name);
                } else {
                    collObject = new Collection(this, collDoc);
                    this.openCollections.put(name, collObject);
                }
            }
            if (collObject != null) {
                return collObject;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NoDatabaseException("Database connection is invalid");
        }
    }

    public ICollection createCollection(String name) throws NoDatabaseException {
        if (this.collections.containsKey(name = this.cleanName(name))) {
            return this.getCollection(name);
        }
        Document collDoc = new Document("Name", name).append("DBPath", this.dataPath).append("Path", File.separator + this.name + "_Collections" + File.separator).append("ReplicaSet", this.replicaSet);
        ICollection c = null;
        c = !this.openCollections.containsKey(name) ? new Collection(this, collDoc) : this.openCollections.get(name);
        if (this.ro) {
            throw new NoDatabaseException("Read only Databases cannot be used to create a collection");
        }
        this.collections.put(name, collDoc);
        this.openCollections.put(name, c);
        return c;
    }

    public ICollection createCollection(String name, Document ranges) throws NoDatabaseException {
        if (this.collections.containsKey(name = this.cleanName(name))) {
            return this.getCollection(name);
        }
        Document collDoc = new Document("Name", name).append("DBPath", this.dataPath).append("Path", File.separator + this.name + "_Collections" + File.separator).append("ReplicaSet", this.replicaSet);
        if (ranges != null) {
            collDoc.append("Ranges", ranges);
        }
        ICollection c = null;
        c = !this.openCollections.containsKey(name) ? new Collection(this, collDoc) : this.openCollections.get(name);
        if (this.ro) {
            throw new NoDatabaseException("Read only Databases cannot be used to create a collection");
        }
        this.collections.put(name, collDoc);
        this.openCollections.put(name, c);
        return c;
    }

    private String cleanName(String name) {
        return name.replaceAll("\\\"|\\\\|\\'", "");
    }

    public ICollection createCollection(String name, String hashKey) throws NoDatabaseException {
        if (this.collections.containsKey(name = this.cleanName(name))) {
            return this.getCollection(name);
        }
        Document collDoc = new Document("Name", name).append("DBPath", this.dataPath).append("Path", File.separator + this.name + "_Collections" + File.separator).append("ReplicaSet", this.replicaSet);
        if (hashKey != null) {
            collDoc.append("HashKey", hashKey);
        }
        ICollection c = null;
        c = !this.openCollections.containsKey(name) ? new Collection(this, collDoc) : this.openCollections.get(name);
        if (this.ro) {
            throw new NoDatabaseException("Read only Databases cannot be used to create a collection");
        }
        this.collections.put(name, collDoc);
        this.openCollections.put(name, c);
        return c;
    }

    public ICollection createCollection(Document collDoc) throws NoDatabaseException {
        String name = this.cleanName(collDoc.getString("Name"));
        if (this.collections.containsKey(name)) {
            return this.getCollection(name);
        }
        ICollection c = null;
        boolean internal = collDoc.getBoolean("Internal", false);
        System.out.println("Opening Collection: " + name);
        c = !this.openCollections.containsKey(name) ? new Collection(this, collDoc) : this.openCollections.get(name);
        if (!this.ro && !internal) {
            this.collections.put(name, collDoc);
        } else if (this.ro) {
            throw new NoDatabaseException("Read only Databases cannot be used to create a collection");
        }
        this.openCollections.put(name, c);
        return c;
    }

    public ICollection createFuzzyCollection(String name) {
        return this.createFuzzyCollection(name, new Document(), null, null);
    }

    public ICollection createFuzzyCollection(String name, Document definition) {
        return this.createFuzzyCollection(name, definition, null, null);
    }

    public ICollection createFuzzyCollection(String name, String definitionFile) {
        Document definition = Document.fromFile(definitionFile);
        if (definition != null) {
            return this.createFuzzyCollection(name, definition, null, null);
        }
        return null;
    }

    public ICollection createFuzzyCollection(String name, String definitionFile, Document ranges) {
        Document definition = Document.fromFile(definitionFile);
        if (definition != null) {
            return this.createFuzzyCollection(name, definition, ranges, null);
        }
        return null;
    }

    public ICollection createFuzzyCollection(String name, String definitionFile, String hashKey) {
        Document definition = Document.fromFile(definitionFile);
        if (definition != null) {
            return this.createFuzzyCollection(name, definition, null, hashKey);
        }
        return null;
    }

    public ICollection createFuzzyCollection(String name, Document definition, Document ranges, String hashKey) {
        name = this.cleanName(name);
        Document collDoc = new Document("Name", name).append("DBPath", this.dataPath).append("Path", File.separator + this.name + "_Collections" + File.separator).append("Definition", definition).append("ReplicaSet", this.replicaSet);
        if (ranges != null) {
            collDoc.append("Ranges", ranges);
        }
        if (hashKey != null) {
            collDoc.append("HashKey", hashKey);
        }
        ICollection c = null;
        c = !this.openCollections.containsKey(name) ? new Collection(this, collDoc) : this.openCollections.get(name);
        c.setExplaining(this.isExplain());
        if (!this.ro) {
            this.collections.put(name, collDoc);
        }
        this.openCollections.put(name, c);
        return c;
    }

    public void dropCollection(String name) {
        if (!this.ro) {
            Document collDoc;
            ICollection c;
            System.out.println("Dropping collection:" + name);
            if (this.remoteView) {
                for (String client : this.replicaSet) {
                    System.out.println("Opening remote DB connection to " + client + ", because  remoteView=" + this.remoteView);
                    MonsterClient clientC = new MonsterClient(client);
                    clientC.setRemoteView(false);
                    clientC.useDatabase(this.name);
                    clientC.useCollection(name);
                    clientC.dropCollection();
                    try {
                        clientC.disconnect();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if ((c = this.openCollections.get(name)) != null) {
                try {
                    c.disconnect();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.openCollections.remove(name);
            }
            if ((collDoc = this.collections.get(name)) != null) {
                this.collections.remove(name);
                CollectionLocal.drop(collDoc);
            }
        }
    }

    public void close() throws Exception {
        for (String c : this.openCollections.keySet()) {
            this.openCollections.get(c).disconnect();
        }
        this.openCollections.clear();
        this.getData().close();
    }

    public synchronized void storeCollection(String collectionName, ICollection collection) {
        this.collections.put(collectionName, collection.getDefinition());
        this.openCollections.put(collectionName, collection);
    }

    public BasicDBList listCollectionNames() {
        BasicDBList list = new BasicDBList();
        for (String collName : this.collections.keySet()) {
            if (this.collections.get(collName).getBoolean("Internal", false)) continue;
            list.add(new Document("Name", collName).append("isFuzzy", this.collections.get(collName).containsKey("Definition")));
        }
        return list;
    }

    public boolean isReadOnly() {
        return this.ro;
    }

    public void drop() {
        try {
            File dir = new File(this.dataPath + File.separator + this.name + "_Collections");
            File master = new File(this.dataPath + File.separator + this.name);
            this.data.close();
            if (dir.exists()) {
                FileUtils.forceDelete((File)dir);
            }
            if (master.exists()) {
                FileUtils.forceDelete((File)master);
            }
            System.out.println("Database dropped: " + this.name);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isExplain() {
        return this.explain;
    }

    public void setExplain(boolean explain) {
        this.explain = explain;
    }

    public DBCursor executeCommand(String command2, User user, Session session) {
        return Container.executeCommand(this, command2, user, session);
    }

    public String getName() {
        return this.name;
    }

    public String getDataPath() {
        return this.dataPath;
    }

    public List<String> getReplicaSet() {
        return this.replicaSet;
    }

    public int getNodeNum() {
        return this.nodeNum;
    }

    public Document describeCollection(String name) {
        return this.collections.get(name);
    }

    public void setRemoteView(boolean remoteView) {
        this.remoteView = remoteView;
    }

    public void setScriptCode(String code) {
        if (this.remoteView) {
            for (String client : this.replicaSet) {
                System.out.println("Opening remote DB connection to " + client + ", because  remoteView=" + this.remoteView);
                MonsterClient clientC = new MonsterClient(client);
                clientC.setRemoteView(false);
                clientC.useDatabase(this.name);
                clientC.setScriptCode(code);
                try {
                    clientC.disconnect();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            File jsPath = new File(this.dataPath + File.separator + this.name + ".js");
            PrintWriter pw = new PrintWriter(new FileOutputStream(jsPath));
            pw.print(code);
            pw.flush();
            pw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setupJS();
    }

    public void setScriptPath(String path) {
        StringBuilder code = new StringBuilder();
        try {
            BufferedReader br = new BufferedReader(new FileReader(path));
            String ln = "";
            while ((ln = br.readLine()) != null) {
                code.append(ln);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setScriptCode(code.toString());
    }

    public Invocable getInvoker() {
        return this.invocable;
    }
}

