/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.monster.db;

import com.entitystream.identiza.db.Node;
import com.entitystream.identiza.entity.resolve.metadata.ITable;
import com.entitystream.monster.db.BasicDBList;
import com.entitystream.monster.geo.GeoType;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;
import org.json.XML;

public class Document
implements Map,
Serializable {
    private static final long serialVersionUID = -8864859272192654343L;
    Map mapObject;

    public Document(String key, Object value) {
        try {
            this.mapObject = new LinkedHashMap();
            this.append(key, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Document() {
        this.mapObject = new LinkedHashMap();
    }

    public Document(Object object) {
        try {
            this.mapObject = new LinkedHashMap();
            if (object instanceof JsonObject) {
                this.putAll((JsonObject)object);
            } else if (object instanceof Document) {
                this.mapObject = ((Document)object).mapObject;
            } else if (object instanceof Map) {
                this.mapObject = (Map)object;
            } else if (object instanceof Map.Entry) {
                this.mapObject.put(((Map.Entry)object).getKey(), ((Map.Entry)object).getValue());
            } else if (object instanceof String) {
                JsonParser parser = new JsonParser();
                JsonObject json = (JsonObject)parser.parse((String)object);
                this.putAll(json);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Document(Map<String, Object> values) {
        try {
            this.mapObject = new LinkedHashMap();
            this.putAll(values);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeObject(this.toString());
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        String json = (String)ois.readObject();
        JsonParser parser = new JsonParser();
        JsonObject jsono = (JsonObject)parser.parse(json);
        this.putAll(jsono);
    }

    public static String toISO8601UTC(Date date) {
        if (date != null) {
            TimeZone tz = TimeZone.getDefault();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            df.setTimeZone(tz);
            return df.format(date);
        }
        return "";
    }

    public static Date fromISO8601UTC(Object dateo) {
        TimeZone tz = TimeZone.getDefault();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        df.setTimeZone(tz);
        if (dateo instanceof String) {
            String dateStr = (String)dateo;
            try {
                return df.parse(dateStr);
            }
            catch (Exception e) {
                try {
                    return new Date(Date.parse(dateStr));
                }
                catch (Exception e2) {
                    System.out.println("Date could not be interpreted: " + dateStr);
                }
            }
        } else if (dateo instanceof Date) {
            return (Date)dateo;
        }
        return null;
    }

    private static JsonElement toJsonElement(Object value) {
        try {
            if (value == null) {
                return new JsonNull();
            }
            if (value instanceof String) {
                return new JsonPrimitive((String)value);
            }
            if (value instanceof Boolean) {
                return new JsonPrimitive((Boolean)value);
            }
            if (value instanceof Number) {
                return new JsonPrimitive((Number)value);
            }
            if (value instanceof Character) {
                return new JsonPrimitive((Character)value);
            }
            if (value instanceof Date) {
                return new JsonPrimitive((Number)((Date)value).toInstant().getEpochSecond());
            }
            if (value instanceof List || value instanceof Set) {
                JsonArray meNewList = new JsonArray();
                for (Object item : (List)value) {
                    meNewList.add(Document.toJsonElement(item));
                }
                return meNewList;
            }
            if (value instanceof Document) {
                JsonObject meNewObject = new JsonObject();
                for (String key : ((Document)value).keyString()) {
                    Object item = ((Document)value).get(key);
                    meNewObject.add(key, Document.toJsonElement(item));
                }
                return meNewObject;
            }
            if (value instanceof Map) {
                JsonObject meNewObject = new JsonObject();
                for (Object key : ((Map)value).keySet()) {
                    Object item = ((Map)value).get(key);
                    meNewObject.add((String)key, Document.toJsonElement(item));
                }
                return meNewObject;
            }
            if (value instanceof JsonPrimitive) {
                return (JsonPrimitive)value;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return new JsonNull();
    }

    public Document append(String key, Object value) {
        try {
            if (value instanceof JsonElement) {
                if (value instanceof JsonPrimitive) {
                    this.mapObject.put(key, this.jsonPrimitiveToObject((JsonPrimitive)value));
                } else if (value instanceof JsonObject) {
                    this.mapObject.put(key, this.jsonObjectToObject((JsonElement)((JsonObject)value)));
                } else if (value instanceof JsonArray) {
                    this.mapObject.put(key, this.jsonObjectToObject((JsonElement)((JsonArray)value)));
                }
            } else {
                this.mapObject.put(key, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return this;
    }

    public void putAll(JsonObject value) {
        try {
            if (value != null) {
                for (Object key : value.keySet()) {
                    JsonElement item = value.get((String)key);
                    this.append((String)key, item);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void putAll(Map value) {
        try {
            if (value != null) {
                for (Object key : value.keySet()) {
                    Object item = value.get(key);
                    if (key instanceof String) {
                        this.append((String)key, item);
                        continue;
                    }
                    if (!(key instanceof byte[])) continue;
                    this.append(new String((byte[])key), item);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean containsKey(Object member) {
        return this.mapObject.containsKey(member);
    }

    public boolean containsProjection(String member) {
        return this.containsProjection(this.mapObject, member);
    }

    private boolean containsProjection(Map doc, String member) {
        String[] parts = member.split("\\.", 1);
        if (parts.length == 0) {
            return false;
        }
        if (parts.length == 1) {
            return doc.containsKey(parts[0]);
        }
        if (doc.containsKey(parts[0])) {
            return this.containsProjection((Map)doc.get(parts[0]), parts[1]);
        }
        return false;
    }

    public Object getProjection(String member) {
        return this.getProjection(this.mapObject, member);
    }

    private Object getProjection(Object doc, String member) {
        String[] parts = member.split("\\.", 2);
        if (doc instanceof Map) {
            if (parts.length == 0) {
                return null;
            }
            if (parts.length == 1) {
                Object v = ((Map)doc).get(parts[0]);
                return v;
            }
            if (((Map)doc).containsKey(parts[0])) {
                return this.getProjection(((Map)doc).get(parts[0]), parts[1]);
            }
        } else if (doc instanceof List) {
            try {
                int pos = Integer.parseInt(parts[0]);
                Object obj = ((List)doc).get(pos);
                if (parts.length == 1) {
                    if (!(obj instanceof Map)) {
                        return obj;
                    }
                    return new Document(obj);
                }
                if (parts.length == 2) {
                    return this.getProjection(obj, parts[1]);
                }
            }
            catch (Exception npe) {
                ArrayList<Object> out = new ArrayList<Object>();
                for (Object inner : (List)doc) {
                    if (inner instanceof Document) {
                        out.add(((Document)inner).get(parts[0]));
                        continue;
                    }
                    out.add(this.getProjection(inner, parts[0]));
                }
                return out;
            }
        }
        return null;
    }

    public Object setProjection(String member, Object value) {
        return this.setProjection(this.mapObject, member, value);
    }

    public static Object translateJoinMap$(Map objectIn, Document doc) {
        for (Object key : objectIn.keySet()) {
            Object out = Document.translateJoin$(objectIn.get(key), doc);
            objectIn.replace(key, out);
        }
        return objectIn;
    }

    public static Object translateJoin$(Object objectIn, Document doc) {
        if (objectIn instanceof Map) {
            objectIn = Document.translateJoinMap$(new Document(objectIn), doc);
        } else if (objectIn instanceof List) {
            objectIn = Document.translateJoinList$((List)objectIn, doc);
        } else if (objectIn instanceof String && ((String)objectIn).startsWith("$")) {
            objectIn = Document.translate$(objectIn, doc);
        }
        return objectIn;
    }

    private static Object translateJoinList$(List objectIn, Document doc) {
        ArrayList out = new ArrayList();
        for (Object item : objectIn) {
            item = Document.translateJoin$(item, doc);
            out.add(item);
        }
        return out;
    }

    public static Object translate$(Object objectIn, Document doc) {
        return Document.translate$(objectIn, doc, "");
    }

    public static Object translate$(Object objectIn, Document doc, String stage) {
        if (objectIn instanceof String && ((String)objectIn).startsWith("$")) {
            if (((String)objectIn).equalsIgnoreCase("$date")) {
                return new Date();
            }
            if (((String)objectIn).equalsIgnoreCase("$first")) {
                Object l = doc.getProjection((String)objectIn);
                if (l instanceof List && ((List)l).size() > 0) {
                    return ((List)l).get(0);
                }
                return null;
            }
            return doc.getProjection(((String)objectIn).replace("$", ""));
        }
        if (objectIn instanceof Document) {
            Document objectDoc = (Document)objectIn;
            Object objectOut = new Document();
            for (Object k : objectDoc.keySet()) {
                if (k instanceof String && ((String)k).startsWith("$")) {
                    objectOut = Document.translateFn$((String)k + stage, objectDoc.get((String)k), doc);
                    continue;
                }
                String ks = (String)k;
                ((Document)objectOut).append(ks, Document.translate$(objectDoc.get(ks), doc, stage));
                if (!ks.contains(".")) continue;
                String topkey = ks.substring(0, ks.indexOf("."));
                String remkey = ks.substring(ks.indexOf(".") + 1);
                if (doc.get(topkey) instanceof Document) {
                    ((Document)objectOut).append(topkey, Document.translate$(objectDoc.get(topkey), doc.getAsDocument(topkey), stage));
                    continue;
                }
                if (doc.get(topkey) instanceof List) {
                    List oldlist = doc.getList(topkey);
                    ArrayList<Document> newlist = new ArrayList<Document>();
                    for (Object item : oldlist) {
                        if (!(item instanceof Document)) continue;
                        Document newitem = (Document)item;
                        Document ret = (Document)Document.translate$(new Document(remkey, objectDoc.get(ks)), (Document)item, stage);
                        for (Object k2 : ret.keySet()) {
                            newitem.append((String)k2, ret.get(k2));
                        }
                        newlist.add(newitem);
                    }
                    ((Document)objectOut).append(topkey, newlist);
                    continue;
                }
                ((Document)objectOut).append(topkey, Document.translate$(objectDoc.get(ks), doc, stage));
            }
            return objectOut;
        }
        return objectIn;
    }

    public static Object translateFn$(String functname, Object object, Document doc) {
        Object l;
        Double additive;
        Object value;
        List items;
        block116: {
            block117: {
                block111: {
                    block112: {
                        if (functname.equalsIgnoreCase("$exists")) {
                            if (object instanceof Long && (Long)object == 1L) {
                                return doc != null && doc.get("value") != null;
                            }
                            if (object instanceof Long && (Long)object == 0L) {
                                return doc != null && doc.get("value") == null;
                            }
                        }
                        if (functname.equalsIgnoreCase("$gt")) {
                            return doc.getDouble("value") > ((Number)object).doubleValue();
                        }
                        if (functname.equalsIgnoreCase("$lt")) {
                            return doc.getDouble("value") < ((Number)object).doubleValue();
                        }
                        if (functname.equalsIgnoreCase("$concat")) {
                            StringBuilder out = new StringBuilder();
                            for (Object v : (List)object) {
                                out.append(Document.translate$(v, doc));
                            }
                            return out.toString();
                        }
                        if (functname.equalsIgnoreCase("$upper")) {
                            Object o = Document.translate$(object, doc);
                            if (o instanceof String) {
                                return ((String)o).toUpperCase();
                            }
                            return o;
                        }
                        if (functname.equalsIgnoreCase("$lower")) {
                            Object o = Document.translate$(object, doc);
                            if (o instanceof String) {
                                return ((String)o).toLowerCase();
                            }
                            return o;
                        }
                        if (functname.equalsIgnoreCase("$eq")) {
                            if (doc.get("value") instanceof Number && object instanceof Number) {
                                return doc.getDouble("value").doubleValue() == ((Number)object).doubleValue();
                            }
                            if (object instanceof List) {
                                boolean same = false;
                                Object lastO = null;
                                for (Object o2 : (List)object) {
                                    Object o = Document.translate$(o2, doc);
                                    if (lastO != null) {
                                        same = lastO instanceof Number && o instanceof Number ? ((Number)lastO).doubleValue() == ((Number)o).doubleValue() : lastO.equals(o);
                                    }
                                    lastO = o;
                                }
                                return same;
                            }
                            return doc.getString("value", "").equals(object);
                        }
                        if (functname.equalsIgnoreCase("$or") && object instanceof List) {
                            for (Object o2 : (List)object) {
                                Object o = Document.translate$(o2, doc);
                                if (!(o instanceof Boolean) || !((Boolean)o).booleanValue()) continue;
                                return true;
                            }
                            return false;
                        }
                        if (functname.equalsIgnoreCase("$and") && object instanceof List) {
                            boolean same = true;
                            for (Object o2 : (List)object) {
                                Object o = Document.translate$(o2, doc);
                                if (!(o instanceof Boolean) || ((Boolean)o).booleanValue()) continue;
                                same = false;
                            }
                            return same;
                        }
                        if (functname.equalsIgnoreCase("$count")) {
                            Object o = Document.translate$(object, doc);
                            if (o instanceof List) {
                                return ((List)o).size();
                            }
                            if (o instanceof Map) {
                                return ((Map)o).size();
                            }
                        }
                        if (functname.equalsIgnoreCase("$equalsIgnoreCase")) {
                            if (object instanceof List) {
                                boolean same = false;
                                Object lastO = null;
                                for (Object o2 : (List)object) {
                                    Object o = Document.translate$(o2, doc);
                                    if (lastO instanceof String && o instanceof String) {
                                        same = lastO != null && ((String)lastO).equalsIgnoreCase((String)o);
                                    }
                                    lastO = o;
                                }
                                return same;
                            }
                            if (object instanceof String) {
                                return doc.getString("value", "").equalsIgnoreCase((String)object);
                            }
                            return false;
                        }
                        if (functname.equalsIgnoreCase("$contains")) {
                            if (object instanceof List) {
                                boolean same = false;
                                Object lastO = null;
                                for (Object o2 : (List)object) {
                                    Object o = Document.translate$(o2, doc);
                                    if (lastO instanceof String && o instanceof String) {
                                        same = lastO != null && ((String)lastO).contains((String)o);
                                    }
                                    lastO = o;
                                }
                                return same;
                            }
                            if (object instanceof String) {
                                return doc.getString("value", "").contains((String)object);
                            }
                            return false;
                        }
                        if (!functname.equalsIgnoreCase("$startsWith")) break block111;
                        if (!(object instanceof List)) break block112;
                        boolean same = false;
                        Object lastO = null;
                        for (Object o2 : (List)object) {
                            Object o;
                            block115: {
                                block113: {
                                    Object oo;
                                    block114: {
                                        o = Document.translate$(o2, doc);
                                        if (!(lastO instanceof String)) break block113;
                                        if (!(o instanceof String)) break block114;
                                        boolean bl = same = lastO != null && ((String)lastO).startsWith((String)o);
                                        if (same) {
                                            break;
                                        }
                                        break block115;
                                    }
                                    if (!(o instanceof List)) break block115;
                                    Iterator iterator = ((List)o).iterator();
                                    while (iterator.hasNext() && !(same = ((String)lastO).startsWith((String)(oo = iterator.next())))) {
                                    }
                                    break block115;
                                }
                                if (lastO instanceof List) {
                                    for (Object lastOO : (List)lastO) {
                                        if (o instanceof String) {
                                            boolean bl = same = lastOO != null && ((String)lastOO).startsWith((String)o);
                                            if (same) {
                                                break;
                                            }
                                        } else if (o instanceof List) {
                                            Object oo;
                                            Iterator iterator = ((List)o).iterator();
                                            while (iterator.hasNext() && !(same = ((String)lastOO).startsWith((String)(oo = iterator.next())))) {
                                            }
                                        }
                                        if (!same) continue;
                                    }
                                }
                                break block115;
                                {
                                    break;
                                }
                            }
                            lastO = o;
                            if (!same) continue;
                            break;
                        }
                        return same;
                    }
                    if (object instanceof String) {
                        return doc.getString("value", "").startsWith((String)object);
                    }
                    return false;
                }
                if (!functname.equalsIgnoreCase("$endsWith")) break block116;
                if (!(object instanceof List)) break block117;
                boolean same = false;
                Object lastO = null;
                for (Object o2 : (List)object) {
                    Object o;
                    block120: {
                        block118: {
                            Object oo;
                            block119: {
                                o = Document.translate$(o2, doc);
                                if (!(lastO instanceof String)) break block118;
                                if (!(o instanceof String)) break block119;
                                boolean bl = same = lastO != null && ((String)lastO).endsWith((String)o);
                                if (same) {
                                    break;
                                }
                                break block120;
                            }
                            if (!(o instanceof List)) break block120;
                            Iterator iterator = ((List)o).iterator();
                            while (iterator.hasNext() && !(same = ((String)lastO).endsWith((String)(oo = iterator.next())))) {
                            }
                            break block120;
                        }
                        if (lastO instanceof List) {
                            for (Object lastOO : (List)lastO) {
                                if (o instanceof String) {
                                    boolean bl = same = lastOO != null && ((String)lastOO).endsWith((String)o);
                                    if (same) {
                                        break;
                                    }
                                } else if (o instanceof List) {
                                    Object oo;
                                    Iterator iterator = ((List)o).iterator();
                                    while (iterator.hasNext() && !(same = ((String)lastOO).endsWith((String)(oo = iterator.next())))) {
                                    }
                                }
                                if (!same) continue;
                            }
                        }
                        break block120;
                        {
                            break;
                        }
                    }
                    lastO = o;
                    if (!same) continue;
                    break;
                }
                return same;
            }
            if (object instanceof String) {
                return doc.getString("value", "").endsWith((String)object);
            }
            return false;
        }
        if (functname.equalsIgnoreCase("$month")) {
            return Document.fromISO8601UTC(Document.translate$(object, doc)).getMonth() + 1;
        }
        if (functname.equalsIgnoreCase("$year")) {
            return Document.fromISO8601UTC(Document.translate$(object, doc)).getYear() + 1900;
        }
        if (functname.equalsIgnoreCase("$dayOfMonth")) {
            return Document.fromISO8601UTC(Document.translate$(object, doc)).getDate();
        }
        if (functname.equalsIgnoreCase("$pattern")) {
            return doc.getDouble("value").doubleValue() == ((Number)object).doubleValue();
        }
        if (functname.equalsIgnoreCase("$geoWithin")) {
            GeoType pg = GeoType.fromDoc((Document)((Document)object));
            GeoType pt = GeoType.fromDoc((Document)doc.getAsDocument("value"));
            if (pg != null && pt != null) {
                return pg.checkInside(pt);
            }
            return false;
        }
        if (functname.equalsIgnoreCase("$multiply")) {
            items = (List)object;
            Double multiply = null;
            for (Object item : items) {
                Double d = Document.toDouble(Document.translate$(item, doc));
                if (multiply == null) {
                    multiply = d;
                    continue;
                }
                multiply = multiply * d;
            }
            return multiply;
        }
        if (functname.equalsIgnoreCase("$divide")) {
            items = (List)object;
            Double divide = null;
            for (Object item : items) {
                Double d = Document.toDouble(Document.translate$(item, doc));
                if (divide == null) {
                    divide = d;
                    continue;
                }
                divide = divide / d;
            }
            return divide;
        }
        if (functname.equalsIgnoreCase("$push")) {
            value = Document.translate$(object, doc);
            return value;
        }
        if (functname.equalsIgnoreCase("$pushMap")) {
            ArrayList<Object> list;
            if (doc == null) {
                doc = new Document();
            }
            if ((list = doc.getList("push")) == null) {
                list = new ArrayList<Object>();
            }
            list.add(object);
            doc.append("push", list);
            return doc;
        }
        if (functname.equalsIgnoreCase("$pushFinalize")) {
            if (doc != null) {
                return doc.getList("push");
            }
            return new ArrayList();
        }
        if (functname.equalsIgnoreCase("$sum")) {
            value = Document.translate$(object, doc);
            return value;
        }
        if (functname.equalsIgnoreCase("$sumMap")) {
            Double curr;
            additive = Document.toDouble(object);
            if (doc == null) {
                doc = new Document();
            }
            if ((curr = doc.getDouble("sum")) == null) {
                curr = 0.0;
            }
            curr = curr + additive;
            doc.append("sum", curr);
            return doc;
        }
        if (functname.equalsIgnoreCase("$sumFinalize")) {
            if (doc != null) {
                return doc.getDouble("sum");
            }
            return 0;
        }
        if (functname.equalsIgnoreCase("$avg")) {
            value = Document.translate$(object, doc);
            return value;
        }
        if (functname.equalsIgnoreCase("$avgMap")) {
            Double curr;
            additive = Document.toDouble(object);
            if (doc == null) {
                doc = new Document();
            }
            if ((curr = doc.getDouble("sum")) == null) {
                curr = 0.0;
            }
            curr = curr + additive;
            doc.append("sum", curr);
            Integer count = doc.getInteger("count");
            if (count == null) {
                count = 0;
            }
            Integer n = count;
            count = count + 1;
            doc.append("count", count);
            return doc;
        }
        if (functname.equalsIgnoreCase("$avgFinalize")) {
            if (doc != null) {
                return doc.getDouble("sum") / (double)doc.getInteger("count", 1);
            }
            return 0;
        }
        if (functname.equalsIgnoreCase("$max")) {
            value = Document.translate$(object, doc);
            return value;
        }
        if (functname.equalsIgnoreCase("$maxMap")) {
            Double curr;
            additive = Document.toDouble(object);
            if (doc == null) {
                doc = new Document();
            }
            if ((curr = doc.getDouble("max")) == null) {
                curr = Double.MIN_VALUE;
            }
            curr = Math.max(curr, additive);
            doc.append("max", curr);
            return doc;
        }
        if (functname.equalsIgnoreCase("$maxFinalize")) {
            if (doc != null) {
                return doc.getDouble("max");
            }
            return 0;
        }
        if (functname.equalsIgnoreCase("$min")) {
            value = Document.translate$(object, doc);
            return value;
        }
        if (functname.equalsIgnoreCase("$minMap")) {
            Double curr;
            additive = Document.toDouble(object);
            if (doc == null) {
                doc = new Document();
            }
            if ((curr = doc.getDouble("min")) == null) {
                curr = Double.MAX_VALUE;
            }
            curr = Math.min(curr, additive);
            doc.append("min", curr);
            return doc;
        }
        if (functname.equalsIgnoreCase("$minFinalize")) {
            if (doc != null) {
                return doc.getDouble("min");
            }
            return 0;
        }
        if (functname.equalsIgnoreCase("$popFirst")) {
            l = Document.translate$(object, doc);
            if (l instanceof List && ((List)l).size() > 0) {
                return ((List)l).get(0);
            }
            return l;
        }
        if (functname.equalsIgnoreCase("$popLast")) {
            l = Document.translate$(object, doc);
            if (l instanceof List && ((List)l).size() > 0) {
                return ((List)l).get(((List)l).size() - 1);
            }
            return l;
        }
        if (functname.equalsIgnoreCase("$first")) {
            value = Document.translate$(object, doc);
            return value;
        }
        if (functname.equalsIgnoreCase("$firstMap")) {
            if (doc == null) {
                doc = new Document("first", object);
            }
            return doc;
        }
        if (functname.equalsIgnoreCase("$firstFinalize")) {
            if (doc != null) {
                return doc.get("first");
            }
            return null;
        }
        if (functname.equalsIgnoreCase("$last")) {
            value = Document.translate$(object, doc);
            return value;
        }
        if (functname.equalsIgnoreCase("$lastMap")) {
            doc = new Document("last", object);
            return doc;
        }
        if (functname.equalsIgnoreCase("$lastFinalize")) {
            if (doc != null) {
                return doc.get("last");
            }
            return null;
        }
        return object;
    }

    public List getList(String member) {
        Object item = this.mapObject.get(member);
        if (item != null) {
            if (item instanceof List) {
                return (List)item;
            }
            return Collections.singletonList(item);
        }
        return new ArrayList();
    }

    private static Double toDouble(Object object) {
        try {
            if (object instanceof Double) {
                return (Double)object;
            }
            if (object instanceof Integer) {
                return ((Integer)object).doubleValue();
            }
            if (object instanceof Long) {
                return ((Long)object).doubleValue();
            }
            if (object instanceof Float) {
                return ((Float)object).doubleValue();
            }
            if (object instanceof Number) {
                return ((Number)object).doubleValue();
            }
            if (object instanceof String) {
                return Double.parseDouble((String)object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0.0;
    }

    private static Number toNumber(Object object) {
        try {
            if (object instanceof Number) {
                return (Number)object;
            }
            if (object instanceof String) {
                return NumberFormat.getInstance().parse((String)object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    private Object setProjection(Object doc, String member, Object value) {
        String[] parts = member.split("\\.", 2);
        if (doc instanceof Map) {
            if (parts.length == 0) {
                return null;
            }
            if (parts.length == 1) {
                return ((Map)doc).put(parts[0], value);
            }
            if (((Map)doc).containsKey(parts[0])) {
                return this.setProjection(((Map)doc).get(parts[0]), parts[1], value);
            }
        } else if (doc instanceof List) {
            try {
                int pos = Integer.parseInt(parts[0]);
                if (pos < ((List)doc).size()) {
                    Object obj = ((List)doc).get(pos);
                    return this.setProjection(obj, parts[1], value);
                }
                if (parts.length == 1) {
                    ((List)doc).add(pos, value);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public String getString(String member) {
        try {
            if (this.mapObject.containsKey(member) && this.mapObject.get(member) != null) {
                if (this.mapObject.get(member) instanceof String) {
                    return (String)this.mapObject.get(member);
                }
                return this.mapObject.get(member).toString();
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object get(Object member) {
        try {
            if (this.mapObject.containsKey((String)member) && this.mapObject.get((String)member) != null) {
                if (this.mapObject.get((String)member) instanceof Map) {
                    return new Document(this.mapObject.get((String)member));
                }
                if (this.mapObject.get((String)member) instanceof List) {
                    ArrayList<Document> newList = new ArrayList<Document>();
                    for (Object item : (List)this.mapObject.get((String)member)) {
                        if (item instanceof Map) {
                            newList.add(new Document(item));
                            continue;
                        }
                        newList.add((Document)item);
                    }
                    return newList;
                }
                return this.mapObject.get((String)member);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return null;
    }

    public int getInteger(String member, int defaultValue) {
        try {
            if (this.mapObject.containsKey(member) && this.mapObject.get(member) != null) {
                if (this.mapObject.get(member) instanceof Integer) {
                    return (Integer)this.mapObject.get(member);
                }
                if (this.mapObject.get(member) instanceof Long) {
                    return ((Long)this.mapObject.get(member)).intValue();
                }
                if (this.mapObject.get(member) instanceof Double) {
                    return ((Double)this.mapObject.get(member)).intValue();
                }
                if (this.mapObject.get(member) instanceof String) {
                    return Integer.parseInt((String)this.mapObject.get(member));
                }
                return defaultValue;
            }
            return defaultValue;
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    public Date getDate(String member) {
        if (this.mapObject.containsKey(member) && this.mapObject.get(member) != null) {
            Object d = this.mapObject.get(member);
            if (d instanceof String) {
                return Document.fromISO8601UTC((String)d);
            }
            if (d instanceof Date) {
                return (Date)d;
            }
            if (d instanceof Long) {
                return Date.from(Instant.ofEpochMilli((Long)d));
            }
            return null;
        }
        return null;
    }

    public long getLong(String member) {
        if (this.mapObject.containsKey(member) && this.mapObject.get(member) != null) {
            if (this.mapObject.get(member) instanceof Double) {
                return ((Double)this.mapObject.get(member)).longValue();
            }
            if (this.mapObject.get(member) instanceof Long) {
                return (Long)this.mapObject.get(member);
            }
            if (this.mapObject.get(member) instanceof Integer) {
                return ((Integer)this.mapObject.get(member)).longValue();
            }
            if (this.mapObject.get(member) instanceof String) {
                String s = (String)this.mapObject.get(member);
                try {
                    return Long.parseLong(s);
                }
                catch (Exception e) {
                    Pattern p = Pattern.compile("\\d+");
                    Matcher m = p.matcher(s);
                    if (m.find()) {
                        return Long.parseLong(m.group());
                    }
                    return -1L;
                }
            }
            return -1L;
        }
        return -1L;
    }

    public Integer getInteger(String member) {
        if (this.mapObject.containsKey(member) && this.mapObject.get(member) != null) {
            if (this.mapObject.get(member) instanceof Integer) {
                return (int)((Integer)this.mapObject.get(member));
            }
            if (this.mapObject.get(member) instanceof Long) {
                return ((Long)this.mapObject.get(member)).intValue();
            }
            if (this.mapObject.get(member) instanceof Double) {
                return ((Double)this.mapObject.get(member)).intValue();
            }
            if (this.mapObject.get(member) instanceof String) {
                return Integer.parseInt((String)this.mapObject.get(member));
            }
            return null;
        }
        return null;
    }

    public Double getDouble(String member) {
        if (this.mapObject.containsKey(member) && this.mapObject.get(member) != null && this.mapObject.get(member) instanceof Double) {
            return (double)((Double)this.mapObject.get(member));
        }
        if (this.mapObject.get(member) instanceof Number) {
            return ((Number)this.mapObject.get(member)).doubleValue();
        }
        return null;
    }

    public boolean getBoolean(String member, boolean defaultValue) {
        if (this.mapObject.containsKey(member) && this.mapObject.get(member) != null) {
            if (this.mapObject.get(member) instanceof Boolean) {
                return (Boolean)this.mapObject.get(member);
            }
            if (this.mapObject.get(member) instanceof String) {
                return Boolean.parseBoolean((String)this.mapObject.get(member));
            }
            return defaultValue;
        }
        return defaultValue;
    }

    public Map getAsMap(String member) {
        try {
            if (this.mapObject.containsKey(member) && this.mapObject.get(member) != null && this.mapObject.get(member) instanceof Map) {
                return (Map)this.mapObject.get(member);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return null;
    }

    public Document getAsDocument(String member) {
        try {
            if (this.mapObject.containsKey(member) && this.mapObject.get(member) != null && this.mapObject.get(member) instanceof Map) {
                return new Document((Map)this.mapObject.get(member));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return null;
    }

    private Object jsonPrimitiveToObject(JsonPrimitive jo) {
        try {
            if (jo.isString()) {
                return jo.getAsString();
            }
            if (jo.isBoolean()) {
                return jo.getAsBoolean();
            }
            if (jo.isNumber()) {
                Number num = jo.getAsNumber();
                if (jo.getAsString().indexOf(".") == -1 && Math.ceil(num.doubleValue()) == (double)num.longValue()) {
                    return num.longValue();
                }
                return num.doubleValue();
            }
            return jo;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object jsonObjectToObject(JsonElement jo) {
        try {
            if (jo.isJsonNull()) {
                return null;
            }
            if (jo.isJsonArray()) {
                ArrayList<Object> meNewList = new ArrayList<Object>();
                for (JsonElement item : jo.getAsJsonArray()) {
                    meNewList.add(this.jsonObjectToObject(item));
                }
                return meNewList;
            }
            if (jo.isJsonObject()) {
                if (((JsonObject)jo).has("pattern")) {
                    int flags = 0;
                    if (!((JsonObject)jo).has("flags")) return jo;
                    flags = ((JsonObject)jo).get("flags").getAsInt();
                    return Pattern.compile(((JsonObject)jo).get("pattern").getAsString(), flags);
                }
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                for (String key : ((JsonObject)jo).keySet()) {
                    map.put(key, this.jsonObjectToObject(((JsonObject)jo).get(key)));
                }
                return map;
            }
            if (!jo.isJsonPrimitive()) return jo;
            return this.jsonPrimitiveToObject(jo.getAsJsonPrimitive());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Document toDocument(ITable table) {
        try {
            Gson gson = new Gson();
            String json = gson.toJson((Object)table, table.getClass());
            JsonParser parser = new JsonParser();
            JsonObject element = (JsonObject)parser.parse(json);
            return new Document(element);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Map toMap() {
        return this.mapObject;
    }

    public static Object toObject(Document document, Class<?> type) {
        try {
            if (document == null || document.toJson() == null) {
                try {
                    return type.newInstance();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            Gson gson = new Gson();
            Object object = gson.fromJson(document.toJson(), type);
            return object;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public <T> T toObject(Class<T> type) {
        try {
            Gson gson = new Gson();
            Object object = gson.fromJson(this.toJson(), type);
            return (T)object;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String toJson() {
        try {
            Gson gson = new Gson();
            JsonElement ele = gson.toJsonTree((Object)this.mapObject, LinkedHashMap.class);
            return ele.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String toPrettyJson() {
        try {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            JsonElement ele = gson.toJsonTree((Object)this.mapObject, LinkedHashMap.class);
            return gson.toJson(ele);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public int hashCode() {
        return this.mapObject.hashCode();
    }

    public String toString() {
        try {
            Gson gson = new Gson();
            JsonElement ele = gson.toJsonTree((Object)this.mapObject, LinkedHashMap.class);
            return ele.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof Document) {
            return other.toString().contentEquals(this.toString());
        }
        return false;
    }

    public static Document fromFile(String filename) {
        try {
            FileReader filereader = new FileReader(filename);
            BufferedReader reader = new BufferedReader(filereader);
            String line = null;
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            reader.close();
            if (sb.length() > 0) {
                return Document.parse(sb.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Document parse(String json) {
        try {
            JsonElement p;
            JsonParser parser = new JsonParser();
            if (json.startsWith("'") && json.endsWith("'")) {
                json = json.replaceAll("'", "");
            }
            if ((p = parser.parse(json)).isJsonNull()) {
                return null;
            }
            if (p.isJsonObject()) {
                JsonObject _jsonObject = (JsonObject)p;
                return new Document(_jsonObject);
            }
            if (p.isJsonArray()) {
                JsonArray _jsonObject = (JsonArray)p;
                return new Document("list", _jsonObject);
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<String> getJsonFromString(String input) {
        ArrayList<Character> stack = new ArrayList<Character>();
        ArrayList<String> jsons = new ArrayList<String>();
        Object temp = "";
        char startBracket = ';';
        int endBracket = 59;
        for (char eachChar : input.toCharArray()) {
            if (startBracket == ';') {
                if (eachChar == '(') {
                    startBracket = '(';
                    endBracket = 41;
                } else if (eachChar == '{') {
                    startBracket = '{';
                    endBracket = 125;
                } else if (eachChar == '[') {
                    startBracket = '[';
                    endBracket = 93;
                }
            }
            if (stack.isEmpty() && eachChar == startBracket) {
                stack.add(Character.valueOf(eachChar));
                temp = (String)temp + eachChar;
                continue;
            }
            if (!stack.isEmpty()) {
                temp = (String)temp + eachChar;
                if (((Character)stack.get(stack.size() - 1)).equals(Character.valueOf(startBracket)) && eachChar == endBracket) {
                    stack.remove(stack.size() - 1);
                    if (!stack.isEmpty()) continue;
                    jsons.add((String)temp);
                    temp = "";
                    continue;
                }
                if (eachChar != startBracket && eachChar != endBracket) continue;
                stack.add(Character.valueOf(eachChar));
                continue;
            }
            if (((String)temp).length() <= 0 || !stack.isEmpty()) continue;
            jsons.add((String)temp);
            temp = "";
        }
        return jsons;
    }

    public static Object parseListOrDoc(String jsonin) {
        List<String> chopper = Document.getJsonFromString(jsonin);
        BasicDBList returned = new BasicDBList();
        for (String json : chopper) {
            try {
                JsonObject _jsonObject;
                JsonParser parser = new JsonParser();
                JsonElement p = parser.parse(json);
                if (p.isJsonObject()) {
                    _jsonObject = (JsonObject)p;
                    returned.add(new Document(_jsonObject));
                }
                if (!p.isJsonArray()) continue;
                _jsonObject = (JsonArray)p;
                BasicDBList list = new BasicDBList();
                for (JsonElement item : _jsonObject) {
                    if (item.isJsonObject()) {
                        list.add(new Document(item));
                        continue;
                    }
                    if (!item.isJsonArray()) continue;
                    list.add(Document.parseListOrDoc(item.toString()));
                }
                returned.add(list);
            }
            catch (Exception e) {
                return e.toString();
            }
        }
        return returned;
    }

    public static Object parseListOrDocument(String json) throws Exception {
        try {
            JsonParser parser = new JsonParser();
            JsonElement p = parser.parse(json);
            if (p.isJsonObject()) {
                JsonObject _jsonObject = (JsonObject)p;
                return new Document(_jsonObject);
            }
            if (p.isJsonArray()) {
                JsonArray _jsonObject = (JsonArray)p;
                BasicDBList list = new BasicDBList();
                for (JsonElement item : _jsonObject) {
                    if (item.isJsonObject()) {
                        list.add(new Document(item));
                        continue;
                    }
                    if (item.isJsonArray()) {
                        list.add(Document.parseListOrDoc(item.toString()));
                        continue;
                    }
                    if (!item.isJsonPrimitive()) continue;
                    list.add(item.getAsJsonPrimitive());
                }
                return list;
            }
        }
        catch (Exception e) {
            throw new Exception(e.toString());
        }
        return null;
    }

    public Object remove(Object memberName) {
        Object removed = null;
        if (this.mapObject.containsKey((String)memberName)) {
            removed = this.mapObject.get((String)memberName);
            this.mapObject.remove((String)memberName);
        }
        return removed;
    }

    public Set keySet() {
        return this.mapObject.keySet();
    }

    public Set<String> keyString() {
        return this.mapObject.keySet();
    }

    @Override
    public int size() {
        return this.mapObject.size();
    }

    @Override
    public boolean isEmpty() {
        return this.mapObject == null || this.mapObject.size() == 0;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.mapObject.containsValue(value);
    }

    public Object put(Object key, Object value) {
        return this.append((String)key, value);
    }

    @Override
    public void clear() {
        this.mapObject = new LinkedHashMap();
    }

    public Collection values() {
        ArrayList ret = new ArrayList();
        for (Object k : this.mapObject.keySet()) {
            ret.add(this.mapObject.get(k));
        }
        return ret;
    }

    public Set entrySet() {
        return this.mapObject.entrySet();
    }

    public <T> T get(Object memberName, Class<T> clazz) {
        Object obj = this.mapObject.get((String)memberName);
        if (obj != null && !obj.getClass().isInstance(clazz)) {
            return null;
        }
        return (T)obj;
    }

    public static String objectToString(Object o) {
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof Long) {
            return "" + (Long)o;
        }
        if (o instanceof Integer) {
            return "" + (Integer)o;
        }
        if (o instanceof Double) {
            return "" + (Double)o;
        }
        if (o instanceof Boolean) {
            return "" + (Boolean)o;
        }
        if (o instanceof Date) {
            return ((Date)o).toString();
        }
        if (o instanceof Document || o instanceof ArrayList) {
            StringBuilder sb = new StringBuilder();
            Node.flattenDocToString((String)"", (Object)o, (StringBuilder)sb, (String)"");
            return sb.toString();
        }
        return "";
    }

    public List<String> getProperties(Collection<String> fieldNames) {
        ArrayList<StringBuilder> fullvals = new ArrayList<StringBuilder>();
        for (String colname : fieldNames) {
            String lastParent = "";
            String parent = "";
            parent = colname.indexOf(".") > -1 ? colname.substring(0, colname.lastIndexOf(".")) : colname;
            Object value = this.getProjection(colname);
            if (parent.equalsIgnoreCase(lastParent) || lastParent.length() == 0) {
                if (value != null) {
                    if (value instanceof ArrayList) {
                        for (int p = 0; p < ((ArrayList)value).size(); ++p) {
                            String s = Document.objectToString(((ArrayList)value).get(p)) + " ";
                            if (fullvals.size() - 1 < p || fullvals.get(p) == null) {
                                fullvals.add(p, new StringBuilder(s));
                                continue;
                            }
                            ((StringBuilder)fullvals.get(p)).append(s);
                        }
                    } else {
                        String s = Document.objectToString(value) + " ";
                        if (fullvals.size() - 1 < 0 || fullvals.get(0) == null) {
                            fullvals.add(0, new StringBuilder(s));
                        } else {
                            ((StringBuilder)fullvals.get(0)).append(s);
                        }
                    }
                }
            } else {
                for (StringBuilder fullval : fullvals) {
                    if (value instanceof ArrayList) {
                        for (int p = 0; p < ((ArrayList)value).size(); ++p) {
                            String s = Document.objectToString(((ArrayList)value).get(p)) + " ";
                            fullval.append(s);
                        }
                        continue;
                    }
                    String s = Document.objectToString(value) + " ";
                    fullval.append(s);
                }
            }
            lastParent = parent;
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (StringBuilder fullval : fullvals) {
            ret.add(fullval.toString().trim());
        }
        return ret;
    }

    public Object getNative(String string) {
        return this.mapObject.get(string);
    }

    public String getString(String member, String defaultv) {
        String ret = this.getString(member);
        if (ret == null) {
            ret = defaultv;
        }
        return ret;
    }

    public String toXML(String type) {
        JSONObject object = new JSONObject(this.toJson());
        return "<" + type + ">" + XML.toString((Object)object) + "</" + type + ">";
    }

    public String toCSV() {
        StringBuffer sb = new StringBuffer();
        for (Object k : this.keySet()) {
            sb.append(this.getString((String)k));
        }
        return sb.toString();
    }

    public void applyUpdate(Document amendments) {
        if (amendments.containsKey("$set")) {
            Document setDoc = amendments.getAsDocument("$set");
            for (Object fieldObject : setDoc.keySet()) {
                String fieldName = (String)fieldObject;
                Object value = setDoc.get(fieldObject);
                if (fieldName.contains(".")) {
                    this.setProjection(fieldName, value);
                    continue;
                }
                this.append(fieldName, value);
            }
        }
        if (amendments.containsKey("$push")) {
            Document pushDoc = amendments.getAsDocument("$push");
            for (Object fieldObject : pushDoc.keySet()) {
                Object supposedArray = this.getProjection((String)fieldObject);
                if (!(supposedArray instanceof List)) continue;
                if (pushDoc.get(fieldObject) instanceof Document) {
                    Document pushDef = pushDoc.getAsDocument((String)fieldObject);
                    if (pushDef.containsKey("$each")) {
                        List each = pushDef.getList("$each");
                        int pos = ((List)supposedArray).size();
                        boolean usePos = false;
                        if (pushDef.containsKey("$position")) {
                            usePos = true;
                            pos = pushDef.getInteger("$position");
                            if (pos < 0) {
                                pos = ((List)supposedArray).size() + pos;
                            }
                            if (pos > ((List)supposedArray).size()) {
                                usePos = false;
                            }
                        }
                        for (Object item : each) {
                            if (usePos) {
                                ((List)supposedArray).add(pos, item);
                            } else {
                                ((List)supposedArray).add(item);
                            }
                            ++pos;
                        }
                    }
                } else {
                    ((List)supposedArray).add(pushDoc.get(fieldObject));
                }
                this.setProjection((String)fieldObject, supposedArray);
            }
        }
    }

    public static String stringify(List<Document> list) {
        StringBuilder d = new StringBuilder("[");
        boolean first = true;
        for (Document doc : list) {
            if (!first) {
                d.append(",");
            }
            d.append(doc.toJson());
            first = false;
        }
        d.append("]");
        return d.toString();
    }
}

