/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.monster.db;

import com.entitystream.identiza.db.WorkTypes;
import com.entitystream.identiza.entity.resolve.match.Indexable;
import com.entitystream.identiza.entity.resolve.match.Matchable;
import com.entitystream.identiza.entity.resolve.metadata.ISchemaMeta;
import com.entitystream.monster.db.DBCursor;
import com.entitystream.monster.db.Document;
import com.entitystream.monster.db.ICollection;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.regex.Pattern;
import javax.script.Invocable;
import javax.script.ScriptException;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.IndexTreeList;
import org.mapdb.Serializer;
import org.mapdb.serializer.SerializerCompressionWrapper;

public class MatchCollection
extends Indexable
implements Matchable {
    private static final String FROMCOL = "fromCol";
    private static final String TOCOL = "toCol";
    private static final String TABLENAME = "Table";
    private int sortCount;
    private ICollection nodeCollection;
    private ICollection relCollection;
    private ICollection taskCollection;
    private int eidCount;
    private DB _catalog;
    private IndexTreeList data;
    private Thread bgthread;
    private boolean killed;
    private int mergeCount;
    private int taskCount;
    private int linkCount;
    private String name;
    private String trigger;
    private Invocable invoker;

    public MatchCollection(final ICollection nodeCollection, final ICollection relCollection, final ICollection taskCollection, ISchemaMeta _schDoc) {
        super.initialize(_schDoc);
        this.nodeCollection = nodeCollection;
        this.relCollection = relCollection;
        this.taskCollection = taskCollection;
        this.data = (IndexTreeList)this.getData().indexTreeList("Queue", (Serializer)SerializerCompressionWrapper.JAVA).createOrOpen();
        this.trigger = nodeCollection.getTrigger();
        this.invoker = nodeCollection.getDatabase().getInvoker();
        if (this.bgthread == null || this.killed) {
            this.killed = false;
            this.bgthread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        System.out.println("Matching starts on " + MatchCollection.this.name);
                        while (!MatchCollection.this.killed) {
                            while (MatchCollection.this.data.size() > 0) {
                                try {
                                    MatchCollection.this.data.getLock().writeLock().lock();
                                    Document matchNode = (Document)MatchCollection.this.data.remove(0);
                                    Document matchDoc = null;
                                    if (matchNode.containsKey(MatchCollection.TABLENAME)) {
                                        matchDoc = nodeCollection.fuzzyMatch(matchNode, MatchCollection.this.matchIndexes);
                                    }
                                    MatchCollection.this.invoke("SAVE", matchNode);
                                    MatchCollection.this.mergeSort(matchDoc);
                                    MatchCollection.this.data.getLock().writeLock().unlock();
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                            Thread.sleep(100L);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        System.out.println("Matching stopping on " + MatchCollection.this.name);
                        MatchCollection.this._catalog.close();
                        MatchCollection.this._catalog = null;
                        relCollection.disconnect();
                        taskCollection.disconnect();
                        System.out.println("Matching stopped on " + MatchCollection.this.name);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            this.bgthread.start();
        }
    }

    public void offer(Document matchNode) {
        this.data.add((Object)matchNode);
    }

    public DBCursor peekAll() {
        return new DBCursor(this.data.iterator());
    }

    private DB getData() {
        if (this._catalog == null) {
            Document definition = this.nodeCollection.getDefinition();
            this.name = definition.getString("Name");
            File fpath = new File(definition.getString("DBPath") + definition.getString("Path"));
            if (!fpath.exists()) {
                fpath.mkdirs();
            }
            String path = fpath.getAbsolutePath() + File.separator + definition.getString("Name") + "_Queue";
            DBMaker.Maker _data = DBMaker.fileDB((String)path).fileMmapEnable().checksumHeaderBypass().closeOnJvmShutdown();
            try {
                if (_data != null) {
                    this._catalog = _data.make();
                }
            }
            catch (Exception e) {
                System.out.println("Match Collections Queue can't be created on a non existent database, " + e.toString());
            }
        }
        return this._catalog;
    }

    public boolean mergeSort(Document matches) {
        try {
            if (matches != null) {
                String id1 = matches.getString("_id");
                ++this.sortCount;
                for (Object oMatchedTo : matches.getList("Matches")) {
                    Document matchedTo = (Document)oMatchedTo;
                    String id2 = matchedTo.getString("_id");
                    if (id1.equalsIgnoreCase(id2)) continue;
                    Document where = new Document();
                    ArrayList<Document> orlist = new ArrayList<Document>();
                    orlist.add(new Document().append(FROMCOL, id1).append(TOCOL, id2));
                    orlist.add(new Document().append(TOCOL, id2).append(FROMCOL, id1));
                    where.append("$or", orlist);
                    DBCursor list = this.relCollection.find(where);
                    if (list != null && list.hasNext()) continue;
                    String action = matchedTo.getString("action");
                    int iAction = 0;
                    if (action.equalsIgnoreCase("LINK")) {
                        iAction = 5;
                    } else if (action.equalsIgnoreCase("MERGE")) {
                        iAction = 3;
                    } else if (action.equalsIgnoreCase("EID")) {
                        iAction = 7;
                    }
                    Document rule = matchedTo.getAsDocument("rule");
                    double score = matchedTo.getDouble("score");
                    if (score <= rule.getDouble("highScore") && score >= rule.getDouble("lowScore")) {
                        iAction = 6;
                    }
                    Document mr = new Document();
                    mr.append("action", action);
                    mr.append("actionText", matchedTo.getString("actionText"));
                    mr.append("rule", rule);
                    mr.append("score", score);
                    mr.append("_id1", id1);
                    mr.append("_id2", id2);
                    new Indexable.MatchItem((Indexable)this, mr, iAction).compute();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean eid(Document mr) {
        if (mr != null) {
            try {
                ++this.eidCount;
                String leftID = mr.getString("_id1");
                String rightID = mr.getString("_id2");
                Document left = this.nodeCollection.getDocument(leftID);
                Document right = this.nodeCollection.getDocument(rightID);
                if (left.containsKey(TABLENAME) && right.containsKey(TABLENAME)) {
                    long leftEID = left.getLong("EID");
                    long rightEID = right.getLong("EID");
                    if (leftEID != -1L && rightEID != -1L) {
                        long EID = Math.min(leftEID, rightEID);
                        left.append("EID", EID);
                        right.append("EID", EID);
                        Document internal = null;
                        Document external = null;
                        if (this.schDoc.getTable(left.getString(TABLENAME)).isInternal() && !this.schDoc.getTable(right.getString(TABLENAME)).isInternal()) {
                            internal = left;
                            external = right;
                        } else if (this.schDoc.getTable(right.getString(TABLENAME)).isInternal() && !this.schDoc.getTable(left.getString(TABLENAME)).isInternal()) {
                            internal = right;
                            external = left;
                        }
                        String sentIT = "";
                        if (internal != null && external != null) {
                            internal = this.applyInheritanceFrom(internal, external);
                            this.nodeCollection.save(internal);
                            sentIT = internal.getString("_id");
                        }
                        if (left.getLong("EID") != leftEID && !sentIT.equalsIgnoreCase(left.getString("_id"))) {
                            this.nodeCollection.updateMany(new Document("EID", leftEID), new Document("$set", new Document("EID", EID)), new Document("upsert", false));
                        }
                        if (right.getLong("EID") != rightEID && !sentIT.equalsIgnoreCase(right.getString("_id"))) {
                            this.nodeCollection.updateMany(new Document("EID", rightEID), new Document("$set", new Document("EID", EID)), new Document("upsert", false));
                        }
                        this.invoke("EID", new Document("left", left).append("right", right).append("match", mr));
                        return true;
                    }
                }
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public void invoke(String action, Document data) {
        if (this.invoker != null && this.trigger != null) {
            try {
                this.invoker.invokeFunction(this.trigger, action, data.toJson());
            }
            catch (NoSuchMethodException | ScriptException e) {
                e.printStackTrace();
            }
        }
    }

    public void resolveTask(Document mr) {
        String id = mr.getString("_id");
        mr.remove("_id");
        if (mr.getInteger("_action") == -1) {
            this.taskCollection.findOneAndUpdate(new Document("_id", id), new Document("$set", mr));
        } else {
            Document activity = new Document();
            activity.append("action", WorkTypes.toString((int)mr.getInteger("_action")));
            activity.append("actionText", mr.getAsDocument("Rule").getString("actionText"));
            activity.append("rule", mr.getAsDocument("Rule"));
            activity.append("score", mr.getDouble("Score"));
            activity.append("_id1", mr.getList("Nodes").get(0));
            activity.append("_id2", mr.getList("Nodes").get(1));
            new Indexable.MatchItem((Indexable)this, activity, mr.getInteger("_action").intValue()).compute();
        }
    }

    public boolean addTask(Document mr) {
        if (mr != null) {
            ++this.taskCount;
            try {
                String leftID = mr.getString("_id1");
                String rightID = mr.getString("_id2");
                Document left = this.nodeCollection.getDocument(leftID);
                Document right = this.nodeCollection.getDocument(rightID);
                if (left.containsKey(TABLENAME) && right.containsKey(TABLENAME)) {
                    ArrayList<String> tablenames = new ArrayList<String>();
                    tablenames.add(left.getString(TABLENAME));
                    tablenames.add(right.getString(TABLENAME));
                    Collections.sort(tablenames);
                    if (!leftID.equalsIgnoreCase(rightID)) {
                        Document doc;
                        String ID = leftID + "_" + rightID;
                        if (leftID.compareTo(rightID) < 0) {
                            ID = rightID + "_" + leftID;
                        }
                        if ((doc = this.taskCollection.getDocument(ID)) == null) {
                            Document values = new Document();
                            Date dueDate = new Date();
                            values.append("Task", mr.getString("actionText") + " of " + leftID + " and " + rightID);
                            values.append("Created", new Date());
                            values.append("Due", dueDate);
                            values.append("Resolved", "false");
                            values.append("Tablename", tablenames.toString());
                            values.append(TABLENAME, "Tasks");
                            values.append("Score", mr.getDouble("score"));
                            values.append("Rule", mr.get("rule"));
                            values.append("Type", mr.getString("action"));
                            values.append("_id", ID);
                            ArrayList<String> nodes = new ArrayList<String>();
                            nodes.add(leftID);
                            nodes.add(rightID);
                            values.append("Nodes", nodes);
                            this.taskCollection.findOneAndReplace(new Document("_id", ID), values, new Document("upsert", true));
                        }
                        return true;
                    }
                }
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public boolean link(Document mr) {
        if (mr != null) {
            ++this.linkCount;
            try {
                String leftID = mr.getString("_id1");
                String rightID = mr.getString("_id2");
                Document left = this.nodeCollection.getDocument(leftID);
                Document right = this.nodeCollection.getDocument(rightID);
                if (left.containsKey(TABLENAME) && right.containsKey(TABLENAME)) {
                    HashMap<String, Object> values = new HashMap<String, Object>();
                    values.put("TaskResolved", "true");
                    values.put("TaskResolvedBy", "System");
                    values.put("TaskScore", mr.getDouble("score"));
                    values.put("TaskDue", new Date());
                    values.put("TaskRule", mr.get("rule"));
                    values.put("TaskCreatedBy", "System");
                    String relType = mr.getString("actionText");
                    String fromTable = left.getString(TABLENAME);
                    String toTable = right.getString(TABLENAME);
                    Document existing = this.relCollection.getDocument(leftID + "_" + rightID);
                    if (existing == null) {
                        existing = this.relCollection.getDocument(rightID + "_" + leftID);
                    }
                    if (existing == null || !existing.getString("relType").equalsIgnoreCase(relType)) {
                        Document rel = new Document("relType", relType);
                        rel.append("task", values);
                        rel.append("history", new Document("status", "ACTIVE").append("lastUpdate", new Date()));
                        rel.append(FROMCOL, leftID);
                        rel.append(TOCOL, rightID);
                        rel.append("fromTable", fromTable);
                        rel.append("toTable", toTable);
                        rel.append("_id", leftID + "_" + rightID);
                        this.relCollection.save(rel);
                    }
                    this.invoke("LINK", new Document("left", left).append("right", right).append("match", mr));
                    return true;
                }
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public boolean merge(Document mr) {
        if (mr != null) {
            try {
                ++this.mergeCount;
                String leftID = mr.getString("_id1");
                String rightID = mr.getString("_id2");
                Document rec1 = this.nodeCollection.getDocument(leftID);
                Document rec2 = this.nodeCollection.getDocument(rightID);
                if (rec1.containsKey(TABLENAME) && rec2.containsKey(TABLENAME)) {
                    String fromTable = rec1.getString(TABLENAME);
                    String toTable = rec2.getString(TABLENAME);
                    Document survivedRec = null;
                    Document goldenRec = this.calcGoldenRec(rec1, rec2, fromTable);
                    Document deletedRec = null;
                    if (rec1.getString("_id").equalsIgnoreCase(goldenRec.getString("_id"))) {
                        deletedRec = rec2;
                        survivedRec = rec1;
                    } else {
                        deletedRec = rec1;
                        survivedRec = rec2;
                    }
                    String deletedID = deletedRec.getString("_id");
                    String survivedID = survivedRec.getString("_id");
                    System.out.println("Removing record " + deletedID + ", surviving with " + survivedID);
                    System.out.println("Deleting Node (" + deletedRec.toJson() + ") survived by (" + survivedRec.toJson() + ") ");
                    String deletedKey = deletedRec.getString(this.schDoc.getTable(deletedRec.getString(TABLENAME)).getKeyField());
                    this.taskCollection.deleteMany(new Document("_id", Pattern.compile("^" + deletedID + "_.*")));
                    this.taskCollection.deleteMany(new Document("_id", Pattern.compile("^*._" + deletedID + "$")));
                    this.nodeCollection.deleteOne(new Document("_id", deletedID));
                    this.relCollection.deleteMany(new Document(FROMCOL, deletedID));
                    this.relCollection.deleteMany(new Document(TOCOL, deletedID));
                    this.nodeCollection.save(goldenRec);
                    this.invoke("MERGE", new Document("left", rec1).append("right", rec2).append("match", mr).append("result", goldenRec));
                    return true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public void disconnect() {
        this.killed = true;
    }

    public void addTrigger(String name) {
        this.trigger = name;
        this.invoker = this.nodeCollection.getDatabase().getInvoker();
    }
}

